/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.security;

import javax.servlet.http.HttpServletRequest;
import org.springframework.security.web.util.IpAddressMatcher;
import org.springframework.util.StringUtils;
import org.web4thejob.security.SecurityUtil;

public class CustomELRequestMatcherContext {
    private final HttpServletRequest request;

    public CustomELRequestMatcherContext(HttpServletRequest request) {
        this.request = request;
    }

    public boolean hasIpAddress(String ipAddress) {
        return new IpAddressMatcher(ipAddress).matches(this.request);
    }

    public boolean hasHeader(String headerName, String value) {
        String header = this.request.getHeader(headerName);
        if (!StringUtils.hasText((String)header)) {
            return false;
        }
        return header.contains(value);
    }

    public boolean isFromIntranet() {
        return SecurityUtil.isFromIntranet(this.request.getRemoteAddr());
    }

    public boolean isFirstUse() {
        return SecurityUtil.isFirstUse();
    }
}

