/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.security;

import org.springframework.security.web.util.IpAddressMatcher;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.security.UserIdentity;

public class SecurityUtil {
    private static boolean firstUse = true;

    public static boolean hasIpAddress(String ipAddress, String remoteAddress) {
        return new IpAddressMatcher(ipAddress).matches(remoteAddress);
    }

    public static boolean isFromIntranet(String remoteAddress) {
        return SecurityUtil.hasIpAddress("127.0.0.1", remoteAddress) || SecurityUtil.hasIpAddress("10.0.0.1/8", remoteAddress) || SecurityUtil.hasIpAddress("192.168.1.1/24", remoteAddress);
    }

    public static boolean isFirstUse() {
        if (firstUse) {
            UserIdentity admin = ContextUtil.getSecurityService().getAdministratorIdentity();
            firstUse = admin.getPassword().equals(ContextUtil.getSecurityService().encodePassword(admin, admin.getCode()));
        }
        return firstUse;
    }
}

