/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.security;

import java.util.Locale;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.SaltSource;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.stereotype.Service;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.Path;
import org.web4thejob.orm.query.Condition;
import org.web4thejob.orm.query.Query;
import org.web4thejob.security.SecurityService;
import org.web4thejob.security.UserDetailsExImpl;
import org.web4thejob.security.UserIdentity;

@Service
public class SpringSecurityService
implements SecurityService {
    public String encodePassword(UserIdentity userIdentity, String value) {
        PasswordEncoder passwordEncoder;
        SaltSource saltSource = null;
        try {
            passwordEncoder = (PasswordEncoder)ContextUtil.getBean(PasswordEncoder.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            return value;
        }
        try {
            saltSource = (SaltSource)ContextUtil.getBean(SaltSource.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            // empty catch block
        }
        if (saltSource != null) {
            return passwordEncoder.encodePassword(value, saltSource.getSalt((UserDetails)new UserDetailsExImpl(userIdentity)));
        }
        return passwordEncoder.encodePassword(value, null);
    }

    public UserIdentity getAdministratorIdentity() {
        Query query = ContextUtil.getEntityFactory().buildQuery(UserIdentity.class);
        query.addCriterion(new Path("code"), Condition.EQ, (Object)"admin");
        UserIdentity userAdmin = (UserIdentity)ContextUtil.getDRS().findUniqueByQuery(query);
        if (userAdmin == null) {
            userAdmin = ContextUtil.getEntityFactory().buildUserIdentity();
            userAdmin.setCode("admin");
            userAdmin.setFirstName("System");
            userAdmin.setLastName("Administrator");
            userAdmin.setPassword(this.encodePassword(userAdmin, "admin"));
            userAdmin.setLocale(Locale.getDefault());
        }
        if (!(!userAdmin.isNewInstance() && userAdmin.isAccountNonExpired() && userAdmin.isAccountNonLocked() && userAdmin.isCredentialsNonExpired() && userAdmin.isEnabled())) {
            userAdmin.setCredentialsNonExpired(true);
            userAdmin.setAccountNonLocked(true);
            userAdmin.setAccountNonExpired(true);
            userAdmin.setEnabled(true);
            ContextUtil.getDWS().save((Entity)userAdmin);
        }
        return userAdmin;
    }

    public <T> T authenticate(String username, String password, boolean useIfValid) {
        Authentication authentication = (Authentication)this.authenticate(username, password);
        if (authentication != null && useIfValid) {
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        return (T)authentication;
    }

    public <T> T authenticate(String username, String password) {
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        AuthenticationManager authenticationManager = (AuthenticationManager)ContextUtil.getBean((String)"authenticationManager", AuthenticationManager.class);
        try {
            return (T)authenticationManager.authenticate((Authentication)authentication);
        }
        catch (AuthenticationException e) {
            return null;
        }
    }
}

