/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;
import org.web4thejob.security.CredentialsRenewAuthenticationToken;

public class CredentialsExpiredErrorHandler
extends SimpleUrlAuthenticationFailureHandler {
    private String passwordChangeUrl;
    private String expiredUserName;

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        if (exception instanceof CredentialsExpiredException && this.passwordChangeUrl != null && this.expiredUserName != null) {
            this.saveException(request, exception);
            this.logger.debug((Object)("Created new " + CredentialsRenewAuthenticationToken.class.getSimpleName()));
            SecurityContextHolder.getContext().setAuthentication((Authentication)new CredentialsRenewAuthenticationToken(this.expiredUserName));
            this.logger.debug((Object)("Forwarding to " + this.passwordChangeUrl));
            this.getRedirectStrategy().sendRedirect(request, response, this.passwordChangeUrl);
        } else {
            super.onAuthenticationFailure(request, response, exception);
        }
    }

    public String getPasswordChangeUrl() {
        return this.passwordChangeUrl;
    }

    public void setPasswordChangeUrl(String passwordChangeUrl) {
        Assert.isTrue((boolean)UrlUtils.isValidRedirectUrl((String)passwordChangeUrl), (String)("'" + passwordChangeUrl + "' is not a valid " + "redirect URL"));
        this.passwordChangeUrl = passwordChangeUrl;
    }

    public void setExpiredUserName(String expiredUserName) {
        this.expiredUserName = expiredUserName;
    }
}

