/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.security;

import java.util.Locale;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.Path;
import org.web4thejob.orm.query.Condition;
import org.web4thejob.orm.query.Query;
import org.web4thejob.security.SecurityService;
import org.web4thejob.security.UserDetailsEx;
import org.web4thejob.security.UserIdentity;

@Service
public class SpringSecurityService
implements SecurityService {
    public String encodePassword(UserIdentity userIdentity, String value) {
        PasswordEncoder passwordEncoder;
        try {
            passwordEncoder = (PasswordEncoder)ContextUtil.getBean(PasswordEncoder.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            return value;
        }
        return passwordEncoder.encode((CharSequence)value);
    }

    public UserIdentity getAdministratorIdentity() {
        Query query = ContextUtil.getEntityFactory().buildQuery(UserIdentity.class);
        query.addCriterion(new Path("code"), Condition.EQ, (Object)"admin");
        UserIdentity userAdmin = (UserIdentity)ContextUtil.getDRS().findUniqueByQuery(query);
        if (userAdmin == null) {
            userAdmin = ContextUtil.getEntityFactory().buildUserIdentity();
            userAdmin.setCode("admin");
            userAdmin.setFirstName("System");
            userAdmin.setLastName("Administrator");
            userAdmin.setPassword(this.encodePassword(userAdmin, "admin"));
            userAdmin.setLocale(Locale.getDefault());
        }
        if (!(!userAdmin.isNewInstance() && userAdmin.isAccountNonExpired() && userAdmin.isAccountNonLocked() && userAdmin.isCredentialsNonExpired() && userAdmin.isEnabled())) {
            userAdmin.setCredentialsNonExpired(true);
            userAdmin.setAccountNonLocked(true);
            userAdmin.setAccountNonExpired(true);
            userAdmin.setEnabled(true);
            ContextUtil.getDWS().save((Entity)userAdmin);
        }
        return userAdmin;
    }

    public UserIdentity getUserIdentity(String userName) {
        Query query = ContextUtil.getEntityFactory().buildQuery(UserIdentity.class);
        query.addCriterion(new Path("code"), Condition.EQ, (Object)userName);
        return (UserIdentity)ContextUtil.getDRS().findUniqueByQuery(query);
    }

    public boolean isPasswordValid(UserIdentity userIdentity, String rawPassword) {
        PasswordEncoder passwordEncoder;
        try {
            passwordEncoder = (PasswordEncoder)ContextUtil.getBean(PasswordEncoder.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            return true;
        }
        return passwordEncoder.matches((CharSequence)rawPassword, userIdentity.getPassword());
    }

    public boolean renewPassword(UserIdentity userIdentity, String oldPassword, String newPassword) {
        if (this.isPasswordValid(userIdentity, oldPassword)) {
            ContextUtil.getDRS().refresh((Entity)userIdentity);
            userIdentity.setCredentialsNonExpired(true);
            userIdentity.setPassword(ContextUtil.getSecurityService().encodePassword(userIdentity, newPassword));
            ContextUtil.getDWS().save((Entity)userIdentity);
            Authentication authentication = (Authentication)ContextUtil.getSecurityService().authenticate(userIdentity.getCode(), newPassword);
            if (authentication != null && authentication.getPrincipal() instanceof UserDetailsEx && ((UserDetailsEx)authentication.getPrincipal()).getUserIdentity().equals(userIdentity)) {
                SecurityContextHolder.getContext().setAuthentication(authentication);
                return true;
            }
        }
        return false;
    }

    public <T> T authenticate(String username, String password, boolean useIfValid) {
        Authentication authentication = (Authentication)this.authenticate(username, password);
        if (authentication != null && useIfValid) {
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
        return (T)authentication;
    }

    public <T> T authenticate(String username, String password) {
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        AuthenticationManager authenticationManager = (AuthenticationManager)ContextUtil.getBean((String)"authenticationManager", AuthenticationManager.class);
        try {
            return (T)authenticationManager.authenticate((Authentication)authentication);
        }
        catch (AuthenticationException e) {
            return null;
        }
    }
}

