/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.security;

import javax.servlet.http.HttpServletRequest;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.util.IpAddressMatcher;
import org.springframework.util.StringUtils;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.security.CredentialsExpiredErrorHandler;
import org.web4thejob.security.SecurityUtil;
import org.web4thejob.security.UserDetailsEx;

public class CustomELRequestMatcherContext {
    private final HttpServletRequest request;

    public CustomELRequestMatcherContext(HttpServletRequest request) {
        this.request = request;
    }

    public boolean hasIpAddress(String ipAddress) {
        return new IpAddressMatcher(ipAddress).matches(this.request);
    }

    public boolean hasHeader(String headerName, String value) {
        String header = this.request.getHeader(headerName);
        if (!StringUtils.hasText((String)header)) {
            return false;
        }
        return header.contains(value);
    }

    public boolean isFromIntranet() {
        return SecurityUtil.isFromIntranet(this.request.getRemoteAddr());
    }

    public boolean isFirstUse() {
        return SecurityUtil.isFirstUse();
    }

    public boolean isCredentialsExpired() {
        if (SecurityContextHolder.getContext().getAuthentication() != null && SecurityContextHolder.getContext().getAuthentication().isAuthenticated() && SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof UserDetailsEx) {
            return true;
        }
        if (((CredentialsExpiredErrorHandler)((Object)ContextUtil.getBean(CredentialsExpiredErrorHandler.class))).getExpiredUserName() != null) {
            CredentialsExpiredErrorHandler ex = (CredentialsExpiredErrorHandler)((Object)ContextUtil.getBean(CredentialsExpiredErrorHandler.class));
            this.request.getSession().setAttribute("web4thejob-EXPIRED_USER_NAME", (Object)((CredentialsExpiredErrorHandler)((Object)ContextUtil.getBean(CredentialsExpiredErrorHandler.class))).getExpiredUserName());
            ex.setExpiredUserName(null);
            return true;
        }
        return false;
    }
}

