/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.security;

import org.springframework.beans.BeansException;
import org.springframework.stereotype.Component;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.security.AuthorizationBeanPostProcessor;
import org.web4thejob.security.SecuredResource;
import org.web4thejob.security.UnauthorizedResourceException;

@Component
public class SpringSecurityAuthorizationBeanPostProcessor
implements AuthorizationBeanPostProcessor {
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof SecuredResource && !ContextUtil.getSessionContext().getSecurityContext().isAccessible(((SecuredResource)bean).getSid())) {
            throw new UnauthorizedResourceException();
        }
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

