/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.authentication.CredentialsExpiredException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;

public class CredentialsExpiredErrorHandler
extends SimpleUrlAuthenticationFailureHandler {
    private String expiredUserName;

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        if (exception instanceof CredentialsExpiredException) {
            this.saveException(request, exception);
            this.getRedirectStrategy().sendRedirect(request, response, "/");
        } else {
            super.onAuthenticationFailure(request, response, exception);
        }
    }

    public void setExpiredUserName(String expiredUserName) {
        this.expiredUserName = expiredUserName;
    }

    public String getExpiredUserName() {
        return this.expiredUserName;
    }
}

