/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.security;

import org.springframework.security.web.util.matcher.IpAddressMatcher;
import org.web4thejob.context.ContextUtil;

public class SecurityUtil {
    private static boolean firstUse = true;

    public static boolean hasIpAddress(String ipAddress, String remoteAddress) {
        return new IpAddressMatcher(ipAddress).matches(remoteAddress);
    }

    public static boolean isFromIntranet(String remoteAddress) {
        return SecurityUtil.hasIpAddress("127.0.0.1", remoteAddress) || SecurityUtil.hasIpAddress("10.0.0.1/8", remoteAddress) || SecurityUtil.hasIpAddress("192.168.1.1/24", remoteAddress) || remoteAddress.startsWith("0");
    }

    public static boolean isFirstUse() {
        if (firstUse) {
            try {
                boolean installed = ContextUtil.getSystemJoblet().isInstalled();
                boolean pchanged = ContextUtil.getSecurityService().authenticate("admin", "admin") == null;
                firstUse = !installed || !pchanged;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return firstUse;
    }
}

