/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import nu.xom.Element;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Scope;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.Path;
import org.web4thejob.orm.PropertyMetadata;
import org.web4thejob.orm.query.Condition;
import org.web4thejob.orm.query.Query;
import org.web4thejob.security.AuthorizationPolicy;
import org.web4thejob.security.RoleIdentity;
import org.web4thejob.security.SecurityContext;
import org.web4thejob.security.UserDetailsEx;
import org.web4thejob.security.UserIdentity;
import org.web4thejob.util.XMLUtil;

@Component
@Scope(value="session")
public class SpringSecurityContext
implements SecurityContext,
InitializingBean {
    private Set<String> revokedResources = new HashSet<String>();
    private Boolean administrator = null;

    public void clearContext() {
        SecurityContextHolder.clearContext();
    }

    public UserIdentity getUserIdentity() {
        if (SecurityContextHolder.getContext().getAuthentication().getPrincipal() instanceof UserDetailsEx) {
            return ((UserDetailsEx)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).getUserIdentity();
        }
        return null;
    }

    public boolean hasRole(String role) {
        role = "ROLE_" + role;
        if (SecurityContextHolder.getContext().getAuthentication() != null) {
            for (GrantedAuthority grantedAuthority : SecurityContextHolder.getContext().getAuthentication().getAuthorities()) {
                if (!grantedAuthority.getAuthority().equals(role)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAccessible(String securityId) {
        String[] token;
        if (this.isAdministrator()) {
            return true;
        }
        String tokens = null;
        for (String aToken : token = securityId.split("-")) {
            if (!this.revokedResources.contains(tokens = tokens == null ? aToken : tokens + "-" + aToken)) continue;
            return false;
        }
        tokens = null;
        token = securityId.split("-");
        for (int i = token.length - 1; i >= 0; --i) {
            if (!this.revokedResources.contains(tokens = tokens == null ? token[i] : token[i] + "-" + tokens)) continue;
            return false;
        }
        return true;
    }

    public boolean isPasswordValid(String rawPassword) {
        UserIdentity userIdentity = this.getUserIdentity();
        if (userIdentity == null) {
            return false;
        }
        return ContextUtil.getSecurityService().isPasswordValid(userIdentity, rawPassword);
    }

    public boolean isAdministrator() {
        if (this.administrator == null) {
            this.administrator = this.hasRole("ADMINISTRATOR");
        }
        return this.administrator;
    }

    public boolean renewPassword(String oldPassword, String newPassword) {
        if (this.isPasswordValid(oldPassword)) {
            return ContextUtil.getSecurityService().renewPassword(this.getUserIdentity(), oldPassword, newPassword);
        }
        return false;
    }

    public String getAuthorizationMenu() {
        Element userMenu = new Element("uid_" + this.getUserIdentity().getId());
        for (Element element : this.getAuthorizationElements()) {
            if (!element.getLocalName().equals("user-menu")) continue;
            if (element.getChildElements().size() != 1) {
                throw new IllegalArgumentException();
            }
            Element startMenu = element.getChildElements().get(0);
            for (int i = 0; i < startMenu.getChildElements().size(); ++i) {
                userMenu.appendChild(startMenu.getChildElements().get(i).copy());
            }
        }
        return userMenu.toXML();
    }

    public void afterPropertiesSet() throws Exception {
        List<Element> elements = this.getAuthorizationElements();
        for (Element element : elements) {
            this.readRevokedResources(element);
        }
        this.revokedResources = Collections.unmodifiableSet(this.revokedResources);
    }

    private List<Element> getAuthorizationElements() {
        ArrayList<Element> elements = new ArrayList<Element>();
        Query query = ContextUtil.getEntityFactory().buildQuery(RoleIdentity.class);
        query.addCriterion(new Path("users").append("user").append("id"), Condition.EQ, (Object)(this.getUserIdentity() != null ? this.getUserIdentity().getId() : -1L));
        query.addOrderBy(new Path("index"));
        PropertyMetadata propertyMetadata = ContextUtil.getMRS().getPropertyMetadata(RoleIdentity.class, "authorizationPolicy");
        for (Entity role : ContextUtil.getDRS().findByQuery(query)) {
            AuthorizationPolicy policy = (AuthorizationPolicy)propertyMetadata.getValue(role);
            if (policy == null || !StringUtils.hasText((String)policy.getDefinition())) continue;
            Element rootElement = XMLUtil.getRootElement((String)policy.getDefinition());
            if (rootElement == null || !rootElement.getLocalName().equals("authorization")) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < rootElement.getChildElements().size(); ++i) {
                elements.add(rootElement.getChildElements().get(i));
            }
        }
        return elements;
    }

    private void readRevokedResources(Element element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        if (element.getLocalName().equals("panels") || element.getLocalName().equals("commands") || element.getLocalName().equals("panel-commands")) {
            for (int i = 0; i < element.getChildElements().size(); ++i) {
                this.revokedResources.add(XMLUtil.getTextualValue((Element)element.getChildElements().get(i)));
            }
        }
    }
}

