/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.security;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.Entity;
import org.web4thejob.orm.Path;
import org.web4thejob.orm.query.Condition;
import org.web4thejob.orm.query.Query;
import org.web4thejob.security.GrantedAuthorityImpl;
import org.web4thejob.security.RoleIdentity;
import org.web4thejob.security.RoleMembers;
import org.web4thejob.security.UserDetailsEx;
import org.web4thejob.security.UserIdentity;

public class UserDetailsExImpl
implements UserDetailsEx {
    private static final long serialVersionUID = 1L;
    private final UserIdentity userIdentity;
    private final Collection<GrantedAuthority> authorities;

    public UserDetailsExImpl(UserIdentity userIdentity) {
        if (userIdentity == null) {
            throw new IllegalArgumentException();
        }
        this.userIdentity = userIdentity;
        this.authorities = new ArrayList<GrantedAuthority>(1);
        this.loadAuthorities();
    }

    private void loadAuthorities() {
        if (this.userIdentity.isNewInstance()) {
            return;
        }
        ContextUtil.getTransactionWrapper().execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                Query query = ContextUtil.getEntityFactory().buildQuery(RoleMembers.class);
                query.addCriterion(new Path("user"), Condition.EQ, (Object)UserDetailsExImpl.this.userIdentity);
                for (Entity roleMembers : ContextUtil.getDRS().findByQuery(query)) {
                    RoleIdentity roleIdentity = (RoleIdentity)ContextUtil.getMRS().deproxyEntity((Entity)((RoleMembers)roleMembers).getRole());
                    UserDetailsExImpl.this.authorities.add(new GrantedAuthorityImpl(roleIdentity));
                }
            }
        });
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public String getPassword() {
        return this.userIdentity.getPassword();
    }

    public String getUsername() {
        return this.userIdentity.getCode();
    }

    public boolean isAccountNonExpired() {
        return this.userIdentity.isAccountNonExpired();
    }

    public boolean isAccountNonLocked() {
        return this.userIdentity.isAccountNonLocked();
    }

    public boolean isCredentialsNonExpired() {
        return this.userIdentity.isCredentialsNonExpired();
    }

    public boolean isEnabled() {
        return this.userIdentity.isEnabled();
    }

    @Override
    public UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.userIdentity.getCode();
    }
}

