/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.security;

import org.springframework.dao.DataAccessException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.web4thejob.context.ContextUtil;
import org.web4thejob.orm.Path;
import org.web4thejob.orm.query.Condition;
import org.web4thejob.orm.query.Query;
import org.web4thejob.security.UserDetailsExImpl;
import org.web4thejob.security.UserIdentity;

public class UserDetailsServiceImpl
implements UserDetailsService {
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        Query query = ContextUtil.getEntityFactory().buildQuery(UserIdentity.class);
        query.addCriterion(new Path("code"), Condition.EQ, (Object)username);
        UserIdentity userIdentity = (UserIdentity)ContextUtil.getDRS().findUniqueByQuery(query);
        if (userIdentity == null) {
            throw new UsernameNotFoundException(username);
        }
        return new UserDetailsExImpl(userIdentity);
    }
}

