/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.canvas;

import java.io.Reader;
import javax.servlet.ServletRequest;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NodeList;
import org.web4thejob.studio.canvas.CanvasAuService;
import org.zkoss.idom.Document;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.io.FileReader;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.http.SimpleUiFactory;
import org.zkoss.zk.ui.metainfo.PageDefinition;
import org.zkoss.zk.ui.sys.RequestInfo;

public class CanvasUiFactory
extends SimpleUiFactory {
    private static final CanvasAuService canvasAuService = new CanvasAuService();
    private static final XPathExpression xPathExpression;

    private static void cleanUUIDs(Document document) throws XPathExpressionException {
        NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            ((Element)nodeList.item(i)).removeAttribute("uuid");
        }
    }

    public Desktop newDesktop(RequestInfo ri, String updateURI, String path) {
        Desktop desktop = super.newDesktop(ri, updateURI, path);
        desktop.addListener((Object)canvasAuService);
        return desktop;
    }

    public PageDefinition getPageDefinition(RequestInfo ri, String path) {
        ServletRequest request = (ServletRequest)ri.getNativeRequest();
        String file = request.getParameter("w4tjstudio_workfile");
        if (file == null || path.startsWith("~")) {
            return super.getPageDefinition(ri, path);
        }
        try {
            Document document = new SAXBuilder(true, false, true).build((Reader)new FileReader(file, "UTF-8"));
            CanvasUiFactory.cleanUUIDs(document);
            return super.getPageDefinitionDirectly(ri, document, "zul");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            xPathExpression = XPathFactory.newInstance().newXPath().compile("descendant-or-self::*[@uuid]");
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }
}

