/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.web4thejob.studio.controller.Controller;
import org.web4thejob.studio.controller.ControllerEnum;
import org.web4thejob.studio.message.Message;
import org.web4thejob.studio.message.MessageEnum;
import org.web4thejob.studio.support.StudioUtil;
import org.zkoss.lang.Generics;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.select.SelectorComposer;

public abstract class AbstractController
extends SelectorComposer<Component>
implements Controller {
    private final List<Message> queue = new ArrayList<Message>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void register(Controller controller) {
        Desktop desktop = Executions.getCurrent().getDesktop();
        synchronized (desktop) {
            TreeMap<ControllerEnum, Controller> controllers = (TreeMap<ControllerEnum, Controller>)Generics.cast((Object)Executions.getCurrent().getDesktop().getAttribute("studio-controllers"));
            if (controllers == null) {
                controllers = new TreeMap<ControllerEnum, Controller>();
                Executions.getCurrent().getDesktop().setAttribute("studio-controllers", controllers);
            }
            controllers.put(controller.getId(), controller);
        }
    }

    public void doAfterCompose(Component comp) throws Exception {
        super.doAfterCompose(comp);
        AbstractController.register(this);
        this.init();
    }

    @Override
    public void publish(MessageEnum id) {
        this.publish(id, null);
    }

    @Override
    public void publish(MessageEnum id, Object data) {
        this.queue.add(new Message(id, this, data));
        if (this.queue.size() > 1) {
            return;
        }
        try {
            while (!this.queue.isEmpty()) {
                Message message = this.queue.get(0);
                for (Controller controller : StudioUtil.getLocalControllers()) {
                    if (message.isStopPropagation()) break;
                    controller.process(message);
                }
                this.queue.remove(message);
                if (MessageEnum.EVALUATE_ZUL == id) continue;
                if (MessageEnum.EVALUATE_XML == id) {
                    this.publish(MessageEnum.XML_EVAL_SUCCEEDED, data);
                    continue;
                }
                if (MessageEnum.ATTRIBUTE_CHANGED == id) {
                    this.publish(MessageEnum.EVALUATE_ZUL, (Object)MessageEnum.ATTRIBUTE_CHANGED);
                    continue;
                }
                if (MessageEnum.COMPONENT_DETACHED == id) {
                    this.publish(MessageEnum.EVALUATE_ZUL, (Object)MessageEnum.COMPONENT_DETACHED);
                    continue;
                }
                if (MessageEnum.ZUL_EVAL_FAILED != id) continue;
                this.publish(MessageEnum.COMPONENT_SELECTED);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.queue.clear();
            if (MessageEnum.EVALUATE_ZUL == id) {
                this.publish(MessageEnum.ZUL_EVAL_FAILED, e);
            }
            if (MessageEnum.EVALUATE_XML == id) {
                this.publish(MessageEnum.XML_EVAL_FAILED, e);
            }
            StudioUtil.showError(e);
        }
    }

    @Override
    public void process(Message message) {
    }

    protected void init() throws Exception {
    }

    @Override
    public int compareTo(Controller o) {
        return this.getId().compareTo(o.getId());
    }
}

