/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.controller.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Node;
import org.apache.commons.io.IOUtils;
import org.web4thejob.studio.controller.AbstractController;
import org.web4thejob.studio.controller.ControllerEnum;
import org.web4thejob.studio.dom.Element;
import org.web4thejob.studio.message.Message;
import org.web4thejob.studio.message.MessageEnum;
import org.web4thejob.studio.support.CodeFormatter;
import org.web4thejob.studio.support.StudioUtil;
import org.web4thejob.studio.support.ZulXsdUtil;
import org.zkoss.io.FileReader;
import org.zkoss.json.JSONObject;
import org.zkoss.util.resource.Locators;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Filedownload;
import org.zkoss.zul.Textbox;

public class CodeController
extends AbstractController {
    @Wire
    private Textbox zulBox;
    private boolean changed;
    private Document document;
    private nu.xom.Element selection;

    @Override
    public ControllerEnum getId() {
        return ControllerEnum.CODE_CONTROLLER;
    }

    public void reset(String file) {
        try {
            this.document = StudioUtil.buildDocument(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.changed = false;
        this.print();
    }

    public Document getCode() {
        if (this.changed) {
            this.document = StudioUtil.buildDocument(this.zulBox.getValue());
        }
        return this.document;
    }

    public void print() {
        if (this.document == null) {
            return;
        }
        Document doc = (Document)this.document.copy();
        StudioUtil.cleanUUIDs(doc.getRootElement());
        this.zulBox.setValue(CodeFormatter.formatXML(doc));
        Clients.evalJavaScript((String)"w4tjStudioDesigner.refreshCode()");
    }

    @Listen(value="onChange=#zulBox;")
    public void codeChanged() {
        if (!this.changed) {
            this.publish(MessageEnum.COMPONENT_SELECTED);
            this.publish(MessageEnum.CODE_CHANGED);
        }
        this.changed = true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void process(Message message) {
        switch (message.getId()) {
            case COMPONENT_ADDED: {
                JSONObject data = (JSONObject)message.getData();
                nu.xom.Element parent = StudioUtil.getElementByUuid((String)data.get((Object)"parent"));
                String template = ((String)data.get((Object)"template")).replace("~./", "web/");
                nu.xom.Element toSelect = null;
                try {
                    nu.xom.Element target = StudioUtil.buildDocument(Locators.getDefault().getResourceAsStream(template)).getRootElement();
                    if ("zk".equals(target.getLocalName())) {
                        for (int i = 0; i < target.getChildCount(); ++i) {
                            nu.xom.Element clone = (nu.xom.Element)target.getChild(i).copy();
                            parent.appendChild((Node)clone);
                            if (i != 0) continue;
                            toSelect = clone;
                        }
                    } else {
                        toSelect = (nu.xom.Element)target.copy();
                        parent.appendChild((Node)toSelect);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                HashMap<String, String> hints = new HashMap<String, String>();
                hints.put("w4tjstudio_hint", MessageEnum.COMPONENT_ADDED.name());
                hints.put("w4tjstudio_xpath", ZulXsdUtil.getXPath(toSelect));
                this.publish(MessageEnum.EVALUATE_ZUL, hints);
                break;
            }
            case RESET: {
                this.reset((String)message.getData());
                break;
            }
            case COMPONENT_DETACHED: {
                nu.xom.Element element = (nu.xom.Element)message.getData();
                element.detach();
                this.print();
                break;
            }
            case EVALUATE_XML: {
                this.getCode();
                break;
            }
            case ZUL_EVAL_SUCCEEDED: {
                this.reset((String)message.getData("w4tjstudio_workfile"));
                this.changed = false;
                break;
            }
            case ZUL_EVAL_FAILED: {
                this.changed = true;
                this.print();
                break;
            }
            case ATTRIBUTE_CHANGED: {
                this.print();
                break;
            }
            case COMPONENT_SELECTED: {
                this.selection = (nu.xom.Element)message.getData();
                break;
            }
            case CODE_ACTIVATED: {
                this.focusSelectedElement();
                break;
            }
            case DOWNLOAD_REQUESTED: {
                try {
                    String uri = StudioUtil.getCanvasURI().split("\\?")[0];
                    if (!uri.endsWith(".zul")) {
                        uri = uri + ".zul";
                    }
                    Filedownload.save((byte[])this.zulBox.getValue().getBytes("UTF-8"), (String)"application/xml", (String)uri);
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    StudioUtil.showError(e);
                }
            }
        }
    }

    private void focusSelectedElement() {
        String regex;
        List lines;
        if (this.changed || this.selection == null || this.selection.getAttributeValue("uuid") == null && !"attribute".equals(this.selection.getLocalName())) {
            return;
        }
        try {
            File workFile = new File(StudioUtil.getWorkFile());
            if (!workFile.exists()) {
                return;
            }
            lines = IOUtils.readLines((Reader)new FileReader(workFile, "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        int lineNo = -1;
        int charNo = -1;
        String tag = this.selection.getQualifiedName();
        String uuid = this.selection.getAttributeValue("uuid");
        if (!"attribute".equals(tag)) {
            regex = "(^\\s*)(<" + tag + "\\s{1,1})(.*)(\\s*uuid=\"" + uuid + "\")";
        } else {
            String preffix = "";
            Attribute attribute = this.selection.getAttribute("name");
            if (attribute == null) {
                String clientNS = StudioUtil.getClientNamespace((Element)this.selection);
                attribute = this.selection.getAttribute("name", clientNS);
                preffix = attribute.getNamespacePrefix() + ":";
            }
            regex = "(^\\s*)(<" + tag + "\\s{1,1})(.*)(\\s*" + preffix + "name=\"" + attribute.getValue() + "\")";
        }
        Pattern pattern = Pattern.compile(regex);
        for (String line : lines) {
            ++lineNo;
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            for (int m = 0; m <= matcher.groupCount(); ++m) {
                if (!matcher.group(m).startsWith("<")) continue;
                charNo = matcher.start(m);
            }
        }
        if (lineNo >= 0 && charNo >= 0) {
            Clients.evalJavaScript((String)("myCodeMirror.setCursor({line:" + lineNo + ",ch:" + charNo + "});myCodeMirror.scrollIntoView(null,Math.round(jq(\".CodeMirror-scroll\").height() / 2))"));
        }
    }

    @Listen(value="onZulCodeClick=#zulBox")
    public void onZulCodeClick(Event event) {
        List lines;
        Clients.evalJavaScript((String)"zAu.cmd0.clearBusy(zk('$propertyeditor').$())");
        if (this.changed) {
            return;
        }
        int targetLine = (Integer)((Map)event.getData()).get("line");
        try {
            File workFile = new File(StudioUtil.getWorkFile());
            if (!workFile.exists()) {
                return;
            }
            lines = IOUtils.readLines((Reader)new FileReader(workFile, "UTF-8"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String uuid = null;
        Pattern pattern = Pattern.compile(".*\\s+uuid=\"(\\w+)\"");
        int lno = -1;
        for (String line : lines) {
            if (++lno != targetLine) continue;
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) break;
            uuid = matcher.group(1);
            break;
        }
        if (uuid != null) {
            this.publish(MessageEnum.COMPONENT_SELECTED, StudioUtil.getElementByUuid(uuid));
        }
    }
}

