/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.controller.impl;

import java.util.HashMap;
import nu.xom.Element;
import org.apache.commons.lang3.Validate;
import org.web4thejob.studio.controller.AbstractController;
import org.web4thejob.studio.controller.ControllerEnum;
import org.web4thejob.studio.message.Message;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Panel;
import org.zkoss.zul.Window;

public class CodeDialogController
extends AbstractController {
    @Wire
    private Window editorWindow;
    @Wire
    private Panel editorPanel;
    private Element element;
    private String eventName;
    private String mode;
    private boolean isServerSide;

    @Override
    public ControllerEnum getId() {
        return ControllerEnum.CODE_DIALOG_CONTROLLER;
    }

    @Override
    public void doAfterCompose(Component comp) throws Exception {
        super.doAfterCompose(comp);
        this.editorWindow.setAttribute("controller", (Object)this);
        this.mode = (String)Executions.getCurrent().getArg().get("mode");
        Validate.notNull((Object)this.mode);
        this.element = (Element)Executions.getCurrent().getArg().get("element");
        Validate.notNull((Object)this.element);
        this.eventName = (String)Executions.getCurrent().getArg().get("event");
        boolean bl = this.isServerSide = !"javascript".equals(this.mode);
        if (this.eventName != null) {
            this.editorPanel.setTitle("<strong class=\"label label-primary\" style=\"font-size:120%;font-family:monospace\">" + this.eventName + "</strong> <strong>" + (this.isServerSide ? "Java" : "Javascript") + "</strong> handler on " + "the " + (this.isServerSide ? "server" : "browser"));
        } else {
            this.editorPanel.setTitle("<strong class=\"label label-primary\" style=\"font-size:120%;font-family:monospace\">Source</strong>");
        }
        this.editorWindow.addEventListener("onCancel", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                CodeDialogController.this.editorWindow.detach();
            }
        });
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("element", this.element);
        data.put("mode", this.mode);
        data.put("event", this.eventName);
        Executions.getCurrent().createComponents("~./include/codemirror.zul", (Component)this.editorPanel.getPanelchildren(), data);
    }

    @Override
    public void process(Message message) {
        switch (message.getId()) {
            case EVALUATE_XML: {
                if (this.editorWindow == null) break;
                this.editorWindow.detach();
            }
        }
    }
}

