/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.controller.impl;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.XPathContext;
import org.apache.commons.lang3.Validate;
import org.web4thejob.studio.controller.AbstractController;
import org.web4thejob.studio.controller.ControllerEnum;
import org.web4thejob.studio.message.Message;
import org.web4thejob.studio.message.MessageEnum;
import org.web4thejob.studio.support.StudioUtil;
import org.zkoss.lang.Generics;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.CheckEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.event.URIEvent;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.Menuseparator;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Tabbox;

public class DesignerController
extends AbstractController {
    private static final String PARAM_TIMESTAMP = "w4tjstudio_timestamp";
    public static final String PARAM_HINT = "w4tjstudio_hint";
    public static final String PARAM_MESSAGE = "w4tjstudio_message";
    public static final String PARAM_WORK_FILE = "w4tjstudio_workfile";
    public static final String PARAM_PRODUCTION_FILE = "w4tjstudio_prodfile";
    public static final String PARAM_XPATH = "w4tjstudio_xpath";
    @Wire
    private Iframe canvasHolder;
    @Wire
    private Tabbox views;
    @Wire
    private Tab canvasView;
    @Wire
    private Tab outlineView;
    @Wire
    private Tab codeView;
    private Element selection;
    private Menupopup actionsPopup;
    private Menupopup parsePopup;

    @Override
    public ControllerEnum getId() {
        return ControllerEnum.DESIGNER_CONTROLLER;
    }

    @Listen(value="onWidgetSelected=#designer")
    public void onWidgetSelected(Event event) throws InterruptedException {
        String target = (String)((Map)event.getData()).get("target");
        Validate.notNull((Object)target);
        try {
            this.selection = StudioUtil.getElementByUuid(target);
            this.publish(MessageEnum.COMPONENT_SELECTED, this.selection);
        }
        catch (Exception e) {
            this.publish(MessageEnum.COMPONENT_SELECTED);
        }
    }

    @Listen(value="onParseZulDropdownClicked=#designer")
    public void onParseZulDropdownClicked(Event event) {
        if (this.parsePopup == null) {
            this.parsePopup = new Menupopup();
            this.parsePopup.setId("parseMenupopup");
            this.parsePopup.setMold("w4tjstudio");
            this.parsePopup.setSclass("custom-menupopup");
            this.parsePopup.setPage(event.getTarget().getPage());
        } else {
            this.parsePopup.getChildren().clear();
        }
        int x = Integer.valueOf(((Map)event.getData()).get("right").toString());
        this.parsePopup.open("auto", ((Map)event.getData()).get("top").toString() + "px");
        this.parsePopup.setStyle("right:" + x + "px");
        Menuitem returntoCanvas = new Menuitem("Always return to canvas");
        returntoCanvas.setParent((Component)this.parsePopup);
        returntoCanvas.setCheckmark(true);
        returntoCanvas.setAutocheck(true);
        returntoCanvas.setChecked(StudioUtil.getConfiguration().isAlwaysReturnToCanvas());
        returntoCanvas.addEventListener("onCheck", (EventListener)new EventListener<CheckEvent>(){

            public void onEvent(CheckEvent event) throws Exception {
                StudioUtil.getConfiguration().setAlwaysReturnToCanvas(event.isChecked());
            }
        });
        new Menuseparator().setParent((Component)this.parsePopup);
        boolean codeValid = StudioUtil.isCodeValid();
        Menuitem nativeNS = new Menuitem("Native namespace");
        nativeNS.setDisabled(!codeValid);
        nativeNS.setParent((Component)this.parsePopup);
        nativeNS.setCheckmark(true);
        nativeNS.setAutocheck(true);
        nativeNS.setChecked(StudioUtil.namespaceExistsInCode("n"));
        nativeNS.addEventListener("onCheck", (EventListener)new EventListener<CheckEvent>(){

            public void onEvent(CheckEvent event) throws Exception {
                if (event.isChecked()) {
                    StudioUtil.addNamespaceToCode("n", "native");
                } else {
                    StudioUtil.removeNamespaceFromCode("n");
                }
                DesignerController.this.publish(MessageEnum.EVALUATE_XML);
            }
        });
        Menuitem clientNS = new Menuitem("Client namespace");
        clientNS.setDisabled(!codeValid);
        clientNS.setParent((Component)this.parsePopup);
        clientNS.setCheckmark(true);
        clientNS.setAutocheck(true);
        clientNS.setChecked(StudioUtil.namespaceExistsInCode("c"));
        clientNS.addEventListener("onCheck", (EventListener)new EventListener<CheckEvent>(){

            public void onEvent(CheckEvent event) throws Exception {
                if (event.isChecked()) {
                    StudioUtil.addNamespaceToCode("c", "client");
                } else {
                    StudioUtil.removeNamespaceFromCode("c");
                }
                DesignerController.this.publish(MessageEnum.EVALUATE_XML);
            }
        });
        Menuitem clientAttrNS = new Menuitem("Client/Attribute namespace");
        clientAttrNS.setDisabled(!codeValid);
        clientAttrNS.setParent((Component)this.parsePopup);
        clientAttrNS.setCheckmark(true);
        clientAttrNS.setAutocheck(true);
        clientAttrNS.setChecked(StudioUtil.namespaceExistsInCode("ca"));
        clientAttrNS.addEventListener("onCheck", (EventListener)new EventListener<CheckEvent>(){

            public void onEvent(CheckEvent event) throws Exception {
                if (event.isChecked()) {
                    StudioUtil.addNamespaceToCode("ca", "client/attribute");
                } else {
                    StudioUtil.removeNamespaceFromCode("ca");
                }
                DesignerController.this.publish(MessageEnum.EVALUATE_XML);
            }
        });
        new Menuseparator().setParent((Component)this.parsePopup);
        Menuitem download = new Menuitem("Download source");
        download.setParent((Component)this.parsePopup);
        download.setIconSclass("z-icon-download");
        download.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                DesignerController.this.publish(MessageEnum.DOWNLOAD_REQUESTED);
            }
        });
    }

    @Listen(value="onActionsClicked=#designer")
    public void onActionsClicked(Event event) {
        if (this.actionsPopup == null) {
            this.actionsPopup = new Menupopup();
            this.actionsPopup.setId("actionsMenupopup");
            this.actionsPopup.setMold("w4tjstudio");
            this.actionsPopup.setSclass("custom-menupopup");
            this.actionsPopup.setPage(event.getTarget().getPage());
        } else {
            this.actionsPopup.getChildren().clear();
        }
        int x = Integer.valueOf(((Map)event.getData()).get("right").toString());
        this.actionsPopup.open("auto", ((Map)event.getData()).get("top").toString() + "px");
        this.actionsPopup.setStyle("right:" + x + "px");
        if (this.selection == null) {
            Menuitem nosel = new Menuitem("No current selection");
            nosel.setParent((Component)this.actionsPopup);
            nosel.setDisabled(true);
            return;
        }
        Menuitem id = new Menuitem(this.selection.getLocalName() + " [" + this.selection.getAttributeValue("uuid") + "]");
        id.setParent((Component)this.actionsPopup);
        id.setDisabled(true);
        new Menuseparator().setParent((Component)this.actionsPopup);
        final Menuitem cut = new Menuitem("Cut");
        cut.setParent((Component)this.actionsPopup);
        cut.setIconSclass("z-icon-cut");
        cut.setAttribute("target", (Object)this.selection);
        cut.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Element element = (Element)cut.getAttribute("target");
                element.detach();
                Element cutElement = (Element)element.copy();
                Executions.getCurrent().getDesktop().setAttribute("cutcopy", (Object)cutElement);
                DesignerController.this.publish(MessageEnum.COMPONENT_SELECTED);
                DesignerController.this.publish(MessageEnum.COMPONENT_DETACHED, element);
            }
        });
        final Menuitem copy = new Menuitem("Copy");
        copy.setParent((Component)this.actionsPopup);
        copy.setIconSclass("z-icon-copy");
        copy.setAttribute("target", (Object)this.selection);
        copy.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Element element = (Element)copy.getAttribute("target");
                Executions.getCurrent().getDesktop().setAttribute("cutcopy", (Object)element);
            }
        });
        new Menuseparator().setParent((Component)this.actionsPopup);
        final Menuitem pasteInside = new Menuitem("Paste inside");
        pasteInside.setParent((Component)this.actionsPopup);
        pasteInside.setIconSclass("z-icon-paste");
        pasteInside.setAttribute("target", (Object)this.selection);
        pasteInside.setDisabled(!Executions.getCurrent().getDesktop().hasAttribute("cutcopy"));
        pasteInside.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Element child;
                Element parent = (Element)pasteInside.getAttribute("target");
                if (StudioUtil.acceptsChild(parent, child = (Element)((Element)Executions.getCurrent().getDesktop().getAttribute("cutcopy")).copy())) {
                    parent.appendChild((Node)child);
                    DesignerController.this.publish(MessageEnum.COMPONENT_SELECTED, child);
                    DesignerController.this.publish(MessageEnum.EVALUATE_ZUL);
                }
            }
        });
        final Menuitem pasteBefore = new Menuitem("Paste before");
        pasteBefore.setParent((Component)this.actionsPopup);
        pasteBefore.setIconSclass("z-icon-paste");
        pasteBefore.setAttribute("target", (Object)this.selection);
        pasteBefore.setDisabled(!Executions.getCurrent().getDesktop().hasAttribute("cutcopy"));
        pasteBefore.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Element child;
                Element before = (Element)pasteBefore.getAttribute("target");
                Element parent = (Element)before.getParent();
                int pos = 0;
                for (int i = 0; i < parent.getChildCount(); ++i) {
                    if (!parent.getChild(i).equals((Object)before)) continue;
                    pos = i;
                    break;
                }
                if (StudioUtil.acceptsChild(parent, child = (Element)((Element)Executions.getCurrent().getDesktop().getAttribute("cutcopy")).copy())) {
                    parent.insertChild((Node)child, pos);
                    DesignerController.this.publish(MessageEnum.COMPONENT_SELECTED, child);
                    DesignerController.this.publish(MessageEnum.EVALUATE_ZUL);
                }
            }
        });
        new Menuseparator().setParent((Component)this.actionsPopup);
        final Menuitem detach = new Menuitem("Detach");
        detach.setParent((Component)this.actionsPopup);
        detach.setIconSclass("z-icon-trash-o");
        detach.setAttribute("target", (Object)this.selection);
        detach.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Element element = (Element)detach.getAttribute("target");
                element.detach();
                DesignerController.this.publish(MessageEnum.COMPONENT_SELECTED);
                DesignerController.this.publish(MessageEnum.COMPONENT_DETACHED, element);
            }
        });
    }

    @Listen(value="onCanvasAddition=#designer")
    public void onCanvasAddition(Event event) {
        this.publish(MessageEnum.COMPONENT_ADDED, event.getData());
        StudioUtil.clearCanvasBusy(null);
    }

    @Listen(value="onCanvasSucceeded=#designer")
    public void onCanvasSucceeded(Event event) {
        StudioUtil.clearAlerts();
        Map data = (Map)Generics.cast((Object)event.getData());
        String message = null;
        String workFile = null;
        if (data != null) {
            message = (String)data.get(PARAM_MESSAGE);
            workFile = (String)data.get(PARAM_WORK_FILE);
            StudioUtil.setWorkFile(workFile);
        }
        if (message == null) {
            Clients.clearBusy();
            this.publish(MessageEnum.RESET, workFile);
        } else {
            MessageEnum id = MessageEnum.valueOf(message);
            switch (id) {
                case EVALUATE_ZUL: {
                    data.remove(PARAM_MESSAGE);
                    this.publish(MessageEnum.ZUL_EVAL_SUCCEEDED, data);
                    if (!StudioUtil.getConfiguration().isAlwaysReturnToCanvas() || this.canvasView.isSelected()) break;
                    this.canvasView.setSelected(true);
                }
            }
        }
    }

    @Listen(value="onCanvasFailed=#designer")
    public void onCanvasFailed(Event event) {
        Clients.clearBusy();
        StudioUtil.clearAlerts();
        Map data = (Map)Generics.cast((Object)event.getData());
        String message = null;
        if (data != null) {
            message = (String)data.get(PARAM_MESSAGE);
        }
        if (message == null) {
            this.publish(MessageEnum.ZUL_EVAL_FAILED, "Unspecified error occurred");
            return;
        }
        MessageEnum id = MessageEnum.valueOf(message);
        switch (id) {
            case EVALUATE_ZUL: {
                this.publish(MessageEnum.ZUL_EVAL_FAILED, data.get("exception"));
            }
        }
    }

    @Override
    public void process(Message message) {
        switch (message.getId()) {
            case EVALUATE_ZUL: {
                Clients.showBusy((String)"Parsing your zul...");
                LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                params.put(PARAM_MESSAGE, MessageEnum.EVALUATE_ZUL.name());
                if (message.getData() != null) {
                    if (message.getData() instanceof Map) {
                        params.putAll((Map)message.getData());
                    } else {
                        params.put(PARAM_HINT, message.getData().toString());
                    }
                }
                params.put(PARAM_TIMESTAMP, Long.valueOf(new Date().getTime()).toString());
                params.put(PARAM_WORK_FILE, StudioUtil.buildWorkingFile(StudioUtil.getCode()).getAbsolutePath());
                try {
                    String src = this.getCanvasHolderURI();
                    this.canvasHolder.removeAttribute("src");
                    this.canvasHolder.setSrc(Encodes.setToQueryString((StringBuffer)new StringBuffer(src), params).toString());
                    Clients.evalJavaScript((String)"w4tjStudioDesigner.monitorCanvasHealth()");
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            case XML_EVAL_SUCCEEDED: {
                this.publish(MessageEnum.EVALUATE_ZUL);
                break;
            }
            case ZUL_EVAL_SUCCEEDED: {
                Nodes nodes;
                String xpath;
                this.canvasView.setDisabled(false);
                this.outlineView.setDisabled(false);
                Clients.clearBusy();
                if (message.getData(PARAM_HINT) == null) {
                    Clients.evalJavaScript((String)"w4tjStudioDesigner.codeSuccessEffect()");
                    break;
                }
                if (!message.getData(PARAM_HINT).equals(MessageEnum.COMPONENT_ADDED.name()) || (xpath = (String)message.getData(PARAM_XPATH)) == null || (nodes = StudioUtil.getCode().query(xpath, XPathContext.makeNamespaceContext((Element)StudioUtil.getCode().getRootElement()))).size() != 1) break;
                this.selection = (Element)nodes.get(0);
                this.publish(MessageEnum.COMPONENT_SELECTED, this.selection);
                break;
            }
            case XML_EVAL_FAILED: {
                this.canvasView.setDisabled(true);
                this.outlineView.setDisabled(true);
                Clients.clearBusy();
                StudioUtil.clearAlerts();
                StudioUtil.showError((Exception)message.getData(), false);
                break;
            }
            case ZUL_EVAL_FAILED: {
                if (!this.codeView.isSelected()) {
                    this.codeView.setSelected(true);
                    Clients.evalJavaScript((String)"w4tjStudioDesigner.refreshCode()");
                }
                this.canvasView.setDisabled(true);
                this.outlineView.setDisabled(true);
                if (message.getData() == null) break;
                StudioUtil.showError(message.getData().toString(), false);
                break;
            }
            case CODE_CHANGED: {
                this.codeView.setSelected(true);
                this.canvasView.setDisabled(true);
                this.outlineView.setDisabled(true);
                break;
            }
            case COMPONENT_SELECTED: {
                Element newSelection = (Element)message.getData();
                if (newSelection != null && this.selection != null) {
                    Clients.evalJavaScript((String)("w4tjStudioDesigner.selectCanvasWidget('" + newSelection.getAttributeValue("uuid") + "')"));
                } else if (newSelection == null && this.selection != null) {
                    Clients.evalJavaScript((String)"w4tjStudioDesigner.selectCanvasWidget()");
                }
                this.selection = newSelection;
                break;
            }
            case NON_ZK_PAGE_VISITED: {
                this.codeView.setDisabled(true);
                this.outlineView.setDisabled(true);
                break;
            }
            case ZK_PAGE_VISITED: {
                this.codeView.setDisabled(false);
                this.outlineView.setDisabled(false);
                break;
            }
            case RESET: {
                this.selection = null;
                break;
            }
        }
    }

    @Listen(value="onParseZulClicked=#designer")
    public void onParseZulClicked() {
        this.publish(MessageEnum.EVALUATE_XML);
    }

    @Listen(value="onCanvasHang=#designer")
    public void onCanvasHang() {
        Clients.clearBusy();
        this.publish(MessageEnum.ZUL_EVAL_FAILED);
    }

    @Listen(value="onURIChange=#canvasHolder")
    public void onCanvasURIChanged(URIEvent event) {
        this.canvasHolder.setAttribute("src", (Object)event.getURI());
    }

    public String getCanvasHolderURI() {
        String src = (String)this.canvasHolder.getAttribute("src");
        if (src == null) {
            src = this.canvasHolder.getSrc();
        }
        try {
            src = Encodes.removeFromQueryString((String)src, (String)PARAM_MESSAGE);
            src = Encodes.removeFromQueryString((String)src, (String)PARAM_HINT);
            src = Encodes.removeFromQueryString((String)src, (String)PARAM_WORK_FILE);
            src = Encodes.removeFromQueryString((String)src, (String)PARAM_TIMESTAMP);
            src = Encodes.removeFromQueryString((String)src, (String)PARAM_PRODUCTION_FILE);
            src = Encodes.removeFromQueryString((String)src, (String)PARAM_XPATH);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return src;
    }

    @Listen(value="onNonZKPage=#designer")
    public void onNonZKPage() {
        this.publish(MessageEnum.NON_ZK_PAGE_VISITED);
    }

    @Listen(value="onZKPage=#designer")
    public void onZKPage() {
        this.publish(MessageEnum.ZK_PAGE_VISITED);
    }

    @Listen(value="onSelect=#views")
    public void onTabSelected(SelectEvent e) {
        Tab tab = (Tab)e.getTarget();
        if (tab.equals((Object)this.canvasView)) {
            this.publish(MessageEnum.DESIGNER_ACTIVATED);
        } else if (tab.equals((Object)this.outlineView)) {
            this.publish(MessageEnum.OUTLINE_ACTIVATED);
        } else if (tab.equals((Object)this.codeView)) {
            this.publish(MessageEnum.CODE_ACTIVATED);
        }
    }

    @Listen(value="onBindingDropped=#designer")
    public void onBindingDropped(Event e) {
        String targetId = (String)((Map)e.getData()).get("target");
        Element target = targetId != null ? StudioUtil.getElementByUuid(targetId) : this.selection;
        if (target == null) {
            return;
        }
        String binding = ((Map)e.getData()).get("binding").toString();
        String property = ((Map)e.getData()).get("property").toString();
        if (binding == null || property == null) {
            return;
        }
        Attribute attr = target.getAttribute(property);
        if (attr == null) {
            attr = new Attribute(property, binding);
            target.addAttribute(attr);
        } else {
            attr.setValue(binding);
        }
        this.publish(MessageEnum.ATTRIBUTE_CHANGED);
        this.publish(MessageEnum.COMPONENT_SELECTED, target);
    }
}

