/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.controller.impl;

import java.util.Comparator;
import java.util.TreeSet;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Html;
import org.zkoss.zul.Panel;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Treerow;

public class JpaEntityBoxController
extends SelectorComposer<Panel> {
    private static AttributeComparator attributeComparator = new AttributeComparator();
    private Panel self;
    private Tree entityAttributesTree;

    public void doAfterCompose(Panel comp) throws Exception {
        super.doAfterCompose((Component)comp);
        this.self = comp;
        this.entityAttributesTree = (Tree)this.self.getPanelchildren().getFirstChild();
        this.entityAttributesTree.clear();
        EntityType entityType = (EntityType)Executions.getCurrent().getArg().get("entityType");
        if (entityType == null) {
            return;
        }
        String id = Executions.getCurrent().getArg().get("id").toString();
        this.self.setTitle(entityType.getJavaType().getSimpleName());
        Clients.evalJavaScript((String)("top.w4tjStudioDesigner.prepareEntityToolbox('" + id + "')"));
        this.render(entityType);
    }

    private void render(EntityType entityType) {
        SingularAttribute key = null;
        if (entityType.hasSingleIdAttribute()) {
            key = entityType.getId(entityType.getIdType().getJavaType());
        }
        TreeSet<Attribute> attributeSortedSet = new TreeSet<Attribute>(attributeComparator);
        attributeSortedSet.addAll(entityType.getAttributes());
        for (Attribute attribute : attributeSortedSet) {
            Treeitem treeitem = new Treeitem();
            treeitem.setParent((Component)this.entityAttributesTree.getTreechildren());
            Treerow treerow = new Treerow();
            treerow.setParent((Component)treeitem);
            Treecell treecell = new Treecell();
            treecell.setTooltiptext(attribute.getJavaType().getName());
            treecell.setAttribute("attribute", (Object)attribute);
            treecell.setStyle("white-space:nowrap;");
            treecell.setParent((Component)treerow);
            Html html = new Html();
            String keyHtml = attribute.equals(key) ? "&nbsp;&nbsp;&nbsp;<i class=\"fa fa-key\" style=\"margin-left:0px\"></i>" : "";
            html.setContent("<span class=\"jpa-attribute label label-default\">" + attribute.getName() + keyHtml + "</span>");
            html.setParent((Component)treecell);
            new Treechildren().setParent((Component)treeitem);
            treeitem.setOpen(false);
            for (int i = 1; i <= 3; ++i) {
                String bindType = "";
                switch (i) {
                    case 1: {
                        bindType = "@bind";
                        break;
                    }
                    case 2: {
                        bindType = "@load";
                        break;
                    }
                    case 3: {
                        bindType = "@save";
                    }
                }
                Treeitem binditem = new Treeitem();
                binditem.setParent((Component)treeitem.getTreechildren());
                treerow = new Treerow();
                treerow.setParent((Component)binditem);
                treecell = new Treecell();
                treecell.setAttribute("attribute", (Object)attribute);
                treecell.setAttribute("bindType", (Object)bindType);
                treecell.setSclass("");
                treecell.setParent((Component)treerow);
                String vm = bindType + "(vm." + attribute.getName() + ")";
                html = new Html("<span bind-data=\"" + vm + "\" class=\"jpa-bindtype label label-default\"><i class=\"fa fa-hand-o-right\" style=\"margin-right:3px\"/>" + bindType + "</span>");
                html.setParent((Component)treecell);
            }
        }
    }

    public static class AttributeComparator
    implements Comparator<Attribute> {
        @Override
        public int compare(Attribute o1, Attribute o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

