/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.support;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import nu.xom.Document;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.web4thejob.studio.support.MultiplexSerializer;
import org.zkoss.util.resource.Locators;

public abstract class CodeFormatter {
    private static Invocable invocable;
    private static Object options;

    public static String formatXML(Document xml) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MultiplexSerializer serializer = new MultiplexSerializer(out);
        try {
            serializer.setIndent(4);
            serializer.write(xml);
            return out.toString("UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String formatCSS(String css) {
        if (StringUtils.isBlank((CharSequence)css)) {
            return "";
        }
        try {
            css = (String)invocable.invokeFunction("css_beautify", "<style>" + css + "</style>", options);
            StringBuffer sb = new StringBuffer();
            StringTokenizer tokenizer = new StringTokenizer(css, "\n", true);
            while (tokenizer.hasMoreElements()) {
                String line = tokenizer.nextToken();
                if (line.contains("<style>")) {
                    line = line.replaceFirst("<style>", "");
                    line = line.trim();
                } else if (line.contains("</style>")) {
                    line = line.replaceFirst("</style>", "");
                }
                sb.append(line);
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String formatJS(String js) {
        try {
            return (String)invocable.invokeFunction("js_beautify", js, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static String formatHTML(String html) {
        try {
            return (String)invocable.invokeFunction("html_beautify", html, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    static {
        ScriptEngineManager engineManager = new ScriptEngineManager();
        ScriptEngine engine = System.getProperty("java.version").startsWith("1.8") ? engineManager.getEngineByName("nashorn") : engineManager.getEngineByName("JavaScript");
        try {
            String basePath = "org/web4thejob/studio/support/js/beautify/";
            engine.eval(IOUtils.toString((InputStream)Locators.getDefault().getResourceAsStream(basePath + "beautify.js")));
            engine.eval(IOUtils.toString((InputStream)Locators.getDefault().getResourceAsStream(basePath + "beautify-css.js")));
            engine.eval(IOUtils.toString((InputStream)Locators.getDefault().getResourceAsStream(basePath + "beautify-html.js")));
            invocable = (Invocable)((Object)engine);
            Object json = engine.eval("JSON");
            options = invocable.invokeMethod(json, "parse", "{\"indent_size\": 2}");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

