/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.XPathContext;
import org.zkoss.util.resource.Locators;

public abstract class ZulXsdUtil {
    private static final ElementComparator ELEMENT_COMPARATOR = new ElementComparator();
    private static final SortedMap<String, SortedSet<Element>> emptyMap = new TreeMap<String, SortedSet<Element>>();
    private static final SortedSet<String> emptySet = new TreeSet<String>();
    private static final Document xsdDocument = new XsdDocumentBuilder().build();
    public static final String ZUL_NS = "http://www.zkoss.org/2005/zul";
    public static final XPathContext XPATH_CONTEXT_XS = new XPathContext("xs", "http://www.w3.org/2001/XMLSchema");

    public static SortedSet<String> getWidgetChildren(String widget) {
        int i;
        TreeSet<String> result = new TreeSet<String>();
        Element root = xsdDocument.getRootElement();
        Nodes nodes = root.query("xs:element[@name='" + widget + "']", XPATH_CONTEXT_XS);
        if (nodes.size() != 1) {
            return emptySet;
        }
        Element element = (Element)nodes.get(0);
        nodes = root.query("xs:complexType[@name='" + element.getAttributeValue("type") + "']//xs:element", XPATH_CONTEXT_XS);
        for (i = 0; i < nodes.size(); ++i) {
            result.add(((Element)nodes.get(i)).getAttributeValue("ref"));
        }
        nodes = root.query("xs:complexType[@name='" + element.getAttributeValue("type") + "']//xs:group", XPATH_CONTEXT_XS);
        for (i = 0; i < nodes.size(); ++i) {
            ZulXsdUtil.getWidgetChildren(((Element)nodes.get(i)).getAttributeValue("ref"), result);
        }
        return result;
    }

    private static void getWidgetChildren(String group, SortedSet<String> result) {
        int i;
        Element root = xsdDocument.getRootElement();
        Nodes nodes = root.query("xs:group[@name='" + group + "']//xs:element", XPATH_CONTEXT_XS);
        for (i = 0; i < nodes.size(); ++i) {
            result.add(((Element)nodes.get(i)).getAttributeValue("ref"));
        }
        nodes = root.query("xs:group[@name='" + group + "']//xs:group", XPATH_CONTEXT_XS);
        for (i = 0; i < nodes.size(); ++i) {
            ZulXsdUtil.getWidgetChildren(((Element)nodes.get(i)).getAttributeValue("ref"), result);
        }
    }

    public static SortedMap<String, SortedSet<Element>> getWidgetDescription(String widget) {
        TreeMap<String, SortedSet<Element>> result = new TreeMap<String, SortedSet<Element>>();
        Element root = xsdDocument.getRootElement();
        Nodes nodes = root.query("xs:element[@name='" + widget + "']", XPATH_CONTEXT_XS);
        if (nodes.size() != 1) {
            return emptyMap;
        }
        Element element = (Element)nodes.get(0);
        nodes = root.query("xs:complexType[@name='" + element.getAttributeValue("type") + "']", XPATH_CONTEXT_XS);
        if (nodes.size() != 1) {
            return emptyMap;
        }
        Element type = (Element)nodes.get(0);
        for (int i = 0; i < type.getChildElements().size(); ++i) {
            Element attr = type.getChildElements().get(i);
            if (attr.getLocalName().equals("attribute")) {
                if (!result.containsKey(widget)) {
                    result.put(widget, new TreeSet<Element>(ELEMENT_COMPARATOR));
                }
                ((SortedSet)result.get(widget)).add(attr);
                continue;
            }
            if (!attr.getLocalName().equals("attributeGroup")) continue;
            ZulXsdUtil.populateAttributeGroups(attr.getAttributeValue("ref"), result);
        }
        return result;
    }

    private static void populateAttributeGroups(String groupName, Map<String, SortedSet<Element>> result) {
        Element root = xsdDocument.getRootElement();
        Nodes nodes = root.query("xs:attributeGroup[@name='" + groupName + "']", XPATH_CONTEXT_XS);
        if (nodes.size() != 1) {
            return;
        }
        Element attrGroup = (Element)nodes.get(0);
        for (int i = 0; i < attrGroup.getChildElements().size(); ++i) {
            Element attr = attrGroup.getChildElements().get(i);
            if (attr.getLocalName().equals("attribute")) {
                if (!result.containsKey(groupName)) {
                    result.put(groupName, new TreeSet<Element>(ELEMENT_COMPARATOR));
                }
                result.get(groupName).add(attr);
                continue;
            }
            if (!attr.getLocalName().equals("attributeGroup")) continue;
            ZulXsdUtil.populateAttributeGroups(attr.getAttributeValue("ref"), result);
        }
    }

    public static List<String> getConstraintForAttributeType(String attributeType) {
        Element root = xsdDocument.getRootElement();
        Nodes nodes = root.query("xs:simpleType[@name='" + attributeType + "']//xs:restriction/xs:enumeration", XPATH_CONTEXT_XS);
        if (nodes.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> restrictions = new ArrayList<String>();
        for (int i = 0; i < nodes.size(); ++i) {
            restrictions.add(((Element)nodes.get(i)).getAttributeValue("value"));
        }
        return restrictions;
    }

    public static String getTypeOfAttribute(String element, String propertyName) {
        SortedMap<String, SortedSet<Element>> propsMap = ZulXsdUtil.getWidgetDescription(element);
        for (SortedSet<Element> group : propsMap.values()) {
            for (Element property : group) {
                if (!property.getAttributeValue("name").equals(propertyName)) continue;
                return property.getAttributeValue("type");
            }
        }
        return null;
    }

    public static boolean isBaseGroupElement(Element element) {
        Element root = xsdDocument.getRootElement();
        Nodes nodes = root.query("xs:group[@name='baseGroup']//xs:element[@ref='" + element.getLocalName() + "']", XPATH_CONTEXT_XS);
        return nodes.size() == 1;
    }

    public static String getXPath(Element element) {
        if (element == null) {
            return null;
        }
        ParentNode parent = element.getParent();
        if (parent == null || !(parent instanceof Element)) {
            return "/" + element.getQualifiedName();
        }
        return ZulXsdUtil.getXPath((Element)parent) + "/" + element.getQualifiedName() + "[" + ZulXsdUtil.getOccurenceOfChild((Element)parent, element) + "]";
    }

    private static int getOccurenceOfChild(Element parent, Element child) {
        int occurence = 0;
        for (int i = 0; i < parent.getChildElements().size(); ++i) {
            if (parent.getChildElements().get(i).getQualifiedName().equals(child.getQualifiedName())) {
                ++occurence;
            }
            if (!parent.getChildElements().get(i).equals((Object)child)) continue;
            return occurence;
        }
        return 0;
    }

    private static class ElementComparator
    implements Comparator<Element> {
        private ElementComparator() {
        }

        @Override
        public int compare(Element o1, Element o2) {
            return o1.getAttributeValue("name").compareTo(o2.getAttributeValue("name"));
        }
    }

    private static class XsdDocumentBuilder {
        private XsdDocumentBuilder() {
        }

        Document build() {
            try {
                return new Builder(false).build(Locators.getDefault().getResourceAsStream("org/web4thejob/studio/zul.xsd"), null);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
    }
}

