//**************************************************************************************************
//
//**************************************************************************************************
function completeAfter(cm, pred) {
    var cur = cm.getCursor();
    if (!pred || pred()) setTimeout(function () {
        if (!cm.state.completionActive)
            CodeMirror.showHint(cm, CodeMirror.hint.xml, {
                schemaInfo: tags,
                completeSingle: false
            });
    }, 100);
    return CodeMirror.Pass;
}

function completeIfAfterLt(cm) {
    return completeAfter(cm, function () {
        var cur = cm.getCursor();
        return cm.getRange(CodeMirror.Pos(cur.line, cur.ch - 1), cur) == "<";
    });
}

function completeIfInTag(cm) {
    return completeAfter(cm, function () {
        var tok = cm.getTokenAt(cm.getCursor());
        if (tok.type == "string" && (!/['"]/.test(tok.string.charAt(tok.string.length - 1)) || tok.string.length == 1)) return false;
        var inner = CodeMirror.innerMode(cm.getMode(), tok.state).state;
        return inner.tagName;
    });
}

//**************************************************************************************************
// copy paste tags here
//**************************************************************************************************

window.tags={
	"!top": ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timer", "timebox", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window", "a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timer", "timebox", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window", ],
	a: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			dir: ["normal", "reverse"],
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			href: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			mold: ["default"],
			onBookmarkChange: null,
			onClick: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tabindex: null,
			target: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	absolutechildren: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			x: null,
			y: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	absolutelayout: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["absolutechildren"]
	},
	anchorchildren: {
		attrs: {
			action: null,
			anchor: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	anchorlayout: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["anchorchildren"]
	},
	applet: {
		attrs: {
			action: null,
			align: null,
			apply: null,
			archive: null,
			auService: null,
			autag: null,
			children: null,
			code: null,
			codebase: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hspace: null,
			id: null,
			if: null,
			left: null,
			mayscript: null,
			mold: ["default"],
			onCreate: null,
			onDrop: null,
			onFulfill: null,
			params: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			vspace: null,
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	area: {
		attrs: {
			apply: null,
			auService: null,
			autag: null,
			children: null,
			coords: null,
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			id: null,
			if: null,
			mold: ["default"],
			onFulfill: null,
			self: null,
			shape: ["rectangle", "circle", "polygon"],
			stubonly: null,
			tooltiptext: null,
			unless: null,
			use: null,
			visible: ["false", "true"]
		},
		children: []
	},
	audio: {
		attrs: {
			action: null,
			align: ["top", "texttop", "middle", "absmiddle", "bottom", "absbottom", "baseline", "left", "right", "center"],
			apply: null,
			auService: null,
			autag: null,
			autoplay: ["false", "true"],
			autostart: ["false", "true"],
			border: null,
			children: null,
			context: null,
			controls: ["false", "true"],
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			loop: ["false", "true"],
			mold: ["default"],
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			preload: ["none", "auto", "metadata"],
			renderdefer: null,
			sclass: null,
			self: null,
			src: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	auxhead: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["auxheader"]
	},
	auxheader: {
		attrs: {
			action: null,
			align: ["left", "right", "center"],
			apply: null,
			auService: null,
			autag: null,
			children: null,
			colspan: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			mold: ["default"],
			onClick: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			rowspan: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			valign: ["top", "baseline", "middle", "bottom"],
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	bandbox: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			autodrop: ["false", "true"],
			buttonVisible: ["false", "true"],
			children: null,
			cols: null,
			constraint: ["no empty"],
			context: null,
			ctrlKeys: null,
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			inplace: ["false", "true"],
			instant: ["false", "true"],
			left: null,
			maxlength: null,
			mold: ["rounded", "default"],
			name: null,
			onBlur: null,
			onBookmarkChange: null,
			onCancel: null,
			onChange: null,
			onChanging: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFocus: null,
			onFulfill: null,
			onOK: null,
			onOpen: null,
			open: ["false", "true"],
			placeholder: null,
			popup: null,
			readonly: ["false", "true"],
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tabindex: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			type: ["text", "password"],
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["bandpopup"]
	},
	bandpopup: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	borderlayout: {
		attrs: {
			action: null,
			animationDisabled: ["false", "true"],
			apply: null,
			auService: null,
			autag: null,
			children: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onDrop: null,
			onFulfill: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["center", "east", "north", "south", "west"]
	},
	box: {
		attrs: {
			action: null,
			align: ["start", "center", "end"],
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			heights: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["horizontal", "vertical"],
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			orient: ["horizontal", "vertical"],
			pack: ["start", "center", "end"],
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			sizedByContent: ["false", "true"],
			spacing: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			widths: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "splitter", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	button: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			autodisable: null,
			children: null,
			context: null,
			ctrlKeys: null,
			dir: ["normal", "reverse"],
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			href: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			mold: ["os", "trendy", "default"],
			onBookmarkChange: null,
			onClick: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			orient: ["horizontal", "vertical"],
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tabindex: null,
			target: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			type: ["button", "submit", "reset"],
			unless: null,
			upload: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	calendar: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			name: null,
			onBookmarkChange: null,
			onChange: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			onWeekClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			weekOfYear: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	caption: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			mold: ["default"],
			onClick: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	cell: {
		attrs: {
			action: null,
			align: ["left", "right", "center"],
			apply: null,
			auService: null,
			autag: null,
			children: null,
			colspan: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			rowspan: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			valign: ["top", "baseline", "middle", "bottom"],
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	center: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			autoscroll: ["false", "true"],
			border: ["normal", "none"],
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			flex: ["false", "true"],
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			margins: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			onOpen: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			title: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "caption", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	chart: {
		attrs: {
			action: null,
			apply: null,
			areaListener: null,
			auService: null,
			autag: null,
			bgAlpha: null,
			bgColor: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			fgAlpha: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			model: null,
			mold: ["default"],
			onBookmarkChange: null,
			onClick: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			orient: ["horizontal", "vertical"],
			paneAlpha: null,
			paneColor: null,
			period: ["millisecond", "secondr", "minute", "hour", "day", "week", "month", "quarter", "year"],
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			showLegend: ["false", "true"],
			showTooltiptext: ["false", "true"],
			stubonly: null,
			style: null,
			threeD: ["false", "true"],
			timeZone: null,
			title: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			type: ["area", "bar", "bubble", "candlestick", "gantt", "hilow", "histogram", "line", "pie", "polar", "ring", "scatter", "stacked_area", "stacked_bar", "step", "step_area", "time_series", "wafermap", "waterfall", "wind"],
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			xAxis: null,
			yAxis: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	checkbox: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			checked: ["false", "true"],
			children: null,
			context: null,
			ctrlKeys: null,
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			mold: ["default"],
			name: null,
			onBookmarkChange: null,
			onCheck: null,
			onClick: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tabindex: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	column: {
		attrs: {
			action: null,
			align: ["left", "right", "center"],
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			mold: ["default"],
			onClick: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onGroup: null,
			onRightClick: null,
			onSort: null,
			onUngroup: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			sort: ["auto", "none"],
			sortAscending: null,
			sortDescending: null,
			sortDirection: ["natural", "ascending", "descending"],
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			valign: ["top", "baseline", "middle", "bottom"],
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	columns: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			columnsgroup: ["false", "true"],
			columnshide: ["false", "true"],
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			menupopup: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			sizable: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["column"]
	},
	combobox: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			autocomplete: ["false", "true"],
			autodrop: ["false", "true"],
			buttonVisible: ["false", "true"],
			children: null,
			cols: null,
			constraint: ["no empty"],
			context: null,
			ctrlKeys: null,
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			inplace: ["false", "true"],
			instant: ["false", "true"],
			itemRenderer: null,
			left: null,
			maxlength: null,
			model: null,
			mold: ["rounded", "default"],
			name: null,
			onBlur: null,
			onBookmarkChange: null,
			onCancel: null,
			onChange: null,
			onChanging: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFocus: null,
			onFulfill: null,
			onOK: null,
			onOpen: null,
			onSelect: null,
			open: ["false", "true"],
			placeholder: null,
			popup: null,
			readonly: ["false", "true"],
			renderdefer: null,
			sclass: null,
			selectedItem: null,
			self: null,
			stubonly: null,
			style: null,
			tabindex: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			type: ["text", "password"],
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["comboitem"]
	},
	comboitem: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			content: null,
			context: null,
			ctrlKeys: null,
			description: null,
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			mold: ["default"],
			onClick: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	combobutton: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			autodisable: null,
			children: null,
			context: null,
			ctrlKeys: null,
			dir: ["normal", "reverse"],
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			href: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			mold: ["toolbar", "default"],
			onBookmarkChange: null,
			onClick: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			orient: ["horizontal", "vertical"],
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tabindex: null,
			target: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			type: ["button", "submit", "reset"],
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["popup"]
	},
	datebox: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			buttonVisible: ["false", "true"],
			children: null,
			cols: null,
			constraint: ["no empty", "no past", "no future", "no today", "between yyyymmdd and yyyymmdd", "before yyyymmdd", "after yyyymmdd"],
			context: null,
			ctrlKeys: null,
			disabled: ["false", "true"],
			displayedTimeZones: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			format: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			inplace: ["false", "true"],
			instant: ["false", "true"],
			left: null,
			lenient: ["false", "true"],
			locale: null,
			maxlength: null,
			mold: ["rounded", "default"],
			name: null,
			onBlur: null,
			onBookmarkChange: null,
			onCancel: null,
			onChange: null,
			onChanging: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFocus: null,
			onFulfill: null,
			onOK: null,
			open: ["false", "true"],
			placeholder: null,
			popup: null,
			readonly: ["false", "true"],
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tabindex: null,
			timeZonesReadonly: ["false", "true"],
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			weekOfYear: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	decimalbox: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			cols: null,
			constraint: ["no empty", "no zero", "no negative", "no positive"],
			context: null,
			ctrlKeys: null,
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			format: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			inplace: ["false", "true"],
			instant: ["false", "true"],
			left: null,
			locale: null,
			maxlength: null,
			mold: ["rounded", "default"],
			name: null,
			onBlur: null,
			onBookmarkChange: null,
			onCancel: null,
			onChange: null,
			onChanging: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFocus: null,
			onFulfill: null,
			onOK: null,
			placeholder: null,
			popup: null,
			readonly: ["false", "true"],
			renderdefer: null,
			roundingMode: null,
			scale: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tabindex: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	div: {
		attrs: {
			action: null,
			align: ["left", "right", "center"],
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onBookmarkChange: null,
			onClick: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	doublebox: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			cols: null,
			constraint: ["no empty", "no zero", "no negative", "no positive"],
			context: null,
			ctrlKeys: null,
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			format: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			inplace: ["false", "true"],
			instant: ["false", "true"],
			left: null,
			locale: null,
			maxlength: null,
			mold: ["rounded", "default"],
			name: null,
			onBlur: null,
			onBookmarkChange: null,
			onCancel: null,
			onChange: null,
			onChanging: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFocus: null,
			onFulfill: null,
			onOK: null,
			placeholder: null,
			popup: null,
			readonly: ["false", "true"],
			renderdefer: null,
			roundingMode: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tabindex: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	doublespinner: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			buttonVisible: ["false", "true"],
			children: null,
			cols: null,
			constraint: ["no empty"],
			context: null,
			ctrlKeys: null,
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			format: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			inplace: ["false", "true"],
			instant: ["false", "true"],
			left: null,
			locale: null,
			maxlength: null,
			mold: ["rounded", "default"],
			name: null,
			onBlur: null,
			onBookmarkChange: null,
			onCancel: null,
			onChange: null,
			onChanging: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFocus: null,
			onFulfill: null,
			onOK: null,
			placeholder: null,
			popup: null,
			readonly: ["false", "true"],
			renderdefer: null,
			roundingMode: null,
			sclass: null,
			self: null,
			step: null,
			stubonly: null,
			style: null,
			tabindex: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	east: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			autoscroll: ["false", "true"],
			border: ["normal", "none"],
			children: null,
			collapsible: ["false", "true"],
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			flex: ["false", "true"],
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			margins: null,
			maxsize: null,
			minsize: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			onOpen: null,
			open: ["false", "true"],
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			size: null,
			splittable: ["false", "true"],
			stubonly: null,
			style: null,
			title: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "caption", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	fileupload: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["os", "default", "trendy"],
			native: null,
			number: null,
			onCreate: null,
			onDrop: null,
			onFulfill: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	flash: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			autoplay: ["false", "true"],
			bgcolor: null,
			children: null,
			content: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			loop: ["false", "true"],
			mold: ["default"],
			onCreate: null,
			onDrop: null,
			onFulfill: null,
			renderdefer: null,
			sclass: null,
			self: null,
			src: null,
			stubonly: null,
			style: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			wmode: ["transparent", "opaque", "window"],
			zclass: null,
			zindex: null
		},
		children: []
	},
	foot: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["footer"]
	},
	footer: {
		attrs: {
			action: null,
			align: ["left", "right", "center"],
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			mold: ["default"],
			onClick: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			span: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			valign: ["top", "baseline", "middle", "bottom"],
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	frozen: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			columns: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			start: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	grid: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			autopaging: ["false", "true"],
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			emptyMessage: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			innerWidth: null,
			left: null,
			model: null,
			mold: ["paging", "default"],
			oddRowSclass: null,
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			onPaging: null,
			pageSize: null,
			paginal: null,
			pagingPosition: ["top", "bottom", "both"],
			popup: null,
			renderdefer: null,
			rowRenderer: null,
			sclass: null,
			self: null,
			sizedByContent: ["false", "true"],
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["auxhead", "columns", "foot", "frozen", "rows"]
	},
	groupbox: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			closable: ["false", "true"],
			contentStyle: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["3d", "default"],
			onBookmarkChange: null,
			onClick: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onOpen: null,
			onRightClick: null,
			open: ["false", "true"],
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "caption", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	hbox: {
		attrs: {
			action: null,
			align: ["start", "center", "end"],
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["horizontal", "vertical"],
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			pack: ["start", "center", "end"],
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			sizedByContent: ["false", "true"],
			spacing: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			widths: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "splitter", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	hlayout: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			spacing: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			valign: ["top", "baseline", "middle", "bottom"],
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	html: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			content: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	idspace: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onBookmarkChange: null,
			onClick: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	iframe: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			autohide: ["false", "true"],
			children: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			name: null,
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onDrop: null,
			onFulfill: null,
			onURIChange: null,
			renderdefer: null,
			sclass: null,
			scrolling: ["auto", "true", "false"],
			self: null,
			src: null,
			stubonly: null,
			style: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	image: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			content: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hover: null,
			hoverContent: null,
			id: null,
			if: null,
			left: null,
			mold: ["alphafix", "default"],
			onBookmarkChange: null,
			onClick: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			src: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	imagemap: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			content: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["alphafix", "default"],
			onBookmarkChange: null,
			onClick: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			src: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["area"]
	},
	include: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			comment: ["false", "true"],
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			localized: ["false", "true"],
			mode: null,
			mold: ["default"],
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			progressing: ["false", "true"],
			renderdefer: null,
			sclass: null,
			self: null,
			src: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	intbox: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			cols: null,
			constraint: ["no empty", "no zero", "no negative", "no positive"],
			context: null,
			ctrlKeys: null,
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			format: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			inplace: ["false", "true"],
			instant: ["false", "true"],
			left: null,
			locale: null,
			maxlength: null,
			mold: ["rounded", "default"],
			name: null,
			onBlur: null,
			onBookmarkChange: null,
			onCancel: null,
			onChange: null,
			onChanging: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFocus: null,
			onFulfill: null,
			onOK: null,
			placeholder: null,
			popup: null,
			readonly: ["false", "true"],
			renderdefer: null,
			roundingMode: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tabindex: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	longbox: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			cols: null,
			constraint: ["no empty", "no zero", "no negative", "no positive"],
			context: null,
			ctrlKeys: null,
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			format: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			inplace: ["false", "true"],
			instant: ["false", "true"],
			left: null,
			locale: null,
			maxlength: null,
			mold: ["rounded", "default"],
			name: null,
			onBlur: null,
			onBookmarkChange: null,
			onCancel: null,
			onChange: null,
			onChanging: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFocus: null,
			onFulfill: null,
			onOK: null,
			placeholder: null,
			popup: null,
			readonly: ["false", "true"],
			renderdefer: null,
			roundingMode: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tabindex: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	label: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			maxlength: null,
			mold: ["default"],
			multiline: ["false", "true"],
			onBookmarkChange: null,
			onClick: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	listbox: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			autopaging: ["false", "true"],
			checkmark: ["false", "true"],
			children: null,
			context: null,
			ctrlKeys: null,
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			emptyMessage: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			innerWidth: null,
			itemRenderer: null,
			left: null,
			maxlength: null,
			model: null,
			mold: ["paging", "select", "default"],
			multiple: ["false", "true"],
			name: null,
			nonselectableTags: null,
			oddRowSclass: null,
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			onPaging: null,
			onSelect: null,
			pageSize: null,
			paginal: null,
			pagingPosition: ["top", "bottom", "both"],
			popup: null,
			renderdefer: null,
			rows: null,
			sclass: null,
			selectedItem: null,
			self: null,
			sizedByContent: ["false", "true"],
			stubonly: null,
			style: null,
			tabindex: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["auxhead", "frozen", "listfoot", "listhead", "listitem"]
	},
	listcell: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			mold: ["default"],
			onClick: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			span: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	listfoot: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["listfooter"]
	},
	listfooter: {
		attrs: {
			action: null,
			align: ["left", "right", "center"],
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			mold: ["default"],
			onClick: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			span: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			valign: ["top", "baseline", "middle", "bottom"],
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	listhead: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			columnsgroup: ["false", "true"],
			columnshide: ["false", "true"],
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			menupopup: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			sizable: ["false", "true"],
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["listheader"]
	},
	listheader: {
		attrs: {
			action: null,
			align: ["left", "right", "center"],
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			maxlength: null,
			mold: ["default"],
			onClick: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onGroup: null,
			onRightClick: null,
			onSort: null,
			onUngroup: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			sort: ["auto", "none"],
			sortAscending: null,
			sortDescending: null,
			sortDirection: ["natural", "ascending", "descending"],
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			valign: ["top", "baseline", "middle", "bottom"],
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	listitem: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			checkable: ["false", "true"],
			children: null,
			context: null,
			ctrlKeys: null,
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			label: null,
			left: null,
			mold: ["select", "default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			selected: ["false", "true"],
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["listcell"]
	},
	menu: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			content: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			mold: ["default"],
			onClick: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["menupopup"]
	},
	menubar: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			autodrop: ["false", "true"],
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			orient: ["horizontal", "vertical"],
			popup: null,
			renderdefer: null,
			sclass: null,
			scrollable: ["false", "true"],
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["menu", "menuitem"]
	},
	menuitem: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			autocheck: ["false", "true"],
			checked: ["false", "true"],
			checkmark: ["false", "true"],
			children: null,
			context: null,
			ctrlKeys: null,
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			href: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			mold: ["default"],
			onClick: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			src: null,
			stubonly: null,
			style: null,
			target: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	menupopup: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			onOpen: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["menu", "menuitem", "menuseparator"]
	},
	menuseparator: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	north: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			autoscroll: ["false", "true"],
			border: null,
			children: null,
			collapsible: ["false", "true"],
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			flex: ["false", "true"],
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			margins: null,
			maxsize: null,
			minsize: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			onOpen: null,
			open: ["false", "true"],
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			size: null,
			splittable: ["false", "true"],
			stubonly: null,
			style: null,
			title: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "caption", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	panel: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			border: ["normal", "none"],
			children: null,
			closable: ["false", "true"],
			collapsible: ["false", "true"],
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			floatable: ["false", "true"],
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			maximizable: ["false", "true"],
			maximized: ["false", "true"],
			minimizable: ["false", "true"],
			minimized: ["false", "true"],
			mold: ["default"],
			movable: ["false", "true"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			open: ["false", "true"],
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			title: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["caption", "panelchildren", "toolbar"]
	},
	panelchildren: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	paging: {
		attrs: {
			action: null,
			activePage: null,
			apply: null,
			auService: null,
			autag: null,
			autohide: ["false", "true"],
			children: null,
			context: null,
			ctrlKeys: null,
			detailed: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["os", "default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			pageIncrement: null,
			pageSize: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			totalSize: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	popup: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			onOpen: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menu", "menubar", "menuitem", "menupopup", "menuseparator", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	progressmeter: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	radio: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			checked: ["false", "true"],
			children: null,
			context: null,
			ctrlKeys: null,
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			mold: ["default"],
			onCheck: null,
			onClick: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			radiogroup: null,
			renderdefer: null,
			sclass: null,
			selected: ["false", "true"],
			self: null,
			stubonly: null,
			style: null,
			tabindex: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	radiogroup: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			model: null,
			mold: ["default"],
			name: null,
			onBookmarkChange: null,
			onCheck: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			orient: ["horizontal", "vertical"],
			popup: null,
			radioRenderer: null,
			renderdefer: null,
			sclass: null,
			selectedItem: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	row: {
		attrs: {
			action: null,
			align: ["left", "right", "center"],
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			nowrap: ["false", "true"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			spans: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			valign: ["top", "baseline", "middle", "bottom"],
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	rows: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["row"]
	},
	script: {
		attrs: {
			apply: null,
			auService: null,
			autag: null,
			charset: null,
			children: null,
			defer: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			id: null,
			if: null,
			mold: null,
			onFulfill: null,
			self: null,
			src: null,
			stubonly: null,
			type: ["text/javascript"],
			unless: null,
			use: null,
			visible: ["false", "true"]
		},
		children: []
	},
	selectbox: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			itemRenderer: null,
			left: null,
			mold: ["default"],
			name: null,
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onDrop: null,
			onFulfill: null,
			onSelect: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tabindex: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	separator: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			bar: ["false", "true"],
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			orient: ["horizontal", "vertical"],
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			spacing: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	slider: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			curpos: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			maxpos: null,
			mold: ["scale", "sphere", "default"],
			name: null,
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			onScroll: null,
			onScrolling: null,
			pageIncrement: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			slidingtext: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	south: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			autoscroll: ["false", "true"],
			border: ["normal", "none"],
			children: null,
			collapsible: ["false", "true"],
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			flex: ["false", "true"],
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			margins: null,
			maxsize: null,
			minsize: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			onOpen: null,
			open: ["false", "true"],
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			size: null,
			splittable: ["false", "true"],
			stubonly: null,
			style: null,
			title: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "caption", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	space: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			bar: ["false", "true"],
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			orient: ["horizontal", "vertical"],
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			spacing: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	spinner: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			buttonVisible: ["false", "true"],
			children: null,
			cols: null,
			constraint: ["no empty"],
			context: null,
			ctrlKeys: null,
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			format: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			inplace: ["false", "true"],
			instant: ["false", "true"],
			left: null,
			locale: null,
			maxlength: null,
			mold: ["rounded", "default"],
			name: null,
			onBlur: null,
			onBookmarkChange: null,
			onCancel: null,
			onChange: null,
			onChanging: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFocus: null,
			onFulfill: null,
			onOK: null,
			placeholder: null,
			popup: null,
			readonly: ["false", "true"],
			renderdefer: null,
			roundingMode: null,
			sclass: null,
			self: null,
			step: null,
			stubonly: null,
			style: null,
			tabindex: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	splitter: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			collapse: ["after", "before"],
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["os", "default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			onOpen: null,
			open: ["false", "true"],
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	style: {
		attrs: {
			apply: null,
			auService: null,
			autag: null,
			children: null,
			content: null,
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			id: null,
			if: null,
			media: null,
			mold: ["default"],
			onFulfill: null,
			self: null,
			src: null,
			stubonly: null,
			unless: null,
			use: null,
			visible: ["false", "true"]
		},
		children: []
	},
	tab: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			closable: ["false", "true"],
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			mold: ["default"],
			onClick: null,
			onClose: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			selected: ["false", "true"],
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["caption"]
	},
	tabbox: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			maximalHeight: ["false", "true"],
			mold: ["accordion-lite", "accordion", "default"],
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			onSelect: null,
			orient: ["top", "left", "right", "bottom"],
			panelSpacing: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			selectedPanel: null,
			selectedTab: null,
			self: null,
			stubonly: null,
			style: null,
			tabscroll: ["false", "true"],
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["tabpanels", "tabs", "toolbar"]
	},
	tabpanel: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onClick: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	tabpanels: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["tabpanel"]
	},
	tabs: {
		attrs: {
			action: null,
			align: ["start", "center", "end"],
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["tab"]
	},
	textbox: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			cols: null,
			constraint: ["no empty"],
			context: null,
			ctrlKeys: null,
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			inplace: ["false", "true"],
			instant: ["false", "true"],
			left: null,
			maxlength: null,
			mold: ["rounded", "default"],
			multiline: ["false", "true"],
			name: null,
			onBlur: null,
			onBookmarkChange: null,
			onCancel: null,
			onChange: null,
			onChanging: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFocus: null,
			onFulfill: null,
			onOK: null,
			placeholder: null,
			popup: null,
			readonly: ["false", "true"],
			renderdefer: null,
			rows: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tabbable: ["false", "true"],
			tabindex: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			type: ["text", "password"],
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	timer: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			delay: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: null,
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onDrop: null,
			onFulfill: null,
			onTimer: null,
			renderdefer: null,
			repeats: ["false", "true"],
			running: ["false", "true"],
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	timebox: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			buttonVisible: ["false", "true"],
			children: null,
			cols: null,
			constraint: ["no empty", "no past", "no future", "no today", "between yyyymmdd and yyyymmdd", "before yyyymmdd", "after yyyymmdd"],
			context: null,
			ctrlKeys: null,
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			format: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			inplace: ["false", "true"],
			instant: ["false", "true"],
			left: null,
			locale: null,
			maxlength: null,
			mold: ["rounded", "default"],
			name: null,
			onBlur: null,
			onBookmarkChange: null,
			onCancel: null,
			onChange: null,
			onChanging: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFocus: null,
			onFulfill: null,
			onOK: null,
			placeholder: null,
			popup: null,
			readonly: ["false", "true"],
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tabindex: null,
			timeZone: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	toolbar: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["panel", "default"],
			onBookmarkChange: null,
			onClick: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			orient: ["horizontal", "vertical"],
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	toolbarbutton: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			checked: ["false", "true"],
			children: null,
			context: null,
			ctrlKeys: null,
			dir: ["normal", "reverse"],
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			href: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			mode: null,
			mold: ["toggle", "default"],
			onBookmarkChange: null,
			onClick: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			orient: ["horizontal", "vertical"],
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tabindex: null,
			target: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			upload: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: []
	},
	tree: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			autopaging: ["false", "true"],
			checkmark: ["false", "true"],
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			innerWidth: null,
			itemRenderer: null,
			left: null,
			model: null,
			mold: ["paging", "default"],
			multiple: ["false", "true"],
			name: null,
			nonselectableTags: null,
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			onPaging: null,
			onSelect: null,
			pageSize: null,
			paginal: null,
			pagingPosition: ["top", "bottom", "both"],
			popup: null,
			renderdefer: null,
			rows: null,
			sclass: null,
			selectedItem: null,
			self: null,
			sizedByContent: ["false", "true"],
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["auxhead", "frozen", "treechildren", "treecols", "treefoot"]
	},
	treecell: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			mold: ["default"],
			onClick: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			span: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	treechildren: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["treeitem"]
	},
	treecol: {
		attrs: {
			action: null,
			align: ["left", "right", "center"],
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			maxlength: null,
			mold: ["default"],
			onClick: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			onSort: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			sort: ["auto", "none"],
			sortAscending: null,
			sortDescending: null,
			sortDirection: ["natural", "ascending", "descending"],
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			valign: ["top", "baseline", "middle", "bottom"],
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	treecols: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			sizable: ["false", "true"],
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["treecol"]
	},
	treefoot: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["treefooter"]
	},
	treefooter: {
		attrs: {
			action: null,
			align: ["left", "right", "center"],
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			hoverImage: null,
			hoverImageContent: null,
			id: null,
			if: null,
			image: null,
			imageContent: null,
			label: null,
			left: null,
			mold: ["default"],
			onClick: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			span: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			valign: ["top", "baseline", "middle", "bottom"],
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	treeitem: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			checkable: ["false", "true"],
			children: null,
			context: null,
			ctrlKeys: null,
			disabled: ["false", "true"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			image: null,
			label: null,
			left: null,
			mold: ["default"],
			onClick: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onOpen: null,
			onRightClick: null,
			open: ["false", "true"],
			popup: null,
			renderdefer: null,
			sclass: null,
			selected: ["false", "true"],
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			value: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["treechildren", "treerow"]
	},
	treerow: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			label: null,
			left: null,
			mold: ["default"],
			onClick: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onRightClick: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["treecell"]
	},
	vbox: {
		attrs: {
			action: null,
			align: ["start", "center", "end"],
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			heights: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["horizontal", "vertical"],
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			pack: ["start", "center", "end"],
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			sizedByContent: ["false", "true"],
			spacing: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "splitter", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	vlayout: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			children: null,
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			mold: ["default"],
			onBookmarkChange: null,
			onClientInfo: null,
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			spacing: null,
			stubonly: null,
			style: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	west: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			autoscroll: ["false", "true"],
			border: ["normal", "none"],
			children: null,
			collapsible: ["false", "true"],
			context: null,
			ctrlKeys: null,
			draggable: null,
			droppable: null,
			flex: ["false", "true"],
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			margins: null,
			maxsize: null,
			minsize: null,
			mold: ["default"],
			onCreate: null,
			onCtrlKey: null,
			onDrop: null,
			onFulfill: null,
			onOpen: null,
			open: ["false", "true"],
			popup: null,
			renderdefer: null,
			sclass: null,
			self: null,
			size: null,
			splittable: ["false", "true"],
			stubonly: null,
			style: null,
			title: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "caption", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},
	window: {
		attrs: {
			action: null,
			apply: null,
			auService: null,
			autag: null,
			border: ["normal", "none"],
			children: null,
			closable: ["false", "true"],
			contentSclass: null,
			contentStyle: null,
			context: null,
			ctrlKeys: null,
			defaultActionOnShow: ["moveDown", "moveRight", "moveDiagonal", "appear", "slideDown"],
			draggable: null,
			droppable: null,
			focus: ["false", "true"],
			forEach: null,
			forEachBegin: null,
			forEachEnd: null,
			forward: null,
			fulfill: null,
			height: null,
			hflex: null,
			id: null,
			if: null,
			left: null,
			maximizable: ["false", "true"],
			maximized: ["false", "true"],
			minheight: null,
			minimizable: ["false", "true"],
			minimized: ["false", "true"],
			minwidth: null,
			mode: ["embedded", "modal", "overlapped", "popup", "highlighted"],
			mold: ["default"],
			onBookmarkChange: null,
			onCancel: null,
			onClick: null,
			onClientInfo: null,
			onClose: null,
			onCreate: null,
			onCtrlKey: null,
			onDoubleClick: null,
			onDrop: null,
			onFulfill: null,
			onMove: null,
			onOK: null,
			onOpen: null,
			onRightClick: null,
			onZIndex: null,
			popup: null,
			position: ["left,top", "left,center", "left,bottom", "center,top", "center", "center,bottom", "right,top", "right,center", "right,bottom", "parent"],
			renderdefer: null,
			sclass: null,
			self: null,
			sizable: ["false", "true"],
			stubonly: null,
			style: null,
			title: null,
			tooltip: null,
			tooltiptext: null,
			top: null,
			unless: null,
			use: null,
			vflex: null,
			visible: ["false", "true"],
			width: null,
			zclass: null,
			zindex: null
		},
		children: ["a", "absolutelayout", "anchorlayout", "audio", "bandbox", "borderlayout", "box", "button", "calendar", "caption", "cell", "chart", "checkbox", "combobox", "combobutton", "datebox", "decimalbox", "div", "doublebox", "doublespinner", "flash", "frozen", "grid", "groupbox", "hbox", "hlayout", "html", "idspace", "iframe", "image", "imagemap", "include", "intbox", "label", "listbox", "longbox", "menubar", "menupopup", "paging", "panel", "popup", "progressmeter", "radio", "radiogroup", "script", "selectbox", "separator", "slider", "space", "spinner", "style", "tabbox", "textbox", "timebox", "timer", "toolbar", "toolbarbutton", "tree", "vbox", "vlayout", "window"]
	},

};
