/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.controller.impl;

import java.util.HashMap;
import nu.xom.Attribute;
import nu.xom.Node;
import nu.xom.Text;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.web4thejob.studio.controller.AbstractController;
import org.web4thejob.studio.controller.ControllerEnum;
import org.web4thejob.studio.dom.Element;
import org.web4thejob.studio.message.MessageEnum;
import org.web4thejob.studio.support.CodeFormatter;
import org.web4thejob.studio.support.StudioUtil;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.MouseEvent;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Button;
import org.zkoss.zul.Textbox;

public class CodeMirrorController
extends AbstractController {
    private String mode;
    private nu.xom.Element element;
    private String eventName;
    private nu.xom.Element codeBlock;
    private boolean isServerSide;
    @Wire
    private Textbox editor;
    @Wire
    private Button btnSave;

    @Override
    public ControllerEnum getId() {
        return ControllerEnum.CODE_MIRROR_CONTROLLER;
    }

    @Override
    public void doAfterCompose(Component comp) throws Exception {
        super.doAfterCompose(comp);
        this.element = (nu.xom.Element)Executions.getCurrent().getArg().get("element");
        if (this.element == null) {
            return;
        }
        this.mode = (String)Executions.getCurrent().getArg().get("mode");
        Validate.notNull((Object)this.element);
        this.eventName = (String)Executions.getCurrent().getArg().get("event");
        if (this.eventName != null) {
            this.isServerSide = !"javascript".equals(this.mode);
            this.codeBlock = (nu.xom.Element)StudioUtil.getEventCodeNode(this.element, this.eventName, this.isServerSide);
            if (this.codeBlock != null) {
                this.editor.setValue(CodeFormatter.formatJS(this.codeBlock.getValue().trim()));
            }
        } else {
            this.codeBlock = this.element;
            switch (this.mode) {
                case "css": {
                    this.editor.setValue(CodeFormatter.formatCSS(this.codeBlock.getValue().trim()));
                    break;
                }
                case "text/html": {
                    this.editor.setValue(CodeFormatter.formatHTML(this.codeBlock.getValue().trim()));
                    break;
                }
                default: {
                    this.editor.setValue(CodeFormatter.formatJS(this.codeBlock.getValue().trim()));
                }
            }
        }
        Clients.evalJavaScript((String)("var cm=zk('" + this.editor.getUuid() + "').$(); if(cm) {cm=cm.get('codemirror'); cm.refresh(); cm.focus();};"));
        this.btnSave.addEventListener("onClick", (EventListener)new onSaveClicked());
    }

    @Listen(value="onClick=#btnDialog")
    public void onToDialogClicked(MouseEvent event) {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("mode", this.mode);
        args.put("element", (String)this.element);
        args.put("event", this.eventName);
        Executions.createComponents((String)"~./include/codedialog.zul", null, args);
    }

    private class onSaveClicked
    implements EventListener<MouseEvent> {
        private onSaveClicked() {
        }

        public void onEvent(MouseEvent event) throws Exception {
            if (StringUtils.isBlank((CharSequence)CodeMirrorController.this.editor.getValue())) {
                if (CodeMirrorController.this.codeBlock != null) {
                    CodeMirrorController.this.codeBlock.detach();
                }
            } else {
                Text cdata = new Text(CodeMirrorController.this.editor.getValue().trim());
                if (CodeMirrorController.this.codeBlock != null) {
                    CodeMirrorController.this.codeBlock.removeChildren();
                } else if (CodeMirrorController.this.eventName != null) {
                    CodeMirrorController.this.codeBlock = new nu.xom.Element("attribute");
                    if (CodeMirrorController.this.isServerSide) {
                        CodeMirrorController.this.codeBlock.addAttribute(new Attribute("name", CodeMirrorController.this.eventName));
                    } else {
                        String clientPrefix = StudioUtil.getClientNamespacePrefix((Element)CodeMirrorController.this.element);
                        if (clientPrefix == null) {
                            clientPrefix = "c";
                            CodeMirrorController.this.element.getDocument().getRootElement().addNamespaceDeclaration(clientPrefix, "client");
                        }
                        CodeMirrorController.this.codeBlock.addAttribute(new Attribute(clientPrefix + ":name", "client", CodeMirrorController.this.eventName));
                    }
                    CodeMirrorController.this.element.insertChild((Node)CodeMirrorController.this.codeBlock, 0);
                }
                CodeMirrorController.this.codeBlock.appendChild((Node)cdata);
            }
            CodeMirrorController.this.publish(MessageEnum.EVALUATE_XML);
        }
    }
}

