/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.controller.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.web4thejob.studio.support.JpaUtil;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.MouseEvent;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.A;
import org.zkoss.zul.Html;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Treerow;

public class JpaNavigatorController
extends SelectorComposer<Tree> {
    private static ManagedClassClickHandler managedClassClick = new ManagedClassClickHandler();
    @Wire
    private Tree entityTree;

    public void doAfterCompose(Tree comp) throws Exception {
        super.doAfterCompose((Component)comp);
        this.populate();
    }

    private void populate() {
        Map<String, EntityManagerFactory> emfs = JpaUtil.getEntityManagerFactories();
        if (emfs == null) {
            Executions.createComponents((String)"~./include/nojpa.zul", (Component)this.entityTree.getParent(), null);
            this.entityTree.detach();
            return;
        }
        this.entityTree.clear();
        ArrayList<String> names = new ArrayList<String>(emfs.keySet());
        Collections.sort(names);
        for (String name : names) {
            this.renderPersistenceUnit(name, emfs.get(name));
        }
    }

    private void renderPersistenceUnit(String name, EntityManagerFactory emf) {
        Treeitem treeitem = new Treeitem();
        treeitem.setParent((Component)this.entityTree.getTreechildren());
        Treerow treerow = new Treerow();
        treerow.setParent((Component)treeitem);
        Treecell treecell = new Treecell();
        treecell.setSclass("punit");
        treecell.setParent((Component)treerow);
        Html html = new Html();
        html.setParent((Component)treecell);
        html.setContent("<span class=\"jpa-joblet label label-default\"><i class=\"fa fa-database\" style=\"margin-right:5px\"></i>" + name + "</span>");
        Metamodel metamodel = emf.getMetamodel();
        TreeSet<EntityType> entitiesSortedSet = new TreeSet<EntityType>(JpaUtil.ENTITY_SORTER_INSTANCE);
        entitiesSortedSet.addAll(metamodel.getEntities());
        for (EntityType entityType : entitiesSortedSet) {
            this.renderEntity(treeitem, entityType);
        }
    }

    private void renderEntity(Treeitem parent, EntityType<?> entityType) {
        if (parent.getTreechildren() == null) {
            new Treechildren().setParent((Component)parent);
        }
        Treeitem treeitem = new Treeitem();
        treeitem.setParent((Component)parent.getTreechildren());
        Treerow treerow = new Treerow();
        treerow.setParent((Component)treeitem);
        Treecell treecell = new Treecell();
        treecell.setParent((Component)treerow);
        treecell.setStyle("white-space:nowrap");
        A a = new A(entityType.getJavaType().getSimpleName());
        a.setTooltiptext(entityType.getJavaType().getCanonicalName());
        a.setParent((Component)treecell);
        a.setAttribute("entityType", entityType);
        a.addEventListener("onClick", (EventListener)managedClassClick);
    }

    private static class ManagedClassClickHandler
    implements EventListener<MouseEvent> {
        private ManagedClassClickHandler() {
        }

        public void onEvent(MouseEvent event) throws Exception {
            EntityType entityType = (EntityType)event.getTarget().getAttribute("entityType");
            if (entityType == null) {
                return;
            }
            String id = "jpa-" + entityType.getJavaType().getCanonicalName();
            id = id.replaceAll("\\.", "");
            Component comp = null;
            for (Component c : Executions.getCurrent().getDesktop().getComponents()) {
                if (!id.equals(c.getId())) continue;
                comp = c;
                break;
            }
            if (comp != null) {
                comp.detach();
            }
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", id);
            data.put("entityType", (String)entityType);
            Executions.createComponents((String)"~./include/jpaentitybox.zul", null, data);
        }
    }
}

