/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.controller.impl;

import java.util.Map;
import nu.xom.Element;
import nu.xom.Node;
import org.web4thejob.studio.controller.AbstractController;
import org.web4thejob.studio.controller.ControllerEnum;
import org.web4thejob.studio.message.Message;
import org.web4thejob.studio.message.MessageEnum;
import org.web4thejob.studio.support.ChildDelegate;
import org.web4thejob.studio.support.StudioUtil;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.MouseEvent;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Html;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Treerow;

public class OutlineController
extends AbstractController {
    private final OutlineClickHandler outlineClickHandler = new OutlineClickHandler();
    private final DroppableHandler droppableHandler = new DroppableHandler();
    @Wire
    private Tree outline;
    private Element selection;

    private static Treeitem findTreeitemParent(Component child) {
        if (child == null) {
            return null;
        }
        if (child instanceof Treeitem) {
            return (Treeitem)child;
        }
        return OutlineController.findTreeitemParent(child.getParent());
    }

    @Override
    public ControllerEnum getId() {
        return ControllerEnum.OUTLINE_CONTROLLER;
    }

    public void refresh() {
        this.outline.clear();
        Element rootElement = StudioUtil.getCode().getRootElement();
        if (rootElement == null) {
            return;
        }
        this.includeComponent(rootElement);
    }

    private Treeitem toTreeitem(Element element) {
        Treeitem item = new Treeitem();
        Treerow treerow = new Treerow();
        treerow.setParent((Component)item);
        treerow.setWidgetAttribute("canvas-uuid", element.getAttributeValue("uuid"));
        Treecell cell = new Treecell();
        cell.setStyle("white-space: nowrap;");
        String i = "/img/zul/" + element.getLocalName() + ".png";
        cell.setImage("/w4tjstudio-support/img?f=" + element.getLocalName() + ".png");
        cell.setParent((Component)item.getTreerow());
        Html html = new Html(StudioUtil.describeElement(element));
        html.setStyle("margin-left: 5px;");
        html.setParent((Component)cell);
        item.setValue((Object)element);
        item.setDraggable("true");
        item.setDroppable("true");
        item.addEventListener("onClick", (EventListener)this.outlineClickHandler);
        item.addEventListener("onDrop", (EventListener)this.droppableHandler);
        return item;
    }

    @Override
    public void process(Message message) {
        switch (message.getId()) {
            case COMPONENT_SELECTED: {
                this.selectItem((Element)message.getData());
                if (this.equals(message.getSender())) break;
                Clients.evalJavaScript((String)"w4tjStudioDesigner.centerOutlineSelection()");
                break;
            }
            case RESET: {
                this.refresh();
                this.selection = null;
                break;
            }
            case ZUL_EVAL_SUCCEEDED: {
                this.refresh();
                break;
            }
            case XML_EVAL_FAILED: {
                this.outline.clear();
                break;
            }
            case ZUL_EVAL_FAILED: {
                this.outline.clear();
            }
        }
    }

    private void includeComponent(Element element) {
        StudioUtil.traverseChildren(element, null, new ChildDelegate<Element>(){

            @Override
            public void onChild(Element child, Map<String, Object> params) {
                Treeitem item = OutlineController.this.toTreeitem(child);
                if (child.getParent() instanceof Element) {
                    Treeitem parent = OutlineController.this.getTreeitemByElement((Element)child.getParent());
                    if (parent.getTreechildren() == null) {
                        new Treechildren().setParent((Component)parent);
                    }
                    item.setParent((Component)parent.getTreechildren());
                } else {
                    if (OutlineController.this.outline.getTreechildren() == null) {
                        new Treechildren().setParent((Component)OutlineController.this.outline);
                    }
                    item.setParent((Component)OutlineController.this.outline.getTreechildren());
                }
            }
        });
    }

    private Treeitem getTreeitemByElement(Element element) {
        for (Treeitem item : this.outline.getItems()) {
            if (!element.equals(item.getValue())) continue;
            return item;
        }
        return null;
    }

    private void removeItem(Element element) {
        this.getTreeitemByElement(element).detach();
    }

    public void selectItem(Element element) {
        Treeitem item;
        this.selection = element;
        this.outline.setSelectedItem(null);
        if (element != null && (item = this.getTreeitemByElement(element)) != null) {
            item.setSelected(true);
        }
    }

    private class OutlineClickHandler
    implements EventListener<MouseEvent> {
        private OutlineClickHandler() {
        }

        public void onEvent(MouseEvent event) throws Exception {
            Element element = (Element)((Treeitem)event.getTarget()).getValue();
            if (element.getAttributeValue("uuid") != null || "attribute".equals(element.getLocalName())) {
                OutlineController.this.publish(MessageEnum.COMPONENT_SELECTED, element);
            } else {
                OutlineController.this.publish(MessageEnum.COMPONENT_SELECTED);
            }
        }
    }

    private class DroppableHandler
    implements EventListener<DropEvent> {
        private DroppableHandler() {
        }

        public void onEvent(DropEvent event) throws Exception {
            Element dragged = (Element)((Treeitem)event.getDragged()).getValue();
            if (dragged.getAttributeValue("uuid") == null) {
                return;
            }
            Element dropped = (Element)((Treeitem)event.getTarget()).getValue();
            if (dropped.getAttributeValue("uuid") == null) {
                return;
            }
            if (StudioUtil.acceptsChild(dropped, dragged)) {
                dragged.detach();
                dropped.appendChild((Node)dragged);
                OutlineController.this.publish(MessageEnum.COMPONENT_SELECTED, dropped);
                OutlineController.this.publish(MessageEnum.EVALUATE_ZUL);
            }
        }
    }
}

