/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeSet;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.Nodes;
import nu.xom.XPathContext;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.web4thejob.studio.conf.Configuration;
import org.web4thejob.studio.controller.Controller;
import org.web4thejob.studio.controller.ControllerEnum;
import org.web4thejob.studio.controller.impl.CodeController;
import org.web4thejob.studio.controller.impl.DesignerController;
import org.web4thejob.studio.dom.Element;
import org.web4thejob.studio.support.ChildDelegate;
import org.web4thejob.studio.support.CodeFormatter;
import org.web4thejob.studio.support.FileUtils;
import org.zkoss.json.JSONValue;
import org.zkoss.lang.Generics;
import org.zkoss.util.resource.Locators;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.util.Clients;

public abstract class StudioUtil {
    private static final String ATTR_CONFIG = "w4tjstudio-configuration";
    public static final String ATTR_CANVAS_DESKTOP = "i-am-the-canvas-desktop";
    public static final String ATTR_PAIRED_DESKTOP = "paired-desktop-id";
    public static final String ATTR_STUDIO_CONTROLLERS = "studio-controllers";
    public static final String ATTR_CANVAS_UUID = "canvas-uuid";
    public static final String ATTR_CANVAS_FILE = "canvas-file";
    public static final String ATTR_WORK_FILE = "work-file";
    private static Map<Class<? extends Component>, Component> defaults = Generics.cast(Collections.synchronizedMap(new HashMap()));

    public static boolean isCanvasDesktop() {
        return Executions.getCurrent().getDesktop().hasAttribute(ATTR_CANVAS_DESKTOP);
    }

    public static Component getComponentByUuid(String uuid) {
        return Executions.getCurrent().getDesktop().getComponentByUuid(uuid);
    }

    public static void showNotification(String sclass, String title, String message, boolean autoclose) {
        StudioUtil.showNotification(sclass, title, message, autoclose, false);
    }

    public static void showNotification(String sclass, String title, String message, boolean autoclose, boolean encoded) {
        String m = message.replaceAll("'", "\"");
        Clients.evalJavaScript((String)("top.w4tjStudioDesigner.alert('" + sclass + "','" + title + "','" + m + "'," + Boolean.valueOf(autoclose).toString() + "," + Boolean.valueOf(encoded).toString() + ")"));
    }

    public static void showPopover(String uuid, String sclass, String message, boolean autoclose) {
        String m = message.replaceAll("'", "\"");
        Clients.evalJavaScript((String)("top.w4tjStudioDesigner.showPopover('#" + uuid + "','" + m + "','" + sclass + "'," + Boolean.valueOf(autoclose).toString() + ")"));
    }

    public static void clearCanvasBusy(String uuid) {
        Clients.evalJavaScript((String)("top.w4tjStudioDesigner.clearCanvasBusy(" + (uuid != null ? "'" + uuid + "'" : "") + ")"));
    }

    public static void clearAlerts() {
        Clients.evalJavaScript((String)"top.w4tjStudioDesigner.clearAlerts()");
    }

    public static void showError(Exception e) {
        StudioUtil.showError(e, false);
    }

    public static void showError(Exception e, boolean autoclosable) {
        StudioUtil.showNotification("danger", "Ooops!", e.getMessage() != null ? e.getMessage() : e.toString(), autoclosable);
    }

    public static void showError(String message, boolean autoclosable) {
        StudioUtil.showNotification("danger", "Ooops!", message, autoclosable);
    }

    public static Desktop getPairedDesktop() {
        return (Desktop)Executions.getCurrent().getDesktop().getAttribute(ATTR_PAIRED_DESKTOP);
    }

    public static TreeSet<Controller> getLocalControllers() {
        SortedMap controllers = (SortedMap)Generics.cast((Object)Executions.getCurrent().getDesktop().getAttribute(ATTR_STUDIO_CONTROLLERS));
        Validate.notNull((Object)controllers, (String)"called to early", (Object[])new Object[0]);
        return new TreeSet<Controller>(controllers.values());
    }

    private static <T extends Controller> T getController(ControllerEnum id) {
        Desktop desktop = id == ControllerEnum.CANVAS_CONTROLLER && StudioUtil.isCanvasDesktop() || id != ControllerEnum.CANVAS_CONTROLLER && !StudioUtil.isCanvasDesktop() ? Executions.getCurrent().getDesktop() : StudioUtil.getPairedDesktop();
        SortedMap controllers = (SortedMap)Generics.cast((Object)desktop.getAttribute(ATTR_STUDIO_CONTROLLERS));
        Validate.notNull((Object)controllers, (String)"called to early", (Object[])new Object[0]);
        return (T)((Controller)Generics.cast(controllers.get((Object)id)));
    }

    public static Document getCode() {
        return ((CodeController)StudioUtil.getController(ControllerEnum.CODE_CONTROLLER)).getCode();
    }

    public static String getCanvasUuid() {
        Validate.isTrue((!StudioUtil.isCanvasDesktop() ? 1 : 0) != 0, (String)"No need for this, you are in the canvas", (Object[])new Object[0]);
        return (String)Executions.getCurrent().getDesktop().getAttribute(ATTR_CANVAS_UUID);
    }

    public static void traverseChildren(Component parent, Map<String, Object> params, ChildDelegate<Component> childDelegate) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        childDelegate.onChild(parent, params);
        for (Component child : parent.getChildren()) {
            StudioUtil.traverseChildren(child, new HashMap<String, Object>(params), childDelegate);
        }
    }

    public static void traverseChildren(nu.xom.Element parent, Map<String, Object> params, ChildDelegate<nu.xom.Element> childDelegate) {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        childDelegate.onChild(parent, params);
        for (int i = 0; i < parent.getChildElements().size(); ++i) {
            StudioUtil.traverseChildren(parent.getChildElements().get(i), new HashMap<String, Object>(params), childDelegate);
        }
    }

    public static nu.xom.Element getElementByUuid(String uuid) {
        return (nu.xom.Element)StudioUtil.getCode().getRootElement().query("descendant-or-self::*[@uuid='" + uuid + "']").get(0);
    }

    public static boolean isDefaultValueForProperty(Component instance, String propertyName, String value, boolean isBoolen) {
        if (!defaults.containsKey(instance.getClass())) {
            defaults.put(instance.getClass(), instance.getDefinition().newInstance(null, null));
        }
        try {
            Object defvalue = StudioUtil.invokeGetter(defaults.get(instance.getClass()), propertyName, isBoolen);
            if (defvalue != null) {
                return value.equals(defvalue.toString());
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Object invokeGetter(Object instance, String property, boolean isBoolean) throws NoSuchMethodException, ClassNotFoundException, InvocationTargetException, IllegalAccessException {
        return MethodUtils.invokeMethod((Object)instance, (String)((isBoolean ? "is" : "get") + StringUtils.capitalize((String)property)), (Object[])new Object[0]);
    }

    public static boolean hasProperty(Class<?> clazz, String property, boolean isBoolean) {
        try {
            return ClassUtils.getPublicMethod(clazz, (String)((isBoolean ? "is" : "get") + StringUtils.capitalize((String)property)), (Class[])new Class[0]) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static void cleanUUIDs(nu.xom.Element parent) {
        Nodes nodes = parent.query("descendant-or-self::*[@uuid]", XPathContext.makeNamespaceContext((nu.xom.Element)parent));
        for (int i = 0; i < nodes.size(); ++i) {
            Attribute uuid = ((nu.xom.Element)nodes.get(i)).getAttribute("uuid");
            ((nu.xom.Element)nodes.get(i)).removeAttribute(uuid);
        }
    }

    public static boolean isEventOrAttributeElement(nu.xom.Element element) {
        return StudioUtil.isEventElement(element) || "custom-attributes".equals(element.getLocalName());
    }

    public static boolean isEventElement(nu.xom.Element element) {
        return "attribute".equals(element.getLocalName());
    }

    public static boolean isCodeElement(nu.xom.Element element) {
        String tagname = element.getLocalName();
        return "attribute".equals(tagname) || "script".equals(tagname) || "zscript".equals(tagname) || "style".equals(tagname) || "html".equals(tagname);
    }

    public static String getQueryParam(String query, String param) {
        if (query == null) {
            return null;
        }
        Validate.notNull((Object)param);
        StringTokenizer tokenizer = new StringTokenizer(query, "&", false);
        while (tokenizer.hasMoreElements()) {
            String token = tokenizer.nextToken().trim();
            if (!token.startsWith(param) || !token.contains("=")) continue;
            return token.split("=")[1];
        }
        return null;
    }

    public static String describeElement(nu.xom.Element element) {
        boolean script = element.getLocalName().equals("attribute");
        StringBuilder sb = new StringBuilder();
        String specialStyle = null;
        if (!script) {
            if (element.getAttributeValue("uuid") == null) {
                specialStyle = "w4tjstudio-element-skipped";
            } else if ("false".equals(element.getAttributeValue("visible"))) {
                specialStyle = "w4tjstudio-element-hidden";
            }
        } else if (element.getParent() != null) {
            nu.xom.Element parent = (nu.xom.Element)element.getParent();
            if (parent.getAttributeValue("uuid") == null) {
                specialStyle = "w4tjstudio-element-skipped";
            } else if ("false".equals(parent.getAttributeValue("visible"))) {
                specialStyle = "w4tjstudio-element-hidden";
            }
        }
        if (specialStyle != null) {
            sb.append("<span class=\"").append(specialStyle).append("\">");
        }
        sb.append(element.getNamespacePrefix() != "" ? element.getNamespacePrefix() + ":" : "").append(element.getLocalName()).append(" [");
        if (!script) {
            if (element.getAttributeValue("id") != null) {
                sb.append(element.getAttributeValue("id"));
            } else if (element.getAttributeValue("uuid") != null) {
                sb.append("#").append(element.getAttributeValue("uuid"));
            }
        } else if (element.getAttributeValue("name") != null) {
            sb.append("<span style=\"font-family:monospace\">");
            sb.append(element.getAttributeValue("name")).append("@server");
            sb.append("</span>");
        } else if (element.getAttributeValue("name", StudioUtil.getClientNamespace((Element)element)) != null) {
            sb.append("<span style=\"font-family:monospace\">");
            sb.append(element.getAttributeValue("name", StudioUtil.getClientNamespace((Element)element))).append("@client");
            sb.append("</span>");
        }
        sb.append("]");
        if (element.getAttributeValue("label") != null || element.getAttributeValue("value") != null) {
            String t2;
            String t1;
            String nval;
            sb.append(": ").append("<span style=\"color:").append(specialStyle != null ? "inherit" : "#428bca").append(";font-style:italic;font-weight:bold;\">");
            String value = element.getAttributeValue("label") != null ? element.getAttributeValue("label") : element.getAttributeValue("value");
            if (specialStyle == null) {
                nval = "";
                t1 = "${";
                t2 = "}";
                if (value.contains(t1)) {
                    int p1 = value.indexOf(t1);
                    int p2 = value.indexOf(t2);
                    if (p2 > p1) {
                        nval = "<code>" + value.substring(p1, p2 + 1) + "</code>";
                        if (p1 > 0) {
                            nval = value.substring(0, p1 - 1) + nval;
                        }
                        if (p2 < value.length() - 1) {
                            nval = nval + value.substring(p2 + 1);
                        }
                        value = nval;
                    }
                }
            }
            if (specialStyle == null) {
                nval = "";
                t1 = null;
                t2 = null;
                for (int j = 1; j <= 3; ++j) {
                    switch (j) {
                        case 1: {
                            t1 = "@bind(";
                            t2 = ")";
                            break;
                        }
                        case 2: {
                            t1 = "@load(";
                            t2 = ")";
                            break;
                        }
                        case 3: {
                            t1 = "@save(";
                            t2 = ")";
                        }
                    }
                    if (!value.contains(t1)) continue;
                    int p1 = value.indexOf(t1);
                    int p2 = value.indexOf(t2);
                    if (p2 <= p1) continue;
                    nval = "<span class=\"label label-success z-label mono\">" + value.substring(p1, p2 + 1) + "</span>";
                    if (p1 > 0) {
                        nval = value.substring(0, p1 - 1) + nval;
                    }
                    if (p2 < value.length() - 1) {
                        nval = nval + value.substring(p2 + 1);
                    }
                    value = nval;
                }
            }
            sb.append(value).append("</span>");
        }
        if (element.getAttributeValue("uuid") == null) {
            sb.append("</span");
        }
        return sb.toString();
    }

    public static ComponentDefinition getDefinitionByTag(String tag) {
        for (LanguageDefinition languageDefinition : LanguageDefinition.getByDeviceType((String)"ajax")) {
            ComponentDefinition componentDefinition = languageDefinition.getComponentDefinitionIfAny(tag);
            if (componentDefinition == null) continue;
            return componentDefinition;
        }
        return null;
    }

    public static Node getEventCodeNode(nu.xom.Element element, String eventName, boolean isServerSide) {
        Nodes nodes;
        if (isServerSide) {
            nodes = element.query("child::*[@name='" + eventName + "']");
        } else {
            String prefix = StudioUtil.getClientNamespacePrefix((Element)element);
            if (prefix != null) {
                nodes = element.query("child::*[@" + prefix + ":name='" + eventName + "']", XPathContext.makeNamespaceContext((nu.xom.Element)element));
            } else {
                return null;
            }
        }
        if (nodes.size() != 1) {
            return null;
        }
        return nodes.get(0);
    }

    public static String getProcessingInstructions(String uri) throws IOException {
        uri = uri.replace("~.", "web");
        InputStream inputStream = Locators.getDefault().getResourceAsStream(uri);
        if (inputStream == null) {
            return null;
        }
        return StudioUtil.processProcessingInstructions(FileUtils.readAllLines(inputStream));
    }

    public static String processProcessingInstructions(String[] lines) {
        StringBuilder sb = new StringBuilder();
        for (String s : lines) {
            String line = s.trim();
            if (line.startsWith("<?style") && line.endsWith("?>")) {
                sb.append("<link type=\"text/css\" rel=\"stylesheet\" href=\"").append(StudioUtil.extractValue(line, "href", true)).append("\"/>\n");
                continue;
            }
            if (line.startsWith("<?script") && line.endsWith("?>")) {
                sb.append("<script type=\"text/javascript\" src=\"").append(StudioUtil.extractValue(line, "src", true)).append("\" charset=\"UTF-8\"></script>\n");
                continue;
            }
            if (line.startsWith("<?link") && line.contains("rel=\"shortcut icon\"") && line.endsWith("?>")) {
                sb.append("<link rel=\"shortcut icon\" type=\"").append(StudioUtil.extractValue(line, "type", false)).append("\"  href=\"").append(StudioUtil.extractValue(line, "href", true)).append("\" </link>\n");
                continue;
            }
            if (line.startsWith("<zk")) break;
        }
        return sb.toString();
    }

    public static String processProcessingInstructions(List<String> lines) {
        return StudioUtil.processProcessingInstructions(lines.toArray(new String[lines.size()]));
    }

    private static String extractValue(String s, String key, boolean isPath) {
        int start = s.indexOf(key);
        if (start < 0) {
            return null;
        }
        String value = "";
        for (int i = start += key.length(); i < s.length(); ++i) {
            String cpath;
            String c = s.substring(i, i + 1);
            if (!c.equals("=")) continue;
            value = s.substring(s.indexOf("\"", i + 1) + 1, s.indexOf("\"", i + 2));
            if (!isPath || !value.startsWith("/") || (cpath = Executions.getCurrent().getContextPath()) == null || cpath.equals("/")) break;
            value = cpath + value;
            break;
        }
        return value;
    }

    private static void cleanWellKnownErrors(Document document) {
        Attribute a;
        int i;
        XPathContext xpathContext = XPathContext.makeNamespaceContext((nu.xom.Element)document.getRootElement());
        Nodes nodes = document.query("//zul:panelchildren[@vflex]", xpathContext);
        for (i = 0; i < nodes.size(); ++i) {
            a = ((nu.xom.Element)nodes.get(i)).getAttribute("vflex");
            a.detach();
        }
        nodes = document.query("//zul:treeitem[@label]", xpathContext);
        for (i = 0; i < nodes.size(); ++i) {
            a = ((nu.xom.Element)nodes.get(i)).getAttribute("label");
            a.detach();
        }
        nodes = document.query("//zul:treerow[@label]", xpathContext);
        for (i = 0; i < nodes.size(); ++i) {
            a = ((nu.xom.Element)nodes.get(i)).getAttribute("label");
            a.detach();
        }
        nodes = document.query("//zul:tabbox[@selectedIndex]", xpathContext);
        for (i = 0; i < nodes.size(); ++i) {
            a = ((nu.xom.Element)nodes.get(i)).getAttribute("selectedIndex");
            a.detach();
        }
    }

    public static File buildWorkingFile(Document document) {
        try {
            File f = File.createTempFile("w4tjstudio", "zul");
            f.deleteOnExit();
            FileUtils.writeStringToFile(f, CodeFormatter.formatXML(document), "UTF-8");
            return f;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void sendToDesigner(String eventName, Object data) {
        Clients.evalJavaScript((String)("w4tjStudioCanvas.sendToDesigner('" + eventName + "'," + "" + JSONValue.toJSONString((Object)data) + ")"));
    }

    public static Document buildDocument(String content) {
        try {
            return new Builder(false, (NodeFactory)new org.web4thejob.studio.dom.NodeFactory()).build(content, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Document buildDocument(InputStream content) {
        try {
            return new Builder(false, (NodeFactory)new org.web4thejob.studio.dom.NodeFactory()).build(content, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getClientNamespacePrefix(Element element) {
        Map<String, String> ns = element.getNamespacePrefixesInScope();
        for (String prefix : ns.keySet()) {
            String uri = ns.get(prefix);
            if (!"client".equals(uri) && !"http://www.zkoss.org/2005/zk/client".equals(uri)) continue;
            return prefix;
        }
        return null;
    }

    public static String getClientNamespace(Element element) {
        Map<String, String> ns = element.getNamespacePrefixesInScope();
        return ns.get(StudioUtil.getClientNamespacePrefix(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean acceptsChild(nu.xom.Element parent, nu.xom.Element child) {
        Component target;
        if ("attribute".equals(child.getLocalName())) {
            return true;
        }
        if ("zk".equals(parent.getLocalName())) {
            return true;
        }
        Component container = null;
        nu.xom.Element parentClone = (nu.xom.Element)parent.copy();
        StudioUtil.cleanUUIDs(parentClone);
        nu.xom.Element childClone = (nu.xom.Element)child.copy();
        childClone.removeChildren();
        StudioUtil.cleanUUIDs(childClone);
        try {
            container = Executions.createComponentsDirectly((String)parentClone.toXML(), (String)"zul", null, null);
            target = Executions.createComponentsDirectly((String)childClone.toXML(), (String)"zul", (Component)container, null);
            container.detach();
        }
        catch (Exception e) {
            StudioUtil.showError(e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (container != null) {
                container.detach();
            }
        }
        return target != null;
    }

    public static String getWorkFile() {
        return (String)Executions.getCurrent().getDesktop().getAttribute(ATTR_WORK_FILE);
    }

    public static void setWorkFile(String path) {
        Executions.getCurrent().getDesktop().setAttribute(ATTR_WORK_FILE, (Object)path);
    }

    public static Configuration getConfiguration() {
        Configuration configuration = (Configuration)Executions.getCurrent().getSession().getAttribute(ATTR_CONFIG);
        if (configuration == null) {
            configuration = new Configuration();
            Executions.getCurrent().getSession().setAttribute(ATTR_CONFIG, (Object)configuration);
        }
        return configuration;
    }

    public static String getCanvasURI() {
        return ((DesignerController)StudioUtil.getController(ControllerEnum.DESIGNER_CONTROLLER)).getCanvasHolderURI();
    }

    public static boolean isNative(nu.xom.Element element) {
        if (element == null) {
            return false;
        }
        String ns = element.getNamespaceURI();
        return "native".equals(ns) || "http://www.zkoss.org/2005/zk/native".equals(ns) || element.getQualifiedName().startsWith("native:");
    }

    public static boolean isCodeValid() {
        try {
            StudioUtil.getCode();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean addNamespaceToCode(String preffix, String nsURI) {
        if (!StudioUtil.isCodeValid()) {
            return false;
        }
        nu.xom.Element root = StudioUtil.getCode().getRootElement();
        root.addNamespaceDeclaration(preffix, nsURI);
        return true;
    }

    public static boolean removeNamespaceFromCode(String preffix) {
        if (!StudioUtil.isCodeValid()) {
            return false;
        }
        nu.xom.Element root = StudioUtil.getCode().getRootElement();
        root.removeNamespaceDeclaration(preffix);
        return true;
    }

    public static boolean namespaceExistsInCode(String preffix) {
        if (!StudioUtil.isCodeValid()) {
            return false;
        }
        nu.xom.Element root = StudioUtil.getCode().getRootElement();
        return root.getNamespaceURI(preffix) != null;
    }

    public static String getDefaultBindingProperty(ComponentDefinition def) {
        if (def.getAnnotationMap() != null) {
            List properties = def.getAnnotationMap().getAnnotatedPropertiesBy("ZKBIND");
            for (String p : properties) {
                if ("errorMessage".equals(p) || "model".equals(p)) continue;
                return p;
            }
        }
        return null;
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods()) {
                if (!name.equals(method.getName()) || paramTypes != null && !Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }
}

