/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.controller.impl;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.web4thejob.studio.controller.impl.DashboardController;
import org.web4thejob.studio.support.Assert;
import org.web4thejob.studio.support.FileUtils;
import org.web4thejob.studio.support.StudioUtil;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Window;

public class AddFileController
extends SelectorComposer<Component> {
    File parentDir;
    @Wire
    private Window win;
    @Wire
    private Textbox txtFilename;
    private DashboardController dashboardController;

    public void doAfterCompose(Component comp) throws Exception {
        super.doAfterCompose(comp);
        StudioUtil.clearAlerts();
        String location = (String)Executions.getCurrent().getArg().get("location");
        Assert.assertTrue(location != null, "Attribute location is missing");
        this.parentDir = new File(location);
        Assert.assertTrue(this.parentDir.exists(), "Invalid parent dir: " + location);
        this.dashboardController = (DashboardController)Executions.getCurrent().getArg().get("dashboardController");
        Assert.assertTrue(this.dashboardController != null, "Attribute dashboardController is missing");
    }

    @Listen(value="onClick=#btnCancel;onCancel=#win")
    public void onCancel() {
        StudioUtil.clearAlerts();
        this.win.detach();
    }

    @Listen(value="onDoneClicked=#win")
    public void onDone(Event event) {
        StudioUtil.clearAlerts();
        boolean isFile = (Boolean)((Map)event.getData()).get("file");
        String name = this.txtFilename.getValue().trim();
        if (name.length() == 0) {
            return;
        }
        try {
            File file;
            if (isFile) {
                file = new File(this.parentDir.getAbsolutePath() + System.getProperty("file.separator") + name + ".zul");
                if (file.exists()) {
                    StudioUtil.showPopover(this.txtFilename.getUuid(), "error", "File already exists.", true);
                    return;
                }
                FileUtils.writeStringToFile(file, "<zk/>", "UTF-8");
            } else {
                file = new File(this.parentDir.getAbsolutePath() + System.getProperty("file.separator") + name);
                if (file.exists()) {
                    StudioUtil.showPopover(this.txtFilename.getUuid(), "error", "Directory already exists.", true);
                    return;
                }
                file.mkdir();
            }
            this.win.detach();
            this.dashboardController.buildTree(file.getAbsolutePath());
        }
        catch (IOException e) {
            StudioUtil.showError(e);
        }
    }
}

