/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.controller.impl;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Nodes;
import nu.xom.XPathContext;
import org.web4thejob.studio.support.JpaUtil;
import org.web4thejob.studio.support.StudioUtil;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.MouseEvent;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.A;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Label;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Panel;

public class JpaInfoController
extends SelectorComposer<Component> {
    @Wire
    Div jpacontroller;
    @Wire
    Listbox punitList;
    @Wire
    Listbox managedList;

    private static SortedMap<String, Map<String, String>> getPersistenceUnitNames() {
        TreeMap<String, Map<String, String>> names = new TreeMap<String, Map<String, String>>();
        try {
            XPathContext ctx = new XPathContext("p", "http://java.sun.com/xml/ns/persistence");
            Enumeration<URL> punits = Persistence.class.getClassLoader().getResources("META-INF/persistence.xml");
            while (punits.hasMoreElements()) {
                Builder parser = new Builder(false);
                URL punit = punits.nextElement();
                Document document = parser.build(punit.openStream());
                Nodes nodes = document.query("p:persistence/p:persistence-unit", ctx);
                if (nodes.size() != 1) continue;
                String name = ((Element)nodes.get(0)).getAttributeValue("name");
                Map<String, String> properties = JpaUtil.getConnectionProperties(name);
                if (properties == null) {
                    properties = new HashMap<String, String>();
                    JpaUtil.setConnectionProperties(name, properties);
                    properties.put("name", name);
                    nodes = document.query("p:persistence/p:persistence-unit/p:properties/p:property[@name='javax.persistence.jdbc.driver']", ctx);
                    if (nodes.size() == 1) {
                        properties.put("driver", ((Element)nodes.get(0)).getAttributeValue("value"));
                    }
                    if ((nodes = document.query("p:persistence/p:persistence-unit/p:properties/p:property[@name='javax.persistence.jdbc.url']", ctx)).size() == 1) {
                        properties.put("url", ((Element)nodes.get(0)).getAttributeValue("value"));
                    }
                    if ((nodes = document.query("p:persistence/p:persistence-unit/p:properties/p:property[@name='javax.persistence.jdbc.user']", ctx)).size() == 1) {
                        properties.put("user", ((Element)nodes.get(0)).getAttributeValue("value"));
                    }
                    if ((nodes = document.query("p:persistence/p:persistence-unit/p:properties/p:property[@name='javax.persistence.jdbc.password']", ctx)).size() == 1) {
                        properties.put("password", ((Element)nodes.get(0)).getAttributeValue("value"));
                    }
                }
                names.put(name + "|" + punit.toString(), properties);
            }
        }
        catch (Exception e) {
            StudioUtil.showError(e);
        }
        return names;
    }

    private static boolean isComplete(Map<String, String> properties) {
        return properties.get("name") != null && properties.get("driver") != null && !(properties.get("url") == null | properties.get("user") == null);
    }

    private static void renderConfigLink(A a, Map<String, String> properties) {
        if (JpaInfoController.isComplete(properties)) {
            a.setLabel("Complete");
            a.setStyle("color:#419641");
        } else {
            a.setLabel("Missing");
            a.setStyle("color:#b94a48");
        }
    }

    private static void renderManagedClasses(String name, Listbox punitList, Listbox managedList) {
        punitList.clearSelection();
        managedList.getItems().clear();
        Clients.evalJavaScript((String)"jq('$jpacontroller .badge').remove()");
        EntityManagerFactory emf = JpaUtil.getEntityManagerFactory(name);
        if (emf == null) {
            return;
        }
        Metamodel metamodel = emf.getMetamodel();
        TreeSet<EntityType> entitiesSortedSet = new TreeSet<EntityType>(JpaUtil.ENTITY_SORTER_INSTANCE);
        entitiesSortedSet.addAll(metamodel.getEntities());
        for (EntityType entityType : entitiesSortedSet) {
            Listitem listitem = new Listitem();
            listitem.setParent((Component)managedList);
            Listcell listcell = new Listcell(entityType.getJavaType().getCanonicalName());
            listcell.setParent((Component)listitem);
        }
        for (Listitem item : punitList.getItems()) {
            if (!name.equals(item.getAttribute("name"))) continue;
            item.setSelected(true);
        }
        Clients.evalJavaScript((String)("jq(\"$jpacontroller .z-center-header\").append('<span class=\"badge\" style=\"margin-left:10px\">" + metamodel.getEntities().size() + "</span>')"));
    }

    private void renderState(String name, Hlayout hlayout, A configLink) {
        hlayout.getChildren().clear();
        boolean started = JpaUtil.getEntityManagerFactory(name) != null;
        Label state = new Label(started ? "Started" : "Stopped");
        state.setSclass("label label-" + (started ? "success" : "default"));
        state.setParent((Component)hlayout);
        if (!started) {
            A a = new A("Start?");
            a.setParent((Component)hlayout);
            a.addEventListener("onClick", (EventListener)new StartStopEMFHandler(name, hlayout, true, configLink));
            a.setWidgetListener("onClick", "zAu.cmd0.showBusy();");
        } else {
            A a = new A("Stop?");
            a.setParent((Component)hlayout);
            a.addEventListener("onClick", (EventListener)new StartStopEMFHandler(name, hlayout, false, configLink));
            a.setWidgetListener("onClick", "zAu.cmd0.showBusy();");
        }
        JpaInfoController.renderManagedClasses(name, this.punitList, this.managedList);
    }

    @Listen(value="onJpaScan=#jpacontroller")
    public void onJpaScan() {
        if (!this.punitList.getEventListeners("onSelect").iterator().hasNext()) {
            this.punitList.addEventListener("onSelect", (EventListener)new OnPunitSelectedHandler());
        }
        this.punitList.getItems().clear();
        this.managedList.getItems().clear();
        Clients.evalJavaScript((String)"jq('$jpacontroller .badge').remove()");
        Clients.clearBusy();
        SortedMap<String, Map<String, String>> units = JpaInfoController.getPersistenceUnitNames();
        if (units.isEmpty()) {
            StudioUtil.showNotification("warning", "No JPA", "Sorry but your project does not contain any JPA persistence units.", true);
            return;
        }
        for (String unit : units.keySet()) {
            String name = unit.split("\\|")[0];
            String url = unit.split("\\|")[1];
            Listitem listitem = new Listitem();
            listitem.setAttribute("name", (Object)name);
            new Listcell(name).setParent((Component)listitem);
            Listcell cell = new Listcell();
            cell.setParent((Component)listitem);
            cell.setStyle("text-align:center");
            A a = new A();
            a.addEventListener("onClick", (EventListener)new ConnInfoConfigClickHandler(name));
            a.setParent((Component)cell);
            JpaInfoController.renderConfigLink(a, (Map)units.get(unit));
            cell = new Listcell();
            cell.setParent((Component)listitem);
            cell.setStyle("text-align:center");
            Hlayout hlayout = new Hlayout();
            hlayout.setParent((Component)cell);
            hlayout.setSpacing("5px");
            this.renderState(name, hlayout, a);
            new Listcell(url).setParent((Component)listitem);
            listitem.setParent((Component)this.punitList);
        }
    }

    private class OnPunitSelectedHandler
    implements EventListener<SelectEvent<Listitem, ?>> {
        private OnPunitSelectedHandler() {
        }

        public void onEvent(SelectEvent<Listitem, ?> event) throws Exception {
            Listitem selectedItem = (Listitem)event.getSelectedItems().iterator().next();
            String name = selectedItem.getAttribute("name").toString();
            JpaInfoController.renderManagedClasses(name, JpaInfoController.this.punitList, JpaInfoController.this.managedList);
        }
    }

    private class ConnInfoConfigClickHandler
    implements EventListener<Event> {
        private String name;

        public ConnInfoConfigClickHandler(String name) {
            this.name = name;
        }

        public void onEvent(Event event) throws Exception {
            A a = (A)event.getTarget();
            Map<String, String> properties = JpaUtil.getConnectionProperties(this.name);
            if ("onConfigChanged".equals(event.getName())) {
                JpaInfoController.renderConfigLink(a, properties);
            } else {
                Panel panel;
                try {
                    panel = (Panel)Executions.getCurrent().createComponents("~./include/jpaconninfo.zul", null, properties);
                }
                catch (Exception e) {
                    return;
                }
                panel.setAttribute("name", (Object)this.name);
                panel.setAttribute("target", (Object)a);
                panel.setAttribute("callback", (Object)this);
                Clients.evalJavaScript((String)("showInPopover('" + a.getUuid() + "','" + panel.getUuid() + "')"));
            }
        }
    }

    private class StartStopEMFHandler
    implements EventListener<MouseEvent> {
        private String name;
        private Hlayout hlayout;
        private boolean start;
        private A configLink;

        public StartStopEMFHandler(String name, Hlayout hlayout, boolean start, A configLink) {
            this.name = name;
            this.hlayout = hlayout;
            this.start = start;
            this.configLink = configLink;
        }

        public void onEvent(MouseEvent event) throws Exception {
            Clients.clearBusy();
            if (this.start) {
                Map<String, String> properties = JpaUtil.getConnectionProperties(this.name);
                if (!JpaInfoController.isComplete(properties)) {
                    StudioUtil.showPopover(this.configLink.getUuid(), "error", "<strong>Incomplete connection info.</strong> Fill in the connection info to continue.", false);
                    return;
                }
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("javax.persistence.jdbc.driver", properties.get("driver"));
                props.put("javax.persistence.jdbc.url", properties.get("url"));
                props.put("javax.persistence.jdbc.user", properties.get("user"));
                props.put("javax.persistence.jdbc.password", properties.get("password"));
                try {
                    EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)this.name, props);
                    JpaUtil.setEntityManagerFactory(this.name, emf);
                    JpaInfoController.this.renderState(this.name, this.hlayout, this.configLink);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    StudioUtil.showError(e);
                }
            } else {
                EntityManagerFactory emf = JpaUtil.getEntityManagerFactory(this.name);
                if (emf != null && emf.isOpen()) {
                    emf.close();
                }
                JpaUtil.removeEntityManagerFactory(this.name);
                JpaInfoController.this.renderState(this.name, this.hlayout, this.configLink);
            }
        }
    }
}

