/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.support;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.zkoss.io.Files;

public abstract class FileUtils {
    public static List<String> readAllLines(InputStream is) {
        BufferedReader r = new BufferedReader(new InputStreamReader(is));
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line;
            while ((line = r.readLine()) != null) {
                list.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(new Error());
        }
        finally {
            Files.close((InputStream)is);
        }
        return list;
    }

    public static List<String> readAllLines(Reader reader) {
        BufferedReader r = new BufferedReader(reader);
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line;
            while ((line = r.readLine()) != null) {
                list.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(new Error());
        }
        finally {
            Files.close((Reader)reader);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String data, String encoding) throws IOException {
        FileOutputStream output = null;
        try {
            output = FileUtils.openOutputStream(file);
            FileUtils.write(data, output, encoding);
        }
        finally {
            Files.close((OutputStream)output);
        }
    }

    private static FileOutputStream openOutputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                throw new IOException("File '" + file + "' could not be created");
            }
        }
        return new FileOutputStream(file);
    }

    private static void write(String data, OutputStream output, String encoding) throws IOException {
        if (data != null) {
            if (encoding == null) {
                FileUtils.write(data, output);
            } else {
                output.write(data.getBytes(encoding));
            }
        }
    }

    private static void write(String data, OutputStream output) throws IOException {
        if (data != null) {
            output.write(data.getBytes());
        }
    }
}

