/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.canvas;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.ParsingException;
import org.apache.commons.lang3.Validate;
import org.web4thejob.studio.support.ChildDelegate;
import org.web4thejob.studio.support.CodeFormatter;
import org.web4thejob.studio.support.CookieUtil;
import org.web4thejob.studio.support.FileUtils;
import org.web4thejob.studio.support.StudioUtil;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuService;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlNativeComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.sys.DesktopCtrl;
import org.zkoss.zk.ui.util.Clients;

public class CanvasAuService
implements AuService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onCanvasReady(AuRequest request) {
        Desktop canvasDesktop = Executions.getCurrent().getDesktop();
        String prodFile = canvasDesktop.getWebApp().getRealPath(canvasDesktop.getRequestPath());
        String queryString = Executions.getCurrent().getDesktop().getQueryString();
        String message = CanvasAuService.getQueryParam(queryString, "w4tjstudio_message");
        String hint = CanvasAuService.getQueryParam(queryString, "w4tjstudio_hint");
        String workFile = CanvasAuService.getQueryParam(queryString, "w4tjstudio_workfile");
        String xpath = CanvasAuService.getQueryParam(queryString, "w4tjstudio_xpath");
        HashMap<String, String> data = new HashMap<String, String>();
        if (prodFile != null) {
            data.put("w4tjstudio_prodfile", prodFile);
        }
        if (message != null) {
            data.put("w4tjstudio_message", message);
        }
        if (hint != null) {
            data.put("w4tjstudio_hint", hint);
        }
        if (workFile != null) {
            data.put("w4tjstudio_workfile", workFile);
        }
        if (xpath != null) {
            data.put("w4tjstudio_xpath", xpath);
        }
        String result = "onCanvasSucceeded";
        try {
            Throwable e = CanvasAuService.getExceptionIfAny();
            if (e == null) {
                Document document = CanvasAuService.mapZulToComponents(workFile != null ? workFile : prodFile);
                if (workFile != null) {
                    FileUtils.writeStringToFile(new File(workFile), CodeFormatter.formatXML(document), "UTF-8");
                    StudioUtil.cleanUUIDs(document.getRootElement());
                    File fileProd = new File(prodFile);
                    if (fileProd.exists() && fileProd.canWrite()) {
                        File fileSourceWebapp;
                        String xml = CodeFormatter.formatXML(document);
                        FileUtils.writeStringToFile(fileProd, xml, "UTF-8");
                        String targetWebapp = canvasDesktop.getWebApp().getRealPath("/");
                        String sourceWebapp = CookieUtil.getCookie((HttpServletRequest)Executions.getCurrent().getNativeRequest(), CookieUtil.comformCookieName(targetWebapp));
                        if (sourceWebapp != null && (fileSourceWebapp = new File(sourceWebapp)).exists() && fileSourceWebapp.isDirectory() && fileSourceWebapp.canWrite()) {
                            File fileProd2 = new File(sourceWebapp + fileProd.getAbsolutePath().substring(targetWebapp.length()));
                            FileUtils.writeStringToFile(fileProd2, xml, "UTF-8");
                        }
                    }
                } else {
                    workFile = StudioUtil.buildWorkingFile(document).getAbsolutePath();
                    data.put("w4tjstudio_workfile", workFile);
                }
            } else {
                result = "onCanvasFailed";
                data.put("exception", e.getMessage() != null ? e.getMessage() : e.toString());
            }
        }
        catch (Exception e) {
            result = "onCanvasFailed";
            data.put("exception", e.getMessage() != null ? e.getMessage() : e.toString());
            e.printStackTrace();
        }
        finally {
            StudioUtil.sendToDesigner(result, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onTemplateDropped(AuRequest event) {
        String template = (String)event.getData().get("template");
        Validate.notNull((Object)template);
        String parentUuid = (String)event.getData().get("parent");
        Validate.notNull((Object)parentUuid);
        if (template.startsWith("@")) {
            Component target = StudioUtil.getComponentByUuid(parentUuid);
            String property = StudioUtil.getDefaultBindingProperty(target.getDefinition());
            if (property != null) {
                HashMap<String, String> data = new HashMap<String, String>();
                data.put("target", parentUuid);
                data.put("binding", template);
                data.put("property", property);
                StudioUtil.sendToDesigner("onBindingDropped", data);
            } else {
                StudioUtil.showNotification("warning", "Not quite", "This component does not declare a default binding property.</br>Drop the binding on a Property Editor row directly to resolve.", true, true);
            }
            return;
        }
        if (Executions.getCurrent().getDesktop().getPageIfAny(parentUuid) != null) {
            parentUuid = "_canvas_";
        }
        String templatePath = "~./template/" + template;
        try {
            Component parent = !"_canvas_".equals(parentUuid) ? StudioUtil.getComponentByUuid(parentUuid) : null;
            HashMap<String, Component> args = new HashMap<String, Component>();
            args.put("parent", parent);
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("parent", parentUuid);
            data.put("template", templatePath);
            if (!"zscript.zul".equals(template)) {
                Component target = Executions.getCurrent().createComponents(templatePath, parent, args);
                if (target != null) {
                    data.put("target", target.getUuid());
                } else {
                    return;
                }
            }
            StudioUtil.sendToDesigner("onCanvasAddition", data);
        }
        catch (Exception e) {
            e.printStackTrace();
            Clients.evalJavaScript((String)"top.zAu.cmd0.clearBusy()");
            StudioUtil.showError(e, true);
        }
        finally {
            Clients.clearBusy();
        }
    }

    private static Document mapZulToComponents(String src) throws IOException, ParsingException {
        final Desktop canvas = Executions.getCurrent().getDesktop();
        Document document = StudioUtil.buildDocument(new FileInputStream(src));
        if (document.getRootElement() == null) {
            return document;
        }
        StudioUtil.cleanUUIDs(document.getRootElement());
        HashMap<String, Object> params = new HashMap<String, Object>();
        StudioUtil.traverseChildren(document.getRootElement(), params, new ChildDelegate<Element>(){

            @Override
            public void onChild(Element child, Map<String, Object> params) {
                block8: {
                    Element parent;
                    block9: {
                        if (child.getParent() instanceof Document && "zk".equals(child.getLocalName())) {
                            child.addAttribute(new Attribute("uuid", "_canvas_"));
                        }
                        if ("zk".equals(child.getLocalName())) {
                            return;
                        }
                        if ("zscript".equals(child.getLocalName())) {
                            child.addAttribute(new Attribute("uuid", "zscript_" + CanvasAuService.getNextUuid()));
                            return;
                        }
                        if (StudioUtil.isNative(child) && StudioUtil.isNative((Element)child.getParent()) && (!CanvasAuService.hasNonNativeSiblings(child) || child.getChildElements().size() == 0)) {
                            child.addAttribute(new Attribute("uuid", "native_" + CanvasAuService.getNextUuid()));
                            return;
                        }
                        parent = CanvasAuService.getParent(child);
                        if (parent != null) break block9;
                        for (Component root : canvas.getFirstPage().getRoots()) {
                            if (!CanvasAuService.doMatch(child, root)) continue;
                            child.addAttribute(new Attribute("uuid", root.getUuid()));
                            break block8;
                        }
                        break block8;
                    }
                    String uuid = parent.getAttributeValue("uuid");
                    if (uuid == null) break block8;
                    if (uuid.startsWith("native_")) {
                        parent = (Element)parent.getParent();
                        while (parent.getAttributeValue("uuid").startsWith("native_")) {
                            parent = (Element)parent.getParent();
                        }
                        uuid = parent.getAttributeValue("uuid");
                    }
                    List children = StudioUtil.getComponentByUuid(uuid).getChildren();
                    for (Component comp : children) {
                        if (!CanvasAuService.doMatch(child, comp)) continue;
                        child.addAttribute(new Attribute("uuid", comp.getUuid()));
                        break;
                    }
                }
            }
        });
        return document;
    }

    private static boolean hasNonNativeSiblings(Element element) {
        ParentNode parent = element.getParent();
        if (!(parent instanceof Element)) {
            return false;
        }
        for (int i = 0; i < ((Element)parent).getChildElements().size(); ++i) {
            Element child = ((Element)parent).getChildElements().get(i);
            if (child.equals((Object)element) || StudioUtil.isNative(child)) continue;
            return true;
        }
        return false;
    }

    private static Element getParent(Element element) {
        ParentNode parent;
        for (parent = element.getParent(); parent != null && (!(parent instanceof Element) || "zk".equals(((Element)parent).getLocalName())); parent = parent.getParent()) {
        }
        return parent instanceof Element ? (Element)parent : null;
    }

    private static boolean doMatch(Element element, Component component) {
        boolean match = CanvasAuService.isAvailable(element.getDocument().getRootElement(), component.getUuid());
        if (!match) {
            return false;
        }
        if (component instanceof HtmlNativeComponent) {
            return element.getLocalName().equals(((HtmlNativeComponent)component).getTag()) && StudioUtil.isNative(element);
        }
        return element.getLocalName().equals(component.getDefinition().getName());
    }

    private static boolean isAvailable(Element root, String uuid) {
        Nodes nodes = root.query("//*[@uuid='" + uuid + "']", null);
        return nodes.size() == 0;
    }

    private static String getQueryParam(String queryString, String param) {
        if (queryString == null) {
            return null;
        }
        for (String s : queryString.split("&")) {
            if (!s.startsWith(param + "=")) continue;
            String v = s.substring(s.indexOf("=") + 1);
            if (v.length() > 0) {
                try {
                    v = URLDecoder.decode(v, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                return v;
            }
            return v;
        }
        return null;
    }

    private static Throwable getExceptionIfAny() {
        Throwable e = null;
        for (Page page : Executions.getCurrent().getDesktop().getPages()) {
            if (!page.hasAttribute("javax.servlet.error.exception")) continue;
            e = (Throwable)page.getAttribute("javax.servlet.error.exception");
            break;
        }
        return e;
    }

    private static String getNextUuid() {
        return ((DesktopCtrl)Executions.getCurrent().getDesktop()).getNextUuid(Executions.getCurrent().getDesktop().getFirstPage());
    }

    public boolean service(AuRequest request, boolean everError) {
        String cmd;
        switch (cmd = request.getCommand()) {
            case "onCanvasReady": {
                CanvasAuService.onCanvasReady(request);
                return true;
            }
            case "onTemplateDropped": {
                CanvasAuService.onTemplateDropped(request);
            }
        }
        return false;
    }
}

