/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.controller.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import nu.xom.Attribute;
import nu.xom.Nodes;
import nu.xom.XPathContext;
import org.apache.commons.lang3.Validate;
import org.web4thejob.studio.controller.AbstractController;
import org.web4thejob.studio.controller.ControllerEnum;
import org.web4thejob.studio.dom.Element;
import org.web4thejob.studio.message.Message;
import org.web4thejob.studio.message.MessageEnum;
import org.web4thejob.studio.support.ChildDelegate;
import org.web4thejob.studio.support.StudioUtil;
import org.web4thejob.studio.support.ZulXsdUtil;
import org.zkoss.lang.Generics;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.event.MouseEvent;
import org.zkoss.zk.ui.metainfo.ComponentDefinition;
import org.zkoss.zk.ui.metainfo.LanguageDefinition;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Button;
import org.zkoss.zul.Caption;
import org.zkoss.zul.Column;
import org.zkoss.zul.Columns;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Grid;
import org.zkoss.zul.Groupbox;
import org.zkoss.zul.Html;
import org.zkoss.zul.Include;
import org.zkoss.zul.Label;
import org.zkoss.zul.Row;
import org.zkoss.zul.Rows;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Tabpanel;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.impl.InputElement;

public class PropertyEditorController
extends AbstractController {
    private static final OnOKHandler OK_HANDLER = new OnOKHandler();
    private static final OnCodeEditorHandler CODE_EDITOR_HANDLER = new OnCodeEditorHandler();
    private final SaveProperties SAVE_CHANGES_HANDLER = new SaveProperties();
    @Wire
    private Tabpanel properties;
    @Wire
    private Tabpanel events;
    @Wire
    private Tabpanel source;
    @Wire
    private Html editorSelection;
    private nu.xom.Element selection;

    private static boolean isEvent(String name) {
        return name.startsWith("on") && name.length() > 2 && name.codePointAt(2) >= "A".codePointAt(0);
    }

    @Override
    public ControllerEnum getId() {
        return ControllerEnum.PROPERTY_EDITOR_CONTROLLER;
    }

    public nu.xom.Element getSelection() {
        return this.selection;
    }

    @Override
    public void process(Message message) {
        switch (message.getId()) {
            case COMPONENT_SELECTED: {
                nu.xom.Element element = (nu.xom.Element)message.getData();
                if (element != null) {
                    this.selection = element;
                    try {
                        this.refresh();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    this.clear();
                }
                Clients.evalJavaScript((String)"zAu.cmd0.clearBusy(zk('$propertyeditor').$())");
                break;
            }
            case RESET: {
                this.clear();
                break;
            }
            case XML_EVAL_FAILED: {
                this.clear();
                break;
            }
            case ZUL_EVAL_FAILED: {
                this.clear();
                break;
            }
            case ZUL_EVAL_SUCCEEDED: {
                if (this.selection == null) break;
                String xpath = ZulXsdUtil.getXPath(this.selection);
                Nodes nodes = StudioUtil.getCode().query(xpath, XPathContext.makeNamespaceContext((nu.xom.Element)this.selection));
                if (nodes.size() != 1 || !this.selection.getQualifiedName().equals(((nu.xom.Element)nodes.get(0)).getQualifiedName())) break;
                this.publish(MessageEnum.COMPONENT_SELECTED, nodes.get(0));
            }
        }
    }

    public void clear() {
        this.editorSelection.setContent(null);
        this.properties.getChildren().clear();
        this.properties.getLinkedTab().setVisible(true);
        this.properties.getLinkedTab().setSelected(true);
        this.events.getChildren().clear();
        this.events.getLinkedTab().setVisible(true);
        this.source.getChildren().clear();
        this.source.getLinkedTab().setVisible(false);
        this.properties.setAttribute("prevSelection", null);
        new Include("~./include/nocurrentselection.zul").setParent((Component)this.properties);
        new Include("~./include/nocurrentselection.zul").setParent((Component)this.events);
    }

    public void refresh() throws Exception {
        this.events.getChildren().clear();
        this.source.getChildren().clear();
        nu.xom.Element prevSelection = (nu.xom.Element)this.properties.getAttribute("prevSelection");
        this.properties.setAttribute("prevSelection", (Object)this.selection);
        if (this.selection == null || prevSelection == null) {
            this.properties.getChildren().clear();
            this.editorSelection.setContent(null);
            if (this.selection == null) {
                return;
            }
        }
        if (prevSelection != null && !prevSelection.getLocalName().equals(this.selection.getLocalName())) {
            this.properties.getChildren().clear();
        }
        this.editorSelection.setContent(StudioUtil.describeElement(this.selection));
        if ("attribute".equals(this.selection.getLocalName())) {
            this.properties.getLinkedTab().setVisible(false);
            this.events.getLinkedTab().setVisible(false);
            this.source.getLinkedTab().setVisible(true);
            this.source.getLinkedTab().setSelected(true);
            if ("attribute".equals(this.selection.getLocalName())) {
                boolean isServerSide = true;
                Attribute name = this.selection.getAttribute("name");
                if (name == null) {
                    String clientNS = StudioUtil.getClientNamespace((Element)this.selection);
                    name = this.selection.getAttribute("name", clientNS);
                    isServerSide = false;
                }
                this.source.getLinkedTab().setLabel(isServerSide ? "Java" : "Javascript");
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("element", this.selection.getParent());
                data.put("size", "xs");
                data.put("mode", isServerSide ? "text/x-java" : "javascript");
                data.put("event", name.getValue());
                Executions.getCurrent().createComponents("~./include/codemirror.zul", (Component)this.source, data);
            }
        } else if ("zscript".equals(this.selection.getLocalName())) {
            this.properties.getLinkedTab().setVisible(false);
            this.events.getLinkedTab().setVisible(false);
            this.source.getLinkedTab().setVisible(true);
            this.source.getLinkedTab().setSelected(true);
            this.source.getLinkedTab().setLabel("Java");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("element", this.selection);
            data.put("size", "xs");
            data.put("mode", "text/x-java");
            Executions.getCurrent().createComponents("~./include/codemirror.zul", (Component)this.source, data);
        } else if (!ZulXsdUtil.isBaseGroupElement(this.selection) && !StudioUtil.isNative(this.selection)) {
            this.properties.getLinkedTab().setVisible(true);
            this.events.getLinkedTab().setVisible(true);
            this.source.getLinkedTab().setVisible(false);
            Tab tab = this.properties.getTabbox().getSelectedTab();
            this.refreshComponent();
            String tag = this.selection.getLocalName();
            if (tag.equals("style") || tag.equals("script") || tag.equals("html")) {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("element", this.selection);
                data.put("size", "xs");
                this.source.getLinkedTab().setVisible(true);
                switch (this.selection.getLocalName()) {
                    case "style": {
                        data.put("mode", "css");
                        this.source.getLinkedTab().setLabel("CSS");
                        break;
                    }
                    case "script": {
                        data.put("mode", "javascript");
                        this.source.getLinkedTab().setLabel("Javascript");
                        break;
                    }
                    case "html": {
                        data.put("mode", "text/html");
                        this.source.getLinkedTab().setLabel("HTML");
                    }
                }
                Executions.getCurrent().createComponents("~./include/codemirror.zul", (Component)this.source, data);
            }
            if (tab == null || tab.isSelected() && !tab.isVisible()) {
                this.properties.getLinkedTab().setSelected(true);
            }
        } else {
            this.clear();
            this.editorSelection.setContent(StudioUtil.describeElement(this.selection));
        }
    }

    private void refreshComponent() {
        SortedMap<String, SortedSet<nu.xom.Element>> propsMap = ZulXsdUtil.getWidgetDescription(this.selection.getLocalName());
        this.refreshComponentProperties(propsMap);
        this.refreshComponentEvents(propsMap);
    }

    private void refreshComponentEvents(SortedMap<String, SortedSet<nu.xom.Element>> propsMap) {
        Grid grid = new Grid();
        grid.setParent((Component)this.events);
        grid.setVflex("true");
        grid.setSpan(true);
        new Columns().setParent((Component)grid);
        grid.getColumns().setSizable(true);
        new Column("Name").setParent((Component)grid.getColumns());
        Column colServer = new Column("Server");
        colServer.setParent((Component)grid.getColumns());
        colServer.setAlign("center");
        colServer.setWidth("60px");
        Column colClient = new Column("Client");
        colClient.setParent((Component)grid.getColumns());
        colClient.setAlign("center");
        colClient.setWidth("60px");
        new Rows().setParent((Component)grid);
        for (String group : propsMap.keySet()) {
            for (nu.xom.Element property : (SortedSet)propsMap.get(group)) {
                String propertyName = property.getAttributeValue("name");
                if (!PropertyEditorController.isEvent(propertyName)) continue;
                Row row = new Row();
                row.setParent((Component)grid.getRows());
                Label name = new Label(propertyName);
                name.setParent((Component)row);
                Button btn = new Button();
                btn.setParent((Component)row);
                btn.setIconSclass("z-icon-bolt");
                btn.setAttribute("mode", (Object)"text/x-java");
                btn.setAttribute("event", (Object)propertyName);
                btn.setAttribute("element", (Object)this.selection);
                btn.addEventListener("onClick", (EventListener)CODE_EDITOR_HANDLER);
                if (StudioUtil.getEventCodeNode(this.selection, propertyName, true) != null) {
                    btn.setZclass("btn btn-xs btn-primary");
                } else {
                    btn.setZclass("btn btn-xs btn-default");
                }
                btn.setWidth("32px");
                btn.setHeight("25px");
                btn = new Button();
                btn.setParent((Component)row);
                btn.setIconSclass("z-icon-bolt");
                btn.setAttribute("mode", (Object)"javascript");
                btn.setAttribute("event", (Object)propertyName);
                btn.setAttribute("element", (Object)this.selection);
                btn.addEventListener("onClick", (EventListener)CODE_EDITOR_HANDLER);
                if (StudioUtil.getEventCodeNode(this.selection, propertyName, false) != null) {
                    btn.setZclass("btn btn-xs btn-primary");
                } else {
                    btn.setZclass("btn btn-xs btn-default");
                }
                btn.setWidth("32px");
                btn.setHeight("25px");
            }
        }
    }

    private Groupbox buildGroupbox(String group) {
        Groupbox groupbox = new Groupbox();
        groupbox.setAttribute("group", (Object)group);
        groupbox.setOpen(this.selection.getLocalName().equals(group));
        groupbox.setMold("3d");
        String groupName = group.replaceAll("AttrGroup", "");
        groupName = groupName.replaceAll("Component", "");
        Caption caption = new Caption(groupName);
        caption.setParent((Component)groupbox);
        Grid grid = new Grid();
        grid.setParent((Component)groupbox);
        grid.setSpan(true);
        new Columns().setParent((Component)grid);
        new Column().setParent((Component)grid.getColumns());
        new Column().setParent((Component)grid.getColumns());
        new Rows().setParent((Component)grid);
        ((Column)grid.getColumns().getFirstChild()).setWidth("160px");
        return groupbox;
    }

    private Groupbox findGroup(String group) {
        for (Component comp : this.properties.getChildren()) {
            if (!group.equals(comp.getAttribute("group"))) continue;
            return (Groupbox)comp;
        }
        return null;
    }

    private void refreshComponentProperties(SortedMap<String, SortedSet<nu.xom.Element>> propsMap) {
        Groupbox groupbox;
        ComponentDefinition componentDefinition = StudioUtil.getDefinitionByTag(this.selection.getLocalName());
        Class clazz = (Class)Generics.cast((Object)componentDefinition.getImplementationClass());
        ArrayList<Row> bindings = new ArrayList<Row>(1);
        for (String group : propsMap.keySet()) {
            Groupbox groupbox2 = this.findGroup(group);
            if (groupbox2 == null) {
                groupbox2 = this.buildGroupbox(group);
            }
            Grid grid = (Grid)groupbox2.getLastChild();
            int num = 0;
            for (nu.xom.Element property : (SortedSet)propsMap.get(group)) {
                String s;
                Row row;
                InputElement editor;
                String propertyName = property.getAttributeValue("name");
                String type = property.getAttributeValue("type");
                boolean isBoolean = "booleanType".equals(type);
                if (PropertyEditorController.isEvent(propertyName)) continue;
                String val = null;
                Attribute attribute = this.selection.getAttribute(propertyName);
                if (attribute != null) {
                    val = attribute.getValue();
                }
                if ((editor = this.findEditor(this.selection, propertyName)) == null) {
                    row = new Row();
                    row.setAttribute("property", (Object)propertyName);
                    row.setWidgetAttribute("w4tjstudio-property", propertyName);
                    row.setParent((Component)grid.getRows());
                    Label name = new Label(propertyName);
                    name.setParent((Component)row);
                    name.setValue(propertyName);
                    editor = this.createEditor(componentDefinition, property, val);
                    editor.setAttribute("property", (Object)propertyName);
                    editor.setAttribute("element", (Object)this.selection);
                    editor.addEventListener("onOK", (EventListener)OK_HANDLER);
                    editor.setParent((Component)row);
                } else {
                    editor.setAttribute("element", (Object)this.selection);
                    editor.setRawValue((Object)val);
                    row = (Row)editor.getParent();
                }
                if (val instanceof String && ((s = val).contains("@bind(") || s.contains("@load(") || s.contains("@save("))) {
                    Row brow = (Row)row.clone();
                    ((Label)brow.getFirstChild()).setSclass("label label-primary");
                    String bval = ((InputElement)brow.getLastChild()).getRawValue().toString();
                    brow.getLastChild().detach();
                    new Html("<span class=\"label label-success z-label\">" + bval + "</span>").setParent((Component)brow);
                    bindings.add(brow);
                }
                ++num;
            }
            if (num <= 0) continue;
            groupbox2.setParent((Component)this.properties);
        }
        if (!bindings.isEmpty()) {
            groupbox = this.findGroup("bindings");
            if (groupbox == null) {
                groupbox = this.buildGroupbox("bindings");
                this.properties.insertBefore((Component)groupbox, this.properties.getFirstChild());
                groupbox.setOpen(true);
            }
            Grid grid = (Grid)groupbox.getLastChild();
            grid.getRows().getChildren().clear();
            for (Row row : bindings) {
                row.setParent((Component)grid.getRows());
            }
        } else {
            groupbox = this.findGroup("bindings");
            if (groupbox != null) {
                groupbox.detach();
            }
        }
        Clients.evalJavaScript((String)"w4tjStudioDesigner.decoratePropertyCaptions();");
    }

    private InputElement createEditor(ComponentDefinition definition, nu.xom.Element element, Object value) {
        if ("mold".equals(element.getAttributeValue("name"))) {
            Combobox combobox = new Combobox();
            combobox.setHflex("true");
            combobox.addEventListener("onChange", (EventListener)this.SAVE_CHANGES_HANDLER);
            for (String moldName : definition.getMoldNames()) {
                if ("w4tjstudio".equals(moldName)) continue;
                Comboitem comboitem = new Comboitem(moldName);
                comboitem.setParent((Component)combobox);
                if (!moldName.equals(value)) continue;
                combobox.setSelectedItem(comboitem);
            }
            return combobox;
        }
        String type = element.getAttributeValue("type");
        List<String> restrictions = ZulXsdUtil.getConstraintForAttributeType(type);
        if (!restrictions.isEmpty()) {
            Combobox combobox = new Combobox();
            combobox.setHflex("true");
            combobox.addEventListener("onChange", (EventListener)this.SAVE_CHANGES_HANDLER);
            for (String enumeration : restrictions) {
                Comboitem comboitem = new Comboitem(enumeration);
                comboitem.setParent((Component)combobox);
                if (!enumeration.equals(value)) continue;
                combobox.setSelectedItem(comboitem);
            }
            if (combobox.getSelectedItem() == null) {
                combobox.setValue((String)value);
            }
            return combobox;
        }
        Textbox textbox = new Textbox();
        textbox.setValue(value != null ? value.toString() : "");
        textbox.setHflex("true");
        textbox.addEventListener("onChange", (EventListener)this.SAVE_CHANGES_HANDLER);
        return textbox;
    }

    public void SaveChanges(nu.xom.Element element, String propertyName, String value, String oldValue) {
        InputElement editor = this.findEditor(element, propertyName);
        Events.sendEvent((Event)new InputEvent("onChange", (Component)editor, value, (Object)oldValue));
        editor.setRawValue((Object)value);
    }

    private InputElement findEditor(final nu.xom.Element element, final String propertyName) {
        final InputElement[] editor = new InputElement[]{null};
        StudioUtil.traverseChildren((Component)this.properties, null, new ChildDelegate<Component>(){

            @Override
            public void onChild(Component child, Map<String, Object> params) {
                if (editor[0] != null) {
                    return;
                }
                nu.xom.Element attached = (nu.xom.Element)child.getAttribute("element");
                if (attached != null && element.getLocalName().equals(attached.getLocalName()) && propertyName.equals(child.getAttribute("property"))) {
                    editor[0] = (InputElement)child;
                }
            }
        });
        return editor[0];
    }

    private class SaveProperties
    implements EventListener<InputEvent> {
        private SaveProperties() {
        }

        public void onEvent(InputEvent event) throws Exception {
            Attribute attribute;
            nu.xom.Element selected = (nu.xom.Element)event.getTarget().getAttribute("element");
            String propertyName = event.getTarget().getAttribute("property").toString();
            String uuid = selected.getAttributeValue("uuid");
            Validate.notNull((Object)uuid);
            String value = event.getValue();
            value = value != null ? value.trim() : "";
            boolean isBoolean = "booleanType".equals(ZulXsdUtil.getTypeOfAttribute(selected.getLocalName(), propertyName));
            boolean isDefaultValue = false;
            LanguageDefinition languageDefinition = LanguageDefinition.getByExtension((String)"zul");
            ComponentDefinition componentDefinition = languageDefinition.getComponentDefinitionIfAny(selected.getLocalName());
            if (componentDefinition != null) {
                Component component = componentDefinition.newInstance(null, null);
                boolean bl = isDefaultValue = component != null && StudioUtil.isDefaultValueForProperty(component, propertyName, value, isBoolean);
            }
            if ((attribute = selected.getAttribute(propertyName)) == null && value.length() > 0) {
                selected.addAttribute(new Attribute(propertyName, value));
            } else if (attribute != null && (value.length() == 0 || isDefaultValue)) {
                selected.removeAttribute(attribute);
            } else if (attribute != null && value.length() > 0) {
                if (value.equals(attribute.getValue())) {
                    return;
                }
                if (!isDefaultValue) {
                    attribute.setValue(value);
                } else {
                    selected.removeAttribute(attribute);
                }
            }
            Clients.evalJavaScript((String)("w4tjStudioDesigner.highlight('" + event.getTarget().getParent().getUuid() + "');"));
            PropertyEditorController.this.publish(MessageEnum.ATTRIBUTE_CHANGED);
        }
    }

    private static class OnCodeEditorHandler
    implements EventListener<MouseEvent> {
        private OnCodeEditorHandler() {
        }

        public void onEvent(MouseEvent event) throws Exception {
            HashMap<String, Object> args = new HashMap<String, Object>();
            args.put("mode", event.getTarget().getAttribute("mode"));
            args.put("element", event.getTarget().getAttribute("element"));
            args.put("event", event.getTarget().getAttribute("event"));
            Executions.createComponents((String)"~./include/codedialog.zul", null, args);
        }
    }

    private static class OnOKHandler
    implements EventListener<KeyEvent> {
        private OnOKHandler() {
        }

        public void onEvent(KeyEvent event) throws Exception {
        }
    }
}

