/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.support;

import java.security.MessageDigest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.web4thejob.studio.support.Base32;

public abstract class CookieUtil {
    private static Cookie newCookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(31104000);
        return cookie;
    }

    public static void setCookie(HttpServletResponse response, String name, String value) {
        Cookie cookie = CookieUtil.newCookie(name, value);
        response.addCookie(cookie);
    }

    public static void deleteCookie(HttpServletResponse response, String name) {
        Cookie cookie = CookieUtil.newCookie(name, "");
        cookie.setMaxAge(0);
        response.addCookie(cookie);
    }

    public static String getCookie(HttpServletRequest request, String name) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static String comformCookieName(String value) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(value.getBytes("UTF-8"));
            return Base32.encode(hash).toLowerCase();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

