/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.support;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Serializer;
import nu.xom.Text;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.web4thejob.studio.support.CodeFormatter;
import org.web4thejob.studio.support.StudioUtil;

public class MultiplexSerializer
extends Serializer {
    private static Field escaper;
    private Method incrementIndent;
    private Method decrementIndent;
    private Method setPreserveSpace;

    public MultiplexSerializer(OutputStream out) {
        super(out);
        try {
            Object o = escaper.get((Object)this);
            this.incrementIndent = StudioUtil.findMethod(o.getClass(), "incrementIndent", new Class[0]);
            Validate.notNull((Object)this.incrementIndent);
            this.incrementIndent.setAccessible(true);
            this.decrementIndent = StudioUtil.findMethod(o.getClass(), "decrementIndent", new Class[0]);
            Validate.notNull((Object)this.decrementIndent);
            this.decrementIndent.setAccessible(true);
            this.setPreserveSpace = StudioUtil.findMethod(o.getClass(), "setPreserveSpace", Boolean.TYPE);
            Validate.notNull((Object)this.setPreserveSpace);
            this.setPreserveSpace.setAccessible(true);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    protected void write(Element element) throws IOException {
        if (StudioUtil.isCodeElement(element)) {
            if (element.getAttribute("src") != null) {
                super.write(element);
                return;
            }
            boolean needsCDATA = !"style".equals(element.getLocalName());
            this.writeStartTag(element);
            if (needsCDATA) {
                this.breakLine();
                this.writeRaw("<![CDATA[");
                this.incrementIndent();
            }
            this.preserveWhiteSpace(true);
            for (int i = 0; i < element.getChildCount(); ++i) {
                String source;
                block13: {
                    if (!(element.getChild(i) instanceof Text)) {
                        this.writeChild(element.getChild(i));
                        continue;
                    }
                    Text text = (Text)element.getChild(i);
                    try {
                        String tag = element.getLocalName();
                        if (tag.equals("attribute") || tag.equals("script") || tag.equals("zscript")) {
                            source = CodeFormatter.formatJS(text.getValue());
                            break block13;
                        }
                        if (tag.equals("style")) {
                            source = CodeFormatter.formatCSS(text.getValue());
                            break block13;
                        }
                        if (tag.equals("html")) {
                            source = CodeFormatter.formatHTML(text.getValue());
                            break block13;
                        }
                        throw new IllegalArgumentException(tag + " is not a recognized code block");
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                StringTokenizer tokenizer = new StringTokenizer(source, "\n", false);
                while (tokenizer.hasMoreTokens()) {
                    this.breakLine();
                    this.writeRaw(tokenizer.nextToken());
                }
            }
            this.preserveWhiteSpace(false);
            if (needsCDATA) {
                this.decrementIndent();
                this.breakLine();
                this.writeRaw("]]>");
            }
            element = (Element)element.copy();
            element.appendChild((Node)new Element("fake"));
            this.writeEndTag(element);
        } else {
            super.write(element);
        }
    }

    private void preserveWhiteSpace(boolean preserve) {
        try {
            this.setPreserveSpace.invoke(escaper.get((Object)this), preserve);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void decrementIndent() {
        try {
            this.decrementIndent.invoke(escaper.get((Object)this), new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void incrementIndent() {
        try {
            this.incrementIndent.invoke(escaper.get((Object)this), new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            escaper = FieldUtils.getField(Serializer.class, (String)"escaper", (boolean)true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

