/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.controller.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.UnsupportedEncodingException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.web4thejob.studio.controller.AbstractController;
import org.web4thejob.studio.controller.ControllerEnum;
import org.web4thejob.studio.support.CookieUtil;
import org.web4thejob.studio.support.StudioUtil;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.A;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Treerow;

public class DashboardController
extends AbstractController {
    private static OnlyDirs ONLY_DIRS = new OnlyDirs(true);
    private static OnlyDirs ONLY_FILES = new OnlyDirs(false);
    private static FileComparator FILE_SORTER = new FileComparator();
    private static onTreeitemOpen ON_OPEN_HANDLER = new onTreeitemOpen();
    @Wire
    private Tree projectTree;

    private static String buildPath(Component target) {
        String path = "";
        while (!target.hasAttribute("root")) {
            if (target instanceof Treeitem) {
                if (path.length() > 0) {
                    path = "/" + path;
                }
                path = target.getAttribute("filename") + path;
            }
            target = target.getParent();
        }
        return "/" + path;
    }

    @Override
    public ControllerEnum getId() {
        return ControllerEnum.DASHBOARD_CONTROLLER;
    }

    @Override
    protected void init() throws Exception {
        super.init();
        this.buildTree();
    }

    public void buildTree(String focusPath) {
        this.buildTree();
        if (focusPath == null) {
            return;
        }
        for (Treeitem item : this.projectTree.getItems()) {
            if (!focusPath.equals(item.getAttribute("fullpath"))) continue;
            item.setSelected(true);
            item.setOpen(true);
            Component parent = item.getParent();
            while (!parent.equals(this.projectTree)) {
                if (parent instanceof Treeitem) {
                    ((Treeitem)parent).setOpen(true);
                }
                parent = parent.getParent();
            }
            Clients.scrollIntoView((Component)item);
            return;
        }
    }

    public void buildTree() {
        this.projectTree.getTreechildren().getChildren().clear();
        File homeDir = new File(Executions.getCurrent().getDesktop().getWebApp().getRealPath("/"));
        Treeitem root = this.buildTreeitem(null, homeDir);
        root.setParent((Component)this.projectTree.getTreechildren());
        root.setAttribute("root", (Object)true);
        try {
            if (!homeDir.isDirectory()) {
                return;
            }
            for (File child : this.getContents(homeDir)) {
                this.traverseFiles(root, child);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            StudioUtil.showError(e);
        }
    }

    private void traverseFiles(Treeitem parent, File file) {
        Treeitem treeitem = this.buildTreeitem(parent, file);
        treeitem.setParent((Component)parent.getTreechildren());
        if (!file.isDirectory()) {
            return;
        }
        for (File child : this.getContents(file)) {
            this.traverseFiles(treeitem, child);
        }
    }

    private Treeitem buildTreeitem(Treeitem parent, File file) {
        Treeitem treeitem = new Treeitem();
        treeitem.setAttribute("filename", (Object)file.getName());
        treeitem.setAttribute("fullpath", (Object)file.getAbsolutePath());
        Treerow treerow = new Treerow();
        treerow.setParent((Component)treeitem);
        Treecell cellName = new Treecell(file.getName());
        cellName.setParent((Component)treerow);
        Treecell cellWritable = new Treecell();
        cellWritable.setIconSclass(file.canWrite() ? "z-icon-check" : "");
        cellWritable.setStyle("text-align: center;");
        cellWritable.setParent((Component)treerow);
        Treecell cellSize = new Treecell(file.isFile() ? NumberFormat.getInstance().format(file.length()) + " b" : "");
        cellSize.setStyle("text-align: right;");
        cellSize.setParent((Component)treerow);
        Treecell cellLastMod = new Treecell(new SimpleDateFormat("dd/MM/yyyy HH:mm").format(new Date(file.lastModified())));
        cellLastMod.setStyle("text-align: center;");
        cellLastMod.setParent((Component)treerow);
        if (parent != null) {
            if (parent.getTreechildren() == null) {
                new Treechildren().setParent((Component)parent);
            }
            treeitem.setParent((Component)parent.getTreechildren());
        }
        if (file.isDirectory()) {
            treeitem.setAttribute("dir", (Object)true);
            treeitem.addEventListener("onOpen", (EventListener)ON_OPEN_HANDLER);
            cellName.setIconSclass("z-icon-folder" + (parent == null ? "-open" : ""));
            treeitem.setOpen(parent == null);
        } else if (file.getName().endsWith(".zul")) {
            cellName.setLabel("");
            A link = new A(file.getName());
            link.setSclass("zulfile");
            link.setTarget("_blank");
            link.setParent((Component)cellName);
            link.setIconSclass("z-icon-file");
            try {
                link.setHref(Encodes.addToQueryString((StringBuffer)new StringBuffer("/w4tjstudio/designer"), (String)"z", (Object)DashboardController.buildPath((Component)link)).toString());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                StudioUtil.showError(e);
            }
        } else {
            cellName.setIconSclass("z-icon-file-o");
        }
        return treeitem;
    }

    private Collection<File> getContents(File parentDir) {
        ArrayList<File> contents = new ArrayList<File>();
        if (!parentDir.isDirectory()) {
            return contents;
        }
        ArrayList<File> dirs = new ArrayList<File>();
        for (File dir : parentDir.listFiles(ONLY_DIRS)) {
            dirs.add(dir);
        }
        Collections.sort(dirs, FILE_SORTER);
        ArrayList<File> files = new ArrayList<File>();
        for (File file : parentDir.listFiles(ONLY_FILES)) {
            files.add(file);
        }
        Collections.sort(files, FILE_SORTER);
        contents.addAll(dirs);
        contents.addAll(files);
        return contents;
    }

    @Listen(value="onProjectNavRefresh=#projectTree")
    public void onProjectNavRefresh() {
        Clients.clearBusy();
        StudioUtil.clearAlerts();
        String selpath = null;
        Treeitem selection = this.projectTree.getSelectedItem();
        if (selection != null) {
            selpath = (String)selection.getAttribute("fullpath");
        }
        this.buildTree(selpath);
    }

    @Listen(value="onProjectAddNew=#projectTree")
    public void onProjectAddNew() {
        Clients.clearBusy();
        StudioUtil.clearAlerts();
        Treeitem selection = this.projectTree.getSelectedItem();
        if (selection == null || !selection.hasAttribute("dir")) {
            StudioUtil.showError("You need to select a directory first.", true);
            return;
        }
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("location", selection.getAttribute("fullpath"));
        args.put("dashboardController", this);
        Executions.getCurrent().createComponents("~./include/newfiledialog.zul", null, args);
    }

    @Listen(value="onClick=#btnSourceLocChange")
    public void SourceLocationChangeClicked() {
        Executions.createComponents((String)"~./include/sourcewebappdialog.zul", null, null);
    }

    @Listen(value="onClick=#btnSourceLocDelete")
    public void SourceLocationDeleteClicked() {
        String name = CookieUtil.comformCookieName(Executions.getCurrent().getDesktop().getWebApp().getRealPath("/"));
        CookieUtil.deleteCookie((HttpServletResponse)Executions.getCurrent().getNativeResponse(), name);
        Executions.getCurrent().sendRedirect(null);
    }

    private static class onTreeitemOpen
    implements EventListener<OpenEvent> {
        private onTreeitemOpen() {
        }

        public void onEvent(OpenEvent event) throws Exception {
            ((Treecell)((Treeitem)event.getTarget()).getTreerow().getFirstChild()).setIconSclass("z-icon-folder" + (event.isOpen() ? "-open" : ""));
        }
    }

    private static class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(File o1, File o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static class OnlyDirs
    implements FileFilter {
        private boolean onlyDirs;

        public OnlyDirs(boolean onlyDirs) {
            this.onlyDirs = onlyDirs;
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() && this.onlyDirs || !f.isDirectory() && !this.onlyDirs;
        }
    }
}

