/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.controller.impl;

import java.util.Map;
import org.web4thejob.studio.support.JpaUtil;
import org.zkoss.lang.Generics;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.A;
import org.zkoss.zul.Button;
import org.zkoss.zul.Panel;
import org.zkoss.zul.Textbox;

public class JpaConnectionConfigController
extends SelectorComposer<Component> {
    @Wire
    private Panel jpaConnPanel;
    @Wire
    private Button btnCancel;
    @Wire
    private Textbox txtDriver;
    @Wire
    private Textbox txtUrl;
    @Wire
    private Textbox txtUser;
    @Wire
    private Textbox txtPassword;
    private String name;

    public void doAfterCompose(Component comp) throws Exception {
        super.doAfterCompose(comp);
        this.name = Executions.getCurrent().getArg().get("name").toString();
    }

    @Listen(value="onClick=#btnSave")
    public void onSaveClicked() throws Exception {
        A a = (A)this.jpaConnPanel.getAttribute("target");
        Map<String, String> properties = JpaUtil.getConnectionProperties(this.name);
        properties.clear();
        properties.put("name", this.name);
        if (this.txtDriver.getValue().trim().length() > 0) {
            properties.put("driver", this.txtDriver.getValue().trim());
        }
        if (this.txtUrl.getValue().trim().length() > 0) {
            properties.put("url", this.txtUrl.getValue().trim());
        }
        if (this.txtUser.getValue().trim().length() > 0) {
            properties.put("user", this.txtUser.getValue().trim());
        }
        if (this.txtPassword.getValue().trim().length() > 0) {
            properties.put("password", this.txtPassword.getValue().trim());
        }
        EventListener callback = (EventListener)Generics.cast((Object)this.jpaConnPanel.getAttribute("callback"));
        callback.onEvent(new Event("onConfigChanged", (Component)a));
    }
}

