/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.controller.impl;

import java.io.File;
import javax.servlet.http.HttpServletResponse;
import org.web4thejob.studio.support.CookieUtil;
import org.web4thejob.studio.support.StudioUtil;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Window;

public class SourceWebappController
extends SelectorComposer<Window> {
    @Wire
    private Window win;
    @Wire
    private Textbox txtPath;

    public void doAfterCompose(Window comp) throws Exception {
        super.doAfterCompose((Component)comp);
    }

    @Listen(value="onClick=#btnCancel;onCancel=#win")
    public void onCancel() {
        StudioUtil.clearAlerts();
        this.win.detach();
    }

    @Listen(value="onDoneClicked=#win")
    public void onDone(Event event) {
        StudioUtil.clearAlerts();
        String name = this.txtPath.getValue().trim();
        if (name.length() == 0) {
            return;
        }
        File path = new File(name);
        if (!path.exists() || !path.isDirectory()) {
            StudioUtil.showPopover(this.txtPath.getUuid(), "error", "<strong>This path does not exist.</strong> Please provide a valid path for your file system.", true);
            return;
        }
        String key = CookieUtil.comformCookieName(Executions.getCurrent().getDesktop().getWebApp().getRealPath("/"));
        CookieUtil.setCookie((HttpServletResponse)Executions.getCurrent().getNativeResponse(), key, path.getAbsolutePath());
        Executions.getCurrent().sendRedirect(null);
        this.win.detach();
    }
}

