/*
 * Decompiled with CFR 0.152.
 */
package org.web4thejob.studio.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import org.apache.commons.codec.Charsets;
import org.zkoss.io.Files;
import org.zkoss.util.resource.Locators;
import org.zkoss.web.servlet.Servlets;

@WebServlet(name="w4tjstudio", urlPatterns={"/w4tjstudio-support/img", "/w4tjstudio-support/designer/scripts", "/w4tjstudio-support/designer/styles", "/w4tjstudio-support/canvas/scripts", "/w4tjstudio-support/canvas/styles", "/w4tjstudio-support/fonts/*", "/w4tjstudio-support/designer/images/*"})
public class SupportServlet
extends HttpServlet {
    private static final String IMG_PATH_PREFFIX = "org/web4thejob/studio/support/img/";
    private static StringBuffer DESIGNER_SCRIPTS_CONTENT;
    private static StringBuffer DESIGNER_STYLES_CONTENT;
    private static StringBuffer CANVAS_SCRIPTS_CONTENT;
    private static StringBuffer CANVAS_STYLES_CONTENT;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (DESIGNER_SCRIPTS_CONTENT == null || DESIGNER_STYLES_CONTENT == null || CANVAS_SCRIPTS_CONTENT == null || CANVAS_STYLES_CONTENT == null) {
            response.sendError(500);
            return;
        }
        response.setHeader("Access-Control-Allow-Origin", "*");
        String path = request.getServletPath();
        if (path.equals("/w4tjstudio-support/img")) {
            String f = request.getParameter("f");
            if (f == null || f.trim().length() == 0) {
                response.sendError(404);
                return;
            }
            String fileName = IMG_PATH_PREFFIX + f.trim();
            InputStream img = Locators.getDefault().getResourceAsStream(fileName);
            if (img == null) {
                fileName = "org/web4thejob/studio/support/img/zk.png";
                img = Locators.getDefault().getResourceAsStream(fileName);
                if (img == null) {
                    response.sendError(404);
                    return;
                }
            }
            try (ServletOutputStream out = response.getOutputStream();){
                byte[] raw = Files.readAll((InputStream)img);
                img.close();
                String extension = Servlets.getExtension((String)fileName);
                response.setStatus(200);
                response.setContentType("image/" + extension);
                response.setContentLength(raw.length);
                out.write(raw);
            }
        }
        if (path.equals("/w4tjstudio-support/fonts")) {
            int dot = request.getRequestURI().lastIndexOf(".");
            String ext = request.getRequestURI().substring(dot);
            String font = "org/web4thejob/studio/support/js/font-awesome/fonts/fontawesome-webfont" + ext;
            try (ServletOutputStream outraw = response.getOutputStream();){
                InputStream is = Locators.getDefault().getResourceAsStream(font);
                byte[] raw = Files.readAll((InputStream)is);
                is.close();
                response.setStatus(200);
                response.setContentType("application/octet-stream");
                response.setContentLength(raw.length);
                outraw.write(raw);
            }
        }
        if (path.equals("/w4tjstudio-support/designer/images")) {
            String dir = "org/web4thejob/studio/support/js/jquery-ui/images/";
            int slash = request.getRequestURI().lastIndexOf("/");
            String file = request.getRequestURI().substring(slash + 1);
            int dot = file.lastIndexOf(".");
            String ext = file.substring(dot + 1);
            try (ServletOutputStream outraw = response.getOutputStream();){
                InputStream is = Locators.getDefault().getResourceAsStream(dir + file);
                byte[] raw = Files.readAll((InputStream)is);
                is.close();
                response.setStatus(200);
                response.setContentType("image/" + ext);
                response.setContentLength(raw.length);
                outraw.write(raw);
            }
        }
        try (PrintWriter out = response.getWriter();){
            if (path.equals("/w4tjstudio-support/designer/scripts")) {
                response.setStatus(200);
                response.setContentType("text/javascript; charset=utf-8");
                out.print(DESIGNER_SCRIPTS_CONTENT.toString());
            } else if (path.equals("/w4tjstudio-support/designer/styles")) {
                response.setStatus(200);
                response.setContentType("text/css; charset=utf-8");
                out.print(DESIGNER_STYLES_CONTENT.toString());
            } else if (path.equals("/w4tjstudio-support/canvas/scripts")) {
                response.setStatus(200);
                response.setContentType("text/javascript; charset=utf-8");
                out.print(CANVAS_SCRIPTS_CONTENT.toString());
            } else if (path.equals("/w4tjstudio-support/canvas/styles")) {
                response.setStatus(200);
                response.setContentType("text/css; charset=utf-8");
                out.print(CANVAS_STYLES_CONTENT.toString());
            } else {
                response.sendError(404);
            }
        }
        response.flushBuffer();
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    static {
        String CSS_PATH_PREFFIX = "org/web4thejob/studio/support/css/";
        String JS_PATH_PREFFIX = "org/web4thejob/studio/support/js/";
        Builder parser = new Builder(false);
        try {
            Node child;
            int i;
            InputStream is = Locators.getDefault().getResourceAsStream("org/web4thejob/studio/support/script.xml");
            Document scriptsDoc = parser.build(is);
            is.close();
            is = Locators.getDefault().getResourceAsStream("org/web4thejob/studio/support/stylesheet.xml");
            Document stylesheetsDoc = parser.build(is);
            is.close();
            DESIGNER_STYLES_CONTENT = new StringBuffer();
            for (i = 0; i < stylesheetsDoc.getRootElement().getChildCount(); ++i) {
                child = stylesheetsDoc.getRootElement().getChild(i);
                if (!(child instanceof Element) || !((Element)child).getLocalName().equals("stylesheet")) continue;
                is = Locators.getDefault().getResourceAsStream(JS_PATH_PREFFIX + ((Element)child).getAttributeValue("src"));
                DESIGNER_STYLES_CONTENT.append(new String(Files.readAll((InputStream)is), Charsets.UTF_8));
                is.close();
            }
            is = Locators.getDefault().getResourceAsStream(CSS_PATH_PREFFIX + "designer.css");
            DESIGNER_STYLES_CONTENT.append(new String(Files.readAll((InputStream)is), Charsets.UTF_8));
            is.close();
            DESIGNER_SCRIPTS_CONTENT = new StringBuffer();
            for (i = 0; i < scriptsDoc.getRootElement().getChildCount(); ++i) {
                child = scriptsDoc.getRootElement().getChild(i);
                if (!(child instanceof Element) || !((Element)child).getLocalName().equals("script")) continue;
                is = Locators.getDefault().getResourceAsStream(JS_PATH_PREFFIX + ((Element)child).getAttributeValue("src"));
                DESIGNER_SCRIPTS_CONTENT.append(new String(Files.readAll((InputStream)is), Charsets.UTF_8));
                is.close();
            }
            CANVAS_SCRIPTS_CONTENT = new StringBuffer();
            is = Locators.getDefault().getResourceAsStream(JS_PATH_PREFFIX + "canvas.js");
            CANVAS_SCRIPTS_CONTENT.append(new String(Files.readAll((InputStream)is), Charsets.UTF_8));
            is.close();
            CANVAS_STYLES_CONTENT = new StringBuffer();
            is = Locators.getDefault().getResourceAsStream(CSS_PATH_PREFFIX + "canvas.css");
            CANVAS_STYLES_CONTENT.append(new String(Files.readAll((InputStream)is), Charsets.UTF_8));
            is.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

