 /*
 * # Semantic UI
 * https://github.com/Semantic-Org/Semantic-UI
 * http://www.semantic-ui.com/
 *
 * Copyright 2014 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,t,n,i){"use strict";e.fn.accordion=function(n){{var o,a=e(this),r=(new Date).getTime(),s=[],c=arguments[0],l="string"==typeof c,u=[].slice.call(arguments,1);t.requestAnimationFrame||t.mozRequestAnimationFrame||t.webkitRequestAnimationFrame||t.msRequestAnimationFrame||function(e){setTimeout(e,0)}}return a.each(function(){var d,m,f=e.isPlainObject(n)?e.extend(!0,{},e.fn.accordion.settings,n):e.extend({},e.fn.accordion.settings),g=f.className,p=f.namespace,b=f.selector,v=(f.error,"."+p),h="module-"+p,y=a.selector||"",x=e(this),w=x.find(b.title),C=x.find(b.content),T=this,k=x.data(h);m={initialize:function(){m.debug("Initializing accordion with bound events",x),x.on("click"+v,b.title,m.event.click),m.observeChanges(),m.instantiate()},instantiate:function(){k=m,x.data(h,m)},destroy:function(){m.debug("Destroying previous accordion for",x),x.removeData(h),w.off(v)},refresh:function(){w=x.find(b.title),C=x.find(b.content)},observeChanges:function(){"MutationObserver"in t&&(d=new MutationObserver(function(){m.debug("DOM tree modified, updating selector cache"),m.refresh()}),d.observe(T,{childList:!0,subtree:!0}),m.debug("Setting up mutation observer",d))},event:{click:function(){e.proxy(m.toggle,this)()}},toggle:function(t){var n=t!==i?"number"==typeof t?w.eq(t):e(t):e(this),o=n.next(C),a=o.is(":visible");m.debug("Toggling visibility of content",n),a?f.collapsible?e.proxy(m.close,n)():m.debug("Cannot close accordion content collapsing is disabled"):e.proxy(m.open,n)()},open:function(t){var n=t!==i?"number"==typeof t?w.eq(t):e(t):e(this),o=n.next(C),a=o.is(":animated"),r=o.hasClass(g.active);a||r||(m.debug("Opening accordion content",n),f.exclusive&&e.proxy(m.closeOthers,n)(),n.addClass(g.active),o.stop().children().stop().animate({opacity:1},f.duration,m.reset.display).end().slideDown(f.duration,f.easing,function(){o.addClass(g.active),e.proxy(m.reset.display,this)(),e.proxy(f.onOpen,this)(),e.proxy(f.onChange,this)()}))},close:function(t){var n=t!==i?"number"==typeof t?w.eq(t):e(t):e(this),o=n.next(C),a=o.hasClass(g.active);a&&(m.debug("Closing accordion content",o),n.removeClass(g.active),o.removeClass(g.active).show().stop().children().stop().animate({opacity:0},f.duration,m.reset.opacity).end().slideUp(f.duration,f.easing,function(){e.proxy(m.reset.display,this)(),e.proxy(f.onClose,this)(),e.proxy(f.onChange,this)()}))},closeOthers:function(t){var n,o,a,r=t!==i?w.eq(t):e(this),s=r.parents(b.content).prev(b.title),c=r.closest(b.accordion),l=b.title+"."+g.active+":visible",u=b.content+"."+g.active+":visible";f.closeNested?(n=c.find(l).not(s),a=n.next(C)):(n=c.find(l).not(s),o=c.find(u).find(l).not(s),n=n.not(o),a=n.next(C)),n.size()>0&&(m.debug("Exclusive enabled, closing other content",n),n.removeClass(g.active),a.stop().children().stop().animate({opacity:0},f.duration,m.resetOpacity).end().slideUp(f.duration,f.easing,function(){e(this).removeClass(g.active),e.proxy(m.reset.display,this)()}))},reset:{display:function(){m.verbose("Removing inline display from element",this),e(this).css("display",""),""===e(this).attr("style")&&e(this).attr("style","").removeAttr("style")},opacity:function(){m.verbose("Removing inline opacity from element",this),e(this).css("opacity",""),""===e(this).attr("style")&&e(this).attr("style","").removeAttr("style")}},setting:function(t,n){if(m.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,f,t);else{if(n===i)return f[t];f[t]=n}},internal:function(t,n){return m.debug("Changing internal",t,n),n===i?m[t]:void(e.isPlainObject(t)?e.extend(!0,m,t):m[t]=n)},debug:function(){f.debug&&(f.performance?m.performance.log(arguments):(m.debug=Function.prototype.bind.call(console.info,console,f.name+":"),m.debug.apply(console,arguments)))},verbose:function(){f.verbose&&f.debug&&(f.performance?m.performance.log(arguments):(m.verbose=Function.prototype.bind.call(console.info,console,f.name+":"),m.verbose.apply(console,arguments)))},error:function(){m.error=Function.prototype.bind.call(console.error,console,f.name+":"),m.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;f.performance&&(t=(new Date).getTime(),i=r||t,n=t-i,r=t,s.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:T,"Execution Time":n})),clearTimeout(m.performance.timer),m.performance.timer=setTimeout(m.performance.display,100)},display:function(){var t=f.name+":",n=0;r=!1,clearTimeout(m.performance.timer),e.each(s,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",y&&(t+=" '"+y+"'"),(console.group!==i||console.table!==i)&&s.length>0&&(console.groupCollapsed(t),console.table?console.table(s):e.each(s,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),s=[]}},invoke:function(t,n,a){var r,s,c,l=k;return n=n||u,a=T||a,"string"==typeof t&&l!==i&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(n,o){var a=n!=r?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[a])&&n!=r)l=l[a];else{if(l[a]!==i)return s=l[a],!1;if(!e.isPlainObject(l[o])||n==r)return l[o]!==i?(s=l[o],!1):!1;l=l[o]}})),e.isFunction(s)?c=s.apply(a,n):s!==i&&(c=s),e.isArray(o)?o.push(c):o!==i?o=[o,c]:c!==i&&(o=c),s}},l?(k===i&&m.initialize(),m.invoke(c)):(k!==i&&m.destroy(),m.initialize())}),o!==i?o:this},e.fn.accordion.settings={name:"Accordion",namespace:"accordion",debug:!1,verbose:!0,performance:!0,exclusive:!0,collapsible:!0,closeNested:!1,duration:500,easing:"easeInOutQuint",onOpen:function(){},onClose:function(){},onChange:function(){},error:{method:"The method you called is not defined"},className:{active:"active"},selector:{accordion:".accordion",title:".title",content:".content"}},e.extend(e.easing,{easeInOutQuint:function(e,t,n,i,o){return(t/=o/2)<1?i/2*t*t*t*t*t+n:i/2*((t-=2)*t*t*t*t+2)+n}})}(jQuery,window,document),function(e,t,n,i){e.api=e.fn.api=function(n){var o,a=e(e.isFunction(this)?t:this),r=a.selector||"",s=(new Date).getTime(),c=[],l=arguments[0],u="string"==typeof l,d=[].slice.call(arguments,1);return a.each(function(){var t,a,m,f,g,p=e.isPlainObject(n)?e.extend(!0,{},e.fn.api.settings,n):e.extend({},e.fn.api.settings),b=p.namespace,v=(p.metadata,p.selector),h=p.error,y=p.className,x="."+b,w="module-"+b,C=e(this),T=C.closest(v.form),k=p.stateContext?e(p.stateContext):C,S=this,A=k.get(),z=C.data(w);g={initialize:function(){var e=g.get.event();u||(e?(g.debug("Attaching API events to element",e),C.on(e+x,g.event.trigger)):g.query()),g.instantiate()},instantiate:function(){g.verbose("Storing instance of module",g),z=g,C.data(w,z)},destroy:function(){g.verbose("Destroying previous module for",S),C.removeData(w).off(x)},query:function(){if(g.is.disabled())return void g.debug("Element is disabled API request aborted");if(g.is.loading()&&0===p.throttle)return void g.debug("Cancelling request, previous request is still pending");if(p.defaultData&&e.extend(!0,p.urlData,g.get.defaultData()),(p.serializeForm!==!1||k.is("form"))&&("json"==p.serializeForm?e.extend(!0,p.data,g.get.formData()):p.data=g.get.formData()),a=g.get.settings(),a===!1)return void g.error(h.beforeSend);if(p.url?(g.debug("Using specified url",m),m=g.add.urlData(p.url)):(m=g.add.urlData(g.get.templateURL()),g.debug("Added URL Data to url",m)),!m){if(!C.is("form"))return void g.error(h.missingURL,p.action);g.debug("No url or action specified, defaulting to form action"),m=C.attr("action")}g.set.loading(),t=e.extend(!0,{},p,{type:p.method||p.type,data:f,url:p.base+m,beforeSend:p.beforeXHR,success:function(){},failure:function(){},complete:function(){}}),g.verbose("Creating AJAX request with settings",t),g.is.loading()?g.timer=setTimeout(function(){g.request=g.create.request(),g.xhr=g.create.xhr()},p.throttle):(g.request=g.create.request(),g.xhr=g.create.xhr())},is:{disabled:function(){return C.filter(p.filter).size()>0},loading:function(){return g.request&&"pending"==g.request.state()}},was:{succesful:function(){return g.request&&"resolved"==g.request.state()},failure:function(){return g.request&&"rejected"==g.request.state()},complete:function(){return g.request&&("resolved"==g.request.state()||"rejected"==g.request.state())}},add:{urlData:function(t,n){var o,a;return t&&(o=t.match(p.regExp.required),a=t.match(p.regExp.optional),n=n||p.urlData,o&&(g.debug("Looking for required URL variables",o),e.each(o,function(o,a){var r=-1!==a.indexOf("$")?a.substr(2,a.length-3):a.substr(1,a.length-2),s=e.isPlainObject(n)&&n[r]!==i?n[r]:C.data(r)!==i?C.data(r):k.data(r)!==i?k.data(r):n[r];return s===i?(g.error(h.requiredParameter,r,t),t=!1,!1):(g.verbose("Found required variable",r,s),void(t=t.replace(a,s)))})),a&&(g.debug("Looking for optional URL variables",o),e.each(a,function(o,a){var r=-1!==a.indexOf("$")?a.substr(3,a.length-4):a.substr(2,a.length-3),s=e.isPlainObject(n)&&n[r]!==i?n[r]:C.data(r)!==i?C.data(r):k.data(r)!==i?k.data(r):n[r];s!==i?(g.verbose("Optional variable Found",r,s),t=t.replace(a,s)):(g.verbose("Optional variable not found",r),t=-1!==t.indexOf("/"+a)?t.replace("/"+a,""):t.replace(a,""))}))),t}},event:{trigger:function(e){g.query(),("submit"==e.type||"click"==e.type)&&e.preventDefault()},xhr:{always:function(){},done:function(e){var t=this,n=(new Date).getTime()-s,i=p.loadingDuration-n;i=i>0?i:0,setTimeout(function(){g.request.resolveWith(t,[e])},i)},fail:function(e,t,n){var i=this,o=(new Date).getTime()-s,a=p.loadingDuration-o;a=a>0?a:0,setTimeout(function(){"abort"!==t?g.request.rejectWith(i,[e,t,n]):g.reset()},a)}},request:{complete:function(t){g.remove.loading(),e.proxy(p.onComplete,A)(t,C)},done:function(t){g.debug("API Response Received",t),"json"==p.dataType&&e.isFunction(p.successTest)?(g.debug("Checking JSON returned success",p.successTest,t),p.successTest(t)?e.proxy(p.onSuccess,A)(t,C):(g.debug("JSON test specified by user and response failed",t),e.proxy(p.onFailure,A)(t,C))):e.proxy(p.onSuccess,A)(t,C)},error:function(t,n,o){var a,r=p.error[n]!==i?p.error[n]:o;if(t!==i)if(t.readyState!==i&&4==t.readyState){if(200!=t.status&&o!==i&&""!==o)g.error(h.statusMessage+o);else if("error"==n&&"json"==p.dataType)try{a=e.parseJSON(t.responseText),a&&a.error!==i&&(r=a.error)}catch(s){g.error(h.JSONParse)}g.remove.loading(),g.set.error(),p.errorDuration&&setTimeout(g.remove.error,p.errorDuration),g.debug("API Request error:",r),e.proxy(p.onError,A)(r,A)}else e.proxy(p.onAbort,A)(r,A),g.debug("Request Aborted (Most likely caused by page change or CORS Policy)",n,o)}}},create:{request:function(){return e.Deferred().always(g.event.request.complete).done(g.event.request.done).fail(g.event.request.error)},xhr:function(){e.ajax(t).always(g.event.xhr.always).done(g.event.xhr.done).fail(g.event.xhr.fail)}},set:{error:function(){g.verbose("Adding error state to element",k),k.addClass(y.error)},loading:function(){g.verbose("Adding loading state to element",k),k.addClass(y.loading)}},remove:{error:function(){g.verbose("Removing error state from element",k),k.removeClass(y.error)},loading:function(){g.verbose("Removing loading state from element",k),k.removeClass(y.loading)}},get:{request:function(){return g.request||!1},xhr:function(){return g.xhr||!1},settings:function(){var t;return t=e.proxy(p.beforeSend,C)(p),t&&(t.success!==i&&(g.debug("Legacy success callback detected",t),g.error(h.legacyParameters,t.success),t.onSuccess=t.success),t.failure!==i&&(g.debug("Legacy failure callback detected",t),g.error(h.legacyParameters,t.failure),t.onFailure=t.failure),t.complete!==i&&(g.debug("Legacy complete callback detected",t),g.error(h.legacyParameters,t.complete),t.onComplete=t.complete)),t===i&&g.error(h.noReturnedValue),t!==i?t:p},defaultData:function(){var t={};return e.isWindow(S)||(C.is("input")?t.value=C.val():C.is("form")||(t.text=C.text())),t},event:function(){return e.isWindow(S)||"now"==p.on?(g.debug("API called without element, no events attached"),!1):"auto"==p.on?C.is("input")?S.oninput!==i?"input":S.onpropertychange!==i?"propertychange":"keyup":C.is("form")?"submit":"click":p.on},formData:function(){var t;return e(this).serializeObject()!==i?t=T.serializeObject():(g.error(h.missingSerialize),t=T.serialize()),g.debug("Retrieved form data",t),t},templateURL:function(e){var t;return e=e||C.data(p.metadata.action)||p.action||!1,e&&(g.debug("Looking up url for action",e,p.api),p.api[e]!==i?(t=p.api[e],g.debug("Found template url",t)):g.error(h.missingAction,p.action,p.api)),t}},reset:function(){g.remove.error(),g.remove.loading()},setting:function(t,n){if(g.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,p,t);else{if(n===i)return p[t];p[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,g,t);else{if(n===i)return g[t];g[t]=n}},debug:function(){p.debug&&(p.performance?g.performance.log(arguments):(g.debug=Function.prototype.bind.call(console.info,console,p.name+":"),g.debug.apply(console,arguments)))},verbose:function(){p.verbose&&p.debug&&(p.performance?g.performance.log(arguments):(g.verbose=Function.prototype.bind.call(console.info,console,p.name+":"),g.verbose.apply(console,arguments)))},error:function(){g.error=Function.prototype.bind.call(console.error,console,p.name+":"),g.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;p.performance&&(t=(new Date).getTime(),i=s||t,n=t-i,s=t,c.push({Name:e[0],Arguments:[].slice.call(e,1)||"","Execution Time":n})),clearTimeout(g.performance.timer),g.performance.timer=setTimeout(g.performance.display,100)},display:function(){var t=p.name+":",n=0;s=!1,clearTimeout(g.performance.timer),e.each(c,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",r&&(t+=" '"+r+"'"),(console.group!==i||console.table!==i)&&c.length>0&&(console.groupCollapsed(t),console.table?console.table(c):e.each(c,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),c=[]}},invoke:function(t,n,a){var r,s,c,l=z;return n=n||d,a=S||a,"string"==typeof t&&l!==i&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(n,o){var a=n!=r?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[a])&&n!=r)l=l[a];else{if(l[a]!==i)return s=l[a],!1;if(!e.isPlainObject(l[o])||n==r)return l[o]!==i?(s=l[o],!1):(g.error(h.method,t),!1);l=l[o]}})),e.isFunction(s)?c=s.apply(a,n):s!==i&&(c=s),e.isArray(o)?o.push(c):o!==i?o=[o,c]:c!==i&&(o=c),s}},u?(z===i&&g.initialize(),g.invoke(l)):(z!==i&&g.destroy(),g.initialize())}),o!==i?o:this},e.api.settings={name:"API",namespace:"api",debug:!1,verbose:!0,performance:!0,on:"auto",filter:".disabled",stateContext:!1,loadingDuration:0,errorDuration:2e3,action:!1,url:!1,base:"",urlData:{},defaultData:!0,serializeForm:!1,throttle:0,method:"get",data:{},dataType:"json",beforeSend:function(e){return e},beforeXHR:function(){},onSuccess:function(){},onComplete:function(){},onFailure:function(){},onError:function(){},onAbort:function(){},successTest:!1,error:{beforeSend:"The before send function has aborted the request",error:"There was an error with your request",exitConditions:"API Request Aborted. Exit conditions met",JSONParse:"JSON could not be parsed during error handling",legacyParameters:"You are using legacy API success callback names",missingAction:"API action used but no url was defined",missingSerialize:"Required dependency jquery-serialize-object missing, using basic serialize",missingURL:"No URL specified for api event",noReturnedValue:"The beforeSend callback must return a settings object, beforeSend ignored.",parseError:"There was an error parsing your request",requiredParameter:"Missing a required URL parameter: ",statusMessage:"Server gave an error: ",timeout:"Your request timed out"},regExp:{required:/\{\$*[A-z0-9]+\}/g,optional:/\{\/\$*[A-z0-9]+\}/g},className:{loading:"loading",error:"error"},selector:{form:"form"},metadata:{action:"action",request:"request",xhr:"xhr"}},e.api.settings.api={}}(jQuery,window,document),function(e,t,n,i){"use strict";e.fn.checkbox=function(n){var o,a=e(this),r=a.selector||"",s=(new Date).getTime(),c=[],l=arguments[0],u="string"==typeof l,d=[].slice.call(arguments,1);return a.each(function(){var a,m,f=e.extend(!0,{},e.fn.checkbox.settings,n),g=f.className,p=f.namespace,b=f.selector,v=f.error,h="."+p,y="module-"+p,x=e(this),w=e(this).next(b.label).first(),C=e(this).find(b.input),T=x.data(y),k=this;m={initialize:function(){m.verbose("Initializing checkbox",f),x.on("click"+h,m.toggle).on("keydown"+h,b.input,m.event.keydown),m.is.checked()?(m.set.checked(),f.fireOnInit&&e.proxy(f.onChecked,C.get())()):(m.remove.checked(),f.fireOnInit&&e.proxy(f.onUnchecked,C.get())()),m.observeChanges(),m.instantiate()},instantiate:function(){m.verbose("Storing instance of module",m),T=m,x.data(y,m)},destroy:function(){m.verbose("Destroying previous module"),x.off(h).removeData(y),C.off(h,m.event.keydown),w.off(h)},refresh:function(){x=e(this),w=e(this).next(b.label).first(),C=e(this).find(b.input)},observeChanges:function(){"MutationObserver"in t&&(a=new MutationObserver(function(){m.debug("DOM tree modified, updating selector cache"),m.refresh()}),a.observe(k,{childList:!0,subtree:!0}),m.debug("Setting up mutation observer",a))},attachEvents:function(t,n){var i=e(t);n=e.isFunction(m[n])?m[n]:m.toggle,i.size()>0?(m.debug("Attaching checkbox events to element",t,n),i.on("click"+h,n)):m.error(v.notFound)},event:{keydown:function(t){var n=t.which,i={enter:13,escape:27};n==i.escape&&(m.verbose("Escape key pressed blurring field"),x.blur()),t.ctrlKey||n!=i.enter||(m.verbose("Enter key pressed, toggling checkbox"),e.proxy(m.toggle,this)(),t.preventDefault())}},is:{radio:function(){return x.hasClass(g.radio)},checked:function(){return C.prop("checked")!==i&&C.prop("checked")},unchecked:function(){return!m.is.checked()}},can:{change:function(){return!(x.hasClass(g.disabled)||x.hasClass(g.readOnly)||C.prop("disabled"))},uncheck:function(){return"boolean"==typeof f.uncheckable?f.uncheckable:!m.is.radio()}},set:{checked:function(){x.addClass(g.checked)},tab:function(){C.attr("tabindex")===i&&C.attr("tabindex",0)}},remove:{checked:function(){x.removeClass(g.checked)}},enable:function(){m.debug("Enabling checkbox functionality"),x.removeClass(g.disabled),C.prop("disabled",!1),e.proxy(f.onEnabled,C.get())()},disable:function(){m.debug("Disabling checkbox functionality"),x.addClass(g.disabled),C.prop("disabled","disabled"),e.proxy(f.onDisabled,C.get())()},check:function(){m.debug("Enabling checkbox",C),C.prop("checked",!0).trigger("change"),m.set.checked(),e.proxy(f.onChange,C.get())(),e.proxy(f.onChecked,C.get())()},uncheck:function(){m.debug("Disabling checkbox"),C.prop("checked",!1).trigger("change"),m.remove.checked(),e.proxy(f.onChange,C.get())(),e.proxy(f.onUnchecked,C.get())()},toggle:function(){return m.can.change()?(m.verbose("Determining new checkbox state"),void(m.is.unchecked()?m.check():m.is.checked()&&m.can.uncheck()&&m.uncheck())):(console.log(m.can.change()),void m.debug("Checkbox is read-only or disabled, ignoring toggle"))},setting:function(t,n){if(m.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,f,t);else{if(n===i)return f[t];f[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,m,t);else{if(n===i)return m[t];m[t]=n}},debug:function(){f.debug&&(f.performance?m.performance.log(arguments):(m.debug=Function.prototype.bind.call(console.info,console,f.name+":"),m.debug.apply(console,arguments)))},verbose:function(){f.verbose&&f.debug&&(f.performance?m.performance.log(arguments):(m.verbose=Function.prototype.bind.call(console.info,console,f.name+":"),m.verbose.apply(console,arguments)))},error:function(){m.error=Function.prototype.bind.call(console.error,console,f.name+":"),m.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;f.performance&&(t=(new Date).getTime(),i=s||t,n=t-i,s=t,c.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:k,"Execution Time":n})),clearTimeout(m.performance.timer),m.performance.timer=setTimeout(m.performance.display,100)},display:function(){var t=f.name+":",n=0;s=!1,clearTimeout(m.performance.timer),e.each(c,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",r&&(t+=" '"+r+"'"),(console.group!==i||console.table!==i)&&c.length>0&&(console.groupCollapsed(t),console.table?console.table(c):e.each(c,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),c=[]}},invoke:function(t,n,a){var r,s,c,l=T;return n=n||d,a=k||a,"string"==typeof t&&l!==i&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(n,o){var a=n!=r?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[a])&&n!=r)l=l[a];else{if(l[a]!==i)return s=l[a],!1;if(!e.isPlainObject(l[o])||n==r)return l[o]!==i?(s=l[o],!1):!1;l=l[o]}})),e.isFunction(s)?c=s.apply(a,n):s!==i&&(c=s),e.isArray(o)?o.push(c):o!==i?o=[o,c]:c!==i&&(o=c),s}},u?(T===i&&m.initialize(),m.invoke(l)):(T!==i&&m.destroy(),m.initialize())}),o!==i?o:this},e.fn.checkbox.settings={name:"Checkbox",namespace:"checkbox",debug:!1,verbose:!0,performance:!0,uncheckable:"auto",fireOnInit:!0,onChange:function(){},onChecked:function(){},onUnchecked:function(){},onEnabled:function(){},onDisabled:function(){},className:{checked:"checked",disabled:"disabled",radio:"radio",readOnly:"read-only"},error:{method:"The method you called is not defined."},selector:{input:"input[type=checkbox], input[type=radio]",label:"label"}}}(jQuery,window,document),function(e,t,n,i){"use strict";e.fn.colorize=function(t){var n=e.extend(!0,{},e.fn.colorize.settings,t),o=arguments||!1;return e(this).each(function(t){var a,r,s,c,l,u,d,m,f=e(this),g=e("<canvas />")[0],p=e("<canvas />")[0],b=e("<canvas />")[0],v=new Image,h=n.colors,y=(n.paths,n.namespace),x=n.error,w=f.data("module-"+y);return m={checkPreconditions:function(){return m.debug("Checking pre-conditions"),!e.isPlainObject(h)||e.isEmptyObject(h)?(m.error(x.undefinedColors),!1):!0},async:function(e){n.async?setTimeout(e,0):e()},getMetadata:function(){m.debug("Grabbing metadata"),c=f.data("image")||n.image||i,l=f.data("name")||n.name||t,u=n.width||f.width(),d=n.height||f.height(),(0===u||0===d)&&m.error(x.undefinedSize)},initialize:function(){m.debug("Initializing with colors",h),m.checkPreconditions()&&m.async(function(){m.getMetadata(),m.canvas.create(),m.draw.image(function(){m.draw.colors(),m.canvas.merge()}),f.data("module-"+y,m)})},redraw:function(){m.debug("Redrawing image"),m.async(function(){m.canvas.clear(),m.draw.colors(),m.canvas.merge()})},change:{color:function(e,t){return m.debug("Changing color",e),h[e]===i?(m.error(x.missingColor),!1):(h[e]=t,void m.redraw())}},canvas:{create:function(){m.debug("Creating canvases"),g.width=u,g.height=d,p.width=u,p.height=d,b.width=u,b.height=d,a=g.getContext("2d"),r=p.getContext("2d"),s=b.getContext("2d"),f.append(g),a=f.children("canvas")[0].getContext("2d")},clear:function(){m.debug("Clearing canvas"),s.fillStyle="#FFFFFF",s.fillRect(0,0,u,d)},merge:function(){return e.isFunction(a.blendOnto)?(a.putImageData(r.getImageData(0,0,u,d),0,0),void s.blendOnto(a,"multiply")):void m.error(x.missingPlugin)}},draw:{image:function(e){m.debug("Drawing image"),e=e||function(){},c?(v.src=c,v.onload=function(){r.drawImage(v,0,0),e()}):(m.error(x.noImage),e())},colors:function(){m.debug("Drawing color overlays",h),e.each(h,function(e,t){n.onDraw(s,l,e,t)})}},debug:function(e,t){n.debug&&(t!==i?console.info(n.name+": "+e,t):console.info(n.name+": "+e))},error:function(e){console.warn(n.name+": "+e)},invoke:function(t,o,a){var r;return a=a||Array.prototype.slice.call(arguments,2),"string"==typeof t&&w!==i&&(t=t.split("."),e.each(t,function(t,i){return e.isPlainObject(w[i])?(w=w[i],!0):e.isFunction(w[i])?(r=w[i],!0):(m.error(n.error.method),!1)})),e.isFunction(r)?r.apply(o,a):!1}},w!==i&&o?("invoke"==o[0]&&(o=Array.prototype.slice.call(o,1)),m.invoke(o[0],this,Array.prototype.slice.call(o,1))):void m.initialize()}),this},e.fn.colorize.settings={name:"Image Colorizer",debug:!0,namespace:"colorize",onDraw:function(){},async:!0,colors:{},metadata:{image:"image",name:"name"},error:{noImage:"No tracing image specified",undefinedColors:"No default colors specified.",missingColor:"Attempted to change color that does not exist",missingPlugin:"Blend onto plug-in must be included",undefinedHeight:"The width or height of image canvas could not be automatically determined. Please specify a height."}}}(jQuery,window,document),function(e,t,n,i){e.fn.dimmer=function(t){var o,a=e(this),r=(new Date).getTime(),s=[],c=arguments[0],l="string"==typeof c,u=[].slice.call(arguments,1);return a.each(function(){var d,m,f,g=e.isPlainObject(t)?e.extend(!0,{},e.fn.dimmer.settings,t):e.extend({},e.fn.dimmer.settings),p=g.selector,b=g.namespace,v=g.className,h=(g.error,"."+b),y="module-"+b,x=a.selector||"",w="ontouchstart"in n.documentElement?"touchstart":"click",C=e(this),T=this,k=C.data(y);f={preinitialize:function(){f.is.dimmer()?(m=C.parent(),d=C):(m=C,d=f.has.dimmer()?g.dimmerName?m.children(p.dimmer).filter("."+g.dimmerName):m.children(p.dimmer):f.create())},initialize:function(){f.debug("Initializing dimmer",g),"hover"==g.on?m.on("mouseenter"+h,f.show).on("mouseleave"+h,f.hide):"click"==g.on&&m.on(w+h,f.toggle),f.is.page()&&(f.debug("Setting as a page dimmer",m),f.set.pageDimmer()),f.is.closable()&&(f.verbose("Adding dimmer close event",d),d.on(w+h,f.event.click)),f.set.dimmable(),f.instantiate()},instantiate:function(){f.verbose("Storing instance of module",f),k=f,C.data(y,k)},destroy:function(){f.verbose("Destroying previous module",d),C.removeData(y),m.off(h),d.off(h)},event:{click:function(t){f.verbose("Determining if event occured on dimmer",t),(0===d.find(t.target).size()||e(t.target).is(p.content))&&(f.hide(),t.stopImmediatePropagation())}},addContent:function(t){var n=e(t);f.debug("Add content to dimmer",n),n.parent()[0]!==d[0]&&n.detach().appendTo(d)},create:function(){var t=e(g.template.dimmer());return g.variation&&(f.debug("Creating dimmer with variation",g.variation),t.addClass(v.variation)),g.dimmerName&&(f.debug("Creating named dimmer",g.dimmerName),t.addClass(g.dimmerName)),t.appendTo(m),t},show:function(t){t=e.isFunction(t)?t:function(){},f.debug("Showing dimmer",d,g),f.is.dimmed()&&!f.is.animating()||!f.is.enabled()?f.debug("Dimmer is already shown or disabled"):(f.animate.show(t),e.proxy(g.onShow,T)(),e.proxy(g.onChange,T)())},hide:function(t){t=e.isFunction(t)?t:function(){},f.is.dimmed()||f.is.animating()?(f.debug("Hiding dimmer",d),f.animate.hide(t),e.proxy(g.onHide,T)(),e.proxy(g.onChange,T)()):f.debug("Dimmer is not visible")},toggle:function(){f.verbose("Toggling dimmer visibility",d),f.is.dimmed()?f.hide():f.show()},animate:{show:function(t){t=e.isFunction(t)?t:function(){},g.useCSS&&e.fn.transition!==i&&d.transition("is supported")?d.transition({animation:g.transition+" in",queue:!1,duration:f.get.duration(),onStart:function(){f.set.dimmed()},onComplete:function(){f.set.active(),t()}}):(f.verbose("Showing dimmer animation with javascript"),f.set.dimmed(),d.stop().css({opacity:0,width:"100%",height:"100%"}).fadeTo(f.get.duration(),1,function(){d.removeAttr("style"),f.set.active(),t()}))},hide:function(t){t=e.isFunction(t)?t:function(){},g.useCSS&&e.fn.transition!==i&&d.transition("is supported")?(f.verbose("Hiding dimmer with css"),d.transition({animation:g.transition+" out",queue:!1,duration:f.get.duration(),onStart:function(){f.remove.dimmed()},onComplete:function(){f.remove.active(),t()}})):(f.verbose("Hiding dimmer with javascript"),f.remove.dimmed(),d.stop().fadeOut(f.get.duration(),function(){f.remove.active(),d.removeAttr("style"),t()}))}},get:{dimmer:function(){return d},duration:function(){return"object"==typeof g.duration?f.is.active()?g.duration.hide:g.duration.show:g.duration}},has:{dimmer:function(){return g.dimmerName?C.children(p.dimmer).filter("."+g.dimmerName).size()>0:C.children(p.dimmer).size()>0}},is:{active:function(){return d.hasClass(v.active)},animating:function(){return d.is(":animated")||d.hasClass(v.animating)},closable:function(){return"auto"==g.closable?"hover"==g.on?!1:!0:g.closable},dimmer:function(){return C.is(p.dimmer)},dimmable:function(){return C.is(p.dimmable)},dimmed:function(){return m.hasClass(v.dimmed)},disabled:function(){return m.hasClass(v.disabled)},enabled:function(){return!f.is.disabled()},page:function(){return m.is("body")},pageDimmer:function(){return d.hasClass(v.pageDimmer)}},can:{show:function(){return!d.hasClass(v.disabled)}},set:{active:function(){d.addClass(v.active)},dimmable:function(){m.addClass(v.dimmable)},dimmed:function(){m.addClass(v.dimmed)},pageDimmer:function(){d.addClass(v.pageDimmer)},disabled:function(){d.addClass(v.disabled)}},remove:{active:function(){d.removeClass(v.active)},dimmed:function(){m.removeClass(v.dimmed)},disabled:function(){d.removeClass(v.disabled)}},setting:function(t,n){if(f.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,g,t);else{if(n===i)return g[t];g[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,f,t);else{if(n===i)return f[t];f[t]=n}},debug:function(){g.debug&&(g.performance?f.performance.log(arguments):(f.debug=Function.prototype.bind.call(console.info,console,g.name+":"),f.debug.apply(console,arguments)))},verbose:function(){g.verbose&&g.debug&&(g.performance?f.performance.log(arguments):(f.verbose=Function.prototype.bind.call(console.info,console,g.name+":"),f.verbose.apply(console,arguments)))},error:function(){f.error=Function.prototype.bind.call(console.error,console,g.name+":"),f.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;g.performance&&(t=(new Date).getTime(),i=r||t,n=t-i,r=t,s.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:T,"Execution Time":n})),clearTimeout(f.performance.timer),f.performance.timer=setTimeout(f.performance.display,100)},display:function(){var t=g.name+":",n=0;r=!1,clearTimeout(f.performance.timer),e.each(s,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",x&&(t+=" '"+x+"'"),a.size()>1&&(t+=" ("+a.size()+")"),(console.group!==i||console.table!==i)&&s.length>0&&(console.groupCollapsed(t),console.table?console.table(s):e.each(s,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),s=[]}},invoke:function(t,n,a){var r,s,c,l=k;return n=n||u,a=T||a,"string"==typeof t&&l!==i&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(n,o){var a=n!=r?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[a])&&n!=r)l=l[a];else{if(l[a]!==i)return s=l[a],!1;if(!e.isPlainObject(l[o])||n==r)return l[o]!==i?(s=l[o],!1):!1;l=l[o]}})),e.isFunction(s)?c=s.apply(a,n):s!==i&&(c=s),e.isArray(o)?o.push(c):o!==i?o=[o,c]:c!==i&&(o=c),s}},f.preinitialize(),l?(k===i&&f.initialize(),f.invoke(c)):(k!==i&&f.destroy(),f.initialize())}),o!==i?o:this},e.fn.dimmer.settings={name:"Dimmer",namespace:"dimmer",debug:!1,verbose:!0,performance:!0,dimmerName:!1,variation:!1,closable:"auto",transition:"fade",useCSS:!0,on:!1,duration:{show:500,hide:500},onChange:function(){},onShow:function(){},onHide:function(){},error:{method:"The method you called is not defined."},selector:{dimmable:".dimmable",dimmer:".ui.dimmer",content:".ui.dimmer > .content, .ui.dimmer > .content > .center"},template:{dimmer:function(){return e("<div />").attr("class","ui dimmer")}},className:{active:"active",animating:"animating",dimmable:"dimmable",dimmed:"dimmed",disabled:"disabled",hide:"hide",pageDimmer:"page",show:"show"}}}(jQuery,window,document),function(e,t,n,i){"use strict";e.fn.dropdown=function(o){var a,r=e(this),s=e(n),c=r.selector||"",l="ontouchstart"in n.documentElement,u=(new Date).getTime(),d=[],m=arguments[0],f="string"==typeof m,g=[].slice.call(arguments,1);return r.each(function(){var n,p,b=e.isPlainObject(o)?e.extend(!0,{},e.fn.dropdown.settings,o):e.extend({},e.fn.dropdown.settings),v=b.className,h=b.metadata,y=b.namespace,x=b.selector,w=b.error,C="."+y,T="module-"+y,k=e(this),S=k.find(x.text),A=k.find(x.search),z=k.find(x.input),P=k.prev().find(x.text).size()>0?k.prev().find(x.text):k.prev(),E=k.children(x.menu),F=E.find(x.item),O=!1,D=!1,R=this,j=k.data(T);p={initialize:function(){p.debug("Initializing dropdown",b),p.setup.layout(),p.save.defaults(),p.set.selected(),l&&p.bind.touchEvents(),p.bind.mouseEvents(),p.bind.keyboardEvents(),p.observeChanges(),p.instantiate()
},instantiate:function(){p.verbose("Storing instance of dropdown",p),j=p,k.data(T,p)},destroy:function(){p.verbose("Destroying previous dropdown for",k),p.remove.tabbable(),k.off(C).removeData(T)},observeChanges:function(){"MutationObserver"in t&&(n=new MutationObserver(function(){p.debug("DOM tree modified, updating selector cache"),p.refresh()}),n.observe(R,{childList:!0,subtree:!0}),p.debug("Setting up mutation observer",n))},setup:{layout:function(){k.is("select")&&p.setup.select(),p.is.search()&&!p.is.searchable()&&(A=e("<input />").addClass(v.search).insertBefore(S)),b.allowTab&&p.set.tabbable()},select:function(){var t=p.get.selectValues();p.debug("Dropdown initialized on a select",t),z=k,z.parents(x.dropdown).size()>0?(p.debug("Creating dropdown menu only from template"),k=z.closest(x.dropdown),0===k.find("."+v.dropdown).size()&&e("<div />").addClass(v.menu).html(b.templates.menu(t)).appendTo(k)):(p.debug("Creating entire dropdown from template"),k=e("<div />").attr("class",z.attr("class")).addClass(v.selection).addClass(v.dropdown).html(b.templates.dropdown(t)).insertBefore(z),z.removeAttr("class").prependTo(k)),p.refresh()}},refresh:function(){S=k.find(x.text),A=k.find(x.search),z=k.find(x.input),E=k.children(x.menu),F=E.find(x.item)},toggle:function(){p.verbose("Toggling menu visibility"),p.is.active()?p.hide():p.show()},show:function(){p.debug("Checking if dropdown can show"),p.is.active()||(p.animate.show(function(){p.can.click()&&p.bind.intent(),p.set.visible()}),e.proxy(b.onShow,R)())},hide:function(){p.is.active()&&(p.debug("Hiding dropdown"),p.animate.hide(function(){p.remove.visible()}),e.proxy(b.onHide,R)())},hideOthers:function(){p.verbose("Finding other dropdowns to hide"),r.not(k).has(x.menu+":visible:not(."+v.animating+")").dropdown("hide")},hideSubMenus:function(){var e=E.find(x.menu);e.transition("hide")},bind:{keyboardEvents:function(){p.debug("Binding keyboard events"),k.on("keydown"+C,p.event.keydown),p.is.searchable()&&k.on(p.get.inputEvent(),x.search,p.event.input)},touchEvents:function(){p.debug("Touch device detected binding additional touch events"),p.is.searchSelection()||k.on("touchstart"+C,p.event.test.toggle),E.on("touchstart"+C,x.item,p.event.item.mouseenter)},mouseEvents:function(){p.verbose("Mouse detected binding mouse events"),p.is.searchSelection()?k.on("mousedown"+C,x.menu,p.event.menu.activate).on("mouseup"+C,x.menu,p.event.menu.deactivate).on("focus"+C,x.search,p.event.searchFocus).on("click"+C,x.search,p.show).on("blur"+C,x.search,p.event.searchBlur):("click"==b.on?k.on("click"+C,p.event.test.toggle):"hover"==b.on?k.on("mouseenter"+C,p.delay.show).on("mouseleave"+C,p.delay.hide):k.on(b.on+C,p.toggle),k.on("mousedown"+C,p.event.mousedown).on("mouseup"+C,p.event.mouseup).on("focus"+C,p.event.focus).on("blur"+C,p.event.blur)),E.on("mouseenter"+C,x.item,p.event.item.mouseenter).on("mouseleave"+C,x.item,p.event.item.mouseleave).on("click"+C,x.item,p.event.item.click)},intent:function(){p.verbose("Binding hide intent event to document"),l&&s.on("touchstart"+C,p.event.test.touch).on("touchmove"+C,p.event.test.touch),s.on("click"+C,p.event.test.hide)}},unbind:{intent:function(){p.verbose("Removing hide intent event from document"),l&&s.off("touchstart"+C).off("touchmove"+C),s.off("click"+C)}},filter:function(t){var n,o,a=e(),r=new RegExp("(?:s|^)"+t,"i"),s=new RegExp(t,"i");F.each(function(){var t=e(this),n=t.data(h.text)!==i?t.data(h.text):b.preserveHTML?t.html():t.text(),o=t.data(h.value)!==i?t.data(h.value):"string"==typeof n?n.toLowerCase():n;r.test(n)||r.test(o)?a=a.add(t):b.fullTextSearch&&(s.test(n)||s.test(o))&&(a=a.add(t))}),o=F.not(a),n=o.size()==F.size(),p.remove.filteredItem(),p.remove.selectedItem(),o.addClass(v.filtered),F.not("."+v.filtered).eq(0).addClass(v.selected),n&&p.hide()},focusSearch:function(){p.is.search()&&A.focus()},event:{mousedown:function(){O=!0},mouseup:function(){O=!1},focus:function(){!O&&p.is.hidden()&&p.show()},blur:function(){O||p.hide()},searchFocus:function(){O=!0,p.show()},searchBlur:function(){D||p.hide()},input:function(){var e=A.val();p.is.searchSelection()&&(p.can.show()&&p.show(),p.set.filtered()),p.filter(e)},keydown:function(t){var n,i=F.not(v.filtered).filter("."+v.selected).eq(0),o=F.not("."+v.filtered),a=t.which,r={enter:13,escape:27,upArrow:38,downArrow:40},s=v.selected,c=o.index(i),l=i.size()>0;if(l||(i=F.filter("."+v.active).eq(0),l=i.size()>0),a==r.escape&&(p.verbose("Escape key pressed, closing dropdown"),p.hide()),p.is.visible()){if(a==r.enter&&l)return p.verbose("Enter key pressed, choosing selected item"),e.proxy(p.event.item.click,i)(t),t.preventDefault(),!1;a==r.upArrow?(n=l?i.prevAll(x.item+":not(."+v.filtered+")").eq(0):o.eq(0),0!==c&&(p.verbose("Up key pressed, changing active item"),F.removeClass(s),n.addClass(s),p.set.scrollPosition(n)),t.preventDefault()):a==r.downArrow&&(n=l?i.nextAll(x.item+":not(."+v.filtered+")").eq(0):o.eq(0),c+1<o.size()&&(p.verbose("Down key pressed, changing active item"),F.removeClass(s),n.addClass(s),p.set.scrollPosition(n)),t.preventDefault())}else a==r.enter&&p.show()},test:{toggle:function(e){p.determine.eventInMenu(e,p.toggle)&&e.preventDefault()},touch:function(e){p.determine.eventInMenu(e,function(){"touchstart"==e.type?p.timer=setTimeout(p.hide,b.delay.touch):"touchmove"==e.type&&clearTimeout(p.timer)}),e.stopPropagation()},hide:function(e){p.determine.eventInModule(e,p.hide)}},menu:{activate:function(){D=!0},deactivate:function(){D=!1}},item:{mouseenter:function(t){var n=e(this).children(x.menu),i=e(this).siblings(x.item).children(x.menu);n.size()>0&&(clearTimeout(p.itemTimer),p.itemTimer=setTimeout(function(){e.each(i,function(){p.animate.hide(!1,e(this))}),p.verbose("Showing sub-menu",n),p.animate.show(!1,n)},b.delay.show),t.preventDefault())},mouseleave:function(){var t=e(this).children(x.menu);t.size()>0&&(clearTimeout(p.itemTimer),p.itemTimer=setTimeout(function(){p.verbose("Hiding sub-menu",t),p.animate.hide(!1,t)},b.delay.hide))},click:function(){var t=e(this),n=t.data(h.text)!==i?t.data(h.text):b.preserveHTML?t.html():t.text(),o=t.data(h.value)!==i?t.data(h.value):"string"==typeof n?n.toLowerCase():n,a=function(){p.remove.searchTerm(),p.remove.filteredItem(),p.determine.selectAction(n,o)},r=t.find(x.menu).size()>0;r||a()}},resetStyle:function(){e(this).removeAttr("style")}},determine:{selectAction:function(t,n){p.verbose("Determining action",b.action),e.isFunction(p.action[b.action])?(p.verbose("Triggering preset action",b.action,t,n),p.action[b.action](t,n)):e.isFunction(b.action)?(p.verbose("Triggering user action",b.action,t,n),b.action(t,n)):p.error(w.action,b.action)},eventInModule:function(t,n){return n=n||function(){},0===e(t.target).closest(k).size()?(p.verbose("Triggering event",n),n(),!0):(p.verbose("Event occurred in dropdown, canceling callback"),!1)},eventInMenu:function(t,n){return n=n||function(){},0===e(t.target).closest(E).size()?(p.verbose("Triggering event",n),n(),!0):(p.verbose("Event occurred in dropdown menu, canceling callback"),!1)}},action:{nothing:function(){},hide:function(){p.hide()},select:function(e,t){t=t!==i?t:e,p.set.selected(t),p.set.value(t),p.hide()},activate:function(e,t){t=t!==i?t:e,p.set.selected(t),p.set.value(t),p.hide()},combo:function(e,t){t=t!==i?t:e,p.set.selected(t),p.set.value(t),p.hide()}},get:{text:function(){return S.text()},value:function(){return z.size()>0?z.val():k.data(h.value)},inputEvent:function(){var e=A[0];return e?e.oninput!==i?"input":e.onpropertychange!==i?"propertychange":"keyup":!1},selectValues:function(){var t={values:{}};return k.find("option").each(function(){var n=e(this).html(),o=e(this).attr("value")!==i?e(this).attr("value"):n;""===o?t.placeholder=n:t.values[o]=n}),p.debug("Retrieved values from select",t),t},item:function(t,n){var o=!1;return t=t!==i?t:p.get.value()!==i?p.get.value():p.get.text(),n=""===t||0===t?!0:n||!1,t!==i?F.each(function(){var a=e(this),r=a.data(h.text)!==i?a.data(h.text):b.preserveHTML?a.html():a.text(),s=a.data(h.value)!==i?a.data(h.value):"string"==typeof r?r.toLowerCase():r;n?(p.verbose("Ambiguous dropdown value using strict type check",a,t),s===t?o=e(this):o||r!==t||(o=e(this))):s==t?(p.verbose("Found select item by value",s,t),o=e(this)):o||r!=t||(p.verbose("Found select item by text",r,t),o=e(this))}):t=p.get.text(),o||!1}},restore:{defaults:function(){p.restore.defaultText(),p.restore.defaultValue()},defaultText:function(){var e=k.data(h.defaultText);p.debug("Restoring default text",e),p.set.text(e)},defaultValue:function(){var e=k.data(h.defaultValue);e!==i&&(p.debug("Restoring default value",e),p.set.selected(e),p.set.value(e))}},save:{defaults:function(){p.save.defaultText(),p.save.defaultValue()},defaultValue:function(){k.data(h.defaultValue,p.get.value())},defaultText:function(){k.data(h.defaultText,S.text())}},set:{filtered:function(){S.addClass(v.filtered)},tabbable:function(){p.is.searchable()?(p.debug("Searchable dropdown initialized"),A.val("").attr("tabindex",0),E.attr("tabindex","-1")):(p.debug("Simple selection dropdown initialized"),k.attr("tabindex")||(k.attr("tabindex",0),E.attr("tabindex","-1")))},scrollPosition:function(e){var t,n,i,o,a,r,s,c,e=e||p.get.item(),l=e&&e.size()>0,u=5;e&&l&&(r=E.height(),n=e.height(),a=E.scrollTop(),o=E.offset().top,i=e.offset().top,t=a-o+i,c=t+u>a+r,s=a>t-u,(s||c)&&(p.debug("Scrolling to active item"),E.scrollTop(t)))},text:function(e){"combo"==b.action?(p.debug("Changing combo button text",e,P),b.preserveHTML?P.html(e):P.text(e)):"select"!==b.action&&(p.debug("Changing text",e,S),S.removeClass(v.filtered).removeClass(v.placeholder),b.preserveHTML?S.html(e):S.text(e))},value:function(e){p.debug("Adding selected value to hidden input",e,z),z.size()>0?z.val(e).trigger("change"):k.data(h.value,e)},active:function(){k.addClass(v.active)},visible:function(){k.addClass(v.visible)},selected:function(t){var n,o=p.get.item(t);o&&(p.debug("Setting selected menu item to",o),n=o.data(h.text)!==i?o.data(h.text):b.preserveHTML?o.html():o.text(),p.remove.activeItem(),p.remove.selectedItem(),o.addClass(v.active).addClass(v.selected),p.set.text(n),e.proxy(b.onChange,R)(t,n,o))}},remove:{active:function(){k.removeClass(v.active)},visible:function(){k.removeClass(v.visible)},activeItem:function(){F.removeClass(v.active)},filteredItem:function(){F.removeClass(v.filtered)},searchTerm:function(){A.val("")},selectedItem:function(){F.removeClass(v.selected)},tabbable:function(){p.is.searchable()?(p.debug("Searchable dropdown initialized"),A.attr("tabindex","-1"),E.attr("tabindex","-1")):(p.debug("Simple selection dropdown initialized"),k.attr("tabindex","-1"),E.attr("tabindex","-1"))}},is:{search:function(){return k.hasClass(v.search)},searchable:function(){return A.size()>0},searchSelection:function(){return p.is.searchable()&&A.parent().is(k)},selection:function(){return k.hasClass(v.selection)},animating:function(e){return e?e.is(":animated")||e.transition&&e.transition("is animating"):E.is(":animated")||E.transition&&E.transition("is animating")},active:function(){return k.hasClass(v.active)},visible:function(e){return e?e.is(":visible"):E.is(":visible")},hidden:function(e){return e?e.is(":hidden"):E.is(":hidden")}},can:{click:function(){return l||"click"==b.on},show:function(){return!k.hasClass(v.disabled)}},animate:{show:function(t,n){var o=n||E,a=n?function(){}:function(){p.hideSubMenus(),p.hideOthers(),p.set.active(),p.set.scrollPosition()};t=t||function(){},p.verbose("Doing menu show animation",o),(p.is.hidden(o)||p.is.animating(o))&&("none"==b.transition?e.proxy(t,R)():e.fn.transition!==i&&k.transition("is supported")?o.transition({animation:b.transition+" in",debug:b.debug,verbose:b.verbose,duration:b.duration,queue:!0,onStart:a,onComplete:function(){e.proxy(t,R)()}}):"slide down"==b.transition?(a(),o.hide().clearQueue().children().clearQueue().css("opacity",0).delay(50).animate({opacity:1},b.duration,"easeOutQuad",p.event.resetStyle).end().slideDown(100,"easeOutQuad",function(){e.proxy(p.event.resetStyle,this)(),e.proxy(t,R)()})):"fade"==b.transition?(a(),o.hide().clearQueue().fadeIn(b.duration,function(){e.proxy(p.event.resetStyle,this)(),e.proxy(t,R)()})):p.error(w.transition,b.transition))},hide:function(t,n){var o=n||E,a=(n?.9*b.duration:b.duration,n?function(){}:function(){p.can.click()&&p.unbind.intent(),p.focusSearch(),p.remove.active()});t=t||function(){},(p.is.visible(o)||p.is.animating(o))&&(p.verbose("Doing menu hide animation",o),"none"==b.transition?e.proxy(t,R)():e.fn.transition!==i&&k.transition("is supported")?o.transition({animation:b.transition+" out",duration:b.duration,debug:b.debug,verbose:b.verbose,queue:!0,onStart:a,onComplete:function(){e.proxy(t,R)()}}):"slide down"==b.transition?(a(),o.show().clearQueue().children().clearQueue().css("opacity",1).animate({opacity:0},100,"easeOutQuad",p.event.resetStyle).end().delay(50).slideUp(100,"easeOutQuad",function(){e.proxy(p.event.resetStyle,this)(),e.proxy(t,R)()})):"fade"==b.transition?(a(),o.show().clearQueue().fadeOut(150,function(){e.proxy(p.event.resetStyle,this)(),e.proxy(t,R)()})):p.error(w.transition))}},delay:{show:function(){p.verbose("Delaying show event to ensure user intent"),clearTimeout(p.timer),p.timer=setTimeout(p.show,b.delay.show)},hide:function(){p.verbose("Delaying hide event to ensure user intent"),clearTimeout(p.timer),p.timer=setTimeout(p.hide,b.delay.hide)}},setting:function(t,n){if(p.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,b,t);else{if(n===i)return b[t];b[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,p,t);else{if(n===i)return p[t];p[t]=n}},debug:function(){b.debug&&(b.performance?p.performance.log(arguments):(p.debug=Function.prototype.bind.call(console.info,console,b.name+":"),p.debug.apply(console,arguments)))},verbose:function(){b.verbose&&b.debug&&(b.performance?p.performance.log(arguments):(p.verbose=Function.prototype.bind.call(console.info,console,b.name+":"),p.verbose.apply(console,arguments)))},error:function(){p.error=Function.prototype.bind.call(console.error,console,b.name+":"),p.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;b.performance&&(t=(new Date).getTime(),i=u||t,n=t-i,u=t,d.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:R,"Execution Time":n})),clearTimeout(p.performance.timer),p.performance.timer=setTimeout(p.performance.display,100)},display:function(){var t=b.name+":",n=0;u=!1,clearTimeout(p.performance.timer),e.each(d,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",c&&(t+=" '"+c+"'"),(console.group!==i||console.table!==i)&&d.length>0&&(console.groupCollapsed(t),console.table?console.table(d):e.each(d,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),d=[]}},invoke:function(t,n,o){var r,s,c,l=j;return n=n||g,o=R||o,"string"==typeof t&&l!==i&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(n,o){var a=n!=r?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[a])&&n!=r)l=l[a];else{if(l[a]!==i)return s=l[a],!1;if(!e.isPlainObject(l[o])||n==r)return l[o]!==i?(s=l[o],!1):(p.error(w.method,t),!1);l=l[o]}})),e.isFunction(s)?c=s.apply(o,n):s!==i&&(c=s),e.isArray(a)?a.push(c):a!==i?a=[a,c]:c!==i&&(a=c),s}},f?(j===i&&p.initialize(),p.invoke(m)):(j!==i&&p.destroy(),p.initialize())}),a!==i?a:this},e.fn.dropdown.settings={debug:!1,verbose:!0,performance:!0,on:"click",action:"activate",allowTab:!0,fullTextSearch:!0,preserveHTML:!0,delay:{show:200,hide:300,touch:50},transition:"slide down",duration:250,onChange:function(){},onShow:function(){},onHide:function(){},name:"Dropdown",namespace:"dropdown",error:{action:"You called a dropdown action that was not defined",method:"The method you called is not defined.",transition:"The requested transition was not found"},metadata:{defaultText:"defaultText",defaultValue:"defaultValue",text:"text",value:"value"},selector:{dropdown:".ui.dropdown",text:"> .text:not(.icon)",input:'> input[type="hidden"], > select',search:"> input.search, .menu > .search > input, .menu > input.search",menu:".menu",item:".item"},className:{active:"active",animating:"animating",disabled:"disabled",dropdown:"ui dropdown",filtered:"filtered",menu:"menu",placeholder:"default",search:"search",selected:"selected",selection:"selection",visible:"visible"}},e.fn.dropdown.settings.templates={menu:function(t){var n=(t.placeholder||!1,t.values||{},"");return e.each(t.values,function(e,t){n+=e===t?'<div class="item">'+t+"</div>":'<div class="item" data-value="'+e+'">'+t+"</div>"}),n},dropdown:function(t){var n=t.placeholder||!1,i=(t.values||{},"");return i+='<i class="dropdown icon"></i>',i+=t.placeholder?'<div class="default text">'+n+"</div>":'<div class="text"></div>',i+='<div class="menu">',e.each(t.values,function(e,t){i+=e===t?'<div class="item">'+t+"</div>":'<div class="item" data-value="'+e+'">'+t+"</div>"}),i+="</div>"}},e.extend(e.easing,{easeOutQuad:function(e,t,n,i,o){return-i*(t/=o)*(t-2)+n}})}(jQuery,window,document),function(e,t,n,i){e.fn.form=function(t,o){var a,r=e(this),s=e.extend(!0,{},e.fn.form.settings,o),c=e.extend({},e.fn.form.settings.defaults,t),l=s.namespace,u=s.metadata,d=s.selector,m=s.className,f=(s.error,"."+l),g="module-"+l,p=r.selector||"",b=(new Date).getTime(),v=[],h=arguments[0],y="string"==typeof h,x=[].slice.call(arguments,1);return r.each(function(){var t,o=e(this),l=e(this).find(d.field),w=e(this).find(d.group),C=e(this).find(d.message),T=(e(this).find(d.prompt),e(this).find(d.submit)),k=[],S=this,A=o.data(g);t={initialize:function(){t.verbose("Initializing form validation",o,c,s),t.bindEvents(),t.instantiate()},instantiate:function(){t.verbose("Storing instance of module",t),A=t,o.data(g,t)},destroy:function(){t.verbose("Destroying previous module",A),t.removeEvents(),o.removeData(g)},refresh:function(){t.verbose("Refreshing selector cache"),l=o.find(d.field)},submit:function(){t.verbose("Submitting form",o),o.submit()},attachEvents:function(n,i){i=i||"submit",e(n).on("click",function(e){t[i](),e.preventDefault()})},bindEvents:function(){s.keyboardShortcuts&&l.on("keydown"+f,t.event.field.keydown),o.on("submit"+f,t.validate.form),l.on("blur"+f,t.event.field.blur),t.attachEvents(T,"submit"),l.each(function(){var n=e(this).prop("type"),i=t.get.changeEvent(n);e(this).on(i+f,t.event.field.change)})},removeEvents:function(){o.off(f),l.off(f),T.off(f),l.off(f)},event:{field:{keydown:function(n){var i=e(this),o=n.which,a={enter:13,escape:27};o==a.escape&&(t.verbose("Escape key pressed blurring field"),i.blur()),!n.ctrlKey&&o==a.enter&&i.is(d.input)&&i.not(d.checkbox).size()>0&&(t.debug("Enter key pressed, submitting form"),T.addClass(m.down),i.one("keyup"+f,t.event.field.keyup))},keyup:function(){t.verbose("Doing keyboard shortcut form submit"),T.removeClass(m.down),t.submit()},blur:function(){var n=e(this),i=n.closest(w);i.hasClass(m.error)?(t.debug("Revalidating field",n,t.get.validation(n)),t.validate.field(t.get.validation(n))):("blur"==s.on||"change"==s.on)&&t.validate.field(t.get.validation(n))},change:function(){var n=e(this),i=n.closest(w);("change"==s.on||i.hasClass(m.error)&&s.revalidate)&&(clearTimeout(t.timer),t.timer=setTimeout(function(){t.debug("Revalidating field",n,t.get.validation(n)),t.validate.field(t.get.validation(n))},s.delay))}}},get:{changeEvent:function(e){return"checkbox"==e||"radio"==e||"hidden"==e?"change":n.createElement("input").oninput!==i?"input":n.createElement("input").onpropertychange!==i?"propertychange":"keyup"},field:function(n){return t.verbose("Finding field with identifier",n),l.filter("#"+n).size()>0?l.filter("#"+n):l.filter('[name="'+n+'"]').size()>0?l.filter('[name="'+n+'"]'):l.filter("[data-"+u.validate+'="'+n+'"]').size()>0?l.filter("[data-"+u.validate+'="'+n+'"]'):e("<input/>")},validation:function(n){var i;return e.each(c,function(e,o){t.get.field(o.identifier).get(0)==n.get(0)&&(i=o)}),i||!1}},has:{field:function(e){return t.verbose("Checking for existence of a field with identifier",e),l.filter("#"+e).size()>0?!0:l.filter('[name="'+e+'"]').size()>0?!0:l.filter("[data-"+u.validate+'="'+e+'"]').size()>0?!0:!1}},add:{prompt:function(n,a){var r=t.get.field(n),c=r.closest(w),l=c.find(d.prompt),u=0!==l.size();a="string"==typeof a?[a]:a,t.verbose("Adding field error state",n),c.addClass(m.error),s.inline&&(u||(l=s.templates.prompt(a),l.appendTo(c)),l.html(a[0]),u?t.verbose("Inline errors are disabled, no inline error added",n):s.transition&&e.fn.transition!==i&&o.transition("is supported")?(t.verbose("Displaying error with css transition",s.transition),l.transition(s.transition+" in",s.duration)):(t.verbose("Displaying error with fallback javascript animation"),l.fadeIn(s.duration)))},errors:function(e){t.debug("Adding form error messages",e),C.html(s.templates.error(e))}},remove:{prompt:function(n){var a=t.get.field(n.identifier),r=a.closest(w),c=r.find(d.prompt);r.removeClass(m.error),s.inline&&c.is(":visible")&&(t.verbose("Removing prompt for field",n),s.transition&&e.fn.transition!==i&&o.transition("is supported")?c.transition(s.transition+" out",s.duration,function(){c.remove()}):c.fadeOut(s.duration,function(){c.remove()}))}},set:{success:function(){o.removeClass(m.error).addClass(m.success)},error:function(){o.removeClass(m.success).addClass(m.error)}},validate:{form:function(n){var a=!0;return k=[],e.each(c,function(e,n){t.validate.field(n)||(a=!1)}),a?(t.debug("Form has no validation errors, submitting"),t.set.success(),e.proxy(s.onSuccess,this)(n)):(t.debug("Form has errors"),t.set.error(),s.inline||t.add.errors(k),o.data("moduleApi")!==i&&n.stopImmediatePropagation(),e.proxy(s.onFailure,this)(k))},field:function(n){var o=t.get.field(n.identifier),a=!0,r=[];return n.rules!==i&&e.each(n.rules,function(e,i){t.has.field(n.identifier)&&!t.validate.rule(n,i)&&(t.debug("Field is invalid",n.identifier,i.type),r.push(i.prompt),a=!1)}),a?(t.remove.prompt(n,r),e.proxy(s.onValid,o)(),!0):(k=k.concat(r),t.add.prompt(n.identifier,r),e.proxy(s.onInvalid,o)(r),!1)},rule:function(n,a){var r,c,l=t.get.field(n.identifier),u=a.type,d=e.trim(l.val()+""),m=/\[(.*)\]/i,f=m.exec(u),g=!0;return f!==i&&null!==f?(r=""+f[1],c=u.replace(f[0],""),g=e.proxy(s.rules[c],o)(d,r)):g=e.proxy(s.rules[u],l)(d),g}},setting:function(t,n){if(e.isPlainObject(t))e.extend(!0,s,t);else{if(n===i)return s[t];s[t]=n}},internal:function(n,o){if(e.isPlainObject(n))e.extend(!0,t,n);else{if(o===i)return t[n];t[n]=o}},debug:function(){s.debug&&(s.performance?t.performance.log(arguments):(t.debug=Function.prototype.bind.call(console.info,console,s.name+":"),t.debug.apply(console,arguments)))},verbose:function(){s.verbose&&s.debug&&(s.performance?t.performance.log(arguments):(t.verbose=Function.prototype.bind.call(console.info,console,s.name+":"),t.verbose.apply(console,arguments)))},error:function(){t.error=Function.prototype.bind.call(console.error,console,s.name+":"),t.error.apply(console,arguments)},performance:{log:function(e){var n,i,o;s.performance&&(n=(new Date).getTime(),o=b||n,i=n-o,b=n,v.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:S,"Execution Time":i})),clearTimeout(t.performance.timer),t.performance.timer=setTimeout(t.performance.display,100)},display:function(){var n=s.name+":",o=0;b=!1,clearTimeout(t.performance.timer),e.each(v,function(e,t){o+=t["Execution Time"]}),n+=" "+o+"ms",p&&(n+=" '"+p+"'"),r.size()>1&&(n+=" ("+r.size()+")"),(console.group!==i||console.table!==i)&&v.length>0&&(console.groupCollapsed(n),console.table?console.table(v):e.each(v,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),v=[]}},invoke:function(t,n,o){var r,s,c,l=A;return n=n||x,o=S||o,"string"==typeof t&&l!==i&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(n,o){var a=n!=r?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[a])&&n!=r)l=l[a];else{if(l[a]!==i)return s=l[a],!1;if(!e.isPlainObject(l[o])||n==r)return l[o]!==i?(s=l[o],!1):!1;l=l[o]}})),e.isFunction(s)?c=s.apply(o,n):s!==i&&(c=s),e.isArray(a)?a.push(c):a!==i?a=[a,c]:c!==i&&(a=c),s}},y?(A===i&&t.initialize(),t.invoke(h)):(A!==i&&t.destroy(),t.initialize())}),a!==i?a:this},e.fn.form.settings={name:"Form",namespace:"form",debug:!1,verbose:!0,performance:!0,keyboardShortcuts:!0,on:"submit",inline:!1,delay:200,revalidate:!0,transition:"scale",duration:150,onValid:function(){},onInvalid:function(){},onSuccess:function(){return!0},onFailure:function(){return!1},metadata:{validate:"validate"},selector:{message:".error.message",field:"input, textarea, select",group:".field",checkbox:'input[type="checkbox"], input[type="radio"]',input:"input",prompt:".prompt",submit:".submit"},className:{error:"error",success:"success",down:"down",label:"ui label prompt"},error:{method:"The method you called is not defined."},templates:{error:function(t){var n='<ul class="list">';return e.each(t,function(e,t){n+="<li>"+t+"</li>"}),n+="</ul>",e(n)},prompt:function(t){return e("<div/>").addClass("ui red pointing prompt label").html(t[0])}},rules:{checked:function(){return e(this).filter(":checked").size()>0},empty:function(e){return!(e===i||""===e)},email:function(e){var t=new RegExp("[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?","i");return t.test(e)},length:function(e,t){return e!==i?e.length>=t:!1},not:function(e,t){return e!=t},contains:function(e,t){return t=t.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&"),-1!==e.search(t)},is:function(e,t){return e==t},maxLength:function(e,t){return e!==i?e.length<=t:!1},match:function(t,n){var o,a=e(this);return a.find("#"+n).size()>0?o=a.find("#"+n).val():a.find('[name="'+n+'"]').size()>0?o=a.find('[name="'+n+'"]').val():a.find('[data-validate="'+n+'"]').size()>0&&(o=a.find('[data-validate="'+n+'"]').val()),o!==i?t.toString()==o.toString():!1},url:function(e){var t=/(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?/;return t.test(e)},integer:function(e,t){var n,o,a,r=/^\-?\d+$/;return t===i||""===t||".."===t||(-1==t.indexOf("..")?r.test(t)&&(n=o=t-0):(a=t.split("..",2),r.test(a[0])&&(n=a[0]-0),r.test(a[1])&&(o=a[1]-0))),r.test(e)&&(n===i||e>=n)&&(o===i||o>=e)}}}}(jQuery,window,document),function(e,t,n,i){"use strict";e.fn.modal=function(o){var a,r=e(this),s=e(t),c=e(n),l=e("body"),u=r.selector||"",d=(new Date).getTime(),m=[],f=arguments[0],g="string"==typeof f,p=[].slice.call(arguments,1),b=t.requestAnimationFrame||t.mozRequestAnimationFrame||t.webkitRequestAnimationFrame||t.msRequestAnimationFrame||function(e){setTimeout(e,0)};return r.each(function(){var r,v,h,y,x,w,C,T=e.isPlainObject(o)?e.extend(!0,{},e.fn.modal.settings,o):e.extend({},e.fn.modal.settings),k=T.selector,S=T.className,A=T.namespace,z=T.error,P="."+A,E="module-"+A,F=e(this),O=e(T.context),D=F.find(k.close),R=this,j=F.data(E);C={initialize:function(){return C.verbose("Initializing dimmer",O),e.fn.dimmer===i?void C.error(z.dimmer):(y=O.dimmer({debug:T.debug,dimmerName:"modals",closable:!1,useCSS:!0,duration:{show:.9*T.duration,hide:1.1*T.duration}}),T.detachable&&y.dimmer("add content",F),x=y.dimmer("get dimmer"),v=F.siblings(k.modal),r=v.add(F),C.verbose("Attaching close events",D),C.bind.events(),C.observeChanges(),void C.instantiate())},instantiate:function(){C.verbose("Storing instance of modal"),j=C,F.data(E,j)},destroy:function(){C.verbose("Destroying previous modal"),F.removeData(E).off(P),D.off(P),O.dimmer("destroy")},observeChanges:function(){"MutationObserver"in t&&(w=new MutationObserver(function(){C.debug("DOM tree modified, refreshing"),C.refresh()}),w.observe(R,{childList:!0,subtree:!0}),C.debug("Setting up mutation observer",w))},refresh:function(){C.remove.scrolling(),C.cacheSizes(),C.set.screenHeight(),C.set.type(),C.set.position()},attachEvents:function(t,n){var i=e(t);n=e.isFunction(C[n])?C[n]:C.toggle,i.size()>0?(C.debug("Attaching modal events to element",t,n),i.off(P).on("click"+P,n)):C.error(z.notFound,t)},bind:{events:function(){D.on("click"+P,C.event.close),s.on("resize"+P,C.event.resize)}},event:{close:function(){C.verbose("Closing element pressed"),e(this).is(k.approve)?e.proxy(T.onApprove,R)()!==!1?C.hide():C.verbose("Approve callback returned false cancelling hide"):e(this).is(k.deny)?e.proxy(T.onDeny,R)()!==!1?C.hide():C.verbose("Deny callback returned false cancelling hide"):C.hide()},click:function(t){0===e(t.target).closest(k.modal).size()&&(C.debug("Dimmer clicked, hiding all modals"),T.allowMultiple?C.hide():C.hideAll(),t.stopImmediatePropagation())},debounce:function(e,t){clearTimeout(C.timer),C.timer=setTimeout(e,t)},keyboard:function(e){var t=e.which,n=27;t==n&&(T.closable?(C.debug("Escape key pressed hiding modal"),C.hide()):C.debug("Escape key pressed, but closable is set to false"),e.preventDefault())},resize:function(){y.dimmer("is active")&&b(C.refresh)}},toggle:function(){C.is.active()||C.is.animating()?C.hide():C.show()},show:function(t){t=e.isFunction(t)?t:function(){},C.showDimmer(),C.showModal(t)},showModal:function(t){t=e.isFunction(t)?t:function(){},C.is.active()?C.debug("Modal is already visible"):v.filter(":visible").size()>0&&!T.allowMultiple?(C.debug("Other modals visible, queueing show animation"),C.hideOthers(C.showModal)):(e.proxy(T.onShow,R)(),T.transition&&e.fn.transition!==i&&F.transition("is supported")?(C.debug("Showing modal with css animations"),C.cacheSizes(),C.set.position(),C.set.screenHeight(),C.set.type(),F.transition({debug:T.debug,animation:T.transition+" in",queue:!1,duration:T.duration,onStart:function(){C.set.clickaway()},onComplete:function(){e.proxy(T.onVisible,R)(),C.add.keyboardShortcuts(),C.save.focus(),C.set.active(),C.set.autofocus(),t()}})):(C.debug("Showing modal with javascript"),F.fadeIn(T.duration,T.easing,function(){e.proxy(T.onVisible,R)(),C.add.keyboardShortcuts(),C.save.focus(),C.set.active(),t()})))},showDimmer:function(){y.dimmer("is active")?C.debug("Dimmer already visible"):(C.debug("Showing dimmer"),y.dimmer("show"))},hide:function(t){t=e.isFunction(t)?t:function(){},r.filter(":visible").size()<=1&&C.hideDimmer(),C.hideModal(t)},hideDimmer:function(){return y.dimmer("is active")||y.dimmer("is animating")?(C.debug("Hiding dimmer"),C.remove.clickaway(),void y.dimmer("hide",function(){T.transition&&e.fn.transition!==i&&F.transition("is supported")&&C.remove.screenHeight(),C.remove.active()})):void C.debug("Dimmer is not visible cannot hide")},hideModal:function(t){t=e.isFunction(t)?t:function(){},C.debug("Hiding modal"),e.proxy(T.onHide,R)(),T.transition&&e.fn.transition!==i&&F.transition("is supported")?F.transition({debug:T.debug,animation:T.transition+" out",queue:!1,duration:T.duration,onStart:function(){C.remove.keyboardShortcuts()},onComplete:function(){e.proxy(T.onHidden,R)(),C.remove.active(),C.restore.focus(),t()}}):(C.remove.keyboardShortcuts(),F.fadeOut(T.duration,T.easing,function(){e.proxy(T.onHidden,R)(),C.remove.active(),C.restore.focus(),t()}))},hideAll:function(t){t=e.isFunction(t)?t:function(){},r.is(":visible")&&(C.debug("Hiding all visible modals"),C.hideDimmer(),r.filter(":visible").modal("hide modal",t))},hideOthers:function(t){t=e.isFunction(t)?t:function(){},v.is(":visible")&&(C.debug("Hiding other modals",v),v.filter(":visible").modal("hide modal",t))},add:{keyboardShortcuts:function(){C.verbose("Adding keyboard shortcuts"),c.on("keyup"+P,C.event.keyboard)}},save:{focus:function(){h=e(n.activeElement).blur()}},restore:{focus:function(){h&&h.size()>0&&h.focus()}},remove:{active:function(){F.removeClass(S.active)},clickaway:function(){T.closable&&x.off("click"+P)},screenHeight:function(){C.cache.height>C.cache.pageHeight&&(C.debug("Removing page height"),l.css("height",""))},keyboardShortcuts:function(){C.verbose("Removing keyboard shortcuts"),c.off("keyup"+P)},scrolling:function(){y.removeClass(S.scrolling),F.removeClass(S.scrolling)}},cacheSizes:function(){var o=F.outerHeight();(C.cache===i||0!==o)&&(C.cache={pageHeight:e(n).outerHeight(),height:o+T.offset,contextHeight:"body"==T.context?e(t).height():y.height()}),C.debug("Caching modal and container sizes",C.cache)
},can:{fit:function(){return C.cache.height<C.cache.contextHeight}},is:{active:function(){return F.hasClass(S.active)},animating:function(){return F.transition("is supported")?F.transition("is animating"):F.is(":visible")},modernBrowser:function(){return!(t.ActiveXObject||"ActiveXObject"in t)}},set:{autofocus:function(){if(T.autofocus){var e=F.find(":input:visible"),t=e.filter("[autofocus]"),n=t.size()>0?t:e;n.first().focus()}},clickaway:function(){T.closable&&x.off("click"+P).on("click"+P,C.event.click)},screenHeight:function(){C.cache.height>C.cache.pageHeight?(C.debug("Modal is taller than page content, resizing page height"),l.css("height",C.cache.height+T.padding)):l.css("height","")},active:function(){F.addClass(S.active)},scrolling:function(){y.addClass(S.scrolling),F.addClass(S.scrolling)},type:function(){C.can.fit()?(C.verbose("Modal fits on screen"),C.remove.scrolling()):(C.verbose("Modal cannot fit on screen setting to scrolling"),C.set.scrolling())},position:function(){C.verbose("Centering modal on page",C.cache),F.css(C.can.fit()?{top:"",marginTop:-(C.cache.height/2)}:{marginTop:"",top:c.scrollTop()})}},setting:function(t,n){if(C.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,T,t);else{if(n===i)return T[t];T[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,C,t);else{if(n===i)return C[t];C[t]=n}},debug:function(){T.debug&&(T.performance?C.performance.log(arguments):(C.debug=Function.prototype.bind.call(console.info,console,T.name+":"),C.debug.apply(console,arguments)))},verbose:function(){T.verbose&&T.debug&&(T.performance?C.performance.log(arguments):(C.verbose=Function.prototype.bind.call(console.info,console,T.name+":"),C.verbose.apply(console,arguments)))},error:function(){C.error=Function.prototype.bind.call(console.error,console,T.name+":"),C.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;T.performance&&(t=(new Date).getTime(),i=d||t,n=t-i,d=t,m.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:R,"Execution Time":n})),clearTimeout(C.performance.timer),C.performance.timer=setTimeout(C.performance.display,100)},display:function(){var t=T.name+":",n=0;d=!1,clearTimeout(C.performance.timer),e.each(m,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",u&&(t+=" '"+u+"'"),(console.group!==i||console.table!==i)&&m.length>0&&(console.groupCollapsed(t),console.table?console.table(m):e.each(m,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),m=[]}},invoke:function(t,n,o){var r,s,c,l=j;return n=n||p,o=R||o,"string"==typeof t&&l!==i&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(n,o){var a=n!=r?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[a])&&n!=r)l=l[a];else{if(l[a]!==i)return s=l[a],!1;if(!e.isPlainObject(l[o])||n==r)return l[o]!==i?(s=l[o],!1):!1;l=l[o]}})),e.isFunction(s)?c=s.apply(o,n):s!==i&&(c=s),e.isArray(a)?a.push(c):a!==i?a=[a,c]:c!==i&&(a=c),s}},g?(j===i&&C.initialize(),C.invoke(f)):(j!==i&&C.destroy(),C.initialize())}),a!==i?a:this},e.fn.modal.settings={name:"Modal",namespace:"modal",debug:!1,verbose:!0,performance:!0,allowMultiple:!1,detachable:!0,closable:!0,autofocus:!0,context:"body",duration:500,easing:"easeOutExpo",offset:0,transition:"scale",padding:30,onShow:function(){},onHide:function(){},onVisible:function(){},onHidden:function(){},onApprove:function(){return!0},onDeny:function(){return!0},selector:{close:".close, .actions .button",approve:".actions .positive, .actions .approve, .actions .ok",deny:".actions .negative, .actions .deny, .actions .cancel",modal:".ui.modal"},error:{dimmer:"UI Dimmer, a required component is not included in this page",method:"The method you called is not defined.",notFound:"The element you specified could not be found"},className:{active:"active",scrolling:"scrolling"}}}(jQuery,window,document),function(e,t,n,i){"use strict";e.fn.nag=function(n){var o,a=e(this),r=a.selector||"",s=(new Date).getTime(),c=[],l=arguments[0],u="string"==typeof l,d=[].slice.call(arguments,1);return a.each(function(){{var a,m=e.isPlainObject(n)?e.extend(!0,{},e.fn.nag.settings,n):e.extend({},e.fn.nag.settings),f=(m.className,m.selector),g=m.error,p=m.namespace,b="."+p,v=p+"-module",h=e(this),y=h.find(f.close),x=e(m.context?m.context:"body"),w=this,C=h.data(v);t.requestAnimationFrame||t.mozRequestAnimationFrame||t.webkitRequestAnimationFrame||t.msRequestAnimationFrame||function(e){setTimeout(e,0)}}a={initialize:function(){a.verbose("Initializing element"),h.data(v,a),y.on("click"+b,a.dismiss),m.detachable&&h.parent()[0]!==x[0]&&h.detach().prependTo(x),m.displayTime>0&&setTimeout(a.hide,m.displayTime),a.show()},destroy:function(){a.verbose("Destroying instance"),h.removeData(v).off(b)},show:function(){a.should.show()&&!h.is(":visible")&&(a.debug("Showing nag",m.animation.show),"fade"==m.animation.show?h.fadeIn(m.duration,m.easing):h.slideDown(m.duration,m.easing))},hide:function(){a.debug("Showing nag",m.animation.hide),"fade"==m.animation.show?h.fadeIn(m.duration,m.easing):h.slideUp(m.duration,m.easing)},onHide:function(){a.debug("Removing nag",m.animation.hide),h.remove(),m.onHide&&m.onHide()},dismiss:function(e){m.storageMethod&&a.storage.set(m.key,m.value),a.hide(),e.stopImmediatePropagation(),e.preventDefault()},should:{show:function(){return m.persist?(a.debug("Persistent nag is set, can show nag"),!0):a.storage.get(m.key)!=m.value.toString()?(a.debug("Stored value is not set, can show nag",a.storage.get(m.key)),!0):(a.debug("Stored value is set, cannot show nag",a.storage.get(m.key)),!1)}},get:{storageOptions:function(){var e={};return m.expires&&(e.expires=m.expires),m.domain&&(e.domain=m.domain),m.path&&(e.path=m.path),e}},clear:function(){a.storage.remove(m.key)},storage:{set:function(n,o){var r=a.get.storageOptions();if("localstorage"==m.storageMethod&&t.localStorage!==i)t.localStorage.setItem(n,o),a.debug("Value stored using local storage",n,o);else{if(e.cookie===i)return void a.error(g.noCookieStorage);e.cookie(n,o,r),a.debug("Value stored using cookie",n,o,r)}},get:function(n){var o;return"localstorage"==m.storageMethod&&t.localStorage!==i?o=t.localStorage.getItem(n):e.cookie!==i?o=e.cookie(n):a.error(g.noCookieStorage),("undefined"==o||"null"==o||o===i||null===o)&&(o=i),o},remove:function(n){var o=a.get.storageOptions();"local"==m.storageMethod&&t.store!==i?t.localStorage.removeItem(n):e.cookie!==i?e.removeCookie(n,o):a.error(g.noStorage)}},setting:function(t,n){if(a.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,m,t);else{if(n===i)return m[t];m[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,a,t);else{if(n===i)return a[t];a[t]=n}},debug:function(){m.debug&&(m.performance?a.performance.log(arguments):(a.debug=Function.prototype.bind.call(console.info,console,m.name+":"),a.debug.apply(console,arguments)))},verbose:function(){m.verbose&&m.debug&&(m.performance?a.performance.log(arguments):(a.verbose=Function.prototype.bind.call(console.info,console,m.name+":"),a.verbose.apply(console,arguments)))},error:function(){a.error=Function.prototype.bind.call(console.error,console,m.name+":"),a.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;m.performance&&(t=(new Date).getTime(),i=s||t,n=t-i,s=t,c.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:w,"Execution Time":n})),clearTimeout(a.performance.timer),a.performance.timer=setTimeout(a.performance.display,100)},display:function(){var t=m.name+":",n=0;s=!1,clearTimeout(a.performance.timer),e.each(c,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",r&&(t+=" '"+r+"'"),(console.group!==i||console.table!==i)&&c.length>0&&(console.groupCollapsed(t),console.table?console.table(c):e.each(c,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),c=[]}},invoke:function(t,n,r){var s,c,l,u=C;return n=n||d,r=w||r,"string"==typeof t&&u!==i&&(t=t.split(/[\. ]/),s=t.length-1,e.each(t,function(n,o){var r=n!=s?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(u[r])&&n!=s)u=u[r];else{if(u[r]!==i)return c=u[r],!1;if(!e.isPlainObject(u[o])||n==s)return u[o]!==i?(c=u[o],!1):(a.error(g.method,t),!1);u=u[o]}})),e.isFunction(c)?l=c.apply(r,n):c!==i&&(l=c),e.isArray(o)?o.push(l):o!==i?o=[o,l]:l!==i&&(o=l),c}},u?(C===i&&a.initialize(),a.invoke(l)):(C!==i&&a.destroy(),a.initialize())}),o!==i?o:this},e.fn.nag.settings={name:"Nag",debug:!1,verbose:!0,performance:!0,namespace:"Nag",persist:!1,displayTime:0,animation:{show:"slide",hide:"slide"},context:!1,detachable:!1,expires:30,domain:!1,path:"/",storageMethod:"cookie",key:"nag",value:"dismiss",error:{noStorage:"Neither $.cookie or store is defined. A storage solution is required for storing state",method:"The method you called is not defined."},className:{bottom:"bottom",fixed:"fixed"},selector:{close:".close.icon"},speed:500,easing:"easeOutQuad",onHide:function(){}}}(jQuery,window,document),function(e,t,n,i){"use strict";e.fn.popup=function(o){var a,r=e(this),s=e(n),c=r.selector||"",l=("ontouchstart"in n.documentElement,(new Date).getTime()),u=[],d=arguments[0],m="string"==typeof d,f=[].slice.call(arguments,1);return r.each(function(){var n,r,g,p=e.isPlainObject(o)?e.extend(!0,{},e.fn.popup.settings,o):e.extend({},e.fn.popup.settings),b=p.selector,v=p.className,h=p.error,y=p.metadata,x=p.namespace,w="."+p.namespace,C="module-"+x,T=e(this),k=e(p.context),S=p.target?e(p.target):T,A=e(t),z=e("body"),P=0,E=!1,F=this,O=T.data(C);g={initialize:function(){g.debug("Initializing module",T),g.refresh(),"click"==p.on?T.on("click"+w,g.toggle):g.get.startEvent()&&T.on(g.get.startEvent()+w,g.event.start).on(g.get.endEvent()+w,g.event.end),p.target&&g.debug("Target set to element",S),A.on("resize"+w,g.event.resize),g.exists()?p.hoverable&&g.bind.popup():g.create(),g.instantiate()},instantiate:function(){g.verbose("Storing instance of module",g),O=g,T.data(C,O)},refresh:function(){p.popup?n=e(p.popup):p.inline&&(n=S.next(p.selector.popup)),p.popup?(n.addClass(v.loading),r=n.offsetParent(),n.removeClass(v.loading)):r=p.inline?S.offsetParent():z,r.is("html")&&(g.debug("Page is popups offset parent"),r=z)},reposition:function(){g.refresh(),g.set.position()},destroy:function(){g.debug("Destroying previous module"),n&&!p.preserve&&g.removePopup(),T.off(w).removeData(C)},event:{start:function(){var t=e.isPlainObject(p.delay)?p.delay.show:p.delay;clearTimeout(g.hideTimer),g.showTimer=setTimeout(function(){!g.is.hidden()||g.is.active()&&g.is.dropdown()||g.show()},t)},end:function(){var t=e.isPlainObject(p.delay)?p.delay.hide:p.delay;clearTimeout(g.showTimer),g.hideTimer=setTimeout(function(){g.is.visible()&&g.hide()},t)},resize:function(){g.is.visible()&&g.set.position()}},create:function(){var t=T.data(y.html)||p.html,i=T.data(y.variation)||p.variation,o=T.data(y.title)||p.title,a=T.data(y.content)||T.attr("title")||p.content;t||a||o?(g.debug("Creating pop-up html"),t||(t=p.templates.popup({title:o,content:a})),n=e("<div/>").addClass(v.popup).addClass(i).html(t),i&&n.addClass(i),p.inline?(g.verbose("Inserting popup element inline",n),n.insertAfter(T)):(g.verbose("Appending popup element to body",n),n.appendTo(k)),p.hoverable&&g.bind.popup(),e.proxy(p.onCreate,n)(F)):0!==S.next(p.selector.popup).size()?(g.verbose("Pre-existing popup found, reverting to inline"),p.inline=!0,g.refresh(),p.hoverable&&g.bind.popup()):g.debug("No content specified skipping display",F)},toggle:function(){g.debug("Toggling pop-up"),g.is.hidden()?(g.debug("Popup is hidden, showing pop-up"),g.unbind.close(),g.hideAll(),g.show()):(g.debug("Popup is visible, hiding pop-up"),g.hide())},show:function(t){t=e.isFunction(t)?t:function(){},g.debug("Showing pop-up",p.transition),p.preserve||p.popup||g.refresh(),g.exists()||g.create(),n&&g.set.position()&&(g.save.conditions(),g.animate.show(t))},hide:function(t){t=e.isFunction(t)?t:function(){},g.remove.visible(),g.unbind.close(),g.is.visible()&&(g.restore.conditions(),g.animate.hide(t))},hideAll:function(){e(b.popup).filter(":visible").popup("hide")},hideGracefully:function(t){t&&0===e(t.target).closest(b.popup).size()?(g.debug("Click occurred outside popup hiding popup"),g.hide()):g.debug("Click was inside popup, keeping popup open")},exists:function(){return n?p.inline||p.popup?0!==n.size():n.closest(k).size():!1},removePopup:function(){g.debug("Removing popup"),e.proxy(p.onRemove,n)(F),n.remove()},save:{conditions:function(){g.cache={title:T.attr("title")},g.cache.title&&T.removeAttr("title"),g.verbose("Saving original attributes",g.cache.title)}},restore:{conditions:function(){return F.blur(),g.cache&&g.cache.title&&(T.attr("title",g.cache.title),g.verbose("Restoring original attributes",g.cache.title)),!0}},animate:{show:function(t){t=e.isFunction(t)?t:function(){},p.transition&&e.fn.transition!==i&&T.transition("is supported")?(g.set.visible(),n.transition({animation:p.transition+" in",queue:!1,debug:p.debug,verbose:p.verbose,duration:p.duration,onComplete:function(){g.bind.close(),e.proxy(t,n)(F),e.proxy(p.onVisible,n)(F)}})):(g.set.visible(),n.stop().fadeIn(p.duration,p.easing,function(){g.bind.close(),e.proxy(t,F)()})),e.proxy(p.onShow,n)(F)},hide:function(t){t=e.isFunction(t)?t:function(){},g.debug("Hiding pop-up"),p.transition&&e.fn.transition!==i&&T.transition("is supported")?n.transition({animation:p.transition+" out",queue:!1,duration:p.duration,debug:p.debug,verbose:p.verbose,onComplete:function(){g.reset(),e.proxy(t,n)(F),e.proxy(p.onHidden,n)(F)}}):n.stop().fadeOut(p.duration,p.easing,function(){g.reset(),t()}),e.proxy(p.onHide,n)(F)}},get:{startEvent:function(){return"hover"==p.on?"mouseenter":"focus"==p.on?"focus":!1},endEvent:function(){return"hover"==p.on?"mouseleave":"focus"==p.on?"blur":!1},offstagePosition:function(i){var i=i||!1,o={top:e(t).scrollTop(),bottom:e(t).scrollTop()+e(t).height(),left:0,right:e(t).width()},a={width:n.width(),height:n.height(),offset:n.offset()},r={},s=[];return a.offset&&i&&(g.verbose("Checking if outside viewable area",a.offset),r={top:a.offset.top<o.top,bottom:a.offset.top+a.height>o.bottom,right:a.offset.left+a.width>o.right,left:a.offset.left<o.left}),e.each(r,function(e,t){t&&s.push(e)}),s.length>0?s.join(" "):!1},positions:function(){return{"top left":!1,"top center":!1,"top right":!1,"bottom left":!1,"bottom center":!1,"bottom right":!1,"left center":!1,"right center":!1}},nextPosition:function(e){var t=e.split(" "),n=t[0],i=t[1],o={top:"bottom",bottom:"top",left:"right",right:"left"},a={left:"center",center:"right",right:"left"},r={"top left":"top center","top center":"top right","top right":"right center","right center":"bottom right","bottom right":"bottom center","bottom center":"bottom left","bottom left":"left center","left center":"top left"},s="top"==n||"bottom"==n,c=!1,l=!1,u=!1;return E||(g.verbose("All available positions available"),E=g.get.positions()),g.debug("Recording last position tried",e),E[e]=!0,"opposite"===p.prefer&&(u=[o[n],i],u=u.join(" "),c=E[u]===!0,g.debug("Trying opposite strategy",u)),"adjacent"===p.prefer&&s&&(u=[n,a[i]],u=u.join(" "),l=E[u]===!0,g.debug("Trying adjacent strategy",u)),(l||c)&&(g.debug("Using backup position",u),u=r[e]),u}},set:{position:function(o,a){var s,c,l=(e(t).width(),e(t).height(),S.outerWidth()),u=S.outerHeight(),d=n.outerWidth(),m=n.outerHeight(),f=r.outerWidth(),b=r.outerHeight(),x=p.distanceAway,w=S[0],C=p.inline?parseInt(t.getComputedStyle(w).getPropertyValue("margin-top"),10):0,k=p.inline?parseInt(t.getComputedStyle(w).getPropertyValue("margin-left"),10):0,A=p.inline||p.popup?S.position():S.offset();switch(o=o||T.data(y.position)||p.position,a=a||T.data(y.offset)||p.offset,P==p.maxSearchDepth&&p.lastResort&&(g.debug("Using last resort position to display",p.lastResort),o=p.lastResort),p.inline&&(g.debug("Adding targets margin to calculation"),"left center"==o||"right center"==o?(a+=C,x+=-k):"top left"==o||"top center"==o||"top right"==o?(a+=k,x-=C):(a+=k,x+=C)),g.debug("Calculating popup positioning",o),o){case"top left":s={top:"auto",bottom:b-A.top+x,left:A.left+a,right:"auto"};break;case"top center":s={bottom:b-A.top+x,left:A.left+l/2-d/2+a,top:"auto",right:"auto"};break;case"top right":s={bottom:b-A.top+x,right:f-A.left-l-a,top:"auto",left:"auto"};break;case"left center":s={top:A.top+u/2-m/2+a,right:f-A.left+x,left:"auto",bottom:"auto"};break;case"right center":s={top:A.top+u/2-m/2+a,left:A.left+l+x,bottom:"auto",right:"auto"};break;case"bottom left":s={top:A.top+u+x,left:A.left+a,bottom:"auto",right:"auto"};break;case"bottom center":s={top:A.top+u+x,left:A.left+l/2-d/2+a,bottom:"auto",right:"auto"};break;case"bottom right":s={top:A.top+u+x,right:f-A.left-l-a,left:"auto",bottom:"auto"}}if(s===i&&g.error(h.invalidPosition,o),n.css(s).removeClass(v.position).addClass(o).addClass(v.loading),c=g.get.offstagePosition(o)){if(g.debug("Popup cant fit into viewport",c),P<p.maxSearchDepth)return P++,o=g.get.nextPosition(o),g.debug("Trying new position",o),n?g.set.position(o):!1;if(!p.lastResort)return g.debug("Popup could not find a position in view",n),g.error(h.cannotPlace),g.remove.attempts(),g.remove.loading(),g.reset(),!1}return g.debug("Position is on stage",o),g.remove.attempts(),g.set.fluidWidth(),g.remove.loading(),!0},fluidWidth:function(){p.setFluidWidth&&n.hasClass(v.fluid)&&n.css("width",r.width())},visible:function(){T.addClass(v.visible)}},remove:{loading:function(){n.removeClass(v.loading)},visible:function(){T.removeClass(v.visible)},attempts:function(){g.verbose("Resetting all searched positions"),P=0,E=!1}},bind:{popup:function(){g.verbose("Allowing hover events on popup to prevent closing"),n&&n.size()>0&&n.on("mouseenter"+w,g.event.start).on("mouseleave"+w,g.event.end)},close:function(){(p.hideOnScroll===!0||"auto"==p.hideOnScroll&&"click"!=p.on)&&(s.one("touchmove"+w,g.hideGracefully).one("scroll"+w,g.hideGracefully),k.one("touchmove"+w,g.hideGracefully).one("scroll"+w,g.hideGracefully)),"click"==p.on&&p.closable&&(g.verbose("Binding popup close event to document"),s.on("click"+w,function(t){g.verbose("Pop-up clickaway intent detected"),e.proxy(g.hideGracefully,F)(t)}))}},unbind:{close:function(){(p.hideOnScroll===!0||"auto"==p.hideOnScroll&&"click"!=p.on)&&(s.off("scroll"+w,g.hide),k.off("scroll"+w,g.hide)),"click"==p.on&&p.closable&&(g.verbose("Removing close event from document"),s.off("click"+w))}},is:{active:function(){return T.hasClass(v.active)},animating:function(){return n&&n.is(":animated")||n.hasClass(v.animating)},visible:function(){return n&&n.is(":visible")},dropdown:function(){return T.hasClass(v.dropdown)},hidden:function(){return!g.is.visible()}},reset:function(){g.remove.visible(),p.preserve||p.popup?e.fn.transition!==i&&n.transition("remove transition"):g.removePopup()},setting:function(t,n){if(e.isPlainObject(t))e.extend(!0,p,t);else{if(n===i)return p[t];p[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,g,t);else{if(n===i)return g[t];g[t]=n}},debug:function(){p.debug&&(p.performance?g.performance.log(arguments):(g.debug=Function.prototype.bind.call(console.info,console,p.name+":"),g.debug.apply(console,arguments)))},verbose:function(){p.verbose&&p.debug&&(p.performance?g.performance.log(arguments):(g.verbose=Function.prototype.bind.call(console.info,console,p.name+":"),g.verbose.apply(console,arguments)))},error:function(){g.error=Function.prototype.bind.call(console.error,console,p.name+":"),g.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;p.performance&&(t=(new Date).getTime(),i=l||t,n=t-i,l=t,u.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:F,"Execution Time":n})),clearTimeout(g.performance.timer),g.performance.timer=setTimeout(g.performance.display,100)},display:function(){var t=p.name+":",n=0;l=!1,clearTimeout(g.performance.timer),e.each(u,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",c&&(t+=" '"+c+"'"),(console.group!==i||console.table!==i)&&u.length>0&&(console.groupCollapsed(t),console.table?console.table(u):e.each(u,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),u=[]}},invoke:function(t,n,o){var r,s,c,l=O;return n=n||f,o=F||o,"string"==typeof t&&l!==i&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(n,o){var a=n!=r?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[a])&&n!=r)l=l[a];else{if(l[a]!==i)return s=l[a],!1;if(!e.isPlainObject(l[o])||n==r)return l[o]!==i?(s=l[o],!1):!1;l=l[o]}})),e.isFunction(s)?c=s.apply(o,n):s!==i&&(c=s),e.isArray(a)?a.push(c):a!==i?a=[a,c]:c!==i&&(a=c),s}},m?(O===i&&g.initialize(),g.invoke(d)):(O!==i&&g.destroy(),g.initialize())}),a!==i?a:this},e.fn.popup.settings={name:"Popup",debug:!1,verbose:!0,performance:!0,namespace:"popup",onCreate:function(){},onRemove:function(){},onShow:function(){},onVisible:function(){},onHide:function(){},onHidden:function(){},variation:"",content:!1,html:!1,title:!1,on:"hover",closable:!0,hideOnScroll:"auto",context:"body",position:"top left",prefer:"opposite",lastResort:!1,delay:{show:30,hide:0},setFluidWidth:!0,target:!1,popup:!1,inline:!1,preserve:!0,hoverable:!1,duration:200,easing:"easeOutQuint",transition:"scale",distanceAway:0,offset:0,maxSearchDepth:20,error:{invalidPosition:"The position you specified is not a valid position",cannotPlace:"No visible position could be found for the popup",method:"The method you called is not defined."},metadata:{content:"content",html:"html",offset:"offset",position:"position",title:"title",variation:"variation"},className:{active:"active",animating:"animating",dropdown:"dropdown",fluid:"fluid",loading:"loading",popup:"ui popup",position:"top left center bottom right",visible:"visible"},selector:{popup:".ui.popup"},templates:{escape:function(e){var t=/[&<>"'`]/g,n=/[&<>"'`]/,i={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},o=function(e){return i[e]};return n.test(e)?e.replace(t,o):e},popup:function(t){var n="",o=e.fn.popup.settings.templates.escape;return typeof t!==i&&(typeof t.title!==i&&t.title&&(t.title=o(t.title),n+='<div class="header">'+t.title+"</div>"),typeof t.content!==i&&t.content&&(t.content=o(t.content),n+='<div class="content">'+t.content+"</div>")),n}}},e.extend(e.easing,{easeOutQuad:function(e,t,n,i,o){return-i*(t/=o)*(t-2)+n}})}(jQuery,window,document),function(e,t,n,i){"use strict";e.fn.progress=function(t){var n,o=e(this),a=o.selector||"",r=(new Date).getTime(),s=[],c=arguments[0],l="string"==typeof c,u=[].slice.call(arguments,1);return o.each(function(){var o,d=e.isPlainObject(t)?e.extend(!0,{},e.fn.progress.settings,t):e.extend({},e.fn.progress.settings),m=d.className,f=d.metadata,g=d.namespace,p=d.selector,b=d.error,v="module-"+g,h=e(this),y=e(this).find(p.bar),x=e(this).find(p.progress),w=e(this).find(p.label),C=this,T=h.data(v);o={initialize:function(){o.debug("Initializing progress",d),o.read.metadata(),o.set.initials(),o.instantiate()},instantiate:function(){o.verbose("Storing instance of progress",o),T=o,h.data(v,o)},destroy:function(){o.verbose("Destroying previous dropdown for",h),h.removeData(v),T=i},reset:function(){o.set.percent(0)},complete:function(){(o.percent===i||o.percent<100)&&o.set.percent(100)},read:{metadata:function(){h.data(f.percent)&&(o.verbose("Current percent value set from metadata"),o.percent=h.data(f.percent)),h.data(f.total)&&(o.verbose("Total value set from metadata"),o.total=h.data(f.total)),h.data(f.value)&&(o.verbose("Current value set from metadata"),o.value=h.data(f.value))},currentValue:function(){return o.value!==i?o.value:!1}},increment:function(e){var t,n,i,a=o.total||!1;a?(n=o.value||0,e=e||1,i=n+e,t=o.total,o.debug("Incrementing value by",e,n,t),i>t&&(o.debug("Value cannot increment above total",t),i=t),o.set.progress(i)):(n=o.percent||0,e=e||o.get.randomValue(),i=n+e,t=100,o.debug("Incrementing percentage by",e,n),i>t&&(o.debug("Value cannot increment above 100 percent"),i=t),o.set.progress(i))},decrement:function(e){var t,n,i=o.total||!1,a=0;i?(t=o.value||0,e=e||1,n=t-e,o.debug("Decrementing value by",e,t)):(t=o.percent||0,e=e||o.get.randomValue(),n=t-e,o.debug("Decrementing percentage by",e,t)),a>n&&(o.debug("Value cannot decrement below 0"),n=0),o.set.progress(n)},get:{text:function(e){var t=o.value||0,n=o.total||0,i=o.percent||0;return e=e||"",e=e.replace("{value}",t).replace("{total}",n).replace("{percent}",i),o.debug("Adding variables to progress bar text",e),e},randomValue:function(){return o.debug("Generating random increment percentage"),Math.floor(Math.random()*d.random.max+d.random.min)},percent:function(){return o.percent||0},value:function(){return o.value||!1},total:function(){return o.total||!1}},is:{success:function(){return h.hasClass(m.success)},warning:function(){return h.hasClass(m.warning)},error:function(){return h.hasClass(m.error)}},remove:{active:function(){o.verbose("Removing active state"),h.removeClass(m.active)},success:function(){o.verbose("Removing success state"),h.removeClass(m.success)},warning:function(){o.verbose("Removing warning state"),h.removeClass(m.warning)},error:function(){o.verbose("Removing error state"),h.removeClass(m.error)}},set:{barWidth:function(e){e>100&&o.error(b.tooHigh,e),y.css("width",e+"%")},initials:function(){d.value&&(o.verbose("Current value set in settings",d.value),o.value=d.value),d.total&&(o.verbose("Current total set in settings",d.total),o.total=d.total),d.percent&&(o.verbose("Current percent set in settings",d.percent),o.percent=d.percent),o.percent?o.set.percent(o.percent):o.value&&o.set.progress(o.value)},percent:function(t){t="string"==typeof t?+t.replace("%",""):t,t>0&&1>t&&(o.verbose("Module percentage passed as decimal, converting"),t=100*t),t=Math.round(0===d.precision?t:10*t*d.precision/(10*d.precision)),o.percent=t,o.total&&(o.value=Math.round(t/100*o.total)),o.set.barWidth(t),o.set.barLabel(),100===t?!d.autoSuccess||o.is.warning()||o.is.error()?o.remove.active():(o.set.success(),o.debug("Automatically triggering success at 100%")):o.set.active(),e.proxy(d.onChange,C)(t,o.value,o.total)},label:function(e){e=e||"",e&&(e=o.get.text(e),o.debug("Setting label to text",e),w.text(e))},barLabel:function(e){e!==i?x.text(o.get.text(e)):"ratio"==d.label&&o.total?(o.debug("Adding ratio to bar label"),x.text(o.get.text(d.text.ratio))):"percent"==d.label&&(o.debug("Adding percentage to bar label"),x.text(o.get.text(d.text.percent)))},active:function(t){t=t||d.text.active,o.debug("Setting active state"),d.showActivity&&h.addClass(m.active),o.remove.warning(),o.remove.error(),o.remove.success(),t&&o.set.label(t),e.proxy(d.onActive,C)(o.value,o.total)},success:function(t){t=t||d.text.success,o.debug("Setting success state"),h.addClass(m.success),o.remove.active(),o.remove.warning(),o.remove.error(),o.complete(),t&&o.set.label(t),e.proxy(d.onSuccess,C)(o.total)},warning:function(t){t=t||d.text.warning,o.debug("Setting warning state"),h.addClass(m.warning),o.remove.active(),o.remove.success(),o.remove.error(),o.complete(),t&&o.set.label(t),e.proxy(d.onWarning,C)(o.value,o.total)},error:function(t){t=t||d.text.error,o.debug("Setting error state"),h.addClass(m.error),o.remove.active(),o.remove.success(),o.remove.warning(),o.complete(),t&&o.set.label(t),e.proxy(d.onError,C)(o.value,o.total)},total:function(e){o.total=e},progress:function(e){var t,n="string"==typeof e?""!==e.replace(/[^\d.]/g,"")?+e.replace(/[^\d.]/g,""):!1:e;n||o.error(b.nonNumeric),o.total?(o.value=n,t=n/o.total*100,o.debug("Calculating percent complete from total",t),o.set.percent(t)):(t=n,o.debug("Setting value to exact percentage value",t),o.set.percent(t))}},setting:function(t,n){if(o.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,d,t);else{if(n===i)return d[t];d[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,o,t);else{if(n===i)return o[t];o[t]=n}},debug:function(){d.debug&&(d.performance?o.performance.log(arguments):(o.debug=Function.prototype.bind.call(console.info,console,d.name+":"),o.debug.apply(console,arguments)))},verbose:function(){d.verbose&&d.debug&&(d.performance?o.performance.log(arguments):(o.verbose=Function.prototype.bind.call(console.info,console,d.name+":"),o.verbose.apply(console,arguments)))},error:function(){o.error=Function.prototype.bind.call(console.error,console,d.name+":"),o.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;d.performance&&(t=(new Date).getTime(),i=r||t,n=t-i,r=t,s.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:C,"Execution Time":n})),clearTimeout(o.performance.timer),o.performance.timer=setTimeout(o.performance.display,100)},display:function(){var t=d.name+":",n=0;r=!1,clearTimeout(o.performance.timer),e.each(s,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",a&&(t+=" '"+a+"'"),(console.group!==i||console.table!==i)&&s.length>0&&(console.groupCollapsed(t),console.table?console.table(s):e.each(s,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),s=[]}},invoke:function(t,a,r){var s,c,l,d=T;return a=a||u,r=C||r,"string"==typeof t&&d!==i&&(t=t.split(/[\. ]/),s=t.length-1,e.each(t,function(n,a){var r=n!=s?a+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(d[r])&&n!=s)d=d[r];else{if(d[r]!==i)return c=d[r],!1;if(!e.isPlainObject(d[a])||n==s)return d[a]!==i?(c=d[a],!1):(o.error(b.method,t),!1);d=d[a]}})),e.isFunction(c)?l=c.apply(r,a):c!==i&&(l=c),e.isArray(n)?n.push(l):n!==i?n=[n,l]:l!==i&&(n=l),c}},l?(T===i&&o.initialize(),o.invoke(c)):(T!==i&&o.destroy(),o.initialize())}),n!==i?n:this},e.fn.progress.settings={name:"Progress",namespace:"progress",debug:!0,verbose:!0,performance:!0,random:{min:2,max:5},autoSuccess:!0,showActivity:!0,label:"percent",precision:1,percent:!1,total:!1,value:!1,onChange:function(){},onSuccess:function(){},onActive:function(){},onError:function(){},onWarning:function(){},error:{method:"The method you called is not defined.",nonNumeric:"Progress value is non numeric"},regExp:{variable:/\{\$*[A-z0-9]+\}/g},metadata:{percent:"percent",total:"total",value:"value"},selector:{bar:"> .bar",label:"> .label",progress:".bar > .progress"},text:{active:!1,error:!1,success:!1,warning:!1,percent:"{percent}%",ratio:"{value} of {total}"},className:{active:"active",error:"error",success:"success",warning:"warning"}}}(jQuery,window,document),function(e,t,n,i){"use strict";e.fn.rating=function(t){var n,o=e(this),a=o.selector||"",r=(new Date).getTime(),s=[],c=arguments[0],l="string"==typeof c,u=[].slice.call(arguments,1);return o.each(function(){var d,m=e.isPlainObject(t)?e.extend(!0,{},e.fn.rating.settings,t):e.extend({},e.fn.rating.settings),f=m.namespace,g=m.className,p=m.metadata,b=m.selector,v=(m.error,"."+f),h="module-"+f,y=this,x=e(this).data(h),w=e(this),C=w.find(b.icon);d={initialize:function(){d.verbose("Initializing rating module",m),0===C.size()&&d.setup.layout(),m.interactive?d.enable():d.disable(),m.initialRating&&(d.debug("Setting initial rating"),d.setRating(m.initialRating)),w.data(p.rating)&&(d.debug("Rating found in metadata"),d.setRating(w.data(p.rating))),d.instantiate()},instantiate:function(){d.verbose("Instantiating module",m),x=d,w.data(h,d)},destroy:function(){d.verbose("Destroying previous instance",x),w.removeData(h),C.off(v)},refresh:function(){C=w.find(b.icon)},setup:{layout:function(){var t=w.data(p.maxRating)||m.maxRating;d.debug("Generating icon html dynamically"),w.html(e.fn.rating.settings.templates.icon(t)),d.refresh()}},event:{mouseenter:function(){var t=e(this);t.nextAll().removeClass(g.selected),w.addClass(g.selected),t.addClass(g.selected).prevAll().addClass(g.selected)},mouseleave:function(){w.removeClass(g.selected),C.removeClass(g.selected)},click:function(){var t=e(this),n=d.getRating(),i=C.index(t)+1,o="auto"==m.clearable?1===C.size():m.clearable;o&&n==i?d.clearRating():d.setRating(i)}},clearRating:function(){d.debug("Clearing current rating"),d.setRating(0)},getRating:function(){var e=C.filter("."+g.active).size();return d.verbose("Current rating retrieved",e),e},enable:function(){d.debug("Setting rating to interactive mode"),C.on("mouseenter"+v,d.event.mouseenter).on("mouseleave"+v,d.event.mouseleave).on("click"+v,d.event.click),w.removeClass(g.disabled)
},disable:function(){d.debug("Setting rating to read-only mode"),C.off(v),w.addClass(g.disabled)},setRating:function(t){var n=t-1>=0?t-1:0,i=C.eq(n);w.removeClass(g.selected),C.removeClass(g.selected).removeClass(g.active),t>0&&(d.verbose("Setting current rating to",t),i.prevAll().andSelf().addClass(g.active)),e.proxy(m.onRate,y)(t)},setting:function(t,n){if(d.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,m,t);else{if(n===i)return m[t];m[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,d,t);else{if(n===i)return d[t];d[t]=n}},debug:function(){m.debug&&(m.performance?d.performance.log(arguments):(d.debug=Function.prototype.bind.call(console.info,console,m.name+":"),d.debug.apply(console,arguments)))},verbose:function(){m.verbose&&m.debug&&(m.performance?d.performance.log(arguments):(d.verbose=Function.prototype.bind.call(console.info,console,m.name+":"),d.verbose.apply(console,arguments)))},error:function(){d.error=Function.prototype.bind.call(console.error,console,m.name+":"),d.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;m.performance&&(t=(new Date).getTime(),i=r||t,n=t-i,r=t,s.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:y,"Execution Time":n})),clearTimeout(d.performance.timer),d.performance.timer=setTimeout(d.performance.display,100)},display:function(){var t=m.name+":",n=0;r=!1,clearTimeout(d.performance.timer),e.each(s,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",a&&(t+=" '"+a+"'"),o.size()>1&&(t+=" ("+o.size()+")"),(console.group!==i||console.table!==i)&&s.length>0&&(console.groupCollapsed(t),console.table?console.table(s):e.each(s,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),s=[]}},invoke:function(t,o,a){var r,s,c,l=x;return o=o||u,a=y||a,"string"==typeof t&&l!==i&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(n,o){var a=n!=r?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[a])&&n!=r)l=l[a];else{if(l[a]!==i)return s=l[a],!1;if(!e.isPlainObject(l[o])||n==r)return l[o]!==i?(s=l[o],!1):!1;l=l[o]}})),e.isFunction(s)?c=s.apply(a,o):s!==i&&(c=s),e.isArray(n)?n.push(c):n!==i?n=[n,c]:c!==i&&(n=c),s}},l?(x===i&&d.initialize(),d.invoke(c)):(x!==i&&d.destroy(),d.initialize())}),n!==i?n:this},e.fn.rating.settings={name:"Rating",namespace:"rating",debug:!1,verbose:!0,performance:!0,initialRating:0,interactive:!0,maxRating:4,clearable:"auto",onRate:function(){},error:{method:"The method you called is not defined",noMaximum:"No maximum rating specified. Cannot generate HTML automatically"},metadata:{rating:"rating",maxRating:"maxRating"},className:{active:"active",disabled:"disabled",selected:"selected",loading:"loading"},selector:{icon:".icon"},templates:{icon:function(e){for(var t=1,n="";e>=t;)n+='<i class="icon"></i>',t++;return n}}}}(jQuery,window,document),function(e,t,n,i){"use strict";e.fn.search=function(n){var o,a=e(this),r=a.selector||"",s=(new Date).getTime(),c=[],l=arguments[0],u="string"==typeof l,d=[].slice.call(arguments,1);return e(this).each(function(){var m,f=e.extend(!0,{},e.fn.search.settings,n),g=f.className,p=f.selector,b=f.error,v=f.namespace,h="."+v,y=v+"-module",x=e(this),w=x.find(p.prompt),C=x.find(p.searchButton),T=x.find(p.results),k=(x.find(p.result),x.find(p.category),this),S=x.data(y);m={initialize:function(){m.verbose("Initializing module");var e=w[0],t=e!==i&&e.oninput!==i?"input":e!==i&&e.onpropertychange!==i?"propertychange":"keyup";f.automatic&&w.on(t+h,m.search.throttle),w.on("focus"+h,m.event.focus).on("blur"+h,m.event.blur).on("keydown"+h,m.handleKeyboard),C.on("click"+h,m.search.query),T.on("mousedown"+h,m.event.mousedown).on("mouseup"+h,m.event.mouseup).on("click"+h,p.result,m.results.select),m.instantiate()},instantiate:function(){m.verbose("Storing instance of module",m),S=m,x.data(y,m)},destroy:function(){m.verbose("Destroying instance"),x.removeData(y),w.off(h),C.off(h),T.off(h)},event:{focus:function(){x.addClass(g.focus),clearTimeout(m.timer),m.search.throttle(),m.has.minimum()&&m.results.show()},mousedown:function(){m.resultsClicked=!0},mouseup:function(){m.resultsClicked=!1},blur:function(){m.search.cancel(),x.removeClass(g.focus),m.resultsClicked||(m.timer=setTimeout(m.results.hide,f.hideDelay))}},handleKeyboard:function(t){var n,i=x.find(p.result),o=x.find(p.category),a=t.which,r={backspace:8,enter:13,escape:27,upArrow:38,downArrow:40},s=g.active,c=i.index(i.filter("."+s)),l=i.size();if(a==r.escape&&(m.verbose("Escape key pressed, blurring search field"),w.trigger("blur")),T.filter(":visible").size()>0)if(a==r.enter){if(m.verbose("Enter key pressed, selecting active result"),i.filter("."+s).size()>0)return e.proxy(m.results.select,i.filter("."+s))(t),t.preventDefault(),!1}else a==r.upArrow?(m.verbose("Up key pressed, changing active result"),n=0>c-1?c:c-1,o.removeClass(s),i.removeClass(s).eq(n).addClass(s).closest(o).addClass(s),t.preventDefault()):a==r.downArrow&&(m.verbose("Down key pressed, changing active result"),n=c+1>=l?c:c+1,o.removeClass(s),i.removeClass(s).eq(n).addClass(s).closest(o).addClass(s),t.preventDefault());else a==r.enter&&(m.verbose("Enter key pressed, executing query"),m.search.query(),C.addClass(g.down),w.one("keyup",function(){C.removeClass(g.down)}))},has:{minimum:function(){var e=w.val(),t=e.length;return t>=f.minCharacters}},search:{cancel:function(){var e=x.data("xhr")||!1;e&&"resolved"!=e.state()&&(m.debug("Cancelling last search"),e.abort())},throttle:function(){clearTimeout(m.timer),m.has.minimum()?m.timer=setTimeout(m.search.query,f.searchDelay):m.results.hide()},query:function(){var t=w.val(),n=m.search.cache.read(t);n?(m.debug("Reading result for '"+t+"' from cache"),m.results.add(n)):(m.debug("Querying for '"+t+"'"),e.isPlainObject(f.source)||e.isArray(f.source)?m.search.local(t):f.apiSettings?m.search.remote(t):e.fn.api!==i&&e.api.settings.api.search!==i?(m.debug("Searching with default search API endpoint"),f.apiSettings={action:"search"},m.search.remote(t)):m.error(b.source),e.proxy(f.onSearchQuery,x)(t))},local:function(t){var n,i=[],o=[],a=e.isArray(f.searchFields)?f.searchFields:[f.searchFields],r=new RegExp("(?:s|^)"+t,"i"),s=new RegExp(t,"i");x.addClass(g.loading),e.each(a,function(t,n){e.each(f.source,function(t,a){var c="string"==typeof a[n],l=-1==e.inArray(a,i)&&-1==e.inArray(a,o);c&&l&&(r.test(a[n])?i.push(a):f.searchFullText&&s.test(a[n])&&o.push(a))})}),n=m.results.generate({results:e.merge(i,o)}),x.removeClass(g.loading),m.search.cache.write(t,n),m.results.add(n)},remote:function(t){var n,i={stateContext:x,urlData:{query:t},onSuccess:function(e){n=m.results.generate(e),m.search.cache.write(t,n),m.results.add(n)},onFailure:m.error};m.search.cancel(),m.debug("Executing search"),e.extend(!0,i,f.apiSettings),e.api(i)},cache:{read:function(e){var t=x.data("cache");return f.cache&&"object"==typeof t&&t[e]!==i?t[e]:!1},write:function(e,t){var n=x.data("cache")!==i?x.data("cache"):{};n[e]=t,x.data("cache",n)}}},results:{generate:function(t){m.debug("Generating html from response",t);var n=f.templates[f.type],i="";return e.isPlainObject(t.results)&&!e.isEmptyObject(t.results)||e.isArray(t.results)&&t.results.length>0?(f.maxResults>0&&(t.results=e.isArray(t.results)?t.results.slice(0,f.maxResults):t.results),e.isFunction(n)?i=n(t):m.error(b.noTemplate,!1)):i=m.message(b.noResults,"empty"),e.proxy(f.onResults,x)(t),i},add:function(t){("default"==f.onResultsAdd||"default"==e.proxy(f.onResultsAdd,T)(t))&&T.html(t),m.results.show()},show:function(){0===T.filter(":visible").size()&&w.filter(":focus").size()>0&&""!==T.html()&&(f.transition&&e.fn.transition!==i&&x.transition("is supported")&&!T.transition("is inward")?(m.debug("Showing results with css animations"),T.transition({animation:f.transition+" in",duration:f.duration,queue:!0})):(m.debug("Showing results with javascript"),T.stop().fadeIn(f.duration,f.easing)),e.proxy(f.onResultsOpen,T)())},hide:function(){T.filter(":visible").size()>0&&(f.transition&&e.fn.transition!==i&&x.transition("is supported")&&!T.transition("is outward")?(m.debug("Hiding results with css animations"),T.transition({animation:f.transition+" out",duration:f.duration,queue:!0})):(m.debug("Hiding results with javascript"),T.stop().fadeIn(f.duration,f.easing)),e.proxy(f.onResultsClose,T)())},select:function(n){m.debug("Search result selected");{var i=e(this),o=i.find(".title");o.html()}if("default"==f.onSelect||"default"==e.proxy(f.onSelect,this)(n)){var a=i.find("a[href]").eq(0),o=i.find(p.title).eq(0),r=a.attr("href")||!1,s=a.attr("target")||!1,c=o.size()>0?o.text():!1;m.results.hide(),c&&w.val(c),r&&("_blank"==s||n.ctrlKey?t.open(r):t.location.href=r)}}},message:function(e,t){return t=t||"standard",m.results.add(f.templates.message(e,t)),f.templates.message(e,t)},setting:function(t,n){if(e.isPlainObject(t))e.extend(!0,f,t);else{if(n===i)return f[t];f[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,m,t);else{if(n===i)return m[t];m[t]=n}},debug:function(){f.debug&&(f.performance?m.performance.log(arguments):(m.debug=Function.prototype.bind.call(console.info,console,f.name+":"),m.debug.apply(console,arguments)))},verbose:function(){f.verbose&&f.debug&&(f.performance?m.performance.log(arguments):(m.verbose=Function.prototype.bind.call(console.info,console,f.name+":"),m.verbose.apply(console,arguments)))},error:function(){m.error=Function.prototype.bind.call(console.error,console,f.name+":"),m.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;f.performance&&(t=(new Date).getTime(),i=s||t,n=t-i,s=t,c.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:k,"Execution Time":n})),clearTimeout(m.performance.timer),m.performance.timer=setTimeout(m.performance.display,100)},display:function(){var t=f.name+":",n=0;s=!1,clearTimeout(m.performance.timer),e.each(c,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",r&&(t+=" '"+r+"'"),a.size()>1&&(t+=" ("+a.size()+")"),(console.group!==i||console.table!==i)&&c.length>0&&(console.groupCollapsed(t),console.table?console.table(c):e.each(c,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),c=[]}},invoke:function(t,n,a){var r,s,c,l=S;return n=n||d,a=k||a,"string"==typeof t&&l!==i&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(n,o){var a=n!=r?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[a])&&n!=r)l=l[a];else{if(l[a]!==i)return s=l[a],!1;if(!e.isPlainObject(l[o])||n==r)return l[o]!==i?(s=l[o],!1):!1;l=l[o]}})),e.isFunction(s)?c=s.apply(a,n):s!==i&&(c=s),e.isArray(o)?o.push(c):o!==i?o=[o,c]:c!==i&&(o=c),s}},u?(S===i&&m.initialize(),m.invoke(l)):(S!==i&&m.destroy(),m.initialize())}),o!==i?o:this},e.fn.search.settings={name:"Search Module",namespace:"search",debug:!1,verbose:!0,performance:!0,apiSettings:!1,type:"standard",minCharacters:1,source:!1,searchFields:["title","description"],searchFullText:!0,automatic:"true",hideDelay:0,searchDelay:300,maxResults:7,cache:!0,transition:"scale",duration:300,easing:"easeOutExpo",onSelect:"default",onResultsAdd:"default",onSearchQuery:function(){},onResults:function(){},onResultsOpen:function(){},onResultsClose:function(){},className:{active:"active",down:"down",focus:"focus",empty:"empty",loading:"loading"},error:{source:"Cannot search. No source used, and Semantic API module was not included",noResults:"Your search returned no results",logging:"Error in debug logging, exiting.",noTemplate:"A valid template name was not specified.",serverError:"There was an issue with querying the server.",method:"The method you called is not defined."},selector:{prompt:".prompt",searchButton:".search.button",results:".results",category:".category",result:".result",title:".title, .name"},templates:{escape:function(e){var t=/[&<>"'`]/g,n=/[&<>"'`]/,i={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},o=function(e){return i[e]};return n.test(e)?e.replace(t,o):e},message:function(e,t){var n="";return e!==i&&t!==i&&(n+='<div class="message '+t+'">',n+="empty"==t?'<div class="header">No Results</div class="header"><div class="description">'+e+'</div class="description">':' <div class="description">'+e+"</div>",n+="</div>"),n},category:function(t){var n="",o=e.fn.search.settings.templates.escape;return t.results!==i?(e.each(t.results,function(t,a){a.results!==i&&a.results.length>0&&(n+='<div class="category"><div class="name">'+a.name+"</div>",e.each(a.results,function(e,t){n+='<div class="result">',t.url&&(n+='<a href="'+t.url+'"></a>'),t.image!==i&&(t.image=o(t.image),n+='<div class="image"> <img src="'+t.image+'" alt=""></div>'),n+='<div class="content">',t.price!==i&&(t.price=o(t.price),n+='<div class="price">'+t.price+"</div>"),t.title!==i&&(t.title=o(t.title),n+='<div class="title">'+t.title+"</div>"),t.description!==i&&(n+='<div class="description">'+t.description+"</div>"),n+="</div></div>"}),n+="</div>")}),t.action&&(n+='<a href="'+t.action.url+'" class="action">'+t.action.text+"</a>"),n):!1},standard:function(t){var n="";return t.results!==i?(e.each(t.results,function(e,t){n+=t.url?'<a class="result" href="'+t.url+'">':'<a class="result">',t.image!==i&&(n+='<div class="image"> <img src="'+t.image+'"></div>'),n+='<div class="content">',t.price!==i&&(n+='<div class="price">'+t.price+"</div>"),t.title!==i&&(n+='<div class="title">'+t.title+"</div>"),t.description!==i&&(n+='<div class="description">'+t.description+"</div>"),n+="</div>",n+="</a>"}),t.action&&(n+='<a href="'+t.action.url+'" class="action">'+t.action.text+"</a>"),n):!1}}}}(jQuery,window,document),function(e,t,n,i){"use strict";e.fn.shape=function(o){var a,r=e(this),s=(e("body"),(new Date).getTime()),c=[],l=arguments[0],u="string"==typeof l,d=[].slice.call(arguments,1),m=t.requestAnimationFrame||t.mozRequestAnimationFrame||t.webkitRequestAnimationFrame||t.msRequestAnimationFrame||function(e){setTimeout(e,0)};return r.each(function(){var t,f,g,p=r.selector||"",b=e.extend(!0,{},e.fn.shape.settings,o),v=b.namespace,h=b.selector,y=b.error,x=b.className,w="."+v,C="module-"+v,T=e(this),k=T.find(h.sides),S=T.find(h.side),A=!1,z=this,P=T.data(C);g={initialize:function(){g.verbose("Initializing module for",z),g.set.defaultSide(),g.instantiate()},instantiate:function(){g.verbose("Storing instance of module",g),P=g,T.data(C,P)},destroy:function(){g.verbose("Destroying previous module for",z),T.removeData(C).off(w)},refresh:function(){g.verbose("Refreshing selector cache for",z),T=e(z),k=e(this).find(h.shape),S=e(this).find(h.side)},repaint:function(){g.verbose("Forcing repaint event");{var e=k.get(0)||n.createElement("div");e.offsetWidth}},animate:function(n,o){g.verbose("Animating box with properties",n),o=o||function(e){g.verbose("Executing animation callback"),e!==i&&e.stopPropagation(),g.reset(),g.set.active()},e.proxy(b.beforeChange,f[0])(),g.get.transitionEvent()?(g.verbose("Starting CSS animation"),T.addClass(x.animating),k.css(n).one(g.get.transitionEvent(),o),g.set.duration(b.duration),m(function(){T.addClass(x.animating),t.addClass(x.hidden)})):o()},queue:function(e){g.debug("Queueing animation of",e),k.one(g.get.transitionEvent(),function(){g.debug("Executing queued animation"),setTimeout(function(){T.shape(e)},0)})},reset:function(){g.verbose("Animating states reset"),T.removeClass(x.animating).attr("style","").removeAttr("style"),k.attr("style","").removeAttr("style"),S.attr("style","").removeAttr("style").removeClass(x.hidden),f.removeClass(x.animating).attr("style","").removeAttr("style")},is:{complete:function(){return S.filter("."+x.active)[0]==f[0]},animating:function(){return T.hasClass(x.animating)}},set:{defaultSide:function(){t=T.find("."+b.className.active),f=t.next(h.side).size()>0?t.next(h.side):T.find(h.side).first(),A=!1,g.verbose("Active side set to",t),g.verbose("Next side set to",f)},duration:function(e){e=e||b.duration,e="number"==typeof e?e+"ms":e,g.verbose("Setting animation duration",e),k.add(S).css({"-webkit-transition-duration":e,"-moz-transition-duration":e,"-ms-transition-duration":e,"-o-transition-duration":e,"transition-duration":e})},stageSize:function(){var e=T.clone().addClass(x.loading),t=e.find("."+b.className.active),n=A?e.find(h.side).eq(A):t.next(h.side).size()>0?t.next(h.side):e.find(h.side).first(),i={};t.removeClass(x.active),n.addClass(x.active),e.insertAfter(T),i={width:n.outerWidth(),height:n.outerHeight()},e.remove(),T.css(i),g.verbose("Resizing stage to fit new content",i)},nextSide:function(e){A=e,f=S.filter(e),A=S.index(f),0===f.size()&&(g.set.defaultSide(),g.error(y.side)),g.verbose("Next side manually set to",f)},active:function(){g.verbose("Setting new side to active",f),S.removeClass(x.active),f.addClass(x.active),e.proxy(b.onChange,f[0])(),g.set.defaultSide()}},flip:{up:function(){return!g.is.complete()||g.is.animating()||b.allowRepeats?void(g.is.animating()?g.queue("flip up"):(g.debug("Flipping up",f),g.set.stageSize(),g.stage.above(),g.animate(g.get.transform.up()))):void g.debug("Side already visible",f)},down:function(){return!g.is.complete()||g.is.animating()||b.allowRepeats?void(g.is.animating()?g.queue("flip down"):(g.debug("Flipping down",f),g.set.stageSize(),g.stage.below(),g.animate(g.get.transform.down()))):void g.debug("Side already visible",f)},left:function(){return!g.is.complete()||g.is.animating()||b.allowRepeats?void(g.is.animating()?g.queue("flip left"):(g.debug("Flipping left",f),g.set.stageSize(),g.stage.left(),g.animate(g.get.transform.left()))):void g.debug("Side already visible",f)},right:function(){return!g.is.complete()||g.is.animating()||b.allowRepeats?void(g.is.animating()?g.queue("flip right"):(g.debug("Flipping right",f),g.set.stageSize(),g.stage.right(),g.animate(g.get.transform.right()))):void g.debug("Side already visible",f)},over:function(){return!g.is.complete()||g.is.animating()||b.allowRepeats?void(g.is.animating()?g.queue("flip over"):(g.debug("Flipping over",f),g.set.stageSize(),g.stage.behind(),g.animate(g.get.transform.over()))):void g.debug("Side already visible",f)},back:function(){return!g.is.complete()||g.is.animating()||b.allowRepeats?void(g.is.animating()?g.queue("flip back"):(g.debug("Flipping back",f),g.set.stageSize(),g.stage.behind(),g.animate(g.get.transform.back()))):void g.debug("Side already visible",f)}},get:{transform:{up:function(){var e={y:-((t.outerHeight()-f.outerHeight())/2),z:-(t.outerHeight()/2)};return{transform:"translateY("+e.y+"px) translateZ("+e.z+"px) rotateX(-90deg)"}},down:function(){var e={y:-((t.outerHeight()-f.outerHeight())/2),z:-(t.outerHeight()/2)};return{transform:"translateY("+e.y+"px) translateZ("+e.z+"px) rotateX(90deg)"}},left:function(){var e={x:-((t.outerWidth()-f.outerWidth())/2),z:-(t.outerWidth()/2)};return{transform:"translateX("+e.x+"px) translateZ("+e.z+"px) rotateY(90deg)"}},right:function(){var e={x:-((t.outerWidth()-f.outerWidth())/2),z:-(t.outerWidth()/2)};return{transform:"translateX("+e.x+"px) translateZ("+e.z+"px) rotateY(-90deg)"}},over:function(){var e={x:-((t.outerWidth()-f.outerWidth())/2)};return{transform:"translateX("+e.x+"px) rotateY(180deg)"}},back:function(){var e={x:-((t.outerWidth()-f.outerWidth())/2)};return{transform:"translateX("+e.x+"px) rotateY(-180deg)"}}},transitionEvent:function(){var e,t=n.createElement("element"),o={transition:"transitionend",OTransition:"oTransitionEnd",MozTransition:"transitionend",WebkitTransition:"webkitTransitionEnd"};for(e in o)if(t.style[e]!==i)return o[e]},nextSide:function(){return t.next(h.side).size()>0?t.next(h.side):T.find(h.side).first()}},stage:{above:function(){var e={origin:(t.outerHeight()-f.outerHeight())/2,depth:{active:f.outerHeight()/2,next:t.outerHeight()/2}};g.verbose("Setting the initial animation position as above",f,e),t.css({transform:"rotateY(0deg) translateZ("+e.depth.active+"px)"}),f.addClass(x.animating).css({display:"block",top:e.origin+"px",transform:"rotateX(90deg) translateZ("+e.depth.next+"px)"})},below:function(){var e={origin:(t.outerHeight()-f.outerHeight())/2,depth:{active:f.outerHeight()/2,next:t.outerHeight()/2}};g.verbose("Setting the initial animation position as below",f,e),t.css({transform:"rotateY(0deg) translateZ("+e.depth.active+"px)"}),f.addClass(x.animating).css({display:"block",top:e.origin+"px",transform:"rotateX(-90deg) translateZ("+e.depth.next+"px)"})},left:function(){var e={origin:(t.outerWidth()-f.outerWidth())/2,depth:{active:f.outerWidth()/2,next:t.outerWidth()/2}};g.verbose("Setting the initial animation position as left",f,e),t.css({transform:"rotateY(0deg) translateZ("+e.depth.active+"px)"}),f.addClass(x.animating).css({display:"block",left:e.origin+"px",transform:"rotateY(-90deg) translateZ("+e.depth.next+"px)"})},right:function(){var e={origin:(t.outerWidth()-f.outerWidth())/2,depth:{active:f.outerWidth()/2,next:t.outerWidth()/2}};g.verbose("Setting the initial animation position as left",f,e),t.css({transform:"rotateY(0deg) translateZ("+e.depth.active+"px)"}),f.addClass(x.animating).css({display:"block",left:e.origin+"px",transform:"rotateY(90deg) translateZ("+e.depth.next+"px)"})},behind:function(){var e={origin:(t.outerWidth()-f.outerWidth())/2,depth:{active:f.outerWidth()/2,next:t.outerWidth()/2}};g.verbose("Setting the initial animation position as behind",f,e),t.css({transform:"rotateY(0deg)"}),f.addClass(x.animating).css({display:"block",left:e.origin+"px",transform:"rotateY(-180deg)"})}},setting:function(t,n){if(g.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,b,t);else{if(n===i)return b[t];b[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,g,t);else{if(n===i)return g[t];g[t]=n}},debug:function(){b.debug&&(b.performance?g.performance.log(arguments):(g.debug=Function.prototype.bind.call(console.info,console,b.name+":"),g.debug.apply(console,arguments)))},verbose:function(){b.verbose&&b.debug&&(b.performance?g.performance.log(arguments):(g.verbose=Function.prototype.bind.call(console.info,console,b.name+":"),g.verbose.apply(console,arguments)))},error:function(){g.error=Function.prototype.bind.call(console.error,console,b.name+":"),g.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;b.performance&&(t=(new Date).getTime(),i=s||t,n=t-i,s=t,c.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:z,"Execution Time":n})),clearTimeout(g.performance.timer),g.performance.timer=setTimeout(g.performance.display,100)},display:function(){var t=b.name+":",n=0;s=!1,clearTimeout(g.performance.timer),e.each(c,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",p&&(t+=" '"+p+"'"),r.size()>1&&(t+=" ("+r.size()+")"),(console.group!==i||console.table!==i)&&c.length>0&&(console.groupCollapsed(t),console.table?console.table(c):e.each(c,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),c=[]}},invoke:function(t,n,o){var r,s,c,l=P;return n=n||d,o=z||o,"string"==typeof t&&l!==i&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(n,o){var a=n!=r?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[a])&&n!=r)l=l[a];else{if(l[a]!==i)return s=l[a],!1;if(!e.isPlainObject(l[o])||n==r)return l[o]!==i?(s=l[o],!1):!1;l=l[o]}})),e.isFunction(s)?c=s.apply(o,n):s!==i&&(c=s),e.isArray(a)?a.push(c):a!==i?a=[a,c]:c!==i&&(a=c),s}},u?(P===i&&g.initialize(),g.invoke(l)):(P!==i&&g.destroy(),g.initialize())}),a!==i?a:this},e.fn.shape.settings={name:"Shape",debug:!1,verbose:!0,performance:!0,namespace:"shape",beforeChange:function(){},onChange:function(){},allowRepeats:!1,duration:700,error:{side:"You tried to switch to a side that does not exist.",method:"The method you called is not defined"},className:{animating:"animating",hidden:"hidden",loading:"loading",active:"active"},selector:{sides:".sides",side:".side"}}}(jQuery,window,document),function(e,t,n,i){"use strict";e.fn.sidebar=function(o){var a,r=e(this),s=e("head"),c=r.selector||"",l=(new Date).getTime(),u=[],d=arguments[0],m="string"==typeof d,f=[].slice.call(arguments,1),g=t.requestAnimationFrame||t.mozRequestAnimationFrame||t.webkitRequestAnimationFrame||t.msRequestAnimationFrame||function(e){setTimeout(e,0)};return r.each(function(){var r,p,b,v,h=e.isPlainObject(o)?e.extend(!0,{},e.fn.sidebar.settings,o):e.extend({},e.fn.sidebar.settings),y=h.selector,x=h.className,w=h.namespace,C=h.error,T="."+w,k="module-"+w,S=e(this),A=e(h.context),z=S.children(y.sidebar),P=A.children(y.pusher),E=this,F=S.data(k);v={initialize:function(){v.debug("Initializing sidebar",o),b=v.get.transitionEvent(),(v.is.legacy()||h.legacy)&&(h.transition="overlay",h.useLegacy=!0),g(v.setup.layout),v.instantiate()},instantiate:function(){v.verbose("Storing instance of module",v),F=v,S.data(k,v)},destroy:function(){v.verbose("Destroying previous module for",S),v.remove.direction(),S.off(T).removeData(k)},event:{clickaway:function(t){0===e(t.target).closest(y.sidebar).size()&&(v.verbose("User clicked on dimmed page"),v.hide())},touch:function(){},containScroll:function(){E.scrollTop<=0&&(E.scrollTop=1),E.scrollTop+E.offsetHeight>=E.scrollHeight&&(E.scrollTop=E.scrollHeight-E.offsetHeight-1)},scroll:function(t){0===e(t.target).closest(y.sidebar).size()&&t.preventDefault()}},bind:{clickaway:function(){h.scrollLock&&e(t).on("DOMMouseScroll"+T,v.event.scroll),e(n).on("touchmove"+T,v.event.touch),S.on("scroll"+T,v.event.containScroll),h.closable&&A.on("click"+T,v.event.clickaway).on("touchend"+T,v.event.clickaway)}},unbind:{clickaway:function(){A.off(T),P.off(T),e(n).off(T),e(t).off(T)}},add:{bodyCSS:function(){var t,n=S.outerWidth(),i=S.outerHeight();t='<style title="'+w+'"> .ui.visible.left.sidebar ~ .fixed, .ui.visible.left.sidebar ~ .pusher {   -webkit-transform: translate3d('+n+"px, 0, 0);           transform: translate3d("+n+"px, 0, 0); } .ui.visible.right.sidebar ~ .fixed, .ui.visible.right.sidebar ~ .pusher {   -webkit-transform: translate3d(-"+n+"px, 0, 0);           transform: translate3d(-"+n+"px, 0, 0); } .ui.visible.left.sidebar ~ .ui.visible.right.sidebar ~ .fixed, .ui.visible.left.sidebar ~ .ui.visible.right.sidebar ~ .pusher, .ui.visible.right.sidebar ~ .ui.visible.left.sidebar ~ .fixed, .ui.visible.right.sidebar ~ .ui.visible.left.sidebar ~ .pusher {   -webkit-transform: translate3d(0px, 0, 0);           transform: translate3d(0px, 0, 0); } .ui.visible.top.sidebar ~ .fixed, .ui.visible.top.sidebar ~ .pusher {   -webkit-transform: translate3d(0, "+i+"px, 0);           transform: translate3d(0, "+i+"px, 0); } .ui.visible.bottom.sidebar ~ .fixed, .ui.visible.bottom.sidebar ~ .pusher {   -webkit-transform: translate3d(0, -"+i+"px, 0);           transform: translate3d(0, -"+i+"px, 0); }",v.is.ie()&&(t+=" .ui.visible.left.sidebar ~ .pusher:after {   -webkit-transform: translate3d("+n+"px, 0, 0);           transform: translate3d("+n+"px, 0, 0); } .ui.visible.right.sidebar ~ .pusher:after {   -webkit-transform: translate3d(-"+n+"px, 0, 0);           transform: translate3d(-"+n+"px, 0, 0); } .ui.visible.left.sidebar ~ .ui.visible.right.sidebar ~ .pusher:after, .ui.visible.right.sidebar ~ .ui.visible.left.sidebar ~ .pusher:after {   -webkit-transform: translate3d(0px, 0, 0);           transform: translate3d(0px, 0, 0); } .ui.visible.top.sidebar ~ .pusher:after {   -webkit-transform: translate3d(0, "+i+"px, 0);           transform: translate3d(0, "+i+"px, 0); } .ui.visible.bottom.sidebar ~ .pusher:after {   -webkit-transform: translate3d(0, -"+i+"px, 0);           transform: translate3d(0, -"+i+"px, 0); }"),t+="</style>",s.append(t),r=e("style[title="+w+"]"),v.debug("Adding sizing css to head",r)}},refresh:function(){v.verbose("Refreshing selector cache"),A=e(h.context),z=A.children(y.sidebar),P=A.children(y.pusher)},repaint:function(){v.verbose("Forcing repaint event"),E.style.display="none",E.offsetHeight,E.scrollTop=E.scrollTop,E.style.display=""},setup:{layout:function(){0===A.children(y.pusher).size()&&(v.debug("Adding wrapper element for sidebar"),v.error(C.pusher),P=e('<div class="pusher" />'),A.children().not(y.omitted).not(z).wrapAll(P),v.refresh()),(0==S.nextAll(y.pusher).size()||S.nextAll(y.pusher)[0]!==P[0])&&(v.debug("Moved sidebar to correct parent element"),v.error(C.movedSidebar,E),S.detach().prependTo(A),v.refresh()),v.set.pushable(),v.set.direction()}},attachEvents:function(t,n){var i=e(t);n=e.isFunction(v[n])?v[n]:v.toggle,i.size()>0?(v.debug("Attaching sidebar events to element",t,n),i.on("click"+T,n)):v.error(C.notFound,t)},show:function(t){var n=h.useLegacy?v.legacyPushPage:v.pushPage;t=e.isFunction(t)?t:function(){},v.is.closed()?(h.overlay&&(v.error(C.overlay),h.transition="overlay"),v.refresh(),v.othersVisible()&&"overlay"!=v.get.transition()&&(v.debug("Other sidebars currently open"),h.exclusive&&v.hideOthers()),n(function(){e.proxy(t,E)(),e.proxy(h.onShow,E)()}),e.proxy(h.onChange,E)(),e.proxy(h.onVisible,E)()):v.debug("Sidebar is already visible")},hide:function(t){var n=h.useLegacy?v.legacyPullPage:v.pullPage;t=e.isFunction(t)?t:function(){},(v.is.visible()||v.is.animating())&&(v.debug("Hiding sidebar",t),n(function(){e.proxy(t,E)(),e.proxy(h.onHidden,E)()}),e.proxy(h.onChange,E)(),e.proxy(h.onHide,E)())},othersVisible:function(){return z.not(S).filter("."+x.visible).size()>0},othersActive:function(){return z.not(S).filter("."+x.active).size()>0},hideOthers:function(e){var t=z.not(S).filter("."+x.visible),e=e||function(){},n=t.size(),i=0;t.sidebar("hide",function(){i++,i==n&&e()})},toggle:function(){v.verbose("Determining toggled direction"),v.is.closed()?v.show():v.hide()},pushPage:function(t){var n,i,o=v.get.transition(),a="safe"==o?A:"overlay"==o||v.othersActive()?S:P;t=e.isFunction(t)?t:function(){},("scale down"==h.transition||v.is.mobile()&&"overlay"!==o)&&v.scrollToTop(),v.set.transition(),v.repaint(),n=function(){v.add.bodyCSS(),v.set.animating(),v.set.visible(),v.othersActive()||h.dimPage&&P.addClass(x.dimmed)},i=function(n){n.target==a[0]&&(a.off(b+T,i),v.remove.animating(),v.bind.clickaway(),e.proxy(t,E)())},a.on(b+T,i),g(n)},pullPage:function(t){var n,i,o=v.get.transition(),a="safe"==o?A:"overlay"==o||v.othersActive()?S:P;t=e.isFunction(t)?t:function(){},v.verbose("Removing context push state",v.get.direction()),v.othersActive()||v.unbind.clickaway(),n=function(){v.set.animating(),v.remove.visible(),h.dimPage&&!v.othersActive()&&P.removeClass(x.dimmed)},i=function(n){n.target==a[0]&&(a.off(b+T,i),v.remove.animating(),v.remove.transition(),v.remove.bodyCSS(),("scale down"==o||h.returnScroll&&v.is.mobile())&&v.scrollBack(),e.proxy(t,E)())},a.on(b+T,i),g(n)},legacyPushPage:function(t){var n=S.width(),i=v.get.direction(),o={};n=n||S.width(),t=e.isFunction(t)?t:function(){},o[i]=n,v.debug("Using javascript to push context",o),v.set.visible(),v.set.transition(),v.set.animating(),h.dimPage&&P.addClass(x.dimmed),A.css("position","relative").animate(o,h.duration,h.easing,function(){v.remove.animating(),v.bind.clickaway(),e.proxy(t,v)()})},legacyPullPage:function(t){var n=0,i=v.get.direction(),o={};n=n||S.width(),t=e.isFunction(t)?t:function(){},o[i]="0px",v.debug("Using javascript to pull context",o),v.unbind.clickaway(),v.set.animating(),v.remove.visible(),h.dimPage&&!v.othersVisible()&&P.removeClass(x.dimmed),A.css("position","relative").animate(o,h.duration,h.easing,function(){v.remove.animating(),e.proxy(t,v)()})},scrollToTop:function(){v.verbose("Scrolling to top of page to avoid animation issues"),p=e(t).scrollTop(),S.scrollTop(0),t.scrollTo(0,0)},scrollBack:function(){v.verbose("Scrolling back to original page position"),t.scrollTo(0,p)},set:{pushed:function(){A.addClass(x.pushed)},pushable:function(){A.addClass(x.pushable)},active:function(){S.addClass(x.active)},animating:function(){S.addClass(x.animating)},transition:function(e){e=e||v.get.transition(),S.addClass(e)},direction:function(e){e=e||v.get.direction(),S.addClass(x[e])},visible:function(){S.addClass(x.visible)},overlay:function(){S.addClass(x.overlay)}},remove:{bodyCSS:function(){v.debug("Removing body css styles",r),r.size()>0&&r.remove()},pushed:function(){A.removeClass(x.pushed)},pushable:function(){A.removeClass(x.pushable)},active:function(){S.removeClass(x.active)
},animating:function(){S.removeClass(x.animating)},transition:function(e){e=e||v.get.transition(),S.removeClass(e)},direction:function(e){e=e||v.get.direction(),S.removeClass(x[e])},visible:function(){S.removeClass(x.visible)},overlay:function(){S.removeClass(x.overlay)}},get:{direction:function(){return S.hasClass(x.top)?x.top:S.hasClass(x.right)?x.right:S.hasClass(x.bottom)?x.bottom:x.left},transition:function(){var e=v.get.direction();return v.is.mobile()?"auto"==h.mobileTransition?h.defaultTransition.mobile[e]:h.mobileTransition:"auto"==h.transition?h.defaultTransition.computer[e]:h.transition},transitionEvent:function(){var e,t=n.createElement("element"),o={transition:"transitionend",OTransition:"oTransitionEnd",MozTransition:"transitionend",WebkitTransition:"webkitTransitionEnd"};for(e in o)if(t.style[e]!==i)return o[e]}},is:{ie:function(){var e=!t.ActiveXObject&&"ActiveXObject"in t,n="ActiveXObject"in t;return e||n},legacy:function(){var e,o=n.createElement("div"),a={webkitTransform:"-webkit-transform",OTransform:"-o-transform",msTransform:"-ms-transform",MozTransform:"-moz-transform",transform:"transform"};n.body.insertBefore(o,null);for(var r in a)o.style[r]!==i&&(o.style[r]="translate3d(1px,1px,1px)",e=t.getComputedStyle(o).getPropertyValue(a[r]));return n.body.removeChild(o),!(e!==i&&e.length>0&&"none"!==e)},mobile:function(){var e=navigator.userAgent,t=/Mobile|iP(hone|od|ad)|Android|BlackBerry|IEMobile|Kindle|NetFront|Silk-Accelerated|(hpw|web)OS|Fennec|Minimo|Opera M(obi|ini)|Blazer|Dolfin|Dolphin|Skyfire|Zune/,n=t.test(e);return n?(v.verbose("Browser was found to be mobile",e),!0):(v.verbose("Browser is not mobile, using regular transition",e),!1)},closed:function(){return!v.is.visible()},visible:function(){return S.hasClass(x.visible)},vertical:function(){return S.hasClass(x.top)},animating:function(){return A.hasClass(x.animating)}},setting:function(t,n){if(v.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,h,t);else{if(n===i)return h[t];h[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,v,t);else{if(n===i)return v[t];v[t]=n}},debug:function(){h.debug&&(h.performance?v.performance.log(arguments):(v.debug=Function.prototype.bind.call(console.info,console,h.name+":"),v.debug.apply(console,arguments)))},verbose:function(){h.verbose&&h.debug&&(h.performance?v.performance.log(arguments):(v.verbose=Function.prototype.bind.call(console.info,console,h.name+":"),v.verbose.apply(console,arguments)))},error:function(){v.error=Function.prototype.bind.call(console.error,console,h.name+":"),v.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;h.performance&&(t=(new Date).getTime(),i=l||t,n=t-i,l=t,u.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:E,"Execution Time":n})),clearTimeout(v.performance.timer),v.performance.timer=setTimeout(v.performance.display,100)},display:function(){var t=h.name+":",n=0;l=!1,clearTimeout(v.performance.timer),e.each(u,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",c&&(t+=" '"+c+"'"),(console.group!==i||console.table!==i)&&u.length>0&&(console.groupCollapsed(t),console.table?console.table(u):e.each(u,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),u=[]}},invoke:function(t,n,o){var r,s,c,l=F;return n=n||f,o=E||o,"string"==typeof t&&l!==i&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(n,o){var a=n!=r?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[a])&&n!=r)l=l[a];else{if(l[a]!==i)return s=l[a],!1;if(!e.isPlainObject(l[o])||n==r)return l[o]!==i?(s=l[o],!1):(v.error(C.method,t),!1);l=l[o]}})),e.isFunction(s)?c=s.apply(o,n):s!==i&&(c=s),e.isArray(a)?a.push(c):a!==i?a=[a,c]:c!==i&&(a=c),s}},m?(F===i&&v.initialize(),v.invoke(d)):(F!==i&&v.invoke("destroy"),v.initialize())}),a!==i?a:this},e.fn.sidebar.settings={name:"Sidebar",namespace:"sidebar",debug:!1,verbose:!0,performance:!0,transition:"auto",mobileTransition:"auto",defaultTransition:{computer:{left:"uncover",right:"uncover",top:"overlay",bottom:"overlay"},mobile:{left:"uncover",right:"uncover",top:"overlay",bottom:"overlay"}},context:"body",exclusive:!1,closable:!0,dimPage:!0,scrollLock:!1,returnScroll:!1,useLegacy:!1,duration:500,easing:"easeInOutQuint",onChange:function(){},onShow:function(){},onHide:function(){},onHidden:function(){},onVisible:function(){},className:{active:"active",animating:"animating",dimmed:"dimmed",pushable:"pushable",pushed:"pushed",right:"right",top:"top",left:"left",bottom:"bottom",visible:"visible"},selector:{fixed:".fixed",omitted:"script, link, style, .ui.modal, .ui.dimmer, .ui.nag, .ui.fixed",pusher:".pusher",sidebar:".ui.sidebar"},error:{method:"The method you called is not defined.",pusher:"Had to add pusher element. For optimal performance make sure body content is inside a pusher element",movedSidebar:"Had to move sidebar. For optimal performance make sure sidebar and pusher are direct children of your body tag",overlay:"The overlay setting is no longer supported, use animation: overlay",notFound:"There were no elements that matched the specified selector"}},e.extend(e.easing,{easeInOutQuint:function(e,t,n,i,o){return(t/=o/2)<1?i/2*t*t*t*t*t+n:i/2*((t-=2)*t*t*t*t+2)+n}})}(jQuery,window,document),function(e,t,n,i){e.site=e.fn.site=function(o){var a,r,s=(new Date).getTime(),c=[],l=arguments[0],u="string"==typeof l,d=[].slice.call(arguments,1),m=e.isPlainObject(o)?e.extend(!0,{},e.site.settings,o):e.extend({},e.site.settings),f=m.namespace,g=m.error,p="module-"+f,b=e(n),v=b,h=this,y=v.data(p);return a={initialize:function(){a.instantiate()},instantiate:function(){a.verbose("Storing instance of site",a),y=a,v.data(p,a)},normalize:function(){a.fix.console(),a.fix.requestAnimationFrame()},fix:{console:function(){a.debug("Normalizing window.console"),(console===i||console.log===i)&&(a.verbose("Console not available, normalizing events"),a.disable.console()),("undefined"==typeof console.group||"undefined"==typeof console.groupEnd||"undefined"==typeof console.groupCollapsed)&&(a.verbose("Console group not available, normalizing events"),t.console.group=function(){},t.console.groupEnd=function(){},t.console.groupCollapsed=function(){}),"undefined"==typeof console.markTimeline&&(a.verbose("Mark timeline not available, normalizing events"),t.console.markTimeline=function(){})},consoleClear:function(){a.debug("Disabling programmatic console clearing"),t.console.clear=function(){}},requestAnimationFrame:function(){a.debug("Normalizing requestAnimationFrame"),t.requestAnimationFrame===i&&(a.debug("RequestAnimationFrame not available, normailizing event"),t.requestAnimationFrame=t.requestAnimationFrame||t.mozRequestAnimationFrame||t.webkitRequestAnimationFrame||t.msRequestAnimationFrame||function(e){setTimeout(e,0)})}},moduleExists:function(t){return e.fn[t]!==i&&e.fn[t].settings!==i},enabled:{modules:function(t){var n=[];return t=t||m.modules,e.each(t,function(e,t){a.moduleExists(t)&&n.push(t)}),n}},disabled:{modules:function(t){var n=[];return t=t||m.modules,e.each(t,function(e,t){a.moduleExists(t)||n.push(t)}),n}},change:{setting:function(t,n,o,r){o="string"==typeof o?"all"===o?m.modules:[o]:o||m.modules,r=r!==i?r:!0,e.each(o,function(i,o){var s,c=a.moduleExists(o)?e.fn[o].settings.namespace||!1:!0;a.moduleExists(o)&&(a.verbose("Changing default setting",t,n,o),e.fn[o].settings[t]=n,r&&c&&(s=e(":data(module-"+c+")"),s.size()>0&&(a.verbose("Modifying existing settings",s),s[o]("setting",t,n))))})},settings:function(t,n,o){n="string"==typeof n?[n]:n||m.modules,o=o!==i?o:!0,e.each(n,function(n,i){var r;a.moduleExists(i)&&(a.verbose("Changing default setting",t,i),e.extend(!0,e.fn[i].settings,t),o&&f&&(r=e(":data(module-"+f+")"),r.size()>0&&(a.verbose("Modifying existing settings",r),r[i]("setting",t))))})}},enable:{console:function(){a.console(!0)},debug:function(e,t){e=e||m.modules,a.debug("Enabling debug for modules",e),a.change.setting("debug",!0,e,t)},verbose:function(e,t){e=e||m.modules,a.debug("Enabling verbose debug for modules",e),a.change.setting("verbose",!0,e,t)}},disable:{console:function(){a.console(!1)},debug:function(e,t){e=e||m.modules,a.debug("Disabling debug for modules",e),a.change.setting("debug",!1,e,t)},verbose:function(e,t){e=e||m.modules,a.debug("Disabling verbose debug for modules",e),a.change.setting("verbose",!1,e,t)}},console:function(e){if(e){if(y.cache.console===i)return void a.error(g.console);a.debug("Restoring console function"),t.console=y.cache.console}else a.debug("Disabling console function"),y.cache.console=t.console,t.console={clear:function(){},error:function(){},group:function(){},groupCollapsed:function(){},groupEnd:function(){},info:function(){},log:function(){},markTimeline:function(){},warn:function(){}}},destroy:function(){a.verbose("Destroying previous site for",v),v.removeData(p)},cache:{},setting:function(t,n){if(e.isPlainObject(t))e.extend(!0,m,t);else{if(n===i)return m[t];m[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,a,t);else{if(n===i)return a[t];a[t]=n}},debug:function(){m.debug&&(m.performance?a.performance.log(arguments):(a.debug=Function.prototype.bind.call(console.info,console,m.name+":"),a.debug.apply(console,arguments)))},verbose:function(){m.verbose&&m.debug&&(m.performance?a.performance.log(arguments):(a.verbose=Function.prototype.bind.call(console.info,console,m.name+":"),a.verbose.apply(console,arguments)))},error:function(){a.error=Function.prototype.bind.call(console.error,console,m.name+":"),a.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;m.performance&&(t=(new Date).getTime(),i=s||t,n=t-i,s=t,c.push({Element:h,Name:e[0],Arguments:[].slice.call(e,1)||"","Execution Time":n})),clearTimeout(a.performance.timer),a.performance.timer=setTimeout(a.performance.display,100)},display:function(){var t=m.name+":",n=0;s=!1,clearTimeout(a.performance.timer),e.each(c,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",(console.group!==i||console.table!==i)&&c.length>0&&(console.groupCollapsed(t),console.table?console.table(c):e.each(c,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),c=[]}},invoke:function(t,n,o){var s,c,l,u=y;return n=n||d,o=h||o,"string"==typeof t&&u!==i&&(t=t.split(/[\. ]/),s=t.length-1,e.each(t,function(n,o){var r=n!=s?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(u[r])&&n!=s)u=u[r];else{if(u[r]!==i)return c=u[r],!1;if(!e.isPlainObject(u[o])||n==s)return u[o]!==i?(c=u[o],!1):(a.error(g.method,t),!1);u=u[o]}})),e.isFunction(c)?l=c.apply(o,n):c!==i&&(l=c),e.isArray(r)?r.push(l):r!==i?r=[r,l]:l!==i&&(r=l),c}},u?(y===i&&a.initialize(),a.invoke(l)):(y!==i&&a.destroy(),a.initialize()),r!==i?r:this},e.site.settings={name:"Site",namespace:"site",error:{console:"Console cannot be restored, most likely it was overwritten outside of module",method:"The method you called is not defined."},debug:!1,verbose:!0,performance:!0,modules:["accordion","api","checkbox","dimmer","dropdown","form","modal","nag","popup","rating","shape","sidebar","state","sticky","tab","transition","video","visit","visibility"],siteNamespace:"site",namespaceStub:{cache:{},config:{},sections:{},section:{},utilities:{}}},e.extend(e.expr[":"],{data:e.expr.createPseudo?e.expr.createPseudo(function(t){return function(n){return!!e.data(n,t)}}):function(t,n,i){return!!e.data(t,i[3])}})}(jQuery,window,document),function(e,t,n,i){e.fn.state=function(t){var o,a=e(this),r=a.selector||"",s=("ontouchstart"in n.documentElement,(new Date).getTime()),c=[],l=arguments[0],u="string"==typeof l,d=[].slice.call(arguments,1);return a.each(function(){var n,m=e.isPlainObject(t)?e.extend(!0,{},e.fn.state.settings,t):e.extend({},e.fn.state.settings),f=m.error,g=m.metadata,p=m.className,b=m.namespace,v=m.states,h=m.text,y="."+b,x=b+"-module",w=e(this),C=this,T=w.data(x);n={initialize:function(){n.verbose("Initializing module"),m.automatic&&n.add.defaults(),m.context&&""!==r?e(m.context).on(r,"mouseenter"+y,n.change.text).on(r,"mouseleave"+y,n.reset.text).on(r,"click"+y,n.toggle.state):w.on("mouseenter"+y,n.change.text).on("mouseleave"+y,n.reset.text).on("click"+y,n.toggle.state),n.instantiate()},instantiate:function(){n.verbose("Storing instance of module",n),T=n,w.data(x,n)},destroy:function(){n.verbose("Destroying previous module",T),w.off(y).removeData(x)},refresh:function(){n.verbose("Refreshing selector cache"),w=e(C)},add:{defaults:function(){var o=t&&e.isPlainObject(t.states)?t.states:{};e.each(m.defaults,function(t,a){n.is[t]!==i&&n.is[t]()&&(n.verbose("Adding default states",t,C),e.extend(m.states,a,o))})}},is:{active:function(){return w.hasClass(p.active)},loading:function(){return w.hasClass(p.loading)},inactive:function(){return!w.hasClass(p.active)},state:function(e){return p[e]===i?!1:w.hasClass(p[e])},enabled:function(){return!w.is(m.filter.active)},disabled:function(){return w.is(m.filter.active)},textEnabled:function(){return!w.is(m.filter.text)},button:function(){return w.is(".button:not(a, .submit)")},input:function(){return w.is("input")},progress:function(){return w.is(".ui.progress")}},allow:function(e){n.debug("Now allowing state",e),v[e]=!0},disallow:function(e){n.debug("No longer allowing",e),v[e]=!1},allows:function(e){return v[e]||!1},enable:function(){w.removeClass(p.disabled)},disable:function(){w.addClass(p.disabled)},setState:function(e){n.allows(e)&&w.addClass(p[e])},removeState:function(e){n.allows(e)&&w.removeClass(p[e])},toggle:{state:function(){var t;if(n.allows("active")&&n.is.enabled()){if(n.refresh(),e.fn.api!==i&&(t=w.api("get request")))return void n.listenTo(t);n.change.state()}}},listenTo:function(t){n.debug("API request detected, waiting for state signal",t),t?(h.loading&&n.update.text(h.loading),e.when(t).then(function(){"resolved"==t.state()?(n.debug("API request succeeded"),m.activateTest=function(){return!0},m.deactivateTest=function(){return!0}):(n.debug("API request failed"),m.activateTest=function(){return!1},m.deactivateTest=function(){return!1}),n.change.state()})):(m.activateTest=function(){return!1},m.deactivateTest=function(){return!1})},change:{state:function(){n.debug("Determining state change direction"),n.is.inactive()?n.activate():n.deactivate(),m.sync&&n.sync(),e.proxy(m.onChange,C)()},text:function(){n.is.textEnabled()&&(n.is.disabled()?(n.verbose("Changing text to disabled text",h.hover),n.update.text(h.disabled)):n.is.active()?h.hover?(n.verbose("Changing text to hover text",h.hover),n.update.text(h.hover)):h.deactivate&&(n.verbose("Changing text to deactivating text",h.deactivate),n.update.text(h.deactivate)):h.hover?(n.verbose("Changing text to hover text",h.hover),n.update.text(h.hover)):h.activate&&(n.verbose("Changing text to activating text",h.activate),n.update.text(h.activate)))}},activate:function(){e.proxy(m.activateTest,C)()&&(n.debug("Setting state to active"),w.addClass(p.active),n.update.text(h.active),e.proxy(m.onActivate,C)())},deactivate:function(){e.proxy(m.deactivateTest,C)()&&(n.debug("Setting state to inactive"),w.removeClass(p.active),n.update.text(h.inactive),e.proxy(m.onDeactivate,C)())},sync:function(){n.verbose("Syncing other buttons to current state"),a.not(w).state(n.is.active()?"activate":"deactivate")},get:{text:function(){return m.selector.text?w.find(m.selector.text).text():w.html()},textFor:function(e){return h[e]||!1}},flash:{text:function(t,i,o){var a=n.get.text();n.debug("Flashing text message",t,i),t=t||m.text.flash,i=i||m.flashDuration,o=o||function(){},n.update.text(t),setTimeout(function(){n.update.text(a),e.proxy(o,C)()},i)}},reset:{text:function(){var e=h.active||w.data(g.storedText),t=h.inactive||w.data(g.storedText);n.is.textEnabled()&&(n.is.active()&&e?(n.verbose("Resetting active text",e),n.update.text(e)):t&&(n.verbose("Resetting inactive text",e),n.update.text(t)))}},update:{text:function(e){var t=n.get.text();e&&e!==t?(n.debug("Updating text",e),m.selector.text?w.data(g.storedText,e).find(m.selector.text).text(e):w.data(g.storedText,e).html(e)):n.debug("Text is already sane, ignoring update",e)}},setting:function(t,o){if(n.debug("Changing setting",t,o),e.isPlainObject(t))e.extend(!0,m,t);else{if(o===i)return m[t];m[t]=o}},internal:function(t,o){if(e.isPlainObject(t))e.extend(!0,n,t);else{if(o===i)return n[t];n[t]=o}},debug:function(){m.debug&&(m.performance?n.performance.log(arguments):(n.debug=Function.prototype.bind.call(console.info,console,m.name+":"),n.debug.apply(console,arguments)))},verbose:function(){m.verbose&&m.debug&&(m.performance?n.performance.log(arguments):(n.verbose=Function.prototype.bind.call(console.info,console,m.name+":"),n.verbose.apply(console,arguments)))},error:function(){n.error=Function.prototype.bind.call(console.error,console,m.name+":"),n.error.apply(console,arguments)},performance:{log:function(e){var t,i,o;m.performance&&(t=(new Date).getTime(),o=s||t,i=t-o,s=t,c.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:C,"Execution Time":i})),clearTimeout(n.performance.timer),n.performance.timer=setTimeout(n.performance.display,100)},display:function(){var t=m.name+":",o=0;s=!1,clearTimeout(n.performance.timer),e.each(c,function(e,t){o+=t["Execution Time"]}),t+=" "+o+"ms",r&&(t+=" '"+r+"'"),(console.group!==i||console.table!==i)&&c.length>0&&(console.groupCollapsed(t),console.table?console.table(c):e.each(c,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),c=[]}},invoke:function(t,a,r){var s,c,l,u=T;return a=a||d,r=C||r,"string"==typeof t&&u!==i&&(t=t.split(/[\. ]/),s=t.length-1,e.each(t,function(o,a){var r=o!=s?a+t[o+1].charAt(0).toUpperCase()+t[o+1].slice(1):t;if(e.isPlainObject(u[r])&&o!=s)u=u[r];else{if(u[r]!==i)return c=u[r],!1;if(!e.isPlainObject(u[a])||o==s)return u[a]!==i?(c=u[a],!1):(n.error(f.method,t),!1);u=u[a]}})),e.isFunction(c)?l=c.apply(r,a):c!==i&&(l=c),e.isArray(o)?o.push(l):o!==i?o=[o,l]:l!==i&&(o=l),c}},u?(T===i&&n.initialize(),n.invoke(l)):(T!==i&&n.destroy(),n.initialize())}),o!==i?o:this},e.fn.state.settings={name:"State",debug:!1,verbose:!0,namespace:"state",performance:!0,onActivate:function(){},onDeactivate:function(){},onChange:function(){},activateTest:function(){return!0},deactivateTest:function(){return!0},automatic:!0,sync:!1,flashDuration:1e3,filter:{text:".loading, .disabled",active:".disabled"},context:!1,error:{method:"The method you called is not defined."},metadata:{promise:"promise",storedText:"stored-text"},className:{active:"active",disabled:"disabled",error:"error",loading:"loading",success:"success",warning:"warning"},selector:{text:!1},defaults:{input:{disabled:!0,loading:!0,active:!0},button:{disabled:!0,loading:!0,active:!0},progress:{active:!0,success:!0,warning:!0,error:!0}},states:{active:!0,disabled:!0,error:!0,loading:!0,success:!0,warning:!0},text:{disabled:!1,flash:!1,hover:!1,active:!1,inactive:!1,activate:!1,deactivate:!1}}}(jQuery,window,document),function(e,t,n,i){"use strict";e.fn.sticky=function(n){var o,a=e(this),r=a.selector||"",s=(new Date).getTime(),c=[],l=arguments[0],u="string"==typeof l,d=[].slice.call(arguments,1);return a.each(function(){var a,m,f,g=e.extend(!0,{},e.fn.sticky.settings,n),p=g.className,b=g.namespace,v=g.error,h="."+b,y="module-"+b,x=e(this),w=e(t),C=x.offsetParent(),T=e(g.scrollContext),k=(x.selector||"",x.data(y)),S=t.requestAnimationFrame||t.mozRequestAnimationFrame||t.webkitRequestAnimationFrame||t.msRequestAnimationFrame||function(e){setTimeout(e,0)},A=this;f={initialize:function(){return a=g.context?e(g.context):C,0===a.size()?void f.error(v.invalidContext,g.context,x):(f.verbose("Initializing sticky",g,C),f.save.positions(),f.is.hidden()&&f.error(v.visible,x),f.cache.element.height>f.cache.context.height?(f.reset(),void f.error(v.elementSize,x)):(w.on("resize"+h,f.event.resize),T.on("scroll"+h,f.event.scroll),f.observeChanges(),void f.instantiate()))},instantiate:function(){f.verbose("Storing instance of module",f),k=f,x.data(y,f)},destroy:function(){f.verbose("Destroying previous module"),f.reset(),w.off("resize"+h,f.event.resize),T.off("scroll"+h,f.event.scroll),x.removeData(y)},observeChanges:function(){var e=a[0];"MutationObserver"in t&&(m=new MutationObserver(function(){clearTimeout(f.timer),f.timer=setTimeout(function(){f.verbose("DOM tree modified, updating sticky menu"),f.refresh()},200)}),m.observe(A,{childList:!0,subtree:!0}),m.observe(e,{childList:!0,subtree:!0}),f.debug("Setting up mutation observer",m))},event:{resize:function(){S(function(){f.refresh(),f.stick()})},scroll:function(){S(function(){f.stick(),e.proxy(g.onScroll,A)()})}},refresh:function(t){f.reset(),t&&(C=x.offsetParent()),f.save.positions(),f.stick(),e.proxy(g.onReposition,A)()},supports:{sticky:function(){{var t=e("<div/>");t.get()}return t.addClass(p.supported),t.css("position").match("sticky")}},save:{scroll:function(e){f.lastScroll=e},positions:function(){var e={height:w.height()},t={margin:{top:parseInt(x.css("margin-top"),10),bottom:parseInt(x.css("margin-bottom"),10)},offset:x.offset(),width:x.outerWidth(),height:x.outerHeight()},n={offset:a.offset(),height:a.outerHeight()};f.cache={fits:t.height<e.height,window:{height:e.height},element:{margin:t.margin,top:t.offset.top-t.margin.top,left:t.offset.left,width:t.width,height:t.height,bottom:t.offset.top+t.height},context:{top:n.offset.top,height:n.height,bottom:n.offset.top+n.height}},f.set.containerSize(),f.set.size(),f.stick(),f.debug("Caching element positions",f.cache)}},get:{direction:function(e){var t="down";return e=e||T.scrollTop(),f.lastScroll!==i&&(f.lastScroll<e?t="down":f.lastScroll>e&&(t="up")),t},scrollChange:function(e){return e=e||T.scrollTop(),f.lastScroll?e-f.lastScroll:0},currentElementScroll:function(){return f.is.top()?Math.abs(parseInt(x.css("top"),10))||0:Math.abs(parseInt(x.css("bottom"),10))||0},elementScroll:function(e){e=e||T.scrollTop();var t,n=f.cache.element,i=f.cache.window,o=f.get.scrollChange(e),a=n.height-i.height+g.offset,r=f.get.currentElementScroll(),s=r+o;return t=f.cache.fits||0>s?0:s>a?a:s}},remove:{offset:function(){x.css("margin-top","")}},set:{offset:function(){f.verbose("Setting offset on element",g.offset),x.css("margin-top",g.offset)},containerSize:function(){var e=C.get(0).tagName;"HTML"===e||"body"==e?C=x.offsetParent():(f.debug("Settings container size",f.cache.context.height),C.height(f.cache.context.height))},scroll:function(e){f.debug("Setting scroll on element",e),f.is.top()&&x.css("bottom","").css("top",-e),f.is.bottom()&&x.css("top","").css("bottom",e)},size:function(){0!==f.cache.element.height&&0!==f.cache.element.width&&x.css({width:f.cache.element.width,height:f.cache.element.height})}},is:{top:function(){return x.hasClass(p.top)},bottom:function(){return x.hasClass(p.bottom)},initialPosition:function(){return!f.is.fixed()&&!f.is.bound()},hidden:function(){return!x.is(":visible")},bound:function(){return x.hasClass(p.bound)},fixed:function(){return x.hasClass(p.fixed)}},stick:function(){var e=f.cache,t=e.fits,n=e.element,i=e.window,o=e.context,a=f.is.bottom()&&g.pushing?g.bottomOffset:g.offset,r={top:T.scrollTop()+a,bottom:T.scrollTop()+a+i.height},s=(f.get.direction(r.top),f.get.elementScroll(r.top)),c=!t,l=0!==n.height;f.save.scroll(r.top),l&&(f.is.initialPosition()?r.top>=n.top&&(f.debug("Element passed, fixing element to page"),f.fixTop()):f.is.fixed()?f.is.top()?r.top<n.top?(f.debug("Fixed element reached top of container"),f.setInitialPosition()):n.height+r.top-s>o.bottom?(f.debug("Fixed element reached bottom of container"),f.bindBottom()):c&&f.set.scroll(s):f.is.bottom()&&(r.bottom-n.height<n.top?(f.debug("Bottom fixed rail has reached top of container"),f.setInitialPosition()):r.bottom>o.bottom?(f.debug("Bottom fixed rail has reached bottom of container"),f.bindBottom()):c&&f.set.scroll(s)):f.is.bottom()&&(g.pushing?f.is.bound()&&r.bottom<o.bottom&&(f.debug("Fixing bottom attached element to bottom of browser."),f.fixBottom()):f.is.bound()&&r.top<o.bottom-n.height&&(f.debug("Fixing bottom attached element to top of browser."),f.fixTop())))},bindTop:function(){f.debug("Binding element to top of parent container"),f.remove.offset(),x.css("left","").css("top","").css("bottom","").removeClass(p.fixed).removeClass(p.bottom).addClass(p.bound).addClass(p.top),e.proxy(g.onTop,A)(),e.proxy(g.onUnstick,A)()},bindBottom:function(){f.debug("Binding element to bottom of parent container"),f.remove.offset(),x.css("left","").css("top","").css("bottom","").removeClass(p.fixed).removeClass(p.top).addClass(p.bound).addClass(p.bottom),e.proxy(g.onBottom,A)(),e.proxy(g.onUnstick,A)()},setInitialPosition:function(){f.unfix(),f.unbind()},fixTop:function(){f.debug("Fixing element to top of page"),f.set.offset(),x.css("left",f.cache.element.left).removeClass(p.bound).removeClass(p.bottom).addClass(p.fixed).addClass(p.top),e.proxy(g.onStick,A)()},fixBottom:function(){f.debug("Sticking element to bottom of page"),f.set.offset(),x.css("left",f.cache.element.left).removeClass(p.bound).removeClass(p.top).addClass(p.fixed).addClass(p.bottom),e.proxy(g.onStick,A)()},unbind:function(){f.debug("Removing absolute position on element"),f.remove.offset(),x.removeClass(p.bound).removeClass(p.top).removeClass(p.bottom)},unfix:function(){f.debug("Removing fixed position on element"),f.remove.offset(),x.removeClass(p.fixed).removeClass(p.top).removeClass(p.bottom),e.proxy(g.onUnstick,this)()},reset:function(){f.debug("Reseting elements position"),f.unbind(),f.unfix(),f.resetCSS()},resetCSS:function(){x.css({top:"",bottom:"",width:"",height:""}),C.css({height:""})},setting:function(t,n){if(e.isPlainObject(t))e.extend(!0,g,t);else{if(n===i)return g[t];g[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,f,t);else{if(n===i)return f[t];f[t]=n}},debug:function(){g.debug&&(g.performance?f.performance.log(arguments):(f.debug=Function.prototype.bind.call(console.info,console,g.name+":"),f.debug.apply(console,arguments)))},verbose:function(){g.verbose&&g.debug&&(g.performance?f.performance.log(arguments):(f.verbose=Function.prototype.bind.call(console.info,console,g.name+":"),f.verbose.apply(console,arguments)))},error:function(){f.error=Function.prototype.bind.call(console.error,console,g.name+":"),f.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;g.performance&&(t=(new Date).getTime(),i=s||t,n=t-i,s=t,c.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:A,"Execution Time":n})),clearTimeout(f.performance.timer),f.performance.timer=setTimeout(f.performance.display,0)},display:function(){var t=g.name+":",n=0;s=!1,clearTimeout(f.performance.timer),e.each(c,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",r&&(t+=" '"+r+"'"),(console.group!==i||console.table!==i)&&c.length>0&&(console.groupCollapsed(t),console.table?console.table(c):e.each(c,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),c=[]}},invoke:function(t,n,a){var r,s,c,l=k;return n=n||d,a=A||a,"string"==typeof t&&l!==i&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(n,o){var a=n!=r?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[a])&&n!=r)l=l[a];else{if(l[a]!==i)return s=l[a],!1;if(!e.isPlainObject(l[o])||n==r)return l[o]!==i?(s=l[o],!1):!1;l=l[o]}})),e.isFunction(s)?c=s.apply(a,n):s!==i&&(c=s),e.isArray(o)?o.push(c):o!==i?o=[o,c]:c!==i&&(o=c),s}},u?(k===i&&f.initialize(),f.invoke(l)):(k!==i&&f.destroy(),f.initialize())}),o!==i?o:this},e.fn.sticky.settings={name:"Sticky",namespace:"sticky",debug:!1,verbose:!1,performance:!1,pushing:!1,context:!1,scrollContext:t,offset:0,bottomOffset:0,onReposition:function(){},onScroll:function(){},onStick:function(){},onUnstick:function(){},onTop:function(){},onBottom:function(){},error:{container:"Sticky element must be inside a relative container",visible:"Element is hidden, you must call refresh after element becomes visible",method:"The method you called is not defined.",invalidContext:"Context specified does not exist",elementSize:"Sticky element is larger than its container, cannot create sticky."},className:{bound:"bound",fixed:"fixed",supported:"native",top:"top",bottom:"bottom"}}}(jQuery,window,document),function(e,t,n,i){"use strict";e.tab=e.fn.tab=function(n){var o,a,r=e(e.isFunction(this)?t:this),s=e.isPlainObject(n)?e.extend(!0,{},e.fn.tab.settings,n):e.extend({},e.fn.tab.settings),c=r.selector||"",l=(new Date).getTime(),u=[],d=arguments[0],m="string"==typeof d,f=[].slice.call(arguments,1);return r.each(function(){var n,g,p,b,v,h=s.className,y=s.metadata,x=s.selector,w=s.error,C="."+s.namespace,T="module-"+s.namespace,k=e(this),S={},A=!0,z=0,P=this,E=k.data(T);o={initialize:function(){o.debug("Initializing tab menu item",k),o.determineTabs(),o.debug("Determining tabs",s.context,g),s.auto&&(o.verbose("Setting up automatic tab retrieval from server"),s.apiSettings={url:s.path+"/{$tab}"}),e.isWindow(P)||(o.debug("Attaching tab activation events to element",k),k.on("click"+C,o.event.click)),o.instantiate()},determineTabs:function(){var t;"parent"===s.context?(k.closest(x.ui).size()>0?(t=k.closest(x.ui),o.verbose("Using closest UI element for determining parent",t)):t=k,n=t.parent(),o.verbose("Determined parent element for creating context",n)):s.context?(n=e(s.context),o.verbose("Using selector for tab context",s.context,n)):n=e("body"),s.childrenOnly?(g=n.children(x.tabs),o.debug("Searching tab context children for tabs",n,g)):(g=n.find(x.tabs),o.debug("Searching tab context for tabs",n,g))},initializeHistory:function(){if(s.history){if(o.debug("Initializing page state"),e.address===i)return o.error(w.state),!1;if("state"==s.historyType){if(o.debug("Using HTML5 to manage state"),s.path===!1)return o.error(w.path),!1;e.address.history(!0).state(s.path)}e.address.bind("change",o.event.history.change)}},instantiate:function(){o.verbose("Storing instance of module",o),k.data(T,o)},destroy:function(){o.debug("Destroying tabs",k),k.removeData(T).off(C)},event:{click:function(t){var n=e(this).data(y.tab);n!==i?(s.history?(o.verbose("Updating page state",t),e.address.value(n)):(o.verbose("Changing tab",t),o.changeTab(n)),t.preventDefault()):o.debug("No tab specified")},history:{change:function(t){var n=t.pathNames.join("/")||o.get.initialPath(),a=s.templates.determineTitle(n)||!1;o.performance.display(),o.debug("History change event",n,t),v=t,n!==i&&o.changeTab(n),a&&e.address.title(a)}}},refresh:function(){p&&(o.debug("Refreshing tab",p),o.changeTab(p))},cache:{read:function(e){return e!==i?S[e]:!1},add:function(e,t){e=e||p,o.debug("Adding cached content for",e),S[e]=t},remove:function(e){e=e||p,o.debug("Removing cached content for",e),delete S[e]}},set:{state:function(t){e.address.value(t)}},changeTab:function(i){var a=t.history&&t.history.pushState,r=a&&s.ignoreFirstLoad&&A,c=s.auto||e.isPlainObject(s.apiSettings),l=c&&!r?o.utilities.pathToArray(i):o.get.defaultPathArray(i);i=o.utilities.arrayToPath(l),e.each(l,function(t,a){var u,d,m,f,g=l.slice(0,t+1),h=o.utilities.arrayToPath(g),y=o.is.tab(h),x=t+1==l.length,C=o.get.tabElement(h);if(o.verbose("Looking for tab",a),y){if(o.verbose("Tab was found",a),p=h,b=o.utilities.filterArray(l,g),x?f=!0:(d=l.slice(0,t+2),m=o.utilities.arrayToPath(d),f=!o.is.tab(m),f&&o.verbose("Tab parameters found",d)),f&&c)return r?(o.debug("Ignoring remote content on first tab load",h),A=!1,o.cache.add(i,C.html()),o.activate.all(h),e.proxy(s.onTabInit,C)(h,b,v),e.proxy(s.onTabLoad,C)(h,b,v)):(o.activate.navigation(h),o.content.fetch(h,i)),!1;o.debug("Opened local tab",h),o.activate.all(h),o.cache.read(h)||(o.cache.add(h,!0),o.debug("First time tab loaded calling tab init"),e.proxy(s.onTabInit,C)(h,b,v)),e.proxy(s.onTabLoad,C)(h,b,v)}else{if(-1!=i.search("/"))return o.error(w.missingTab,k,n,h),!1;if(u=e("#"+i+', a[name="'+i+'"]'),h=u.closest("[data-tab]").data("tab"),C=o.get.tabElement(h),u&&u.size()>0&&h)return o.debug("No tab found, but deep anchor link present, opening parent tab"),o.activate.all(h),o.cache.read(h)||(o.cache.add(h,!0),o.debug("First time tab loaded calling tab init"),e.proxy(s.onTabInit,C)(h,b,v)),!1
}})},content:{fetch:function(t,n){var a,r,c=o.get.tabElement(t),l={dataType:"html",stateContext:c,onSuccess:function(i){o.cache.add(n,i),o.content.update(t,i),t==p?(o.debug("Content loaded",t),o.activate.tab(t)):o.debug("Content loaded in background",t),e.proxy(s.onTabInit,c)(t,b,v),e.proxy(s.onTabLoad,c)(t,b,v)},urlData:{tab:n}},u=c.data(y.promise)||!1,d=u&&"pending"===u.state();n=n||t,r=o.cache.read(n),s.cache&&r?(o.debug("Showing existing content",n),o.content.update(t,r),o.activate.tab(t),e.proxy(s.onTabLoad,c)(t,b,v)):d?(o.debug("Content is already loading",n),c.addClass(h.loading)):e.api!==i?(a=e.extend(!0,{headers:{"X-Remote":!0}},s.apiSettings,l),o.debug("Retrieving remote content",n,a),e.api(a)):o.error(w.api)},update:function(e,t){o.debug("Updating html for",e);var n=o.get.tabElement(e);n.html(t)}},activate:{all:function(e){o.activate.tab(e),o.activate.navigation(e)},tab:function(e){var t=o.get.tabElement(e);o.verbose("Showing tab content for",t),t.addClass(h.active).siblings(g).removeClass(h.active+" "+h.loading)},navigation:function(e){var t=o.get.navElement(e);o.verbose("Activating tab navigation for",t,e),t.addClass(h.active).siblings(r).removeClass(h.active+" "+h.loading)}},deactivate:{all:function(){o.deactivate.navigation(),o.deactivate.tabs()},navigation:function(){r.removeClass(h.active)},tabs:function(){g.removeClass(h.active+" "+h.loading)}},is:{tab:function(e){return e!==i?o.get.tabElement(e).size()>0:!1}},get:{initialPath:function(){return r.eq(0).data(y.tab)||g.eq(0).data(y.tab)},path:function(){return e.address.value()},defaultPathArray:function(e){return o.utilities.pathToArray(o.get.defaultPath(e))},defaultPath:function(e){var t=r.filter("[data-"+y.tab+'^="'+e+'/"]').eq(0),n=t.data(y.tab)||!1;if(n){if(o.debug("Found default tab",n),z<s.maxDepth)return z++,o.get.defaultPath(n);o.error(w.recursion)}else o.debug("No default tabs found for",e,g);return z=0,e},navElement:function(e){return e=e||p,r.filter("[data-"+y.tab+'="'+e+'"]')},tabElement:function(e){var t,n,i,a;return e=e||p,i=o.utilities.pathToArray(e),a=o.utilities.last(i),t=g.filter("[data-"+y.tab+'="'+a+'"]'),n=g.filter("[data-"+y.tab+'="'+e+'"]'),t.size()>0?t:n},tab:function(){return p}},utilities:{filterArray:function(t,n){return e.grep(t,function(t){return-1==e.inArray(t,n)})},last:function(t){return e.isArray(t)?t[t.length-1]:!1},pathToArray:function(e){return e===i&&(e=p),"string"==typeof e?e.split("/"):[e]},arrayToPath:function(t){return e.isArray(t)?t.join("/"):!1}},setting:function(t,n){if(o.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,s,t);else{if(n===i)return s[t];s[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,o,t);else{if(n===i)return o[t];o[t]=n}},debug:function(){s.debug&&(s.performance?o.performance.log(arguments):(o.debug=Function.prototype.bind.call(console.info,console,s.name+":"),o.debug.apply(console,arguments)))},verbose:function(){s.verbose&&s.debug&&(s.performance?o.performance.log(arguments):(o.verbose=Function.prototype.bind.call(console.info,console,s.name+":"),o.verbose.apply(console,arguments)))},error:function(){o.error=Function.prototype.bind.call(console.error,console,s.name+":"),o.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;s.performance&&(t=(new Date).getTime(),i=l||t,n=t-i,l=t,u.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:P,"Execution Time":n})),clearTimeout(o.performance.timer),o.performance.timer=setTimeout(o.performance.display,100)},display:function(){var t=s.name+":",n=0;l=!1,clearTimeout(o.performance.timer),e.each(u,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",c&&(t+=" '"+c+"'"),(console.group!==i||console.table!==i)&&u.length>0&&(console.groupCollapsed(t),console.table?console.table(u):e.each(u,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),u=[]}},invoke:function(t,n,r){var s,c,l,u=E;return n=n||f,r=P||r,"string"==typeof t&&u!==i&&(t=t.split(/[\. ]/),s=t.length-1,e.each(t,function(n,a){var r=n!=s?a+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(u[r])&&n!=s)u=u[r];else{if(u[r]!==i)return c=u[r],!1;if(!e.isPlainObject(u[a])||n==s)return u[a]!==i?(c=u[a],!1):(o.error(w.method,t),!1);u=u[a]}})),e.isFunction(c)?l=c.apply(r,n):c!==i&&(l=c),e.isArray(a)?a.push(l):a!==i?a=[a,l]:l!==i&&(a=l),c}},m?(E===i&&o.initialize(),o.invoke(d)):(E!==i&&o.destroy(),o.initialize())}),o&&!m&&o.initializeHistory(),a!==i?a:this},e.tab=function(n){e(t).tab(n)},e.fn.tab.settings={name:"Tab",namespace:"tab",debug:!1,verbose:!0,performance:!0,auto:!1,history:!1,historyType:"hash",path:!1,context:!1,childrenOnly:!1,maxDepth:25,ignoreFirstLoad:!1,alwaysRefresh:!1,cache:!0,apiSettings:!1,onTabInit:function(){},onTabLoad:function(){},templates:{determineTitle:function(){}},error:{api:"You attempted to load content without API module",method:"The method you called is not defined",missingTab:"Activated tab cannot be found for this context.",noContent:"The tab you specified is missing a content url.",path:"History enabled, but no path was specified",recursion:"Max recursive depth reached",state:"History requires Asual's Address library <https://github.com/asual/jquery-address>"},metadata:{tab:"tab",loaded:"loaded",promise:"promise"},className:{loading:"loading",active:"active"},selector:{tabs:".ui.tab",ui:".ui"}}}(jQuery,window,document),function(e,t,n,i){"use strict";e.fn.transition=function(){{var o,a=e(this),r=a.selector||"",s=(new Date).getTime(),c=[],l=arguments,u=l[0],d=[].slice.call(arguments,1),m="string"==typeof u;t.requestAnimationFrame||t.mozRequestAnimationFrame||t.webkitRequestAnimationFrame||t.msRequestAnimationFrame||function(e){setTimeout(e,0)}}return a.each(function(){var t,f,g,p,b,v,h,y,x,w,C,T,k=e(this),S=this;T={initialize:function(){w="module-"+x,t=T.get.settings.apply(S,l),p=t.className,b=t.metadata,v=T.get.animationStartEvent(),h=T.get.animationEndEvent(),y=T.get.animationName(),g=t.error,x=t.namespace,C="."+t.namespace,f=k.data(w)||T,m&&(m=T.invoke(u)),m===!1&&(T.verbose("Converted arguments into settings object",t),T.animate(),T.instantiate())},instantiate:function(){T.verbose("Storing instance of module",T),k.data(w,f)},destroy:function(){T.verbose("Destroying previous module for",S),k.removeData(w)},refresh:function(){T.verbose("Refreshing display type on next animation"),delete T.displayType},forceRepaint:function(){T.verbose("Forcing element repaint");var e=k.parent(),t=k.next();0===t.size()?k.detach().appendTo(e):k.detach().insertBefore(t)},repaint:function(){T.verbose("Repainting element");S.offsetWidth},animate:function(e){return t=e||t,T.is.supported()?(T.debug("Preparing animation",t.animation),T.is.animating()&&t.queue?(!t.allowRepeats&&T.has.direction()&&T.is.occuring()&&T.queuing!==!0?T.error(g.repeated,t.animation,k):T.queue(t.animation),!1):void(T.can.animate()?T.set.animating(t.animation):T.error(g.noAnimation,t.animation))):(T.error(g.support),!1)},reset:function(){T.debug("Resetting animation to beginning conditions"),T.remove.animationEndCallback(),T.restore.conditions(),T.remove.animating()},queue:function(e){T.debug("Queueing animation of",e),T.queuing=!0,k.one(h+C,function(){T.queuing=!1,T.repaint(),T.animate.apply(this,t)})},complete:function(){T.verbose("CSS animation complete",t.animation),T.remove.animationEndCallback(),T.remove.failSafe(),T.is.looping()||(T.is.outward()?(T.verbose("Animation is outward, hiding element"),T.restore.conditions(),T.hide(),e.proxy(t.onHide,this)()):T.is.inward()?(T.verbose("Animation is outward, showing element"),T.restore.conditions(),T.show(),T.set.display(),e.proxy(t.onShow,this)()):T.restore.conditions(),T.remove.animation(),T.remove.animating()),e.proxy(t.onComplete,this)()},has:{direction:function(e){return e=e||t.animation,-1!==e.search(p.inward)||-1!==e.search(p.outward)?(T.debug("Direction already set in animation"),!0):!1},inlineDisplay:function(){var t=k.attr("style")||"";return e.isArray(t.match(/display.*?;/,""))}},set:{animating:function(n){n=n||t.animation,T.is.animating()||T.save.conditions(),T.remove.direction(),T.remove.animationEndCallback(),T.can.transition()&&!T.has.direction()&&T.set.direction(),T.remove.hidden(),T.set.display(),k.addClass(p.animating).addClass(p.transition).addClass(n).one(h+".complete"+C,T.complete),t.useFailSafe&&T.add.failSafe(),T.set.duration(t.duration),e.proxy(t.onStart,this)(),T.debug("Starting tween",n,k.attr("class"))},duration:function(e,n){n=n||t.duration,n="number"==typeof n?n+"ms":n,T.verbose("Setting animation duration",n),k.css({"-webkit-animation-duration":n,"-moz-animation-duration":n,"-ms-animation-duration":n,"-o-animation-duration":n,"animation-duration":n})},display:function(){var e=T.get.style(),t=T.get.displayType(),n=e+"display: "+t+" !important;";k.css("display",""),T.refresh(),k.css("display")!==t&&(T.verbose("Setting inline visibility to",t),k.attr("style",n))},direction:function(){k.is(":visible")&&!T.is.hidden()?(T.debug("Automatically determining the direction of animation","Outward"),k.removeClass(p.inward).addClass(p.outward)):(T.debug("Automatically determining the direction of animation","Inward"),k.removeClass(p.outward).addClass(p.inward))},looping:function(){T.debug("Transition set to loop"),k.addClass(p.looping)},hidden:function(){T.is.hidden()||(k.addClass(p.transition).addClass(p.hidden),"none"!==k.css("display")&&(T.verbose("Overriding default display to hide element"),k.css("display","none")))},visible:function(){k.addClass(p.transition).addClass(p.visible)}},save:{displayType:function(e){k.data(b.displayType,e)},transitionExists:function(t,n){e.fn.transition.exists[t]=n,T.verbose("Saving existence of transition",t,n)},conditions:function(){k.attr("class")||!1,k.attr("style")||"";k.removeClass(t.animation),T.remove.direction(),T.cache={className:k.attr("class"),style:T.get.style()},T.verbose("Saving original attributes",T.cache)}},restore:{conditions:function(){return T.cache===i?!1:(T.cache.className?k.attr("class",T.cache.className):k.removeAttr("class"),T.cache.style&&(T.verbose("Restoring original style attribute",T.cache.style),k.attr("style",T.cache.style)),T.is.looping()&&T.remove.looping(),void T.verbose("Restoring original attributes",T.cache))}},add:{failSafe:function(){var e=T.get.duration();T.timer=setTimeout(T.complete,e+100),T.verbose("Adding fail safe timer",T.timer)}},remove:{animating:function(){k.removeClass(p.animating)},animation:function(){k.css({"-webkit-animation":"","-moz-animation":"","-ms-animation":"","-o-animation":"",animation:""})},animationEndCallback:function(){k.off(".complete")},display:function(){k.css("display","")},direction:function(){k.removeClass(p.inward).removeClass(p.outward)},failSafe:function(){T.verbose("Removing fail safe timer",T.timer),T.timer&&clearTimeout(T.timer)},hidden:function(){k.removeClass(p.hidden)},visible:function(){k.removeClass(p.visible)},looping:function(){T.debug("Transitions are no longer looping"),k.removeClass(p.looping),T.forceRepaint()},transition:function(){k.removeClass(p.visible).removeClass(p.hidden)}},get:{settings:function(t,n,i){return"object"==typeof t?e.extend(!0,{},e.fn.transition.settings,t):"function"==typeof i?e.extend({},e.fn.transition.settings,{animation:t,onComplete:i,duration:n}):"string"==typeof n||"number"==typeof n?e.extend({},e.fn.transition.settings,{animation:t,duration:n}):"object"==typeof n?e.extend({},e.fn.transition.settings,n,{animation:t}):"function"==typeof n?e.extend({},e.fn.transition.settings,{animation:t,onComplete:n}):e.extend({},e.fn.transition.settings,{animation:t})},duration:function(e){return e=e||t.duration,"string"==typeof t.duration?e.indexOf("ms")>-1?parseFloat(e):1e3*parseFloat(e):e},displayType:function(){return t.displayType?t.displayType:(k.data(b.displayType)===i&&T.can.transition(!0),k.data(b.displayType))},style:function(){var e=k.attr("style")||"";return e.replace(/display.*?;/,"")},transitionExists:function(t){return e.fn.transition.exists[t]},animationName:function(){var e,t=n.createElement("div"),o={animation:"animationName",OAnimation:"oAnimationName",MozAnimation:"mozAnimationName",WebkitAnimation:"webkitAnimationName"};for(e in o)if(t.style[e]!==i)return o[e];return!1},animationStartEvent:function(){var e,t=n.createElement("div"),o={animation:"animationstart",OAnimation:"oAnimationStart",MozAnimation:"mozAnimationStart",WebkitAnimation:"webkitAnimationStart"};for(e in o)if(t.style[e]!==i)return o[e];return!1},animationEndEvent:function(){var e,t=n.createElement("div"),o={animation:"animationend",OAnimation:"oAnimationEnd",MozAnimation:"mozAnimationEnd",WebkitAnimation:"webkitAnimationEnd"};for(e in o)if(t.style[e]!==i)return o[e];return!1}},can:{transition:function(n){var o,a,r,s,c,l=k.attr("class"),u=k.prop("tagName"),d=t.animation,m=T.get.transitionExists(d);if(m===i||n){if(T.verbose("Determining whether animation exists"),o=e("<"+u+" />").addClass(l).insertAfter(k),a=o.addClass(d).removeClass(p.inward).removeClass(p.outward).addClass(p.animating).addClass(p.transition).css(y),r=o.addClass(p.inward).css(y),c=o.attr("class",l).removeAttr("style").removeClass(p.hidden).removeClass(p.visible).show().css("display"),T.verbose("Determining final display state",c),o.remove(),a!=r)T.debug("Direction exists for animation",d),s=!0;else{if("none"==a||!a)return void T.debug("No animation defined in css",d);T.debug("Static animation found",d,c),s=!1}T.save.displayType(c),T.save.transitionExists(d,s)}return m!==i?m:s},animate:function(){return T.can.transition()!==i}},is:{animating:function(){return k.hasClass(p.animating)},inward:function(){return k.hasClass(p.inward)},outward:function(){return k.hasClass(p.outward)},looping:function(){return k.hasClass(p.looping)},occuring:function(e){return e=e||t.animation,e=e.replace(" ","."),k.filter(e).size()>0},visible:function(){return k.is(":visible")},hidden:function(){return"hidden"===k.css("visibility")},supported:function(){return y!==!1&&h!==!1}},hide:function(){T.verbose("Hiding element"),T.is.animating()&&T.reset(),T.remove.display(),T.remove.visible(),T.set.hidden(),T.repaint()},show:function(e){T.verbose("Showing element",e),T.remove.hidden(),T.set.visible(),T.repaint()},start:function(){T.verbose("Starting animation"),k.removeClass(p.disabled)},stop:function(){T.debug("Stopping animation"),k.addClass(p.disabled)},toggle:function(){T.debug("Toggling play status"),k.toggleClass(p.disabled)},setting:function(n,o){if(T.debug("Changing setting",n,o),e.isPlainObject(n))e.extend(!0,t,n);else{if(o===i)return t[n];t[n]=o}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,T,t);else{if(n===i)return T[t];T[t]=n}},debug:function(){t.debug&&(t.performance?T.performance.log(arguments):(T.debug=Function.prototype.bind.call(console.info,console,t.name+":"),T.debug.apply(console,arguments)))},verbose:function(){t.verbose&&t.debug&&(t.performance?T.performance.log(arguments):(T.verbose=Function.prototype.bind.call(console.info,console,t.name+":"),T.verbose.apply(console,arguments)))},error:function(){T.error=Function.prototype.bind.call(console.error,console,t.name+":"),T.error.apply(console,arguments)},performance:{log:function(e){var n,i,o;t.performance&&(n=(new Date).getTime(),o=s||n,i=n-o,s=n,c.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:S,"Execution Time":i})),clearTimeout(T.performance.timer),T.performance.timer=setTimeout(T.performance.display,600)},display:function(){var n=t.name+":",o=0;s=!1,clearTimeout(T.performance.timer),e.each(c,function(e,t){o+=t["Execution Time"]}),n+=" "+o+"ms",r&&(n+=" '"+r+"'"),a.size()>1&&(n+=" ("+a.size()+")"),(console.group!==i||console.table!==i)&&c.length>0&&(console.groupCollapsed(n),console.table?console.table(c):e.each(c,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),c=[]}},invoke:function(t,n,a){var r,s,c,l=f;return n=n||d,a=S||a,"string"==typeof t&&l!==i&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(n,o){var a=n!=r?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[a])&&n!=r)l=l[a];else{if(l[a]!==i)return s=l[a],!1;if(!e.isPlainObject(l[o])||n==r)return l[o]!==i?(s=l[o],!1):!1;l=l[o]}})),e.isFunction(s)?c=s.apply(a,n):s!==i&&(c=s),e.isArray(o)?o.push(c):o!==i?o=[o,c]:c!==i&&(o=c),s!==i?s:!1}},T.initialize()}),o!==i?o:this},e.fn.transition.exists={},e.fn.transition.settings={name:"Transition",debug:!1,verbose:!0,performance:!0,namespace:"transition",onStart:function(){},onComplete:function(){},onShow:function(){},onHide:function(){},useFailSafe:!1,allowRepeats:!1,displayType:!1,animation:"fade",duration:"500ms",queue:!0,metadata:{displayType:"display"},className:{animating:"animating",disabled:"disabled",hidden:"hidden",inward:"in",loading:"loading",looping:"looping",outward:"out",transition:"transition",visible:"visible"},error:{noAnimation:"There is no css animation matching the one you specified.",repeated:"That animation is already occurring, cancelling repeated animation",method:"The method you called is not defined",support:"This browser does not support CSS animations"}}}(jQuery,window,document),function(e,t,n,i){"use strict";e.fn.video=function(n){{var o,a=e(this),r=a.selector||"",s=(new Date).getTime(),c=[],l=arguments[0],u="string"==typeof l,d=[].slice.call(arguments,1);t.requestAnimationFrame||t.mozRequestAnimationFrame||t.webkitRequestAnimationFrame||t.msRequestAnimationFrame||function(e){setTimeout(e,0)}}return a.each(function(){var m,f=e.isPlainObject(n)?e.extend(!0,{},e.fn.video.settings,n):e.extend({},e.fn.video.settings),g=f.selector,p=f.className,b=f.error,v=f.metadata,h=f.namespace,y=f.templates,x="."+h,w="module-"+h,C=(e(t),e(this)),T=C.find(g.placeholder),k=C.find(g.playButton),S=C.find(g.embed),A=this,z=C.data(w);m={initialize:function(){m.debug("Initializing video"),m.create(),T.on("click"+x,m.play),k.on("click"+x,m.play),m.instantiate()},instantiate:function(){m.verbose("Storing instance of module",m),z=m,C.data(w,m)},create:function(){var e=C.data(v.image),t=y.video(e);C.html(t),m.refresh(),e||m.play(),m.debug("Creating html for video element",t)},destroy:function(){m.verbose("Destroying previous instance of video"),m.reset(),C.removeData(w).off(x),T.off(x),k.off(x)},refresh:function(){m.verbose("Refreshing selector cache"),T=C.find(g.placeholder),k=C.find(g.playButton),S=C.find(g.embed)},change:function(e,t,n){m.debug("Changing video to ",e,t,n),C.data(v.source,e).data(v.id,t).data(v.url,n),f.onChange()},reset:function(){m.debug("Clearing video embed and showing placeholder"),C.removeClass(p.active),S.html(" "),T.show(),f.onReset()},play:function(){m.debug("Playing video");var e=C.data(v.source)||!1,t=C.data(v.url)||!1,n=C.data(v.id)||!1;S.html(m.generate.html(e,n,t)),C.addClass(p.active),f.onPlay()},get:{source:function(e){return"string"!=typeof e?!1:-1!==e.search("youtube.com")?"youtube":-1!==e.search("vimeo.com")?"vimeo":!1},id:function(e){return f.regExp.youtube.test(e)?e.match(f.regExp.youtube)[1]:f.regExp.vimeo.test(e)?e.match(f.regExp.vimeo)[2]:!1}},generate:{html:function(e,t,n){m.debug("Generating embed html");var i;return e=e||f.source,t=t||f.id,e&&t||n?(e&&t||(e=m.get.source(n),t=m.get.id(n)),"vimeo"==e?i='<iframe src="http://player.vimeo.com/video/'+t+"?="+m.generate.url(e)+'" width="100%" height="100%" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>':"youtube"==e&&(i='<iframe src="http://www.youtube.com/embed/'+t+"?="+m.generate.url(e)+'" width="100%" height="100%" frameborder="0" webkitAllowFullScreen mozallowfullscreen allowFullScreen></iframe>')):m.error(b.noVideo),i},url:function(e){var t=f.api?1:0,n="auto"===f.autoplay?C.data("image")!==i:f.autoplay,o=f.hd?1:0,a=f.showUI?1:0,r=f.showUI?0:1,s="";return"vimeo"==e&&(s="api="+t+"&amp;title="+a+"&amp;byline="+a+"&amp;portrait="+a+"&amp;autoplay="+n,f.color&&(s+="&amp;color="+f.color)),"ustream"==e?(s="autoplay="+n,f.color&&(s+="&amp;color="+f.color)):"youtube"==e&&(s="enablejsapi="+t+"&amp;autoplay="+n+"&amp;autohide="+r+"&amp;hq="+o+"&amp;modestbranding=1",f.color&&(s+="&amp;color="+f.color)),s}},setting:function(t,n){if(m.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,f,t);else{if(n===i)return f[t];f[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,m,t);else{if(n===i)return m[t];m[t]=n}},debug:function(){f.debug&&(f.performance?m.performance.log(arguments):(m.debug=Function.prototype.bind.call(console.info,console,f.name+":"),m.debug.apply(console,arguments)))},verbose:function(){f.verbose&&f.debug&&(f.performance?m.performance.log(arguments):(m.verbose=Function.prototype.bind.call(console.info,console,f.name+":"),m.verbose.apply(console,arguments)))},error:function(){m.error=Function.prototype.bind.call(console.error,console,f.name+":"),m.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;f.performance&&(t=(new Date).getTime(),i=s||t,n=t-i,s=t,c.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:A,"Execution Time":n})),clearTimeout(m.performance.timer),m.performance.timer=setTimeout(m.performance.display,100)},display:function(){var t=f.name+":",n=0;s=!1,clearTimeout(m.performance.timer),e.each(c,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",r&&(t+=" '"+r+"'"),a.size()>1&&(t+=" ("+a.size()+")"),(console.group!==i||console.table!==i)&&c.length>0&&(console.groupCollapsed(t),console.table?console.table(c):e.each(c,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),c=[]}},invoke:function(t,n,a){var r,s,c,l=z;return n=n||d,a=A||a,"string"==typeof t&&l!==i&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(n,o){var a=n!=r?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[a])&&n!=r)l=l[a];else{if(l[a]!==i)return s=l[a],!1;if(!e.isPlainObject(l[o])||n==r)return l[o]!==i?(s=l[o],!1):!1;l=l[o]}})),e.isFunction(s)?c=s.apply(a,n):s!==i&&(c=s),e.isArray(o)?o.push(c):o!==i?o=[o,c]:c!==i&&(o=c),s}},u?(z===i&&m.initialize(),m.invoke(l)):(z!==i&&m.destroy(),m.initialize())}),o!==i?o:this},e.fn.video.settings={name:"Video",namespace:"video",debug:!1,verbose:!0,performance:!0,metadata:{id:"id",image:"image",source:"source",url:"url"},source:!1,url:!1,id:!1,aspectRatio:16/9,onPlay:function(){},onReset:function(){},onChange:function(){},onPause:function(){},onStop:function(){},width:"auto",height:"auto",autoplay:"auto",color:"#442359",hd:!0,showUI:!1,api:!0,regExp:{youtube:/^(?:https?:\/\/)?(?:www\.)?(?:youtu\.be\/|youtube\.com\/(?:embed\/|v\/|watch\?v=|watch\?.+&v=))((\w|-){11})(?:\S+)?$/,vimeo:/http:\/\/(www\.)?vimeo.com\/(\d+)($|\/)/},error:{noVideo:"No video specified",method:"The method you called is not defined"},className:{active:"active"},selector:{embed:".embed",placeholder:".placeholder",playButton:".play"}},e.fn.video.settings.templates={video:function(e){var t="";return e&&(t+='<i class="video play icon"></i><img class="placeholder" src="'+e+'">'),t+='<div class="embed"></div>'}}}(jQuery,window,document),function(e,t,n,i){e.fn.visibility=function(o){var a,r=e(this),s=r.selector||"",c=(new Date).getTime(),l=[],u=arguments[0],d="string"==typeof u,m=[].slice.call(arguments,1);return r.each(function(){var r,f=e.extend(!0,{},e.fn.visibility.settings,o),g=f.className,p=f.namespace,b=(f.error,"."+p),v="module-"+p,h=e(t),y=e(this),x=e(f.context),w=(y.offsetParent(),y.selector||"",y.data(v)),C=t.requestAnimationFrame||t.mozRequestAnimationFrame||t.webkitRequestAnimationFrame||t.msRequestAnimationFrame||function(e){setTimeout(e,0)},T=this;r={initialize:function(){r.verbose("Initializing visibility",f),r.setup.cache(),r.save.position(),r.bindEvents(),r.instantiate(),"image"==f.type&&r.setup.image(),"fixed"==f.type&&r.setup.fixed(),C(r.checkVisibility)},instantiate:function(){r.verbose("Storing instance of module",r),w=r,y.data(v,r)},destroy:function(){r.verbose("Destroying previous module"),y.off(b).removeData(v)},bindEvents:function(){r.verbose("Binding visibility events to scroll and resize"),h.on("resize"+b,r.event.refresh),x.on("scroll"+b,r.event.scroll)},event:{refresh:function(){C(r.refresh)},scroll:function(){r.verbose("Scroll position changed"),f.throttle?(clearTimeout(r.timer),r.timer=setTimeout(r.checkVisibility,f.throttle)):C(r.checkVisibility)}},precache:function(t,i){t instanceof Array||(t=[t]);for(var o=t.length,a=0,r=[],s=n.createElement("img"),c=function(){a++,a>=t.length&&e.isFunction(i)&&i()};o--;)s=n.createElement("img"),s.onload=c,s.onerror=c,s.src=t[o],r.push(s)},setup:{cache:function(){r.cache={occurred:{},screen:{},element:{}}},image:function(){var e=y.data("src");e&&(r.verbose("Lazy loading image",e),r.topVisible(function(){r.precache(e,function(){r.set.image(e),f.onTopVisible=!1})}))},fixed:function(){r.verbose("Setting up fixed on element pass"),y.visibility({once:!1,continuous:!1,onTopPassed:function(){y.addClass(g.fixed).css({position:"fixed",top:f.offset+"px"}),f.animation&&e.fn.transition!==i&&y.transition(f.transition,f.duration)},onTopPassedReverse:function(){y.removeClass(g.fixed).css({position:"",top:""})}})}},set:{image:function(t){var n=r.cache.screen.bottom<r.cache.element.top;y.attr("src",t),n?(r.verbose("Image outside browser, avoiding animation"),y.show()):f.transition&&e.fn.transition!==i?y.transition(f.transition,f.duration):y.fadeIn(f.duration)}},refresh:function(){r.debug("Refreshing constants (element width/height)"),r.reset(),r.save.position(),r.checkVisibility(),e.proxy(f.onRefresh,T)()},reset:function(){r.verbose("Reseting all cached values"),e.isPlainObject(r.cache)&&(r.cache.screen={},r.cache.element={})},checkVisibility:function(){r.verbose("Checking visibility of element",r.cache.element),r.save.scroll(),r.save.direction(),r.save.screenCalculations(),r.save.elementCalculations(),r.passed(),r.passingReverse(),r.topVisibleReverse(),r.bottomVisibleReverse(),r.topPassedReverse(),r.bottomPassedReverse(),r.passing(),r.topVisible(),r.bottomVisible(),r.topPassed(),r.bottomPassed()},passed:function(t,n){var o=r.get.elementCalculations();if(t!==i&&n!==i)f.onPassed[t]=n;else{if(t!==i)return r.get.pixelsPassed(t)>o.pixelsPassed;o.passing&&e.each(f.onPassed,function(e,t){o.bottomVisible||o.pixelsPassed>r.get.pixelsPassed(e)?r.execute(t,e):f.once||r.remove.occurred(t)})}},passing:function(e){var t=r.get.elementCalculations(),n=e||f.onPassing,o="passing";return e&&(r.debug("Adding callback for passing",e),f.onPassing=e),t.passing?r.execute(n,o):f.once||r.remove.occurred(o),e!==i?t.passing:void 0},topVisible:function(e){var t=r.get.elementCalculations(),n=e||f.onTopVisible,o="topVisible";return e&&(r.debug("Adding callback for top visible",e),f.onTopVisible=e),t.topVisible?r.execute(n,o):f.once||r.remove.occurred(o),e===i?t.topVisible:void 0},bottomVisible:function(e){var t=r.get.elementCalculations(),n=e||f.onBottomVisible,o="bottomVisible";return e&&(r.debug("Adding callback for bottom visible",e),f.onBottomVisible=e),t.bottomVisible?r.execute(n,o):f.once||r.remove.occurred(o),e===i?t.bottomVisible:void 0},topPassed:function(e){var t=r.get.elementCalculations(),n=e||f.onTopPassed,o="topPassed";return e&&(r.debug("Adding callback for top passed",e),f.onTopPassed=e),t.topPassed?r.execute(n,o):f.once||r.remove.occurred(o),e===i?t.onTopPassed:void 0},bottomPassed:function(e){var t=r.get.elementCalculations(),n=e||f.onBottomPassed,o="bottomPassed";return e&&(r.debug("Adding callback for bottom passed",e),f.onBottomPassed=e),t.bottomPassed?r.execute(n,o):f.once||r.remove.occurred(o),e===i?t.bottomPassed:void 0},passingReverse:function(e){var t=r.get.elementCalculations(),n=e||f.onPassingReverse,o="passingReverse";return e&&(r.debug("Adding callback for passing reverse",e),f.onPassingReverse=e),t.passing?f.once||r.remove.occurred(o):r.get.occurred("passing")&&r.execute(n,o),e!==i?!t.passing:void 0},topVisibleReverse:function(e){var t=r.get.elementCalculations(),n=e||f.onTopVisibleReverse,o="topVisibleReverse";return e&&(r.debug("Adding callback for top visible reverse",e),f.onTopVisibleReverse=e),t.topVisible?f.once||r.remove.occurred(o):r.get.occurred("topVisible")&&r.execute(n,o),e===i?!t.topVisible:void 0},bottomVisibleReverse:function(e){var t=r.get.elementCalculations(),n=e||f.onBottomVisibleReverse,o="bottomVisibleReverse";return e&&(r.debug("Adding callback for bottom visible reverse",e),f.onBottomVisibleReverse=e),t.bottomVisible?f.once||r.remove.occurred(o):r.get.occurred("bottomVisible")&&r.execute(n,o),e===i?!t.bottomVisible:void 0},topPassedReverse:function(e){var t=r.get.elementCalculations(),n=e||f.onTopPassedReverse,o="topPassedReverse";return e&&(r.debug("Adding callback for top passed reverse",e),f.onTopPassedReverse=e),t.topPassed?f.once||r.remove.occurred(o):r.get.occurred("topPassed")&&r.execute(n,o),e===i?!t.onTopPassed:void 0},bottomPassedReverse:function(e){var t=r.get.elementCalculations(),n=e||f.onBottomPassedReverse,o="bottomPassedReverse";return e&&(r.debug("Adding callback for bottom passed reverse",e),f.onBottomPassedReverse=e),t.bottomPassed?f.once||r.remove.occurred(o):r.get.occurred("bottomPassed")&&r.execute(n,o),e===i?!t.bottomPassed:void 0},execute:function(t,n){var i=r.get.elementCalculations(),o=r.get.screenCalculations();t=t||!1,t&&(f.continuous?(r.debug("Callback being called continuously",n,i),e.proxy(t,T)(i,o)):r.get.occurred(n)||(r.debug("Conditions met",n,i),e.proxy(t,T)(i,o))),r.save.occurred(n)},remove:{occurred:function(e){e?r.cache.occurred[e]!==i&&r.cache.occurred[e]===!0&&(r.debug("Callback can now be called again",e),r.cache.occurred[e]=!1):r.cache.occurred={}}},save:{occurred:function(e){e&&(r.cache.occurred[e]===i||r.cache.occurred[e]!==!0)&&(r.verbose("Saving callback occurred",e),r.cache.occurred[e]=!0)},scroll:function(){r.cache.scroll=x.scrollTop()+f.offset},direction:function(){var e,t=r.get.scroll(),n=r.get.lastScroll();return e=t>n&&n?"down":n>t&&n?"up":"static",r.cache.direction=e,r.cache.direction},elementPosition:function(){var t=r.get.screenSize();return r.verbose("Saving element position"),e.extend(r.cache.element,{margin:{top:parseInt(y.css("margin-top"),10),bottom:parseInt(y.css("margin-bottom"),10)},fits:T.height<t.height,offset:y.offset(),width:y.outerWidth(),height:y.outerHeight()}),r.cache.element},elementCalculations:function(){var t=r.get.screenCalculations(),n=r.get.elementPosition();f.includeMargin?e.extend(r.cache.element,{top:n.offset.top-n.margin.top,bottom:n.offset.top+n.height+n.margin.bottom}):e.extend(r.cache.element,{top:n.offset.top,bottom:n.offset.top+n.height}),e.extend(r.cache.element,{topVisible:t.bottom>=n.top,topPassed:t.top>=n.top,bottomVisible:t.bottom>=n.bottom,bottomPassed:t.top>=n.bottom,pixelsPassed:0,percentagePassed:0}),e.extend(r.cache.element,{visible:r.cache.element.topVisible||r.cache.element.bottomVisible,passing:r.cache.element.topPassed&&!r.cache.element.bottomPassed,hidden:!r.cache.element.topVisible&&!r.cache.element.bottomVisible}),r.cache.element.passing&&(r.cache.element.pixelsPassed=t.top-n.top,r.cache.element.percentagePassed=(t.top-n.top)/n.height),r.verbose("Updated element calculations",r.cache.element)},screenCalculations:function(){var t=x.scrollTop()+f.offset;return r.cache.scroll===i&&(r.cache.scroll=x.scrollTop()+f.offset),r.save.direction(),e.extend(r.cache.screen,{top:t,bottom:t+r.cache.screen.height}),r.cache.screen},screenSize:function(){r.verbose("Saving window position"),r.cache.screen={height:x.height()}},position:function(){r.save.screenSize(),r.save.elementPosition()}},get:{pixelsPassed:function(e){var t=r.get.elementCalculations();return e.search("%")>-1?t.height*(parseInt(e,10)/100):parseInt(e,10)},occurred:function(e){return r.cache.occurred!==i?r.cache.occurred[e]||!1:!1},direction:function(){return r.cache.direction===i&&r.save.direction(),r.cache.direction},elementPosition:function(){return r.cache.element===i&&r.save.elementPosition(),r.cache.element},elementCalculations:function(){return r.cache.element===i&&r.save.elementCalculations(),r.cache.element},screenCalculations:function(){return r.cache.screen===i&&r.save.screenCalculations(),r.cache.screen
},screenSize:function(){return r.cache.screen===i&&r.save.screenSize(),r.cache.screen},scroll:function(){return r.cache.scroll===i&&r.save.scroll(),r.cache.scroll},lastScroll:function(){return r.cache.screen===i?(r.debug("First scroll event, no last scroll could be found"),!1):r.cache.screen.top}},setting:function(t,n){if(e.isPlainObject(t))e.extend(!0,f,t);else{if(n===i)return f[t];f[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,r,t);else{if(n===i)return r[t];r[t]=n}},debug:function(){f.debug&&(f.performance?r.performance.log(arguments):(r.debug=Function.prototype.bind.call(console.info,console,f.name+":"),r.debug.apply(console,arguments)))},verbose:function(){f.verbose&&f.debug&&(f.performance?r.performance.log(arguments):(r.verbose=Function.prototype.bind.call(console.info,console,f.name+":"),r.verbose.apply(console,arguments)))},error:function(){r.error=Function.prototype.bind.call(console.error,console,f.name+":"),r.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;f.performance&&(t=(new Date).getTime(),i=c||t,n=t-i,c=t,l.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:T,"Execution Time":n})),clearTimeout(r.performance.timer),r.performance.timer=setTimeout(r.performance.display,100)},display:function(){var t=f.name+":",n=0;c=!1,clearTimeout(r.performance.timer),e.each(l,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",s&&(t+=" '"+s+"'"),(console.group!==i||console.table!==i)&&l.length>0&&(console.groupCollapsed(t),console.table?console.table(l):e.each(l,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),l=[]}},invoke:function(t,n,o){var r,s,c,l=w;return n=n||m,o=T||o,"string"==typeof t&&l!==i&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(n,o){var a=n!=r?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[a])&&n!=r)l=l[a];else{if(l[a]!==i)return s=l[a],!1;if(!e.isPlainObject(l[o])||n==r)return l[o]!==i?(s=l[o],!1):!1;l=l[o]}})),e.isFunction(s)?c=s.apply(o,n):s!==i&&(c=s),e.isArray(a)?a.push(c):a!==i?a=[a,c]:c!==i&&(a=c),s}},d?(w===i&&r.initialize(),r.invoke(u)):(w!==i&&r.destroy(),r.initialize())}),a!==i?a:this},e.fn.visibility.settings={name:"Visibility",namespace:"visibility",className:{fixed:"fixed"},debug:!1,verbose:!1,performance:!0,offset:0,includeMargin:!1,context:t,throttle:!1,type:!1,transition:!1,duration:500,onPassed:{},onPassing:!1,onTopVisible:!1,onBottomVisible:!1,onTopPassed:!1,onBottomPassed:!1,onPassingReverse:!1,onTopVisibleReverse:!1,onBottomVisibleReverse:!1,onTopPassedReverse:!1,onBottomPassedReverse:!1,once:!0,continuous:!1,onRefresh:function(){},onScroll:function(){},error:{method:"The method you called is not defined."}}}(jQuery,window,document),function(e,t,n,i){e.visit=e.fn.visit=function(n){var o,a=e(e.isFunction(this)?t:this),r=a.selector||"",s=(new Date).getTime(),c=[],l=arguments[0],u="string"==typeof l,d=[].slice.call(arguments,1);return a.each(function(){var m,f=e.extend(!0,{},e.fn.visit.settings,n),g=f.error,p=f.namespace,b=p+"-module",v=e(this),h=e(),y=this,x=v.data(b);m={initialize:function(){f.count?m.store(f.key.count,f.count):f.id?m.add.id(f.id):f.increment&&"increment"!==u&&m.increment(),m.add.display(v),m.instantiate()},instantiate:function(){m.verbose("Storing instance of visit module",m),x=m,v.data(b,m)},destroy:function(){m.verbose("Destroying instance"),v.removeData(b)},increment:function(e){var t=m.get.count(),n=+t+1;e?m.add.id(e):(n>f.limit&&!f.surpass&&(n=f.limit),m.debug("Incrementing visits",n),m.store(f.key.count,n))},decrement:function(e){var t=m.get.count(),n=+t-1;e?m.remove.id(e):(m.debug("Removing visit"),m.store(f.key.count,n))},get:{count:function(){return+m.retrieve(f.key.count)||0},idCount:function(e){return e=e||m.get.ids(),e.length},ids:function(e){var t=[];return e=e||m.retrieve(f.key.ids),"string"==typeof e&&(t=e.split(f.delimiter)),m.verbose("Found visited ID list",t),t},storageOptions:function(){var e={};return f.expires&&(e.expires=f.expires),f.domain&&(e.domain=f.domain),f.path&&(e.path=f.path),e}},has:{visited:function(t,n){var o=!1;return n=n||m.get.ids(),t!==i&&n&&e.each(n,function(e,n){n==t&&(o=!0)}),o}},set:{count:function(e){m.store(f.key.count,e)},ids:function(e){m.store(f.key.ids,e)}},reset:function(){m.store(f.key.count,0),m.store(f.key.ids,null)},add:{id:function(e){var t=m.retrieve(f.key.ids),n=t===i||""===t?e:t+f.delimiter+e;m.has.visited(e)?m.debug("Unique content already visited, not adding visit",e,t):e===i?m.debug("ID is not defined"):(m.debug("Adding visit to unique content",e),m.store(f.key.ids,n)),m.set.count(m.get.idCount())},display:function(t){var n=e(t);n.size()>0&&!e.isWindow(n[0])&&(m.debug("Updating visit count for element",n),h=h.size()>0?h.add(n):n)}},remove:{id:function(t){var n=m.get.ids(),o=[];t!==i&&n!==i&&(m.debug("Removing visit to unique content",t,n),e.each(n,function(e,n){n!==t&&o.push(n)}),o=o.join(f.delimiter),m.store(f.key.ids,o)),m.set.count(m.get.idCount())}},check:{limit:function(t){t=t||m.get.count(),f.limit&&(t>=f.limit&&(m.debug("Pages viewed exceeded limit, firing callback",t,f.limit),e.proxy(f.onLimit,this)(t)),m.debug("Limit not reached",t,f.limit),e.proxy(f.onChange,this)(t)),m.update.display(t)}},update:{display:function(e){e=e||m.get.count(),h.size()>0&&(m.debug("Updating displayed view count",h),h.html(e))}},store:function(n,o){var a=m.get.storageOptions(o);if("localstorage"==f.storageMethod&&t.localStorage!==i)t.localStorage.setItem(n,o),m.debug("Value stored using local storage",n,o);else{if(e.cookie===i)return void m.error(g.noCookieStorage);e.cookie(n,o,a),m.debug("Value stored using cookie",n,o,a)}n==f.key.count&&m.check.limit(o)},retrieve:function(n){var o;return"localstorage"==f.storageMethod&&t.localStorage!==i?o=t.localStorage.getItem(n):e.cookie!==i?o=e.cookie(n):m.error(g.noCookieStorage),("undefined"==o||"null"==o||o===i||null===o)&&(o=i),o},setting:function(t,n){if(e.isPlainObject(t))e.extend(!0,f,t);else{if(n===i)return f[t];f[t]=n}},internal:function(t,n){return m.debug("Changing internal",t,n),n===i?m[t]:void(e.isPlainObject(t)?e.extend(!0,m,t):m[t]=n)},debug:function(){f.debug&&(f.performance?m.performance.log(arguments):(m.debug=Function.prototype.bind.call(console.info,console,f.name+":"),m.debug.apply(console,arguments)))},verbose:function(){f.verbose&&f.debug&&(f.performance?m.performance.log(arguments):(m.verbose=Function.prototype.bind.call(console.info,console,f.name+":"),m.verbose.apply(console,arguments)))},error:function(){m.error=Function.prototype.bind.call(console.error,console,f.name+":"),m.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;f.performance&&(t=(new Date).getTime(),i=s||t,n=t-i,s=t,c.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:y,"Execution Time":n})),clearTimeout(m.performance.timer),m.performance.timer=setTimeout(m.performance.display,100)},display:function(){var t=f.name+":",n=0;s=!1,clearTimeout(m.performance.timer),e.each(c,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",r&&(t+=" '"+r+"'"),a.size()>1&&(t+=" ("+a.size()+")"),(console.group!==i||console.table!==i)&&c.length>0&&(console.groupCollapsed(t),console.table?console.table(c):e.each(c,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),c=[]}},invoke:function(t,n,a){var r,s,c,l=x;return n=n||d,a=y||a,"string"==typeof t&&l!==i&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(n,o){var a=n!=r?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[a])&&n!=r)l=l[a];else{if(l[a]!==i)return s=l[a],!1;if(!e.isPlainObject(l[o])||n==r)return l[o]!==i?(s=l[o],!1):!1;l=l[o]}})),e.isFunction(s)?c=s.apply(a,n):s!==i&&(c=s),e.isArray(o)?o.push(c):o!==i?o=[o,c]:c!==i&&(o=c),s}},u?(x===i&&m.initialize(),m.invoke(l)):(x!==i&&m.destroy(),m.initialize())}),o!==i?o:this},e.fn.visit.settings={name:"Visit",debug:!1,verbose:!0,performance:!0,namespace:"visit",increment:!1,surpass:!1,count:!1,limit:!1,delimiter:"&",storageMethod:"localstorage",key:{count:"visit-count",ids:"visit-ids"},expires:30,domain:!1,path:"/",onLimit:function(){},onChange:function(){},error:{method:"The method you called is not defined",missingPersist:"Using the persist setting requires the inclusion of PersistJS",noCookieStorage:"The default storage cookie requires $.cookie to be included."}}}(jQuery,window,document);