/*!
 * # Semantic UI 1.11.6 - Dropdown
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Copyright 2014 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,t,n,i){"use strict";e.fn.dropdown=function(o){var a,r=e(this),s=e(n),c=r.selector||"",l="ontouchstart"in n.documentElement,u=(new Date).getTime(),d=[],f=arguments[0],v="string"==typeof f,h=[].slice.call(arguments,1);return r.each(function(){var m,g,p,b,w=e.isPlainObject(o)?e.extend(!0,{},e.fn.dropdown.settings,o):e.extend({},e.fn.dropdown.settings),y=w.className,x=w.metadata,T=w.namespace,C=w.selector,S=w.error,k="."+T,I="module-"+T,E=e(this),A=E.find(C.text),D=E.find(C.search),F=E.find(C.input),M=E.prev().find(C.text).length>0?E.prev().find(C.text):E.prev(),O=E.children(C.menu),q=O.find(C.item),V=!1,z=!1,Q=this,R=E.data(I);b={initialize:function(){b.debug("Initializing dropdown",w),b.is.alreadySetup()?b.setup.reference():(b.setup.layout(),b.save.defaults(),b.set.selected(),b.create.id(),l&&b.bind.touchEvents(),b.bind.mouseEvents(),b.bind.keyboardEvents(),b.observeChanges(),b.instantiate())},instantiate:function(){b.verbose("Storing instance of dropdown",b),R=b,E.data(I,b)},destroy:function(){b.verbose("Destroying previous dropdown for",E),b.remove.tabbable(),E.off(k).removeData(I),O.off(k),s.off(m)},observeChanges:function(){"MutationObserver"in t&&(p=new MutationObserver(function(e){b.is.selectMutation(e)?(b.debug("<select> modified, recreating menu"),b.setup.select()):(b.debug("DOM tree modified, updating selector cache"),b.refresh())}),p.observe(Q,{childList:!0,subtree:!0}),b.debug("Setting up mutation observer",p))},create:{id:function(){g=(Math.random().toString(16)+"000000000").substr(2,8),m="."+g,b.verbose("Creating unique id for element",g)}},search:function(){var e;e=D.val(),b.verbose("Searching for query",e),b.filter(e),b.is.searchSelection()&&b.can.show()&&b.show()},setup:{layout:function(){E.is("select")&&b.setup.select(),b.is.search()&&!b.is.searchable()&&(D=e("<input />").addClass(y.search).insertBefore(A)),w.allowTab&&b.set.tabbable()},select:function(){var t=b.get.selectValues();b.debug("Dropdown initialized on a select",t),E.is("select")&&(F=E),F.parent(C.dropdown).length>0?(b.debug("UI dropdown already exists. Creating dropdown menu only"),E=F.closest(C.dropdown),O=E.children(C.menu),0===O.length&&(O=e("<div />").addClass(y.menu).appendTo(E)),O.html(w.templates.menu(t))):(b.debug("Creating entire dropdown from select"),E=e("<div />").attr("class",F.attr("class")).addClass(y.selection).addClass(y.dropdown).html(w.templates.dropdown(t)).insertBefore(F),F.removeAttr("class").prependTo(E)),b.refresh()},reference:function(){var e,t,n=r.index(E);b.debug("Dropdown behavior was called on select, replacing with closest dropdown"),E=E.parent(C.dropdown),b.refresh(),e=r.slice(0,n),t=r.slice(n+1),r=e.add(E).add(t)}},refresh:function(){b.verbose("Refreshing selector cache"),A=E.find(C.text),D=E.find(C.search),F=E.find(C.input),M=E.prev().find(C.text).length>0?E.prev().find(C.text):E.prev(),O=E.children(C.menu),q=O.find(C.item)},toggle:function(){b.verbose("Toggling menu visibility"),b.is.active()?b.hide():b.show()},show:function(t){t=e.isFunction(t)?t:function(){},b.is.searchSelection()&&b.is.allFiltered()||b.can.show()&&!b.is.active()&&(b.debug("Showing dropdown"),b.animate.show(function(){b.can.click()&&b.bind.intent(),b.set.visible(),t.call(Q)}),w.onShow.call(Q))},hide:function(t){t=e.isFunction(t)?t:function(){},b.is.active()&&(b.debug("Hiding dropdown"),b.animate.hide(function(){b.remove.visible(),t.call(Q)}),w.onHide.call(Q))},hideOthers:function(){b.verbose("Finding other dropdowns to hide"),r.not(E).has(C.menu+":visible:not(."+y.animating+")").dropdown("hide")},hideSubMenus:function(){var e=O.find(C.menu);e.transition("hide")},bind:{keyboardEvents:function(){b.debug("Binding keyboard events"),E.on("keydown"+k,b.event.keydown),b.is.searchable()&&E.on(b.get.inputEvent(),C.search,b.event.input)},touchEvents:function(){b.debug("Touch device detected binding additional touch events"),b.is.searchSelection()||E.on("touchstart"+k,b.event.test.toggle),O.on("touchstart"+k,C.item,b.event.item.mouseenter)},mouseEvents:function(){b.verbose("Mouse detected binding mouse events"),b.is.searchSelection()?E.on("mousedown"+k,C.menu,b.event.menu.activate).on("mouseup"+k,C.menu,b.event.menu.deactivate).on("click"+k,C.search,b.show).on("focus"+k,C.search,b.event.searchFocus).on("blur"+k,C.search,b.event.searchBlur).on("click"+k,C.text,b.event.searchTextFocus):("click"==w.on?E.on("click"+k,b.event.test.toggle):"hover"==w.on?E.on("mouseenter"+k,b.delay.show).on("mouseleave"+k,b.delay.hide):E.on(w.on+k,b.toggle),E.on("mousedown"+k,b.event.mousedown).on("mouseup"+k,b.event.mouseup).on("focus"+k,b.event.focus).on("blur"+k,b.event.blur)),O.on("mouseenter"+k,C.item,b.event.item.mouseenter).on("mouseleave"+k,C.item,b.event.item.mouseleave).on("click"+k,C.item,b.event.item.click)},intent:function(){b.verbose("Binding hide intent event to document"),l&&s.on("touchstart"+m,b.event.test.touch).on("touchmove"+m,b.event.test.touch),s.on("click"+m,b.event.test.hide)}},unbind:{intent:function(){b.verbose("Removing hide intent event from document"),l&&s.off("touchstart"+m).off("touchmove"+m),s.off("click"+m)}},filter:function(t){var n=e(),i=b.escape.regExp(t),o=new RegExp("^"+i,"igm"),a=new RegExp(i,"ig");b.verbose("Searching for matching values"),q.each(function(){var t=e(this),i=String(b.get.choiceText(t,!1)),r=String(b.get.choiceValue(t,i));i.match(o)||r.match(o)?n=n.add(t):w.fullTextSearch&&(i.match(a)||r.match(a))&&(n=n.add(t))}),b.debug("Setting filter",t),b.remove.filteredItem(),q.not(n).addClass(y.filtered),b.verbose("Selecting first non-filtered element"),b.remove.selectedItem(),q.not("."+y.filtered).eq(0).addClass(y.selected),b.is.allFiltered()&&(b.debug("All items filtered, hiding dropdown",t),b.is.searchSelection()&&b.hide(),w.onNoResults.call(Q,t))},focusSearch:function(){b.is.search()&&D.focus()},forceSelection:function(){var e=q.not(y.filtered).filter("."+y.selected).eq(0),t=q.filter("."+y.active).eq(0),n=e.length>0?e:t,i=n.size()>0;i?(b.event.item.click.call(n),b.remove.filteredItem()):b.hide()},event:{mousedown:function(){V=!0},mouseup:function(){V=!1},focus:function(){!V&&b.is.hidden()&&b.show()},blur:function(){var e=n.activeElement===this;V||e||b.hide()},searchFocus:function(){V=!0,b.show()},searchBlur:function(){var e=n.activeElement===this;z||e||(w.forceSelection?b.forceSelection():b.hide())},searchTextFocus:function(){V=!0,D.focus()},input:function(){b.is.searchSelection()&&b.set.filtered(),clearTimeout(b.timer),b.timer=setTimeout(b.search,w.delay.search)},keydown:function(e){{var t,n=q.not(y.filtered).filter("."+y.selected).eq(0),i=O.children("."+y.active).eq(0),o=n.length>0?n:i,a=o.length>0?o.siblings(":not(."+y.filtered+")").andSelf():O.children(":not(."+y.filtered+")"),r=o.children(C.menu),s=o.closest(C.menu),c=s[0]!==O[0],l=s.is(":visible"),u=e.which,d={enter:13,escape:27,leftArrow:37,upArrow:38,rightArrow:39,downArrow:40},f=r.length>0,v=o.length>0;a.size()-1}if(b.is.visible()){if(u==d.enter&&v&&(f&&!w.allowCategorySelection?(b.verbose("Pressed enter on unselectable category, opening sub menu"),u=d.rightArrow):(b.verbose("Enter key pressed, choosing selected item"),b.event.item.click.call(o,e))),u==d.leftArrow&&(c&&(b.verbose("Left key pressed, closing sub-menu"),b.animate.hide(!1,s),o.removeClass(y.selected),s.closest(C.item).addClass(y.selected)),e.preventDefault()),u==d.rightArrow&&(f&&(b.verbose("Right key pressed, opening sub-menu"),b.animate.show(!1,r),o.removeClass(y.selected),r.find(C.item).eq(0).addClass(y.selected)),e.preventDefault()),u==d.upArrow){if(t=v&&l?o.prevAll(C.item+":not(."+y.filtered+")").eq(0):q.eq(0),a.index(t)<0)return void b.verbose("Up key pressed but reached top of current menu");b.verbose("Up key pressed, changing active item"),o.removeClass(y.selected),t.addClass(y.selected),b.set.scrollPosition(t),e.preventDefault()}if(u==d.downArrow){if(t=v&&l?t=o.nextAll(C.item+":not(."+y.filtered+")").eq(0):q.eq(0),0===t.length)return void b.verbose("Down key pressed but reached bottom of current menu");b.verbose("Down key pressed, changing active item"),q.removeClass(y.selected),t.addClass(y.selected),b.set.scrollPosition(t),e.preventDefault()}}else u==d.enter&&(b.verbose("Enter key pressed, showing dropdown"),b.show()),u==d.escape&&(b.verbose("Escape key pressed, closing dropdown"),b.hide()),u==d.downArrow&&(b.verbose("Down key pressed, showing dropdown"),b.show())},test:{toggle:function(e){b.determine.eventInMenu(e,b.toggle)&&e.preventDefault()},touch:function(e){b.determine.eventInMenu(e,function(){"touchstart"==e.type?b.timer=setTimeout(b.hide,w.delay.touch):"touchmove"==e.type&&clearTimeout(b.timer)}),e.stopPropagation()},hide:function(e){b.determine.eventInModule(e,b.hide)}},menu:{activate:function(){z=!0},deactivate:function(){z=!1}},item:{mouseenter:function(t){var n=e(this).children(C.menu),i=e(this).siblings(C.item).children(C.menu);n.length>0&&(clearTimeout(b.itemTimer),b.itemTimer=setTimeout(function(){b.verbose("Showing sub-menu",n),e.each(i,function(){b.animate.hide(!1,e(this))}),b.animate.show(!1,n)},w.delay.show),t.preventDefault())},mouseleave:function(){var t=e(this).children(C.menu);t.length>0&&(clearTimeout(b.itemTimer),b.itemTimer=setTimeout(function(){b.verbose("Hiding sub-menu",t),b.animate.hide(!1,t)},w.delay.hide))},click:function(t){var n=e(this),i=e(t?t.target:""),o=n.find(C.menu),a=b.get.choiceText(n),r=b.get.choiceValue(n,a),s=function(){b.remove.searchTerm(),b.determine.selectAction(a,r)},c=o.length>0,l=o.find(i).length>0;l||c&&!w.allowCategorySelection||s()}},resetStyle:function(){e(this).removeAttr("style")}},determine:{selectAction:function(t,n){b.verbose("Determining action",w.action),e.isFunction(b.action[w.action])?(b.verbose("Triggering preset action",w.action,t,n),b.action[w.action](t,n)):e.isFunction(w.action)?(b.verbose("Triggering user action",w.action,t,n),w.action(t,n)):b.error(S.action,w.action)},eventInModule:function(t,n){return n=e.isFunction(n)?n:function(){},0===e(t.target).closest(E).length?(b.verbose("Triggering event",n),n(),!0):(b.verbose("Event occurred in dropdown, canceling callback"),!1)},eventInMenu:function(t,n){return n=e.isFunction(n)?n:function(){},0===e(t.target).closest(O).length?(b.verbose("Triggering event",n),n(),!0):(b.verbose("Event occurred in dropdown menu, canceling callback"),!1)}},action:{nothing:function(){},activate:function(e,t){t=t!==i?t:e,b.set.selected(t),b.hide(function(){b.remove.filteredItem()})},select:function(e,t){t=t!==i?t:e,b.set.selected(t),b.hide(function(){b.remove.filteredItem()})},combo:function(e,t){t=t!==i?t:e,b.set.selected(t),b.hide(function(){b.remove.filteredItem()})},hide:function(){b.hide(function(){b.remove.filteredItem()})}},get:{id:function(){return g},text:function(){return A.text()},value:function(){return F.length>0?F.val():E.data(x.value)},choiceText:function(e,t){return t=t!==i?t:w.preserveHTML,e!==i?(e.find(C.menu).length>0&&(b.verbose("Retreiving text of element with sub-menu"),e=e.clone(),e.find(C.menu).remove(),e.find(C.menuIcon).remove()),e.data(x.text)!==i?e.data(x.text):t?e.html().trim():e.text().trim()):void 0},choiceValue:function(e,t){return t=t||b.get.choiceText(e),e.data(x.value)!==i?e.data(x.value):"string"==typeof t?t.toLowerCase().trim():t.trim()},inputEvent:function(){var e=D[0];return e?e.oninput!==i?"input":e.onpropertychange!==i?"propertychange":"keyup":!1},selectValues:function(){var t={};return t.values=w.sortSelect?{}:[],E.find("option").each(function(){var n=e(this).html(),o=e(this).attr("value")!==i?e(this).attr("value"):n;""===o?t.placeholder=n:w.sortSelect?t.values[o]={name:n,value:o}:t.values.push({name:n,value:o})}),w.sortSelect?b.debug("Retrieved and sorted values from select",t):b.debug("Retreived values from select",t),t},activeItem:function(){return q.filter("."+y.active)},item:function(t,n){var o=!1;return t=t!==i?t:b.get.value()!==i?b.get.value():b.get.text(),n=""===t||0===t?!0:n||!1,t!==i?q.each(function(){var i=e(this),a=b.get.choiceText(i),r=b.get.choiceValue(i,a);if(n){if(b.verbose("Ambiguous dropdown value using strict type check",i,t),r===t)return o=e(this),!0;if(!o&&a===t)return o=e(this),!0}else{if(r==t)return b.verbose("Found select item by value",r,t),o=e(this),!0;if(!o&&a==t)return b.verbose("Found select item by text",a,t),o=e(this),!0}}):t=b.get.text(),o||!1}},restore:{defaults:function(){b.restore.defaultText(),b.restore.defaultValue()},defaultText:function(){var e=E.data(x.defaultText);b.debug("Restoring default text",e),b.set.text(e),A.addClass(y.placeholder)},defaultValue:function(){var e=E.data(x.defaultValue);e!==i&&(b.debug("Restoring default value",e),e.length?b.set.selected(e):(b.remove.activeItem(),b.remove.selectedItem()))}},save:{defaults:function(){b.save.defaultText(),b.save.placeholderText(),b.save.defaultValue()},defaultValue:function(){E.data(x.defaultValue,b.get.value())},defaultText:function(){E.data(x.defaultText,A.text())},placeholderText:function(){A.hasClass(y.placeholder)&&E.data(x.placeholderText,A.text())}},clear:function(){var e=E.data(x.placeholderText);b.set.text(e),b.set.value(""),b.remove.activeItem(),b.remove.selectedItem(),A.addClass(y.placeholder)},set:{filtered:function(){var e=D.val(),t="string"==typeof e&&e.length>0;t?A.addClass(y.filtered):A.removeClass(y.filtered)},tabbable:function(){b.is.searchable()?(b.debug("Searchable dropdown initialized"),D.val("").attr("tabindex",0),O.attr("tabindex","-1")):(b.debug("Simple selection dropdown initialized"),E.attr("tabindex")||(E.attr("tabindex",0),O.attr("tabindex","-1")))},scrollPosition:function(e,t){var n,o,a,r,s,c,l,u,d,f=5;e=e||b.get.activeItem(),n=e&&e.length>0,t=t!==i?t:!1,e&&n&&(O.hasClass(y.visible)||O.addClass(y.loading),l=O.height(),a=e.height(),c=O.scrollTop(),s=O.offset().top,r=e.offset().top,o=c-s+r,d=o+f>c+l,u=c>o-f,b.debug("Scrolling to active item",o),(u||d||t)&&O.scrollTop(o).removeClass(y.loading))},text:function(e){"combo"==w.action?(b.debug("Changing combo button text",e,M),w.preserveHTML?M.html(e):M.text(e)):"select"!==w.action&&(b.debug("Changing text",e,A),A.removeClass(y.filtered).removeClass(y.placeholder),w.preserveHTML?A.html(e):A.text(e))},value:function(e){b.debug("Adding selected value to hidden input",e,F),F.length>0?F.val(e).trigger("change"):E.data(x.value,e)},active:function(){E.addClass(y.active)},visible:function(){E.addClass(y.visible)},selected:function(e){var t,n,i=b.get.item(e);i&&!i.hasClass(y.active)&&(b.debug("Setting selected menu item to",i),b.remove.activeItem(),b.remove.selectedItem(),i.addClass(y.active).addClass(y.selected),t=b.get.choiceText(i),n=b.get.choiceValue(i,t),b.set.text(t),b.set.value(n),w.onChange.call(Q,e,t,i))}},remove:{active:function(){E.removeClass(y.active)},visible:function(){E.removeClass(y.visible)},activeItem:function(){q.removeClass(y.active)},filteredItem:function(){q.removeClass(y.filtered)},searchTerm:function(){D.val("")},selectedItem:function(){q.removeClass(y.selected)},tabbable:function(){b.is.searchable()?(b.debug("Searchable dropdown initialized"),D.attr("tabindex","-1"),O.attr("tabindex","-1")):(b.debug("Simple selection dropdown initialized"),E.attr("tabindex","-1"),O.attr("tabindex","-1"))}},is:{active:function(){return E.hasClass(y.active)},alreadySetup:function(){return E.is("select")&&E.parent(C.dropdown).length>0},animating:function(e){return e?e.is(":animated")||e.transition&&e.transition("is animating"):O.is(":animated")||O.transition&&O.transition("is animating")},allFiltered:function(){return q.filter("."+y.filtered).length===q.length},hidden:function(e){return e?e.is(":hidden"):O.is(":hidden")},selectMutation:function(t){var n=!1;return e.each(t,function(t,i){return i.target&&e(i.target).is("select")?(n=!0,!0):void 0}),n},search:function(){return E.hasClass(y.search)},searchable:function(){return D.length>0},searchSelection:function(){return b.is.searchable()&&D.parent().is(E)},selection:function(){return E.hasClass(y.selection)},upward:function(){return E.hasClass(y.upward)},visible:function(e){return e?e.is(":visible"):O.is(":visible")}},can:{click:function(){return l||"click"==w.on},show:function(){return!E.hasClass(y.disabled)}},animate:{show:function(t,n){var o=n||O,a=n?function(){}:function(){b.hideSubMenus(),b.hideOthers(),b.set.active()};t=e.isFunction(t)?t:function(){},b.set.scrollPosition(b.get.activeItem(),!0),b.verbose("Doing menu show animation",o),(b.is.hidden(o)||b.is.animating(o))&&("auto"==w.transition&&(w.transition=b.is.upward()?"slide up":"slide down",b.verbose("Automatically determining animation based on animation direction",w.transition)),"none"==w.transition?t.call(Q):e.fn.transition!==i&&E.transition("is supported")?o.transition({animation:w.transition+" in",debug:w.debug,verbose:w.verbose,duration:w.duration,queue:!0,onStart:a,onComplete:function(){t.call(Q)}}):"slide down"==w.transition?(a(),o.hide().clearQueue().children().clearQueue().css("opacity",0).delay(50).animate({opacity:1},w.duration,"easeOutQuad",b.event.resetStyle).end().slideDown(100,"easeOutQuad",function(){b.event.resetStyle.call(this),t.call(Q)})):"fade"==w.transition?(a(),o.hide().clearQueue().fadeIn(w.duration,function(){b.event.resetStyle.call(this),t.call(Q)})):b.error(S.transition,w.transition))},hide:function(t,n){var o=n||O,a=(n?.9*w.duration:w.duration,n?function(){}:function(){b.can.click()&&b.unbind.intent(),b.focusSearch(),b.remove.active()});t=e.isFunction(t)?t:function(){},(b.is.visible(o)||b.is.animating(o))&&(b.verbose("Doing menu hide animation",o),"auto"==w.transition&&(w.transition=b.is.upward()?"slide up":"slide down"),F.trigger("blur"),"none"==w.transition?t.call(Q):e.fn.transition!==i&&E.transition("is supported")?o.transition({animation:w.transition+" out",duration:w.duration,debug:w.debug,verbose:w.verbose,queue:!0,onStart:a,onComplete:function(){t.call(Q)}}):"slide down"==w.transition?(a(),o.show().clearQueue().children().clearQueue().css("opacity",1).animate({opacity:0},100,"easeOutQuad",b.event.resetStyle).end().delay(50).slideUp(100,"easeOutQuad",function(){b.event.resetStyle.call(this),t.call(Q)})):"fade"==w.transition?(a(),o.show().clearQueue().fadeOut(150,function(){b.event.resetStyle.call(this),t.call(Q)})):b.error(S.transition))}},delay:{show:function(){b.verbose("Delaying show event to ensure user intent"),clearTimeout(b.timer),b.timer=setTimeout(b.show,w.delay.show)},hide:function(){b.verbose("Delaying hide event to ensure user intent"),clearTimeout(b.timer),b.timer=setTimeout(b.hide,w.delay.hide)}},escape:{regExp:function(e){return e=String(e),e.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,"\\$&")}},setting:function(t,n){if(b.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,w,t);else{if(n===i)return w[t];w[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,b,t);else{if(n===i)return b[t];b[t]=n}},debug:function(){w.debug&&(w.performance?b.performance.log(arguments):(b.debug=Function.prototype.bind.call(console.info,console,w.name+":"),b.debug.apply(console,arguments)))},verbose:function(){w.verbose&&w.debug&&(w.performance?b.performance.log(arguments):(b.verbose=Function.prototype.bind.call(console.info,console,w.name+":"),b.verbose.apply(console,arguments)))},error:function(){b.error=Function.prototype.bind.call(console.error,console,w.name+":"),b.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;w.performance&&(t=(new Date).getTime(),i=u||t,n=t-i,u=t,d.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:Q,"Execution Time":n})),clearTimeout(b.performance.timer),b.performance.timer=setTimeout(b.performance.display,500)},display:function(){var t=w.name+":",n=0;u=!1,clearTimeout(b.performance.timer),e.each(d,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",c&&(t+=" '"+c+"'"),(console.group!==i||console.table!==i)&&d.length>0&&(console.groupCollapsed(t),console.table?console.table(d):e.each(d,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),d=[]}},invoke:function(t,n,o){var r,s,c,l=R;return n=n||h,o=Q||o,"string"==typeof t&&l!==i&&(t=t.split(/[\. ]/),r=t.length-1,e.each(t,function(n,o){var a=n!=r?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[a])&&n!=r)l=l[a];else{if(l[a]!==i)return s=l[a],!1;if(!e.isPlainObject(l[o])||n==r)return l[o]!==i?(s=l[o],!1):(b.error(S.method,t),!1);l=l[o]}})),e.isFunction(s)?c=s.apply(o,n):s!==i&&(c=s),e.isArray(a)?a.push(c):a!==i?a=[a,c]:c!==i&&(a=c),s}},v?(R===i&&b.initialize(),b.invoke(f)):(R!==i&&R.invoke("destroy"),b.initialize())}),a!==i?a:r},e.fn.dropdown.settings={debug:!1,verbose:!0,performance:!0,on:"click",action:"activate",allowTab:!0,fullTextSearch:!1,preserveHTML:!0,sortSelect:!1,allowCategorySelection:!1,delay:{hide:300,show:200,search:50,touch:50},forceSelection:!0,transition:"auto",duration:250,onNoResults:function(){},onChange:function(){},onShow:function(){},onHide:function(){},name:"Dropdown",namespace:"dropdown",error:{action:"You called a dropdown action that was not defined",alreadySetup:"Once a select has been initialized behaviors must be called on the created ui dropdown",method:"The method you called is not defined.",transition:"The requested transition was not found"},metadata:{defaultText:"defaultText",defaultValue:"defaultValue",placeholderText:"placeholderText",text:"text",value:"value"},selector:{dropdown:".ui.dropdown",input:'> input[type="hidden"], > select',item:".item",menu:".menu",menuIcon:".dropdown.icon",search:"> input.search, .menu > .search > input, .menu > input.search",text:"> .text:not(.icon)"},className:{active:"active",animating:"animating",disabled:"disabled",dropdown:"ui dropdown",filtered:"filtered",loading:"loading",menu:"menu",placeholder:"default",search:"search",selected:"selected",selection:"selection",upward:"upward",visible:"visible"}},e.fn.dropdown.settings.templates={menu:function(t){var n=(t.placeholder||!1,t.values||{},"");return e.each(t.values,function(e,t){n+='<div class="item" data-value="'+t.value+'">'+t.name+"</div>"}),n},dropdown:function(t){var n=t.placeholder||!1,i=(t.values||{},"");return i+='<i class="dropdown icon"></i>',i+=t.placeholder?'<div class="default text">'+n+"</div>":'<div class="text"></div>',i+='<div class="menu">',e.each(t.values,function(e,t){i+='<div class="item" data-value="'+t.value+'">'+t.name+"</div>"}),i+="</div>"}},e.extend(e.easing,{easeOutQuad:function(e,t,n,i,o){return-i*(t/=o)*(t-2)+n}})}(jQuery,window,document);