/*!
 * # Semantic UI 1.11.6 - Visibility
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Copyright 2014 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,t,o,n){"use strict";e.fn.visibility=function(i){var s,c=e(this),r=c.selector||"",a=(new Date).getTime(),l=[],u=arguments[0],d="string"==typeof u,m=[].slice.call(arguments,1);return c.each(function(){var c,b,g=e.isPlainObject(i)?e.extend(!0,{},e.fn.visibility.settings,i):e.extend({},e.fn.visibility.settings),p=g.className,v=g.namespace,f=g.error,h="."+v,P="module-"+v,V=e(t),C=e(this),y=e(g.context),R=C.find("img"),x=(C.selector||"",C.data(P)),T=t.requestAnimationFrame||t.mozRequestAnimationFrame||t.webkitRequestAnimationFrame||t.msRequestAnimationFrame||function(e){setTimeout(e,0)},k=this;b={initialize:function(){b.debug("Initializing",g),b.setup.cache(),b.save.position(),b.should.trackChanges()&&(b.bind.events(),"image"==g.type&&b.setup.image(),"fixed"==g.type&&b.setup.fixed()),g.initialCheck&&b.checkVisibility(),g.observeChanges&&b.observeChanges(),b.instantiate()},instantiate:function(){b.debug("Storing instance",b),C.data(P,b),x=b},destroy:function(){b.verbose("Destroying previous module"),C.off(h).removeData(P),V.off("resize"+h,b.event.refresh),y.off("scroll"+h,b.event.scroll)},observeChanges:function(){y[0];"MutationObserver"in t&&(c=new MutationObserver(function(){b.verbose("DOM tree modified, updating visibility calculations"),b.refresh()}),c.observe(k,{childList:!0,subtree:!0}),b.debug("Setting up mutation observer",c))},bind:{events:function(){b.verbose("Binding visibility events to scroll and resize"),V.on("resize"+h,b.event.refresh),y.on("scroll"+h,b.event.scroll),R.length>0&&b.bind.imageLoad()},imageLoad:function(){var t=R.length,n=t,i=0,s=[],c=[],r=o.createElement("img"),a=function(){i++,i>=t&&(b.debug("Images finished loading inside element, refreshing position"),b.refresh())};for(R.each(function(){s.push(e(this).attr("src"))});n--;)r=o.createElement("img"),r.onload=a,r.onerror=a,r.src=s[n],c.push(r)}},event:{refresh:function(){T(b.refresh)},scroll:function(){b.verbose("Scroll position changed"),g.throttle?(clearTimeout(b.timer),b.timer=setTimeout(function(){b.checkVisibility()},g.throttle)):T(function(){b.checkVisibility()})}},should:{trackChanges:function(){return d&&m.length>0?(b.debug("One time query, no need to bind events"),!1):(b.debug("Callbacks being attached"),!0)}},setup:{cache:function(){b.cache={occurred:{},screen:{},element:{}}},image:function(){var e=C.data("src");e&&(b.verbose("Lazy loading image",e),g.observeChanges=!1,b.topVisible(function(){b.debug("Image top visible",k),b.precache(e,function(){b.set.image(e),g.onTopVisible=!1})}))},fixed:function(){b.verbose("Setting up fixed on element pass"),g.once=!1,g.onTopPassed=function(){C.addClass(p.fixed).css({top:g.offset+"px"}),g.transition&&e.fn.transition!==n&&C.transition(g.transition,g.duration)},g.onTopPassedReverse=function(){C.removeClass(p.fixed).css({position:"",top:""})}}},set:{image:function(t){var o=b.cache.screen.bottom<b.cache.element.top;C.attr("src",t),o?(b.verbose("Image outside browser, no show animation"),C.show()):g.transition?e.fn.transition!==n?C.transition(g.transition,g.duration):C.fadeIn(g.duration):C.show()}},is:{visible:function(){return b.cache&&b.cache.element?b.cache.element.width>0:!1}},refresh:function(){b.debug("Refreshing constants (element width/height)"),b.reset(),b.save.position(),b.checkVisibility(),g.onRefresh.call(k)},reset:function(){b.verbose("Reseting all cached values"),e.isPlainObject(b.cache)&&(b.cache.screen={},b.cache.element={})},checkVisibility:function(){b.verbose("Checking visibility of element",b.cache.element),b.is.visible()&&(b.save.calculations(),b.passed(),b.passingReverse(),b.topVisibleReverse(),b.bottomVisibleReverse(),b.topPassedReverse(),b.bottomPassedReverse(),b.passing(),b.topVisible(),b.bottomVisible(),b.topPassed(),b.bottomPassed(),g.onUpdate&&g.onUpdate.call(k,b.get.elementCalculations()))},passed:function(t,o){var i=b.get.elementCalculations();if(t!==n&&o!==n)g.onPassed[t]=o;else{if(t!==n)return b.get.pixelsPassed(t)>i.pixelsPassed;i.passing&&e.each(g.onPassed,function(e,t){i.bottomVisible||i.pixelsPassed>b.get.pixelsPassed(e)?b.execute(t,e):g.once||b.remove.occurred(t)})}},passing:function(e){var t=b.get.elementCalculations(),o=e||g.onPassing,i="passing";return e&&(b.debug("Adding callback for passing",e),g.onPassing=e),t.passing?b.execute(o,i):g.once||b.remove.occurred(i),e!==n?t.passing:void 0},topVisible:function(e){var t=b.get.elementCalculations(),o=e||g.onTopVisible,i="topVisible";return e&&(b.debug("Adding callback for top visible",e),g.onTopVisible=e),t.topVisible?b.execute(o,i):g.once||b.remove.occurred(i),e===n?t.topVisible:void 0},bottomVisible:function(e){var t=b.get.elementCalculations(),o=e||g.onBottomVisible,i="bottomVisible";return e&&(b.debug("Adding callback for bottom visible",e),g.onBottomVisible=e),t.bottomVisible?b.execute(o,i):g.once||b.remove.occurred(i),e===n?t.bottomVisible:void 0},topPassed:function(e){var t=b.get.elementCalculations(),o=e||g.onTopPassed,i="topPassed";return e&&(b.debug("Adding callback for top passed",e),g.onTopPassed=e),t.topPassed?b.execute(o,i):g.once||b.remove.occurred(i),e===n?t.topPassed:void 0},bottomPassed:function(e){var t=b.get.elementCalculations(),o=e||g.onBottomPassed,i="bottomPassed";return e&&(b.debug("Adding callback for bottom passed",e),g.onBottomPassed=e),t.bottomPassed?b.execute(o,i):g.once||b.remove.occurred(i),e===n?t.bottomPassed:void 0},passingReverse:function(e){var t=b.get.elementCalculations(),o=e||g.onPassingReverse,i="passingReverse";return e&&(b.debug("Adding callback for passing reverse",e),g.onPassingReverse=e),t.passing?g.once||b.remove.occurred(i):b.get.occurred("passing")&&b.execute(o,i),e!==n?!t.passing:void 0},topVisibleReverse:function(e){var t=b.get.elementCalculations(),o=e||g.onTopVisibleReverse,i="topVisibleReverse";return e&&(b.debug("Adding callback for top visible reverse",e),g.onTopVisibleReverse=e),t.topVisible?g.once||b.remove.occurred(i):b.get.occurred("topVisible")&&b.execute(o,i),e===n?!t.topVisible:void 0},bottomVisibleReverse:function(e){var t=b.get.elementCalculations(),o=e||g.onBottomVisibleReverse,i="bottomVisibleReverse";return e&&(b.debug("Adding callback for bottom visible reverse",e),g.onBottomVisibleReverse=e),t.bottomVisible?g.once||b.remove.occurred(i):b.get.occurred("bottomVisible")&&b.execute(o,i),e===n?!t.bottomVisible:void 0},topPassedReverse:function(e){var t=b.get.elementCalculations(),o=e||g.onTopPassedReverse,i="topPassedReverse";return e&&(b.debug("Adding callback for top passed reverse",e),g.onTopPassedReverse=e),t.topPassed?g.once||b.remove.occurred(i):b.get.occurred("topPassed")&&b.execute(o,i),e===n?!t.onTopPassed:void 0},bottomPassedReverse:function(e){var t=b.get.elementCalculations(),o=e||g.onBottomPassedReverse,i="bottomPassedReverse";return e&&(b.debug("Adding callback for bottom passed reverse",e),g.onBottomPassedReverse=e),t.bottomPassed?g.once||b.remove.occurred(i):b.get.occurred("bottomPassed")&&b.execute(o,i),e===n?!t.bottomPassed:void 0},execute:function(e,t){var o=b.get.elementCalculations(),n=b.get.screenCalculations();e=e||!1,e&&(g.continuous?(b.debug("Callback being called continuously",t,o),e.call(k,o,n)):b.get.occurred(t)||(b.debug("Conditions met",t,o),e.call(k,o,n))),b.save.occurred(t)},remove:{occurred:function(e){e?b.cache.occurred[e]!==n&&b.cache.occurred[e]===!0&&(b.debug("Callback can now be called again",e),b.cache.occurred[e]=!1):b.cache.occurred={}}},save:{calculations:function(){b.verbose("Saving all calculations necessary to determine positioning"),b.save.scroll(),b.save.direction(),b.save.screenCalculations(),b.save.elementCalculations()},occurred:function(e){e&&(b.cache.occurred[e]===n||b.cache.occurred[e]!==!0)&&(b.verbose("Saving callback occurred",e),b.cache.occurred[e]=!0)},scroll:function(){b.cache.scroll=y.scrollTop()+g.offset},direction:function(){var e,t=b.get.scroll(),o=b.get.lastScroll();return e=t>o&&o?"down":o>t&&o?"up":"static",b.cache.direction=e,b.cache.direction},elementPosition:function(){var e=b.cache.element,t=b.get.screenSize();return b.verbose("Saving element position"),e.fits=e.height<t.height,e.offset=C.offset(),e.width=C.outerWidth(),e.height=C.outerHeight(),b.cache.element=e,e},elementCalculations:function(){var e=b.get.screenCalculations(),t=b.get.elementPosition();return g.includeMargin?(t.margin={},t.margin.top=parseInt(C.css("margin-top"),10),t.margin.bottom=parseInt(C.css("margin-bottom"),10),t.top=t.offset.top-t.margin.top,t.bottom=t.offset.top+t.height+t.margin.bottom):(t.top=t.offset.top,t.bottom=t.offset.top+t.height),t.topVisible=e.bottom>=t.top,t.topPassed=e.top>=t.top,t.bottomVisible=e.bottom>=t.bottom,t.bottomPassed=e.top>=t.bottom,t.pixelsPassed=0,t.percentagePassed=0,t.visible=t.topVisible||t.bottomVisible,t.passing=t.topPassed&&!t.bottomPassed,t.hidden=!t.topVisible&&!t.bottomVisible,t.passing&&(t.pixelsPassed=e.top-t.top,t.percentagePassed=(e.top-t.top)/t.height),b.cache.element=t,b.verbose("Updated element calculations",t),t},screenCalculations:function(){var e=b.get.scroll();return b.save.direction(),b.cache.screen.top=e,b.cache.screen.bottom=e+b.cache.screen.height,b.cache.screen},screenSize:function(){b.verbose("Saving window position"),b.cache.screen={height:y.height()}},position:function(){b.save.screenSize(),b.save.elementPosition()}},get:{pixelsPassed:function(e){var t=b.get.elementCalculations();return e.search("%")>-1?t.height*(parseInt(e,10)/100):parseInt(e,10)},occurred:function(e){return b.cache.occurred!==n?b.cache.occurred[e]||!1:!1},direction:function(){return b.cache.direction===n&&b.save.direction(),b.cache.direction},elementPosition:function(){return b.cache.element===n&&b.save.elementPosition(),b.cache.element},elementCalculations:function(){return b.cache.element===n&&b.save.elementCalculations(),b.cache.element},screenCalculations:function(){return b.cache.screen===n&&b.save.screenCalculations(),b.cache.screen},screenSize:function(){return b.cache.screen===n&&b.save.screenSize(),b.cache.screen},scroll:function(){return b.cache.scroll===n&&b.save.scroll(),b.cache.scroll},lastScroll:function(){return b.cache.screen===n?(b.debug("First scroll event, no last scroll could be found"),!1):b.cache.screen.top}},setting:function(t,o){if(e.isPlainObject(t))e.extend(!0,g,t);else{if(o===n)return g[t];g[t]=o}},internal:function(t,o){if(e.isPlainObject(t))e.extend(!0,b,t);else{if(o===n)return b[t];b[t]=o}},debug:function(){g.debug&&(g.performance?b.performance.log(arguments):(b.debug=Function.prototype.bind.call(console.info,console,g.name+":"),b.debug.apply(console,arguments)))},verbose:function(){g.verbose&&g.debug&&(g.performance?b.performance.log(arguments):(b.verbose=Function.prototype.bind.call(console.info,console,g.name+":"),b.verbose.apply(console,arguments)))},error:function(){b.error=Function.prototype.bind.call(console.error,console,g.name+":"),b.error.apply(console,arguments)},performance:{log:function(e){var t,o,n;g.performance&&(t=(new Date).getTime(),n=a||t,o=t-n,a=t,l.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:k,"Execution Time":o})),clearTimeout(b.performance.timer),b.performance.timer=setTimeout(b.performance.display,100)},display:function(){var t=g.name+":",o=0;a=!1,clearTimeout(b.performance.timer),e.each(l,function(e,t){o+=t["Execution Time"]}),t+=" "+o+"ms",r&&(t+=" '"+r+"'"),(console.group!==n||console.table!==n)&&l.length>0&&(console.groupCollapsed(t),console.table?console.table(l):e.each(l,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),l=[]}},invoke:function(t,o,i){var c,r,a,l=x;return o=o||m,i=k||i,"string"==typeof t&&l!==n&&(t=t.split(/[\. ]/),c=t.length-1,e.each(t,function(o,i){var s=o!=c?i+t[o+1].charAt(0).toUpperCase()+t[o+1].slice(1):t;if(e.isPlainObject(l[s])&&o!=c)l=l[s];else{if(l[s]!==n)return r=l[s],!1;if(!e.isPlainObject(l[i])||o==c)return l[i]!==n?(r=l[i],!1):(b.error(f.method,t),!1);l=l[i]}})),e.isFunction(r)?a=r.apply(i,o):r!==n&&(a=r),e.isArray(s)?s.push(a):s!==n?s=[s,a]:a!==n&&(s=a),r}},d?(x===n&&b.initialize(),b.invoke(u)):(x!==n&&x.invoke("destroy"),b.initialize())}),s!==n?s:this},e.fn.visibility.settings={name:"Visibility",namespace:"visibility",debug:!1,verbose:!1,performance:!0,observeChanges:!0,once:!0,continuous:!1,offset:0,includeMargin:!1,context:t,initialCheck:!0,throttle:!1,type:!1,transition:!1,duration:1e3,onPassed:{},onPassing:!1,onTopVisible:!1,onBottomVisible:!1,onTopPassed:!1,onBottomPassed:!1,onPassingReverse:!1,onTopVisibleReverse:!1,onBottomVisibleReverse:!1,onTopPassedReverse:!1,onBottomPassedReverse:!1,onUpdate:!1,onRefresh:function(){},className:{fixed:"fixed"},error:{method:"The method you called is not defined."}}}(jQuery,window,document);