/*!
 * # Semantic UI 1.12.1 - Search
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Copyright 2014 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,t,s,n){"use strict";e.fn.search=function(r){var a,i=e(this),o=i.selector||"",c=(new Date).getTime(),u=[],l=arguments[0],d="string"==typeof l,f=[].slice.call(arguments,1);return e(this).each(function(){var p,g=e.extend(!0,{},e.fn.search.settings,r),h=g.className,m=g.metadata,v=g.regExp,b=g.selector,y=g.error,w=g.namespace,R="."+w,C=w+"-module",x=e(this),A=x.find(b.prompt),k=x.find(b.searchButton),S=x.find(b.results),q=(x.find(b.result),x.find(b.category),this),E=x.data(C);p={initialize:function(){p.verbose("Initializing module");var e=A[0],t=e!==n&&e.oninput!==n?"input":e!==n&&e.onpropertychange!==n?"propertychange":"keyup";g.automatic&&A.on(t+R,p.throttle).attr("autocomplete","off"),A.on("focus"+R,p.event.focus).on("blur"+R,p.event.blur).on("keydown"+R,p.handleKeyboard),k.on("click"+R,p.query),S.on("mousedown"+R,p.event.result.mousedown).on("mouseup"+R,p.event.result.mouseup).on("click"+R,b.result,p.event.result.click),p.instantiate()},instantiate:function(){p.verbose("Storing instance of module",p),E=p,x.data(C,p)},destroy:function(){p.verbose("Destroying instance"),x.removeData(C),A.off(R),k.off(R),S.off(R)},event:{focus:function(){p.set.focus(),clearTimeout(p.timer),p.throttle(),p.has.minimumCharacters()&&p.showResults()},blur:function(){var e=s.activeElement===this;e||p.resultsClicked||(p.cancel.query(),p.remove.focus(),p.timer=setTimeout(p.hideResults,g.hideDelay))},result:{mousedown:function(){p.resultsClicked=!0},mouseup:function(){p.resultsClicked=!1},click:function(s){p.debug("Search result selected");var n=e(this),r=n.find(b.title).eq(0),a=n.find("a[href]").eq(0),i=a.attr("href")||!1,o=a.attr("target")||!1,c=(r.html(),r.length>0?r.text():!1),u=p.get.results(),l=p.get.result(c,u);return e.isFunction(g.onSelect)&&g.onSelect.call(q,l,u)===!1?void p.debug("Custom onSelect callback cancelled default select action"):(p.hideResults(),c&&p.set.value(c),void(i&&(p.verbose("Opening search link found in result",a),"_blank"==o||s.ctrlKey?t.open(i):t.location.href=i)))}}},handleKeyboard:function(e){var t,s=x.find(b.result),n=x.find(b.category),r=s.index(s.filter("."+h.active)),a=s.length,i=e.which,o={backspace:8,enter:13,escape:27,upArrow:38,downArrow:40};if(i==o.escape&&(p.verbose("Escape key pressed, blurring search field"),A.trigger("blur")),p.is.visible())if(i==o.enter){if(p.verbose("Enter key pressed, selecting active result"),s.filter("."+h.active).length>0)return p.event.result.click.call(s.filter("."+h.active),e),e.preventDefault(),!1}else i==o.upArrow?(p.verbose("Up key pressed, changing active result"),t=0>r-1?r:r-1,n.removeClass(h.active),s.removeClass(h.active).eq(t).addClass(h.active).closest(n).addClass(h.active),e.preventDefault()):i==o.downArrow&&(p.verbose("Down key pressed, changing active result"),t=r+1>=a?r:r+1,n.removeClass(h.active),s.removeClass(h.active).eq(t).addClass(h.active).closest(n).addClass(h.active),e.preventDefault());else i==o.enter&&(p.verbose("Enter key pressed, executing query"),p.query(),p.set.buttonPressed(),A.one("keyup",p.remove.buttonFocus))},setup:{api:function(){var e={on:!1,action:"search",onFailure:p.error};p.verbose("First request, initializing API"),x.api(e)}},can:{useAPI:function(){return e.fn.api!==n},transition:function(){return g.transition&&e.fn.transition!==n&&x.transition("is supported")}},is:{empty:function(){return""===S.html()},visible:function(){return S.filter(":visible").length>0},focused:function(){return A.filter(":focus").length>0}},get:{value:function(){return A.val()},results:function(){var e=x.data(m.results);return e},result:function(t,s){var n=!1;return t=t||p.get.value(),s=s||p.get.results(),"category"===g.type?(p.debug("Finding result that matches",t),e.each(s,function(s,r){return e.isArray(r.results)&&(n=p.search.object(t,r.results)[0],n&&n.length>0)?!0:void 0})):(p.debug("Finding result in results object",t),n=p.search.object(t,s)[0]),n}},set:{focus:function(){x.addClass(h.focus)},loading:function(){x.addClass(h.loading)},value:function(e){p.verbose("Setting search input value",e),A.val(e),p.query()},buttonPressed:function(){k.addClass(h.pressed)}},remove:{loading:function(){x.removeClass(h.loading)},focus:function(){x.removeClass(h.focus)},buttonPressed:function(){k.removeClass(h.pressed)}},query:function(){var t=p.get.value(),s=p.read.cache(t);s?(p.debug("Reading result for "+t+" from cache"),p.save.results(s.results),p.addResults(s.html)):(p.debug("Querying for "+t),e.isPlainObject(g.source)||e.isArray(g.source)?p.search.local(t):p.can.useAPI()?g.apiSettings?(p.debug("Searching with specified API settings",g.apiSettings),p.search.remote(t)):e.api.settings.api.search!==n?(p.debug("Searching with default search API endpoint"),p.search.remote(t)):p.error(y.noEndpoint):p.error(y.source),g.onSearchQuery.call(q,t))},search:{local:function(e){var t,s=p.search.object(e,g.content);p.set.loading(),p.save.results(s),p.debug("Returned local search results",s),t=p.generateResults({results:s}),p.remove.loading(),p.write.cache(e,{html:t,results:s}),p.addResults(t)},remote:function(t){var s={onSuccess:function(e){p.parse.response.call(q,e,t)},urlData:{query:t}};x.api("get request")||p.setup.api(),e.extend(!0,s,g.apiSettings),p.debug("Executing search",s),p.cancel.query(),x.api("setting",s).api("query")},object:function(t,s){var r=[],a=[],i=e.isArray(g.searchFields)?g.searchFields:[g.searchFields],o=t.replace(v.escape,"\\$&"),c=new RegExp(v.exact+o,"i");return s=s||g.source,s===n?(p.error(y.source),[]):(e.each(i,function(n,i){e.each(s,function(s,n){var o="string"==typeof n[i],u=-1==e.inArray(n,r)&&-1==e.inArray(n,a);o&&u&&(n[i].match(c)?r.push(n):g.searchFullText&&p.fuzzySearch(t,n[i])&&a.push(n))})}),e.merge(r,a))}},fuzzySearch:function(e,t){var s=t.length,n=e.length;if(e=e.toLowerCase(),t=t.toLowerCase(),n>s)return!1;if(n===s)return e===t;e:for(var r=0,a=0;n>r;r++){for(var i=e.charCodeAt(r);s>a;)if(t.charCodeAt(a++)===i)continue e;return!1}return!0},parse:{response:function(e,t){var s=p.generateResults(e);p.verbose("Parsing server response",e),e!==n&&t!==n&&e.results!==n&&(p.write.cache(t,{html:s,results:e.results}),p.save.results(e.results),p.addResults(s))}},throttle:function(){clearTimeout(p.timer),p.has.minimumCharacters()?p.timer=setTimeout(p.query,g.searchDelay):p.hideResults()},cancel:{query:function(){p.can.useAPI()&&x.api("abort")}},has:{minimumCharacters:function(){var e=p.get.value(),t=e.length;return t>=g.minCharacters}},read:{cache:function(e){var t=x.data(m.cache);return g.cache?(p.verbose("Checking cache for generated html for query",e),"object"==typeof t&&t[e]!==n?t[e]:!1):!1}},save:{results:function(e){p.verbose("Saving current search results to metadata",e),x.data(m.results,e)}},write:{cache:function(e,t){var s=x.data(m.cache)!==n?x.data(m.cache):{};g.cache&&(p.verbose("Writing generated html to cache",e,t),s[e]=t,x.data(m.cache,s))}},addResults:function(t){return e.isFunction(g.onResultsAdd)&&g.onResultsAdd.call(S,t)===!1?(p.debug("onResultsAdd callback cancelled default action"),!1):(S.html(t),void p.showResults())},showResults:function(){p.is.visible()||!p.is.focused()||p.is.empty()||(p.can.transition()?(p.debug("Showing results with css animations"),S.transition({animation:g.transition+" in",duration:g.duration,queue:!0})):(p.debug("Showing results with javascript"),S.stop().fadeIn(g.duration,g.easing)),g.onResultsOpen.call(S))},hideResults:function(){p.is.visible()&&(p.can.transition()?(p.debug("Hiding results with css animations"),S.transition({animation:g.transition+" out",duration:g.duration,queue:!0})):(p.debug("Hiding results with javascript"),S.stop().fadeOut(g.duration,g.easing)),g.onResultsClose.call(S))},generateResults:function(t){p.debug("Generating html from response",t);var s=g.templates[g.type],n=e.isPlainObject(t.results)&&!e.isEmptyObject(t.results),r=e.isArray(t.results)&&t.results.length>0,a="";return n||r?(g.maxResults>0&&(n?"standard"==g.type&&p.error(y.maxResults):t.results=t.results.slice(0,g.maxResults)),e.isFunction(s)?a=s(t):p.error(y.noTemplate,!1)):a=p.displayMessage(y.noResults,"empty"),g.onResults.call(q,t),a},displayMessage:function(e,t){return t=t||"standard",p.debug("Displaying message",e,t),p.addResults(g.templates.message(e,t)),g.templates.message(e,t)},setting:function(t,s){if(e.isPlainObject(t))e.extend(!0,g,t);else{if(s===n)return g[t];g[t]=s}},internal:function(t,s){if(e.isPlainObject(t))e.extend(!0,p,t);else{if(s===n)return p[t];p[t]=s}},debug:function(){g.debug&&(g.performance?p.performance.log(arguments):(p.debug=Function.prototype.bind.call(console.info,console,g.name+":"),p.debug.apply(console,arguments)))},verbose:function(){g.verbose&&g.debug&&(g.performance?p.performance.log(arguments):(p.verbose=Function.prototype.bind.call(console.info,console,g.name+":"),p.verbose.apply(console,arguments)))},error:function(){p.error=Function.prototype.bind.call(console.error,console,g.name+":"),p.error.apply(console,arguments)},performance:{log:function(e){var t,s,n;g.performance&&(t=(new Date).getTime(),n=c||t,s=t-n,c=t,u.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:q,"Execution Time":s})),clearTimeout(p.performance.timer),p.performance.timer=setTimeout(p.performance.display,100)},display:function(){var t=g.name+":",s=0;c=!1,clearTimeout(p.performance.timer),e.each(u,function(e,t){s+=t["Execution Time"]}),t+=" "+s+"ms",o&&(t+=" '"+o+"'"),i.length>1&&(t+=" ("+i.length+")"),(console.group!==n||console.table!==n)&&u.length>0&&(console.groupCollapsed(t),console.table?console.table(u):e.each(u,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),u=[]}},invoke:function(t,s,r){var i,o,c,u=E;return s=s||f,r=q||r,"string"==typeof t&&u!==n&&(t=t.split(/[\. ]/),i=t.length-1,e.each(t,function(s,r){var a=s!=i?r+t[s+1].charAt(0).toUpperCase()+t[s+1].slice(1):t;if(e.isPlainObject(u[a])&&s!=i)u=u[a];else{if(u[a]!==n)return o=u[a],!1;if(!e.isPlainObject(u[r])||s==i)return u[r]!==n?(o=u[r],!1):!1;u=u[r]}})),e.isFunction(o)?c=o.apply(r,s):o!==n&&(c=o),e.isArray(a)?a.push(c):a!==n?a=[a,c]:c!==n&&(a=c),o}},d?(E===n&&p.initialize(),p.invoke(l)):(E!==n&&E.invoke("destroy"),p.initialize())}),a!==n?a:this},e.fn.search.settings={name:"Search Module",namespace:"search",debug:!1,verbose:!0,performance:!0,type:"standard",minCharacters:1,apiSettings:!1,source:!1,searchFields:["title","description"],searchFullText:!0,automatic:"true",hideDelay:0,searchDelay:100,maxResults:7,cache:!0,transition:"scale",duration:300,easing:"easeOutExpo",onSelect:!1,onResultsAdd:!1,onSearchQuery:function(){},onResults:function(){},onResultsOpen:function(){},onResultsClose:function(){},className:{active:"active",empty:"empty",focus:"focus",loading:"loading",pressed:"down"},error:{source:"Cannot search. No source used, and Semantic API module was not included",noResults:"Your search returned no results",logging:"Error in debug logging, exiting.",noEndpoint:"No search endpoint was specified",noTemplate:"A valid template name was not specified.",serverError:"There was an issue with querying the server.",maxResults:"Results must be an array to use maxResults setting",method:"The method you called is not defined."},metadata:{cache:"cache",results:"results"},regExp:{escape:/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,exact:"(?:s|^)"},selector:{prompt:".prompt",searchButton:".search.button",results:".results",category:".category",result:".result",title:".title, .name"},templates:{escape:function(e){var t=/[&<>"'`]/g,s=/[&<>"'`]/,n={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},r=function(e){return n[e]};return s.test(e)?e.replace(t,r):e},message:function(e,t){var s="";return e!==n&&t!==n&&(s+='<div class="message '+t+'">',s+="empty"==t?'<div class="header">No Results</div class="header"><div class="description">'+e+'</div class="description">':' <div class="description">'+e+"</div>",s+="</div>"),s},category:function(t){var s="",r=e.fn.search.settings.templates.escape;return t.results!==n?(e.each(t.results,function(t,a){a.results!==n&&a.results.length>0&&(s+='<div class="category"><div class="name">'+a.name+"</div>",e.each(a.results,function(e,t){s+='<div class="result">',t.url&&(s+='<a href="'+t.url+'"></a>'),t.image!==n&&(t.image=r(t.image),s+='<div class="image"> <img src="'+t.image+'" alt=""></div>'),s+='<div class="content">',t.price!==n&&(t.price=r(t.price),s+='<div class="price">'+t.price+"</div>"),t.title!==n&&(t.title=r(t.title),s+='<div class="title">'+t.title+"</div>"),t.description!==n&&(s+='<div class="description">'+t.description+"</div>"),s+="</div></div>"}),s+="</div>")}),t.action&&(s+='<a href="'+t.action.url+'" class="action">'+t.action.text+"</a>"),s):!1},standard:function(t){var s="";return t.results!==n?(e.each(t.results,function(e,t){s+=t.url?'<a class="result" href="'+t.url+'">':'<a class="result">',t.image!==n&&(s+='<div class="image"> <img src="'+t.image+'"></div>'),s+='<div class="content">',t.price!==n&&(s+='<div class="price">'+t.price+"</div>"),t.title!==n&&(s+='<div class="title">'+t.title+"</div>"),t.description!==n&&(s+='<div class="description">'+t.description+"</div>"),s+="</div>",s+="</a>"}),t.action&&(s+='<a href="'+t.action.url+'" class="action">'+t.action.text+"</a>"),s):!1}}}}(jQuery,window,document);