 /*
 * # Semantic UI
 * https://github.com/Semantic-Org/Semantic-UI
 * http://www.semantic-ui.com/
 *
 * Copyright 2014 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,i,n,o){"use strict";e.fn.modal=function(t){var s,r=e(this),a=e(i),c=e(n),l=e("body"),u=r.selector||"",d=(new Date).getTime(),m=[],f=arguments[0],g="string"==typeof f,h=[].slice.call(arguments,1),b=i.requestAnimationFrame||i.mozRequestAnimationFrame||i.webkitRequestAnimationFrame||i.msRequestAnimationFrame||function(e){setTimeout(e,0)};return r.each(function(){var r,v,p,y,w,k,x,H,M,A=e.isPlainObject(t)?e.extend(!0,{},e.fn.modal.settings,t):e.extend({},e.fn.modal.settings),D=A.selector,S=A.className,z=A.namespace,C=A.error,F="."+z,T="module-"+z,O=e(this),q=e(A.context),E=O.find(D.close),j=this,I=O.data(T);M={initialize:function(){return M.verbose("Initializing dimmer",q),e.fn.dimmer===o?void M.error(C.dimmer):(x=M.get.uniqueID(),k="."+x,y=q.dimmer({debug:A.debug,dimmerName:"modals",closable:!1,useCSS:!0,duration:{show:.9*A.duration,hide:1.1*A.duration}}),A.detachable&&y.dimmer("add content",O),w=y.dimmer("get dimmer"),M.refreshModals(),M.verbose("Attaching close events",E),M.bind.events(),M.observeChanges(),void M.instantiate())},instantiate:function(){M.verbose("Storing instance of modal"),I=M,O.data(T,I)},destroy:function(){M.verbose("Destroying previous modal"),O.removeData(T).off(F),a.off(k),E.off(F),q.dimmer("destroy")},observeChanges:function(){"MutationObserver"in i&&(H=new MutationObserver(function(){M.debug("DOM tree modified, refreshing"),M.refresh()}),H.observe(j,{childList:!0,subtree:!0}),M.debug("Setting up mutation observer",H))},refresh:function(){M.remove.scrolling(),M.cacheSizes(),M.set.screenHeight(),M.set.type(),M.set.position()},refreshModals:function(){v=O.siblings(D.modal),r=v.add(O)},attachEvents:function(i,n){var o=e(i);n=e.isFunction(M[n])?M[n]:M.toggle,o.size()>0?(M.debug("Attaching modal events to element",i,n),o.off(F).on("click"+F,n)):M.error(C.notFound,i)},bind:{events:function(){E.on("click"+F,M.event.close),a.on("resize"+k,M.event.resize)}},get:{uniqueID:function(){return(Math.random().toString(16)+"000000000").substr(2,8)}},event:{close:function(){M.verbose("Closing element pressed"),e(this).is(D.approve)?e.proxy(A.onApprove,j)()!==!1?M.hide():M.verbose("Approve callback returned false cancelling hide"):e(this).is(D.deny)?e.proxy(A.onDeny,j)()!==!1?M.hide():M.verbose("Deny callback returned false cancelling hide"):M.hide()},click:function(i){0===e(i.target).closest(O).size()&&(M.debug("Dimmer clicked, hiding all modals"),M.is.active()&&(M.remove.clickaway(),A.allowMultiple?M.hide():M.hideAll()))},debounce:function(e,i){clearTimeout(M.timer),M.timer=setTimeout(e,i)},keyboard:function(e){var i=e.which,n=27;i==n&&(A.closable?(M.debug("Escape key pressed hiding modal"),M.hide()):M.debug("Escape key pressed, but closable is set to false"),e.preventDefault())},resize:function(){y.dimmer("is active")&&b(M.refresh)}},toggle:function(){M.is.active()||M.is.animating()?M.hide():M.show()},show:function(i){i=e.isFunction(i)?i:function(){},M.refreshModals(),M.showDimmer(),M.showModal(i)},hide:function(i){i=e.isFunction(i)?i:function(){},M.refreshModals(),M.othersActive()||M.hideDimmer(),M.hideModal(i)},showModal:function(i){i=e.isFunction(i)?i:function(){},M.is.active()?M.debug("Modal is already visible"):!A.allowMultiple&&v.filter(":visible").size()>0?(M.debug("Other modals visible, queueing show animation"),M.hideOthers(M.showModal)):(e.proxy(A.onShow,j)(),A.transition&&e.fn.transition!==o&&O.transition("is supported")?(M.debug("Showing modal with css animations"),M.cacheSizes(),M.set.position(),M.set.screenHeight(),M.set.type(),M.set.clickaway(),O.transition({debug:A.debug,animation:A.transition+" in",queue:!1,duration:A.duration,onComplete:function(){e.proxy(A.onVisible,j)(),M.add.keyboardShortcuts(),M.save.focus(),M.set.active(),M.set.autofocus(),i()}})):(M.debug("Showing modal with javascript"),O.fadeIn(A.duration,A.easing,function(){e.proxy(A.onVisible,j)(),M.add.keyboardShortcuts(),M.save.focus(),M.set.active(),i()})))},showDimmer:function(){y.dimmer("is active")?M.debug("Dimmer already visible"):(M.debug("Showing dimmer"),y.dimmer("show"))},hideDimmer:function(){return y.dimmer("is active")||y.dimmer("is animating")?(M.debug("Hiding dimmer"),void y.dimmer("hide",function(){A.transition&&e.fn.transition!==o&&O.transition("is supported")&&(M.remove.clickaway(),M.remove.screenHeight())})):void M.debug("Dimmer is not visible cannot hide")},hideModal:function(i){i=e.isFunction(i)?i:function(){},M.debug("Hiding modal"),e.proxy(A.onHide,j)(),A.transition&&e.fn.transition!==o&&O.transition("is supported")?(M.remove.active(),O.transition({debug:A.debug,animation:A.transition+" out",queue:!1,duration:A.duration,onStart:function(){M.remove.keyboardShortcuts()},onComplete:function(){e.proxy(A.onHidden,j)(),M.restore.focus(),i()}})):(M.remove.active(),M.remove.keyboardShortcuts(),O.fadeOut(A.duration,A.easing,function(){e.proxy(A.onHidden,j)(),M.restore.focus(),i()}))},hideAll:function(i){i=e.isFunction(i)?i:function(){},r.is(":visible")&&(M.debug("Hiding all visible modals"),M.hideDimmer(),r.filter(":visible").modal("hide modal",i))},hideOthers:function(i){i=e.isFunction(i)?i:function(){},v.is(":visible")&&(M.debug("Hiding other modals",v),v.filter(":visible").modal("hide modal",i))},othersActive:function(){return v.filter("."+S.active).size()>0},add:{keyboardShortcuts:function(){M.verbose("Adding keyboard shortcuts"),c.on("keyup"+F,M.event.keyboard)}},save:{focus:function(){p=e(n.activeElement).blur()}},restore:{focus:function(){p&&p.size()>0&&p.focus()}},remove:{active:function(){O.removeClass(S.active)},clickaway:function(){A.closable&&w.off("click"+k)},screenHeight:function(){M.cache.height>M.cache.pageHeight&&(M.debug("Removing page height"),l.css("height",""))},keyboardShortcuts:function(){M.verbose("Removing keyboard shortcuts"),c.off("keyup"+F)},scrolling:function(){y.removeClass(S.scrolling),O.removeClass(S.scrolling)}},cacheSizes:function(){var t=O.outerHeight();(M.cache===o||0!==t)&&(M.cache={pageHeight:e(n).outerHeight(),height:t+A.offset,contextHeight:"body"==A.context?e(i).height():y.height()}),M.debug("Caching modal and container sizes",M.cache)},can:{fit:function(){return M.cache.height<M.cache.contextHeight}},is:{active:function(){return O.hasClass(S.active)},animating:function(){return O.transition("is supported")?O.transition("is animating"):O.is(":visible")},scrolling:function(){return y.hasClass(S.scrolling)},modernBrowser:function(){return!(i.ActiveXObject||"ActiveXObject"in i)}},set:{autofocus:function(){if(A.autofocus){var e=O.find(":input:visible"),i=e.filter("[autofocus]"),n=i.size()>0?i:e;n.first().focus()}},clickaway:function(){A.closable&&w.on("click"+k,M.event.click)},screenHeight:function(){M.cache.height>M.cache.pageHeight?(M.debug("Modal is taller than page content, resizing page height"),l.css("height",M.cache.height+A.padding)):l.css("height","")},active:function(){O.addClass(S.active)},scrolling:function(){y.addClass(S.scrolling),O.addClass(S.scrolling)},type:function(){M.can.fit()?(M.verbose("Modal fits on screen"),M.othersActive||M.remove.scrolling()):(M.verbose("Modal cannot fit on screen setting to scrolling"),M.set.scrolling())},position:function(){M.verbose("Centering modal on page",M.cache),O.css(M.can.fit()?{top:"",marginTop:-(M.cache.height/2)}:{marginTop:"",top:c.scrollTop()})}},setting:function(i,n){if(M.debug("Changing setting",i,n),e.isPlainObject(i))e.extend(!0,A,i);else{if(n===o)return A[i];A[i]=n}},internal:function(i,n){if(e.isPlainObject(i))e.extend(!0,M,i);else{if(n===o)return M[i];M[i]=n}},debug:function(){A.debug&&(A.performance?M.performance.log(arguments):(M.debug=Function.prototype.bind.call(console.info,console,A.name+":"),M.debug.apply(console,arguments)))},verbose:function(){A.verbose&&A.debug&&(A.performance?M.performance.log(arguments):(M.verbose=Function.prototype.bind.call(console.info,console,A.name+":"),M.verbose.apply(console,arguments)))},error:function(){M.error=Function.prototype.bind.call(console.error,console,A.name+":"),M.error.apply(console,arguments)},performance:{log:function(e){var i,n,o;A.performance&&(i=(new Date).getTime(),o=d||i,n=i-o,d=i,m.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:j,"Execution Time":n})),clearTimeout(M.performance.timer),M.performance.timer=setTimeout(M.performance.display,100)},display:function(){var i=A.name+":",n=0;d=!1,clearTimeout(M.performance.timer),e.each(m,function(e,i){n+=i["Execution Time"]}),i+=" "+n+"ms",u&&(i+=" '"+u+"'"),(console.group!==o||console.table!==o)&&m.length>0&&(console.groupCollapsed(i),console.table?console.table(m):e.each(m,function(e,i){console.log(i.Name+": "+i["Execution Time"]+"ms")}),console.groupEnd()),m=[]}},invoke:function(i,n,t){var r,a,c,l=I;return n=n||h,t=j||t,"string"==typeof i&&l!==o&&(i=i.split(/[\. ]/),r=i.length-1,e.each(i,function(n,t){var s=n!=r?t+i[n+1].charAt(0).toUpperCase()+i[n+1].slice(1):i;if(e.isPlainObject(l[s])&&n!=r)l=l[s];else{if(l[s]!==o)return a=l[s],!1;if(!e.isPlainObject(l[t])||n==r)return l[t]!==o?(a=l[t],!1):!1;l=l[t]}})),e.isFunction(a)?c=a.apply(t,n):a!==o&&(c=a),e.isArray(s)?s.push(c):s!==o?s=[s,c]:c!==o&&(s=c),a}},g?(I===o&&M.initialize(),M.invoke(f)):(I!==o&&M.destroy(),M.initialize())}),s!==o?s:this},e.fn.modal.settings={name:"Modal",namespace:"modal",debug:!1,verbose:!0,performance:!0,allowMultiple:!1,detachable:!0,closable:!0,autofocus:!0,context:"body",duration:500,easing:"easeOutExpo",offset:0,transition:"scale",padding:30,onShow:function(){},onHide:function(){},onVisible:function(){},onHidden:function(){},onApprove:function(){return!0},onDeny:function(){return!0},selector:{close:".close, .actions .button",approve:".actions .positive, .actions .approve, .actions .ok",deny:".actions .negative, .actions .deny, .actions .cancel",modal:".ui.modal"},error:{dimmer:"UI Dimmer, a required component is not included in this page",method:"The method you called is not defined.",notFound:"The element you specified could not be found"},className:{active:"active",scrolling:"scrolling"}}}(jQuery,window,document);