 /*
 * # Semantic UI
 * https://github.com/Semantic-Org/Semantic-UI
 * http://www.semantic-ui.com/
 *
 * Copyright 2014 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,t,n,r){"use strict";e.fn.progress=function(t){var n,a=e(this),o=a.selector||"",s=(new Date).getTime(),i=[],c=arguments[0],l="string"==typeof c,u=[].slice.call(arguments,1);return a.each(function(){var a,g=e.isPlainObject(t)?e.extend(!0,{},e.fn.progress.settings,t):e.extend({},e.fn.progress.settings),p=g.className,v=g.metadata,m=g.namespace,d=g.selector,b=g.error,f="module-"+m,h=e(this),x=e(this).find(d.bar),y=e(this).find(d.progress),w=e(this).find(d.label),C=this,A=h.data(f);a={initialize:function(){a.debug("Initializing progress",g),a.read.metadata(),a.set.initials(),a.instantiate()},instantiate:function(){a.verbose("Storing instance of progress",a),A=a,h.data(f,a)},destroy:function(){a.verbose("Destroying previous progress for",h),a.remove.state(),h.removeData(f),A=r},reset:function(){a.set.percent(0)},complete:function(){(a.percent===r||a.percent<100)&&a.set.percent(100)},read:{metadata:function(){h.data(v.percent)&&(a.verbose("Current percent value set from metadata"),a.percent=h.data(v.percent)),h.data(v.total)&&(a.verbose("Total value set from metadata"),a.total=h.data(v.total)),h.data(v.value)&&(a.verbose("Current value set from metadata"),a.value=h.data(v.value))},currentValue:function(){return a.value!==r?a.value:!1}},increment:function(e){var t,n,r,o=a.total||!1;o?(n=a.value||0,e=e||1,r=n+e,t=a.total,a.debug("Incrementing value by",e,n,t),r>t&&(a.debug("Value cannot increment above total",t),r=t),a.set.progress(r)):(n=a.percent||0,e=e||a.get.randomValue(),r=n+e,t=100,a.debug("Incrementing percentage by",e,n),r>t&&(a.debug("Value cannot increment above 100 percent"),r=t),a.set.progress(r))},decrement:function(e){var t,n,r=a.total||!1,o=0;r?(t=a.value||0,e=e||1,n=t-e,a.debug("Decrementing value by",e,t)):(t=a.percent||0,e=e||a.get.randomValue(),n=t-e,a.debug("Decrementing percentage by",e,t)),o>n&&(a.debug("Value cannot decrement below 0"),n=0),a.set.progress(n)},get:{text:function(e){var t=a.value||0,n=a.total||0,r=a.percent||0;return e=e||"",e=e.replace("{value}",t).replace("{total}",n).replace("{percent}",r),a.debug("Adding variables to progress bar text",e),e},randomValue:function(){return a.debug("Generating random increment percentage"),Math.floor(Math.random()*g.random.max+g.random.min)},percent:function(){return a.percent||0},value:function(){return a.value||!1},total:function(){return a.total||!1}},is:{success:function(){return h.hasClass(p.success)},warning:function(){return h.hasClass(p.warning)},error:function(){return h.hasClass(p.error)}},remove:{state:function(){a.verbose("Removing stored state"),delete a.total,delete a.percent,delete a.value},active:function(){a.verbose("Removing active state"),h.removeClass(p.active)},success:function(){a.verbose("Removing success state"),h.removeClass(p.success)},warning:function(){a.verbose("Removing warning state"),h.removeClass(p.warning)},error:function(){a.verbose("Removing error state"),h.removeClass(p.error)}},set:{barWidth:function(e){e>100?a.error(b.tooHigh,e):0>e?a.error(b.tooLow,e):x.css("width",e+"%")},initials:function(){g.total!==!1&&(a.verbose("Current total set in settings",g.total),a.total=g.total),g.value!==!1&&(a.verbose("Current value set in settings",g.value),a.value=g.value),g.percent!==!1&&(a.verbose("Current percent set in settings",g.percent),a.percent=g.percent),a.percent!==r?a.set.percent(a.percent):a.value!==r&&a.set.progress(a.value)},percent:function(t){t="string"==typeof t?+t.replace("%",""):t,t>0&&1>t&&(a.verbose("Module percentage passed as decimal, converting"),t=100*t),t=Math.round(0===g.precision?t:10*t*g.precision/(10*g.precision)),a.percent=t,a.total&&(a.value=Math.round(t/100*a.total)),g.limitValues&&(a.value=a.value>100?100:a.value<0?0:a.value),a.set.barWidth(t),a.set.barLabel(),100===t?!g.autoSuccess||a.is.warning()||a.is.error()?a.remove.active():(a.set.success(),a.debug("Automatically triggering success at 100%")):t>0&&a.set.active(),e.proxy(g.onChange,C)(t,a.value,a.total)},label:function(e){e=e||"",e&&(e=a.get.text(e),a.debug("Setting label to text",e),w.text(e))},barLabel:function(e){e!==r?y.text(a.get.text(e)):"ratio"==g.label&&a.total?(a.debug("Adding ratio to bar label"),y.text(a.get.text(g.text.ratio))):"percent"==g.label&&(a.debug("Adding percentage to bar label"),y.text(a.get.text(g.text.percent)))},active:function(t){t=t||g.text.active,a.debug("Setting active state"),g.showActivity&&h.addClass(p.active),a.remove.warning(),a.remove.error(),a.remove.success(),t&&a.set.label(t),e.proxy(g.onActive,C)(a.value,a.total)},success:function(t){t=t||g.text.success,a.debug("Setting success state"),h.addClass(p.success),a.remove.active(),a.remove.warning(),a.remove.error(),a.complete(),t&&a.set.label(t),e.proxy(g.onSuccess,C)(a.total)},warning:function(t){t=t||g.text.warning,a.debug("Setting warning state"),h.addClass(p.warning),a.remove.active(),a.remove.success(),a.remove.error(),a.complete(),t&&a.set.label(t),e.proxy(g.onWarning,C)(a.value,a.total)},error:function(t){t=t||g.text.error,a.debug("Setting error state"),h.addClass(p.error),a.remove.active(),a.remove.success(),a.remove.warning(),a.complete(),t&&a.set.label(t),e.proxy(g.onError,C)(a.value,a.total)},total:function(e){a.total=e},progress:function(e){var t,n="string"==typeof e?""!==e.replace(/[^\d.]/g,"")?+e.replace(/[^\d.]/g,""):!1:e;n===!1&&a.error(b.nonNumeric,e),a.total?(a.value=n,t=n/a.total*100,a.debug("Calculating percent complete from total",t),a.set.percent(t)):(t=n,a.debug("Setting value to exact percentage value",t),a.set.percent(t))}},setting:function(t,n){if(a.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,g,t);else{if(n===r)return g[t];g[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,a,t);else{if(n===r)return a[t];a[t]=n}},debug:function(){g.debug&&(g.performance?a.performance.log(arguments):(a.debug=Function.prototype.bind.call(console.info,console,g.name+":"),a.debug.apply(console,arguments)))},verbose:function(){g.verbose&&g.debug&&(g.performance?a.performance.log(arguments):(a.verbose=Function.prototype.bind.call(console.info,console,g.name+":"),a.verbose.apply(console,arguments)))},error:function(){a.error=Function.prototype.bind.call(console.error,console,g.name+":"),a.error.apply(console,arguments)},performance:{log:function(e){var t,n,r;g.performance&&(t=(new Date).getTime(),r=s||t,n=t-r,s=t,i.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:C,"Execution Time":n})),clearTimeout(a.performance.timer),a.performance.timer=setTimeout(a.performance.display,100)},display:function(){var t=g.name+":",n=0;s=!1,clearTimeout(a.performance.timer),e.each(i,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",o&&(t+=" '"+o+"'"),(console.group!==r||console.table!==r)&&i.length>0&&(console.groupCollapsed(t),console.table?console.table(i):e.each(i,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),i=[]}},invoke:function(t,o,s){var i,c,l,g=A;return o=o||u,s=C||s,"string"==typeof t&&g!==r&&(t=t.split(/[\. ]/),i=t.length-1,e.each(t,function(n,o){var s=n!=i?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(g[s])&&n!=i)g=g[s];else{if(g[s]!==r)return c=g[s],!1;if(!e.isPlainObject(g[o])||n==i)return g[o]!==r?(c=g[o],!1):(a.error(b.method,t),!1);g=g[o]}})),e.isFunction(c)?l=c.apply(s,o):c!==r&&(l=c),e.isArray(n)?n.push(l):n!==r?n=[n,l]:l!==r&&(n=l),c}},l?(A===r&&a.initialize(),a.invoke(c)):(A!==r&&a.destroy(),a.initialize())}),n!==r?n:this},e.fn.progress.settings={name:"Progress",namespace:"progress",debug:!1,verbose:!0,performance:!0,random:{min:2,max:5},autoSuccess:!0,showActivity:!0,limitValues:!0,label:"percent",precision:1,percent:!1,total:!1,value:!1,onChange:function(){},onSuccess:function(){},onActive:function(){},onError:function(){},onWarning:function(){},error:{method:"The method you called is not defined.",nonNumeric:"Progress value is non numeric",tooHigh:"Value specified is above 100%",tooLow:"Value specified is below 0%"},regExp:{variable:/\{\$*[A-z0-9]+\}/g},metadata:{percent:"percent",total:"total",value:"value"},selector:{bar:"> .bar",label:"> .label",progress:".bar > .progress"},text:{active:!1,error:!1,success:!1,warning:!1,percent:"{percent}%",ratio:"{value} of {total}"},className:{active:"active",error:"error",success:"success",warning:"warning"}}}(jQuery,window,document);