 /*
 * # Semantic UI
 * https://github.com/Semantic-Org/Semantic-UI
 * http://www.semantic-ui.com/
 *
 * Copyright 2014 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,i,n,t){"use strict";e.fn.modal=function(o){var s,a=e(this),r=e(i),c=e(n),u=e("body"),l=a.selector||"",d=(new Date).getTime(),m=[],f=arguments[0],g="string"==typeof f,h=[].slice.call(arguments,1),v=i.requestAnimationFrame||i.mozRequestAnimationFrame||i.webkitRequestAnimationFrame||i.msRequestAnimationFrame||function(e){setTimeout(e,0)};return a.each(function(){var a,b,p,y,w,k,S,x,M,A=e.isPlainObject(o)?e.extend(!0,{},e.fn.modal.settings,o):e.extend({},e.fn.modal.settings),C=A.selector,D=A.className,H=A.namespace,z=A.error,F="."+H,T="module-"+H,O=e(this),q=e(A.context),E=O.find(C.close),j=this,I=O.data(T);M={initialize:function(){M.verbose("Initializing dimmer",q),M.create.id(),M.create.dimmer(),M.refreshModals(),M.verbose("Attaching close events",E),M.bind.events(),M.observeChanges(),M.instantiate()},instantiate:function(){M.verbose("Storing instance of modal"),I=M,O.data(T,I)},create:{dimmer:function(){var i={debug:A.debug,dimmerName:"modals",duration:{show:A.duration,hide:A.duration}},n=e.extend(!0,i,A.dimmerSettings);return e.fn.dimmer===t?void M.error(z.dimmer):(M.debug("Creating dimmer with settings",n),y=q.dimmer(n),A.detachable&&(M.verbose("Modal is detachable, moving content into dimmer"),y.dimmer("add content",O)),void(w=y.dimmer("get dimmer")))},id:function(){M.verbose("Creating unique id for element"),S=M.get.uniqueID(),k="."+S}},destroy:function(){M.verbose("Destroying previous modal"),O.removeData(T).off(F),r.off(k),E.off(F),q.dimmer("destroy")},observeChanges:function(){"MutationObserver"in i&&(x=new MutationObserver(function(){M.debug("DOM tree modified, refreshing"),M.refresh()}),x.observe(j,{childList:!0,subtree:!0}),M.debug("Setting up mutation observer",x))},refresh:function(){M.remove.scrolling(),M.cacheSizes(),M.set.screenHeight(),M.set.type(),M.set.position()},refreshModals:function(){b=O.siblings(C.modal),a=b.add(O)},attachEvents:function(i,n){var t=e(i);n=e.isFunction(M[n])?M[n]:M.toggle,t.size()>0?(M.debug("Attaching modal events to element",i,n),t.off(F).on("click"+F,n)):M.error(z.notFound,i)},bind:{events:function(){E.on("click"+F,M.event.close),r.on("resize"+k,M.event.resize)}},get:{uniqueID:function(){return(Math.random().toString(16)+"000000000").substr(2,8)}},event:{close:function(){M.verbose("Closing element pressed"),e(this).is(C.approve)?e.proxy(A.onApprove,j)()!==!1?M.hide():M.verbose("Approve callback returned false cancelling hide"):e(this).is(C.deny)?e.proxy(A.onDeny,j)()!==!1?M.hide():M.verbose("Deny callback returned false cancelling hide"):M.hide()},click:function(i){0===e(i.target).closest(O).size()&&(M.debug("Dimmer clicked, hiding all modals"),M.is.active()&&(M.remove.clickaway(),A.allowMultiple?M.hide():M.hideAll()))},debounce:function(e,i){clearTimeout(M.timer),M.timer=setTimeout(e,i)},keyboard:function(e){var i=e.which,n=27;i==n&&(A.closable?(M.debug("Escape key pressed hiding modal"),M.hide()):M.debug("Escape key pressed, but closable is set to false"),e.preventDefault())},resize:function(){y.dimmer("is active")&&v(M.refresh)}},toggle:function(){M.is.active()||M.is.animating()?M.hide():M.show()},show:function(i){i=e.isFunction(i)?i:function(){},M.refreshModals(),M.showModal(i)},hide:function(i){i=e.isFunction(i)?i:function(){},M.refreshModals(),M.hideModal(i)},showModal:function(i){i=e.isFunction(i)?i:function(){},M.is.animating()||!M.is.active()?(M.showDimmer(),M.cacheSizes(),M.set.position(),M.set.screenHeight(),M.set.type(),M.set.clickaway(),!A.allowMultiple&&b.filter(":visible").size()>0?(M.debug("Other modals visible, queueing show animation"),M.hideOthers(M.showModal)):(e.proxy(A.onShow,j)(),A.transition&&e.fn.transition!==t&&O.transition("is supported")?(M.debug("Showing modal with css animations"),O.transition({debug:A.debug,animation:A.transition+" in",queue:A.queue,duration:A.duration,useFailSafe:!0,onComplete:function(){e.proxy(A.onVisible,j)(),M.add.keyboardShortcuts(),M.save.focus(),M.set.active(),M.set.autofocus(),i()}})):(M.debug("Showing modal with javascript"),O.fadeIn(A.duration,A.easing,function(){e.proxy(A.onVisible,j)(),M.add.keyboardShortcuts(),M.save.focus(),M.set.active(),i()})))):M.debug("Modal is already visible")},hideModal:function(i){i=e.isFunction(i)?i:function(){},M.debug("Hiding modal"),e.proxy(A.onHide,j)(),(M.is.animating()||M.is.active())&&(A.transition&&e.fn.transition!==t&&O.transition("is supported")?(M.remove.active(),O.transition({debug:A.debug,animation:A.transition+" out",queue:A.queue,duration:A.duration,useFailSafe:!0,onStart:function(){M.othersActive()||M.hideDimmer(),M.remove.keyboardShortcuts()},onComplete:function(){e.proxy(A.onHidden,j)(),M.restore.focus(),i()}})):(M.remove.active(),M.othersActive()||M.hideDimmer(),M.remove.keyboardShortcuts(),O.fadeOut(A.duration,A.easing,function(){e.proxy(A.onHidden,j)(),M.restore.focus(),i()})))},showDimmer:function(){y.dimmer("is animating")||!y.dimmer("is active")?(M.debug("Showing dimmer"),y.dimmer("show")):M.debug("Dimmer already visible")},hideDimmer:function(){return y.dimmer("is animating")||y.dimmer("is active")?void y.dimmer("hide",function(){A.transition&&e.fn.transition!==t&&O.transition("is supported")&&(M.remove.clickaway(),M.remove.screenHeight())}):void M.debug("Dimmer is not visible cannot hide")},hideAll:function(i){i=e.isFunction(i)?i:function(){},a.is(":visible")&&(M.debug("Hiding all visible modals"),M.hideDimmer(),a.filter(":visible").modal("hide modal",i))},hideOthers:function(i){i=e.isFunction(i)?i:function(){},b.is(":visible")&&(M.debug("Hiding other modals",b),b.filter(":visible").modal("hide modal",i))},othersActive:function(){return b.filter("."+D.active).size()>0},add:{keyboardShortcuts:function(){M.verbose("Adding keyboard shortcuts"),c.on("keyup"+F,M.event.keyboard)}},save:{focus:function(){p=e(n.activeElement).blur()}},restore:{focus:function(){p&&p.size()>0&&p.focus()}},remove:{active:function(){O.removeClass(D.active)},clickaway:function(){A.closable&&w.off("click"+k)},screenHeight:function(){M.cache.height>M.cache.pageHeight&&(M.debug("Removing page height"),u.css("height",""))},keyboardShortcuts:function(){M.verbose("Removing keyboard shortcuts"),c.off("keyup"+F)},scrolling:function(){y.removeClass(D.scrolling),O.removeClass(D.scrolling)}},cacheSizes:function(){var o=O.outerHeight();(M.cache===t||0!==o)&&(M.cache={pageHeight:e(n).outerHeight(),height:o+A.offset,contextHeight:"body"==A.context?e(i).height():y.height()}),M.debug("Caching modal and container sizes",M.cache)},can:{fit:function(){return M.cache.height<M.cache.contextHeight}},is:{active:function(){return O.hasClass(D.active)},animating:function(){return O.transition("is supported")?O.transition("is animating"):O.is(":visible")},scrolling:function(){return y.hasClass(D.scrolling)},modernBrowser:function(){return!(i.ActiveXObject||"ActiveXObject"in i)}},set:{autofocus:function(){if(A.autofocus){var e=O.find(":input:visible"),i=e.filter("[autofocus]"),n=i.size()>0?i:e;n.first().focus()}},clickaway:function(){A.closable&&w.on("click"+k,M.event.click)},screenHeight:function(){M.cache.height>M.cache.pageHeight?(M.debug("Modal is taller than page content, resizing page height"),u.css("height",M.cache.height+A.padding)):u.css("height","")},active:function(){O.addClass(D.active)},scrolling:function(){y.addClass(D.scrolling),O.addClass(D.scrolling)},type:function(){M.can.fit()?(M.verbose("Modal fits on screen"),M.othersActive||M.remove.scrolling()):(M.verbose("Modal cannot fit on screen setting to scrolling"),M.set.scrolling())},position:function(){M.verbose("Centering modal on page",M.cache),O.css(M.can.fit()?{top:"",marginTop:-(M.cache.height/2)}:{marginTop:"",top:c.scrollTop()})}},setting:function(i,n){if(M.debug("Changing setting",i,n),e.isPlainObject(i))e.extend(!0,A,i);else{if(n===t)return A[i];A[i]=n}},internal:function(i,n){if(e.isPlainObject(i))e.extend(!0,M,i);else{if(n===t)return M[i];M[i]=n}},debug:function(){A.debug&&(A.performance?M.performance.log(arguments):(M.debug=Function.prototype.bind.call(console.info,console,A.name+":"),M.debug.apply(console,arguments)))},verbose:function(){A.verbose&&A.debug&&(A.performance?M.performance.log(arguments):(M.verbose=Function.prototype.bind.call(console.info,console,A.name+":"),M.verbose.apply(console,arguments)))},error:function(){M.error=Function.prototype.bind.call(console.error,console,A.name+":"),M.error.apply(console,arguments)},performance:{log:function(e){var i,n,t;A.performance&&(i=(new Date).getTime(),t=d||i,n=i-t,d=i,m.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:j,"Execution Time":n})),clearTimeout(M.performance.timer),M.performance.timer=setTimeout(M.performance.display,100)},display:function(){var i=A.name+":",n=0;d=!1,clearTimeout(M.performance.timer),e.each(m,function(e,i){n+=i["Execution Time"]}),i+=" "+n+"ms",l&&(i+=" '"+l+"'"),(console.group!==t||console.table!==t)&&m.length>0&&(console.groupCollapsed(i),console.table?console.table(m):e.each(m,function(e,i){console.log(i.Name+": "+i["Execution Time"]+"ms")}),console.groupEnd()),m=[]}},invoke:function(i,n,o){var a,r,c,u=I;return n=n||h,o=j||o,"string"==typeof i&&u!==t&&(i=i.split(/[\. ]/),a=i.length-1,e.each(i,function(n,o){var s=n!=a?o+i[n+1].charAt(0).toUpperCase()+i[n+1].slice(1):i;if(e.isPlainObject(u[s])&&n!=a)u=u[s];else{if(u[s]!==t)return r=u[s],!1;if(!e.isPlainObject(u[o])||n==a)return u[o]!==t?(r=u[o],!1):!1;u=u[o]}})),e.isFunction(r)?c=r.apply(o,n):r!==t&&(c=r),e.isArray(s)?s.push(c):s!==t?s=[s,c]:c!==t&&(s=c),r}},g?(I===t&&M.initialize(),M.invoke(f)):(I!==t&&M.destroy(),M.initialize())}),s!==t?s:this},e.fn.modal.settings={name:"Modal",namespace:"modal",debug:!1,verbose:!0,performance:!0,allowMultiple:!1,detachable:!0,closable:!0,autofocus:!0,dimmerSettings:{closable:!1,useCSS:!0},context:"body",queue:!1,duration:500,easing:"easeOutExpo",offset:0,transition:"scale",padding:30,onShow:function(){},onHide:function(){},onVisible:function(){},onHidden:function(){},onApprove:function(){return!0},onDeny:function(){return!0},selector:{close:".close, .actions .button",approve:".actions .positive, .actions .approve, .actions .ok",deny:".actions .negative, .actions .deny, .actions .cancel",modal:".ui.modal"},error:{dimmer:"UI Dimmer, a required component is not included in this page",method:"The method you called is not defined.",notFound:"The element you specified could not be found"},className:{active:"active",animating:"animating",scrolling:"scrolling"}}}(jQuery,window,document);