 /*
 * # Semantic UI
 * https://github.com/Semantic-Org/Semantic-UI
 * http://www.semantic-ui.com/
 *
 * Copyright 2014 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,t,n,i){"use strict";e.fn.dropdown=function(o){var a,s=e(this),r=e(n),c=s.selector||"",u="ontouchstart"in n.documentElement,d=(new Date).getTime(),l=[],f=arguments[0],v="string"==typeof f,m=[].slice.call(arguments,1);return s.each(function(){var h,p,g,b,w=e.isPlainObject(o)?e.extend(!0,{},e.fn.dropdown.settings,o):e.extend({},e.fn.dropdown.settings),y=w.className,x=w.metadata,T=w.namespace,C=w.selector,S=w.error,k="."+T,z="module-"+T,I=e(this),D=I.find(C.text),E=I.find(C.search),F=I.find(C.input),A=I.prev().find(C.text).size()>0?I.prev().find(C.text):I.prev(),M=I.children(C.menu),O=M.find(C.item),q=!1,V=!1,Q=this,P=I.data(z);b={initialize:function(){b.debug("Initializing dropdown",w),b.setup.layout(),b.save.defaults(),b.set.selected(),b.create.id(),u&&b.bind.touchEvents(),b.bind.mouseEvents(),b.bind.keyboardEvents(),b.observeChanges(),b.instantiate()},instantiate:function(){b.verbose("Storing instance of dropdown",b),P=b,I.data(z,b)},destroy:function(){b.verbose("Destroying previous dropdown for",I),b.remove.tabbable(),I.off(k).removeData(z),r.off(h)},observeChanges:function(){"MutationObserver"in t&&(g=new MutationObserver(function(){b.debug("DOM tree modified, updating selector cache"),b.refresh()}),g.observe(Q,{childList:!0,subtree:!0}),b.debug("Setting up mutation observer",g))},create:{id:function(){b.verbose("Creating unique id for element"),p=b.get.uniqueID(),h="."+p}},search:function(){var e;e=E.val(),b.verbose("Searching for query",e),b.is.searchSelection()&&(b.filter(e),b.can.show()&&b.show())},setup:{layout:function(){I.is("select")&&b.setup.select(),b.is.search()&&!b.is.searchable()&&(E=e("<input />").addClass(y.search).insertBefore(D)),w.allowTab&&b.set.tabbable()},select:function(){var t=b.get.selectValues();b.debug("Dropdown initialized on a select",t),F=I,F.parents(C.dropdown).size()>0?(b.debug("Creating dropdown menu only from template"),I=F.closest(C.dropdown),0===I.find("."+y.dropdown).size()&&e("<div />").addClass(y.menu).html(w.templates.menu(t)).appendTo(I)):(b.debug("Creating entire dropdown from template"),I=e("<div />").attr("class",F.attr("class")).addClass(y.selection).addClass(y.dropdown).html(w.templates.dropdown(t)).insertBefore(F),F.removeAttr("class").prependTo(I)),b.refresh()}},refresh:function(){D=I.find(C.text),E=I.find(C.search),F=I.find(C.input),M=I.children(C.menu),O=M.find(C.item)},toggle:function(){b.verbose("Toggling menu visibility"),b.is.active()?b.hide():b.show()},show:function(t){t=e.isFunction(t)?t:function(){},b.is.active()||b.is.allFiltered()||(b.debug("Showing dropdown"),b.animate.show(function(){b.can.click()&&b.bind.intent(),b.set.visible(),e.proxy(t,Q)()}),e.proxy(w.onShow,Q)())},hide:function(t){t=e.isFunction(t)?t:function(){},b.is.active()&&(b.debug("Hiding dropdown"),b.animate.hide(function(){b.remove.visible(),e.proxy(t,Q)()}),e.proxy(w.onHide,Q)())},hideOthers:function(){b.verbose("Finding other dropdowns to hide"),s.not(I).has(C.menu+":visible:not(."+y.animating+")").dropdown("hide")},hideSubMenus:function(){var e=M.find(C.menu);e.transition("hide")},bind:{keyboardEvents:function(){b.debug("Binding keyboard events"),I.on("keydown"+k,b.event.keydown),b.is.searchable()&&I.on(b.get.inputEvent(),C.search,b.event.input)},touchEvents:function(){b.debug("Touch device detected binding additional touch events"),b.is.searchSelection()||I.on("touchstart"+k,b.event.test.toggle),M.on("touchstart"+k,C.item,b.event.item.mouseenter)},mouseEvents:function(){b.verbose("Mouse detected binding mouse events"),b.is.searchSelection()?I.on("mousedown"+k,C.menu,b.event.menu.activate).on("mouseup"+k,C.menu,b.event.menu.deactivate).on("click"+k,C.search,b.show).on("focus"+k,C.search,b.event.searchFocus).on("blur"+k,C.search,b.event.searchBlur):("click"==w.on?I.on("click"+k,b.event.test.toggle):"hover"==w.on?I.on("mouseenter"+k,b.delay.show).on("mouseleave"+k,b.delay.hide):I.on(w.on+k,b.toggle),I.on("mousedown"+k,b.event.mousedown).on("mouseup"+k,b.event.mouseup).on("focus"+k,b.event.focus).on("blur"+k,b.event.blur)),M.on("mouseenter"+k,C.item,b.event.item.mouseenter).on("mouseleave"+k,C.item,b.event.item.mouseleave).on("click"+k,C.item,b.event.item.click)},intent:function(){b.verbose("Binding hide intent event to document"),u&&r.on("touchstart"+h,b.event.test.touch).on("touchmove"+h,b.event.test.touch),r.on("click"+h,b.event.test.hide)}},unbind:{intent:function(){b.verbose("Removing hide intent event from document"),u&&r.off("touchstart"+h).off("touchmove"+h),r.off("click"+h)}},filter:function(t){var n=e(),i=new RegExp("^"+t,"igm"),o=new RegExp(t,"ig");b.verbose("Searching for matching values"),O.each(function(){var t=e(this),a=b.get.choiceText(t,!1),s=b.get.choiceValue(t,a);i.test(a)||i.test(s)?n=n.add(t):w.fullTextSearch&&(o.test(a)||o.test(s))&&(n=n.add(t))}),b.debug("Setting filter",t),b.remove.filteredItem(),O.not(n).addClass(y.filtered),b.verbose("Selecting first non-filtered element"),b.remove.selectedItem(),O.not("."+y.filtered).eq(0).addClass(y.selected),b.is.allFiltered()&&(b.debug("All items filtered, hiding dropdown",t),b.hide(),e.proxy(w.onNoResults,Q)(t))},focusSearch:function(){b.is.search()&&E.focus()},event:{mousedown:function(){q=!0},mouseup:function(){q=!1},focus:function(){!q&&b.is.hidden()&&b.show()},blur:function(){var e=n.activeElement===this;q||e||b.hide()},searchFocus:function(){q=!0,b.show()},searchBlur:function(){var e=n.activeElement===this;V||e||b.hide()},input:function(){b.set.filtered(),clearTimeout(b.timer),b.timer=setTimeout(b.search,w.delay.search)},keydown:function(t){var n,i=O.not(y.filtered).filter("."+y.selected).eq(0),o=O.not("."+y.filtered),a=t.which,s={enter:13,escape:27,upArrow:38,downArrow:40},r=y.selected,c=o.index(i),u=i.size()>0;if(u||(i=O.filter("."+y.active).eq(0),u=i.size()>0),a==s.escape&&(b.verbose("Escape key pressed, closing dropdown"),b.hide()),a==s.downArrow&&(b.verbose("Down key pressed, showing dropdown"),b.show()),b.is.visible()){if(a==s.enter&&u)return b.verbose("Enter key pressed, choosing selected item"),e.proxy(b.event.item.click,i)(t),t.preventDefault(),!1;a==s.upArrow?(n=u?i.prevAll(C.item+":not(."+y.filtered+")").eq(0):o.eq(0),0!==c&&(b.verbose("Up key pressed, changing active item"),O.removeClass(r),n.addClass(r),b.set.scrollPosition(n)),t.preventDefault()):a==s.downArrow&&(n=u?i.nextAll(C.item+":not(."+y.filtered+")").eq(0):o.eq(0),c+1<o.size()&&(b.verbose("Down key pressed, changing active item"),O.removeClass(r),n.addClass(r),b.set.scrollPosition(n)),t.preventDefault())}else a==s.enter&&b.show()},test:{toggle:function(e){b.determine.eventInMenu(e,b.toggle)&&e.preventDefault()},touch:function(e){b.determine.eventInMenu(e,function(){"touchstart"==e.type?b.timer=setTimeout(b.hide,w.delay.touch):"touchmove"==e.type&&clearTimeout(b.timer)}),e.stopPropagation()},hide:function(e){b.determine.eventInModule(e,b.hide)}},menu:{activate:function(){V=!0},deactivate:function(){V=!1}},item:{mouseenter:function(t){var n=e(this).children(C.menu),i=e(this).siblings(C.item).children(C.menu);n.size()>0&&(clearTimeout(b.itemTimer),b.itemTimer=setTimeout(function(){e.each(i,function(){b.animate.hide(!1,e(this))}),b.verbose("Showing sub-menu",n),b.animate.show(!1,n)},w.delay.show),t.preventDefault())},mouseleave:function(){var t=e(this).children(C.menu);t.size()>0&&(clearTimeout(b.itemTimer),b.itemTimer=setTimeout(function(){b.verbose("Hiding sub-menu",t),b.animate.hide(!1,t)},w.delay.hide))},click:function(){var t=e(this),n=b.get.choiceText(t),i=b.get.choiceValue(t,n),o=function(){b.remove.searchTerm(),b.determine.selectAction(n,i)},a=t.find(C.menu).size()>0;a||o()}},resetStyle:function(){e(this).removeAttr("style")}},determine:{selectAction:function(t,n){b.verbose("Determining action",w.action),e.isFunction(b.action[w.action])?(b.verbose("Triggering preset action",w.action,t,n),b.action[w.action](t,n)):e.isFunction(w.action)?(b.verbose("Triggering user action",w.action,t,n),w.action(t,n)):b.error(S.action,w.action)},eventInModule:function(t,n){return n=e.isFunction(n)?n:function(){},0===e(t.target).closest(I).size()?(b.verbose("Triggering event",n),n(),!0):(b.verbose("Event occurred in dropdown, canceling callback"),!1)},eventInMenu:function(t,n){return n=e.isFunction(n)?n:function(){},0===e(t.target).closest(M).size()?(b.verbose("Triggering event",n),n(),!0):(b.verbose("Event occurred in dropdown menu, canceling callback"),!1)}},action:{nothing:function(){},hide:function(){b.hide(function(){b.remove.filteredItem()})},select:function(e,t){t=t!==i?t:e,b.set.selected(t),b.set.value(t),b.hide(function(){b.remove.filteredItem()})},activate:function(e,t){t=t!==i?t:e,b.set.selected(t),b.set.value(t),b.hide(function(){b.remove.filteredItem()})},combo:function(e,t){t=t!==i?t:e,b.set.selected(t),b.set.value(t),b.hide(function(){b.remove.filteredItem()})}},get:{text:function(){return D.text()},value:function(){return F.size()>0?F.val():I.data(x.value)},choiceText:function(e,t){return t=t!==i?t:w.preserveHTML,e!==i?e.data(x.text)!==i?e.data(x.text):t?e.html():e.text():void 0},choiceValue:function(e,t){return t=t||b.get.choiceText(D),e.data(x.value)!==i?e.data(x.value):"string"==typeof t?t.toLowerCase():t},inputEvent:function(){var e=E[0];return e?e.oninput!==i?"input":e.onpropertychange!==i?"propertychange":"keyup":!1},selectValues:function(){var t={};return t.values=w.sortSelect?{}:[],I.find("option").each(function(){var n=e(this).html(),o=e(this).attr("value")!==i?e(this).attr("value"):n;""===o?t.placeholder=n:w.sortSelect?t.values[o]={name:n,value:o}:t.values.push({name:n,value:o})}),w.sortSelect?b.debug("Retrieved and sorted values from select",t):b.debug("Retreived values from select",t),t},activeItem:function(){return O.filter("."+y.active)},item:function(t,n){var o=!1;return t=t!==i?t:b.get.value()!==i?b.get.value():b.get.text(),n=""===t||0===t?!0:n||!1,t!==i?O.each(function(){var i=e(this),a=b.get.choiceText(i),s=b.get.choiceValue(i,a);n?(b.verbose("Ambiguous dropdown value using strict type check",i,t),s===t?o=e(this):o||a!==t||(o=e(this))):s==t?(b.verbose("Found select item by value",s,t),o=e(this)):o||a!=t||(b.verbose("Found select item by text",a,t),o=e(this))}):t=b.get.text(),o||!1},uniqueID:function(){return(Math.random().toString(16)+"000000000").substr(2,8)}},restore:{defaults:function(){b.restore.defaultText(),b.restore.defaultValue()},defaultText:function(){var e=I.data(x.defaultText);b.debug("Restoring default text",e),b.set.text(e)},defaultValue:function(){var e=I.data(x.defaultValue);e!==i&&(b.debug("Restoring default value",e),b.set.selected(e),b.set.value(e))}},save:{defaults:function(){b.save.defaultText(),b.save.defaultValue()},defaultValue:function(){I.data(x.defaultValue,b.get.value())},defaultText:function(){I.data(x.defaultText,D.text())}},set:{filtered:function(){var e=E.val(),t="string"==typeof e&&e.length>0;t?D.addClass(y.filtered):D.removeClass(y.filtered)},tabbable:function(){b.is.searchable()?(b.debug("Searchable dropdown initialized"),E.val("").attr("tabindex",0),M.attr("tabindex","-1")):(b.debug("Simple selection dropdown initialized"),I.attr("tabindex")||(I.attr("tabindex",0),M.attr("tabindex","-1")))},scrollPosition:function(e,t){var n,o,a,s,r,c,u,d,l,f=5;e=e||b.get.activeItem(),n=e&&e.size()>0,t=t!==i?t:!1,e&&n&&(M.hasClass(y.visible)||M.addClass(y.loading),u=M.height(),a=e.height(),c=M.scrollTop(),r=M.offset().top,s=e.offset().top,o=c-r+s,l=o+f>c+u,d=c>o-f,b.debug("Scrolling to active item",o),(d||l||t)&&M.scrollTop(o).removeClass(y.loading))},text:function(e){"combo"==w.action?(b.debug("Changing combo button text",e,A),w.preserveHTML?A.html(e):A.text(e)):"select"!==w.action&&(b.debug("Changing text",e,D),D.removeClass(y.filtered).removeClass(y.placeholder),w.preserveHTML?D.html(e):D.text(e))},value:function(e){b.debug("Adding selected value to hidden input",e,F),F.size()>0?F.val(e).trigger("change"):I.data(x.value,e)},active:function(){I.addClass(y.active)},visible:function(){I.addClass(y.visible)},selected:function(t){var n,i=b.get.item(t);i&&(b.debug("Setting selected menu item to",i),b.remove.activeItem(),b.remove.selectedItem(),i.addClass(y.active).addClass(y.selected),n=b.get.choiceText(i),b.set.text(n),e.proxy(w.onChange,Q)(t,n,i))}},remove:{active:function(){I.removeClass(y.active)},visible:function(){I.removeClass(y.visible)},activeItem:function(){O.removeClass(y.active)},filteredItem:function(){O.removeClass(y.filtered)},searchTerm:function(){E.val("")},selectedItem:function(){O.removeClass(y.selected)},tabbable:function(){b.is.searchable()?(b.debug("Searchable dropdown initialized"),E.attr("tabindex","-1"),M.attr("tabindex","-1")):(b.debug("Simple selection dropdown initialized"),I.attr("tabindex","-1"),M.attr("tabindex","-1"))}},is:{active:function(){return I.hasClass(y.active)},animating:function(e){return e?e.is(":animated")||e.transition&&e.transition("is animating"):M.is(":animated")||M.transition&&M.transition("is animating")},allFiltered:function(){return O.filter("."+y.filtered).size()===O.size()},hidden:function(e){return e?e.is(":hidden"):M.is(":hidden")},search:function(){return I.hasClass(y.search)},searchable:function(){return E.size()>0},searchSelection:function(){return b.is.searchable()&&E.parent().is(I)},selection:function(){return I.hasClass(y.selection)},visible:function(e){return e?e.is(":visible"):M.is(":visible")}},can:{click:function(){return u||"click"==w.on},show:function(){return!I.hasClass(y.disabled)}},animate:{show:function(t,n){var o=n||M,a=n?function(){}:function(){b.hideSubMenus(),b.hideOthers(),b.set.active()};t=e.isFunction(t)?t:function(){},b.set.scrollPosition(b.get.activeItem(),!0),b.verbose("Doing menu show animation",o),(b.is.hidden(o)||b.is.animating(o))&&("none"==w.transition?e.proxy(t,Q)():e.fn.transition!==i&&I.transition("is supported")?o.transition({animation:w.transition+" in",debug:w.debug,verbose:w.verbose,duration:w.duration,queue:!0,onStart:a,onComplete:function(){e.proxy(t,Q)()}}):"slide down"==w.transition?(a(),o.hide().clearQueue().children().clearQueue().css("opacity",0).delay(50).animate({opacity:1},w.duration,"easeOutQuad",b.event.resetStyle).end().slideDown(100,"easeOutQuad",function(){e.proxy(b.event.resetStyle,this)(),e.proxy(t,Q)()})):"fade"==w.transition?(a(),o.hide().clearQueue().fadeIn(w.duration,function(){e.proxy(b.event.resetStyle,this)(),e.proxy(t,Q)()})):b.error(S.transition,w.transition))},hide:function(t,n){var o=n||M,a=(n?.9*w.duration:w.duration,n?function(){}:function(){b.can.click()&&b.unbind.intent(),b.focusSearch(),b.remove.active()});t=e.isFunction(t)?t:function(){},(b.is.visible(o)||b.is.animating(o))&&(b.verbose("Doing menu hide animation",o),"none"==w.transition?e.proxy(t,Q)():e.fn.transition!==i&&I.transition("is supported")?o.transition({animation:w.transition+" out",duration:w.duration,debug:w.debug,verbose:w.verbose,queue:!0,onStart:a,onComplete:function(){e.proxy(t,Q)()}}):"slide down"==w.transition?(a(),o.show().clearQueue().children().clearQueue().css("opacity",1).animate({opacity:0},100,"easeOutQuad",b.event.resetStyle).end().delay(50).slideUp(100,"easeOutQuad",function(){e.proxy(b.event.resetStyle,this)(),e.proxy(t,Q)()})):"fade"==w.transition?(a(),o.show().clearQueue().fadeOut(150,function(){e.proxy(b.event.resetStyle,this)(),e.proxy(t,Q)()})):b.error(S.transition))}},delay:{show:function(){b.verbose("Delaying show event to ensure user intent"),clearTimeout(b.timer),b.timer=setTimeout(b.show,w.delay.show)},hide:function(){b.verbose("Delaying hide event to ensure user intent"),clearTimeout(b.timer),b.timer=setTimeout(b.hide,w.delay.hide)}},setting:function(t,n){if(b.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,w,t);else{if(n===i)return w[t];w[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,b,t);else{if(n===i)return b[t];b[t]=n}},debug:function(){w.debug&&(w.performance?b.performance.log(arguments):(b.debug=Function.prototype.bind.call(console.info,console,w.name+":"),b.debug.apply(console,arguments)))},verbose:function(){w.verbose&&w.debug&&(w.performance?b.performance.log(arguments):(b.verbose=Function.prototype.bind.call(console.info,console,w.name+":"),b.verbose.apply(console,arguments)))},error:function(){b.error=Function.prototype.bind.call(console.error,console,w.name+":"),b.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;w.performance&&(t=(new Date).getTime(),i=d||t,n=t-i,d=t,l.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:Q,"Execution Time":n})),clearTimeout(b.performance.timer),b.performance.timer=setTimeout(b.performance.display,100)},display:function(){var t=w.name+":",n=0;d=!1,clearTimeout(b.performance.timer),e.each(l,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",c&&(t+=" '"+c+"'"),(console.group!==i||console.table!==i)&&l.length>0&&(console.groupCollapsed(t),console.table?console.table(l):e.each(l,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),l=[]}},invoke:function(t,n,o){var s,r,c,u=P;return n=n||m,o=Q||o,"string"==typeof t&&u!==i&&(t=t.split(/[\. ]/),s=t.length-1,e.each(t,function(n,o){var a=n!=s?o+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(u[a])&&n!=s)u=u[a];else{if(u[a]!==i)return r=u[a],!1;if(!e.isPlainObject(u[o])||n==s)return u[o]!==i?(r=u[o],!1):(b.error(S.method,t),!1);u=u[o]}})),e.isFunction(r)?c=r.apply(o,n):r!==i&&(c=r),e.isArray(a)?a.push(c):a!==i?a=[a,c]:c!==i&&(a=c),r}},v?(P===i&&b.initialize(),b.invoke(f)):(P!==i&&b.destroy(),b.initialize())}),a!==i?a:this},e.fn.dropdown.settings={debug:!1,verbose:!0,performance:!0,on:"click",action:"activate",allowTab:!0,fullTextSearch:!1,preserveHTML:!0,sortSelect:!1,delay:{hide:300,show:200,search:50,touch:50},transition:"slide down",duration:250,onNoResults:function(){},onChange:function(){},onShow:function(){},onHide:function(){},name:"Dropdown",namespace:"dropdown",error:{action:"You called a dropdown action that was not defined",method:"The method you called is not defined.",transition:"The requested transition was not found"},metadata:{defaultText:"defaultText",defaultValue:"defaultValue",text:"text",value:"value"},selector:{dropdown:".ui.dropdown",text:"> .text:not(.icon)",input:'> input[type="hidden"], > select',search:"> input.search, .menu > .search > input, .menu > input.search",menu:".menu",item:".item"},className:{active:"active",animating:"animating",disabled:"disabled",dropdown:"ui dropdown",filtered:"filtered",loading:"loading",menu:"menu",placeholder:"default",search:"search",selected:"selected",selection:"selection",visible:"visible"}},e.fn.dropdown.settings.templates={menu:function(t){var n=(t.placeholder||!1,t.values||{},"");return e.each(t.values,function(e,t){n+='<div class="item" data-value="'+t.value+'">'+t.name+"</div>"}),n},dropdown:function(t){var n=t.placeholder||!1,i=(t.values||{},"");return i+='<i class="dropdown icon"></i>',i+=t.placeholder?'<div class="default text">'+n+"</div>":'<div class="text"></div>',i+='<div class="menu">',e.each(t.values,function(e,t){i+='<div class="item" data-value="'+t.value+'">'+t.name+"</div>"}),i+="</div>"}},e.extend(e.easing,{easeOutQuad:function(e,t,n,i,o){return-i*(t/=o)*(t-2)+n}})}(jQuery,window,document);