 /*
 * # Semantic UI - 1.8.1
 * https://github.com/Semantic-Org/Semantic-UI
 * http://www.semantic-ui.com/
 *
 * Copyright 2014 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,t,n,r){"use strict";e.fn.progress=function(t){var a,o=e(this),i=o.selector||"",s=(new Date).getTime(),c=[],l=arguments[0],u="string"==typeof l,g=[].slice.call(arguments,1);return o.each(function(){var o,v,d=e.isPlainObject(t)?e.extend(!0,{},e.fn.progress.settings,t):e.extend({},e.fn.progress.settings),p=d.className,m=d.metadata,b=d.namespace,f=d.selector,h=d.error,w="."+b,x="module-"+b,y=e(this),C=e(this).find(f.bar),T=e(this).find(f.progress),A=e(this).find(f.label),E=this,S=y.data(x),I=!1;v={initialize:function(){v.debug("Initializing progress bar",d),o=v.get.transitionEnd(),v.read.metadata(),v.set.duration(),v.set.initials(),v.instantiate()},instantiate:function(){v.verbose("Storing instance of progress",v),S=v,y.data(x,v)},destroy:function(){v.verbose("Destroying previous progress for",y),clearInterval(S.interval),v.remove.state(),y.removeData(x),S=r},reset:function(){v.set.percent(0)},complete:function(){(v.percent===r||v.percent<100)&&v.set.percent(100)},read:{metadata:function(){y.data(m.percent)&&(v.verbose("Current percent value set from metadata"),v.percent=y.data(m.percent)),y.data(m.total)&&(v.verbose("Total value set from metadata"),v.total=y.data(m.total)),y.data(m.value)&&(v.verbose("Current value set from metadata"),v.value=y.data(m.value))},currentValue:function(){return v.value!==r?v.value:!1}},increment:function(e){var t,n,r,a=v.total||!1;a?(n=v.value||0,e=e||1,r=n+e,t=v.total,v.debug("Incrementing value by",e,n,t),r>t&&(v.debug("Value cannot increment above total",t),r=t),v.set.progress(r)):(n=v.percent||0,e=e||v.get.randomValue(),r=n+e,t=100,v.debug("Incrementing percentage by",e,n),r>t&&(v.debug("Value cannot increment above 100 percent"),r=t),v.set.progress(r))},decrement:function(e){var t,n,r=v.total||!1,a=0;r?(t=v.value||0,e=e||1,n=t-e,v.debug("Decrementing value by",e,t)):(t=v.percent||0,e=e||v.get.randomValue(),n=t-e,v.debug("Decrementing percentage by",e,t)),a>n&&(v.debug("Value cannot decrement below 0"),n=0),v.set.progress(n)},get:{text:function(e){var t=v.value||0,n=v.total||0,r=v.is.visible()&&I?v.get.displayPercent():v.percent||0,a=v.total>0?n-t:100-r;return e=e||"",e=e.replace("{value}",t).replace("{total}",n).replace("{left}",a).replace("{percent}",r),v.debug("Adding variables to progress bar text",e),e},randomValue:function(){return v.debug("Generating random increment percentage"),Math.floor(Math.random()*d.random.max+d.random.min)},transitionEnd:function(){var e,t=n.createElement("element"),a={transition:"transitionend",OTransition:"oTransitionEnd",MozTransition:"transitionend",WebkitTransition:"webkitTransitionEnd"};for(e in a)if(t.style[e]!==r)return a[e]},displayPercent:function(){var e=C.width(),t=y.width(),n=parseInt(C.css("min-width"),10),r=e>n?e/t*100:v.percent;return Math.round(0===d.precision?r:10*r*d.precision/(10*d.precision))},percent:function(){return v.percent||0},value:function(){return v.value||!1},total:function(){return v.total||!1}},is:{success:function(){return y.hasClass(p.success)},warning:function(){return y.hasClass(p.warning)},error:function(){return y.hasClass(p.error)},active:function(){return y.hasClass(p.active)},visible:function(){return y.is(":visible")}},remove:{state:function(){v.verbose("Removing stored state"),delete v.total,delete v.percent,delete v.value},active:function(){v.verbose("Removing active state"),y.removeClass(p.active)},success:function(){v.verbose("Removing success state"),y.removeClass(p.success)},warning:function(){v.verbose("Removing warning state"),y.removeClass(p.warning)},error:function(){v.verbose("Removing error state"),y.removeClass(p.error)}},set:{barWidth:function(e){e>100?v.error(h.tooHigh,e):0>e?v.error(h.tooLow,e):(C.css("width",e+"%"),y.attr("data-percent",parseInt(e,10)))},duration:function(e){e=e||d.duration,e="number"==typeof e?e+"ms":e,v.verbose("Setting progress bar transition duration",e),C.css({"-webkit-transition-duration":e,"-moz-transition-duration":e,"-ms-transition-duration":e,"-o-transition-duration":e,"transition-duration":e})},initials:function(){d.total!==!1&&(v.verbose("Current total set in settings",d.total),v.total=d.total),d.value!==!1&&(v.verbose("Current value set in settings",d.value),v.value=d.value),d.percent!==!1&&(v.verbose("Current percent set in settings",d.percent),v.percent=d.percent),v.percent!==r?v.set.percent(v.percent):v.value!==r&&v.set.progress(v.value)},percent:function(e){e="string"==typeof e?+e.replace("%",""):e,e>0&&1>e&&(v.verbose("Module percentage passed as decimal, converting"),e=100*e),e=Math.round(0===d.precision?e:10*e*d.precision/(10*d.precision)),v.percent=e,v.total?v.value=Math.round(e/100*v.total):d.limitValues&&(v.value=v.value>100?100:v.value<0?0:v.value),v.set.barWidth(e),v.is.visible()&&v.set.labelInterval(),v.set.labels(),d.onChange.call(E,e,v.value,v.total)},labelInterval:function(){var e=function(){v.verbose("Bar finished animating, removing continuous label updates"),clearInterval(v.interval),I=!1,v.set.labels()};clearInterval(v.interval),C.one(o+w,e),v.timer=setTimeout(e,d.duration+100),I=!0,v.interval=setInterval(v.set.labels,d.framerate)},labels:function(){v.verbose("Setting both bar progress and outer label text"),v.set.barLabel(),v.set.state()},label:function(e){e=e||"",e&&(e=v.get.text(e),v.debug("Setting label to text",e),A.text(e))},state:function(e){e=e!==r?e:v.percent,100===e?!d.autoSuccess||v.is.warning()||v.is.error()?(v.verbose("Reached 100% removing active state"),v.remove.active()):(v.set.success(),v.debug("Automatically triggering success at 100%")):e>0?(v.verbose("Adjusting active progress bar label",e),v.set.active()):(v.remove.active(),v.set.label(d.text.active))},barLabel:function(e){e!==r?T.text(v.get.text(e)):"ratio"==d.label&&v.total?(v.debug("Adding ratio to bar label"),T.text(v.get.text(d.text.ratio))):"percent"==d.label&&(v.debug("Adding percentage to bar label"),T.text(v.get.text(d.text.percent)))},active:function(e){e=e||d.text.active,v.debug("Setting active state"),d.showActivity&&!v.is.active()&&y.addClass(p.active),v.remove.warning(),v.remove.error(),v.remove.success(),e&&v.set.label(e),d.onActive.call(E,v.value,v.total)},success:function(e){e=e||d.text.success,v.debug("Setting success state"),y.addClass(p.success),v.remove.active(),v.remove.warning(),v.remove.error(),v.complete(),e&&v.set.label(e),d.onSuccess.call(E,v.total)},warning:function(e){e=e||d.text.warning,v.debug("Setting warning state"),y.addClass(p.warning),v.remove.active(),v.remove.success(),v.remove.error(),v.complete(),e&&v.set.label(e),d.onWarning.call(E,v.value,v.total)},error:function(e){e=e||d.text.error,v.debug("Setting error state"),y.addClass(p.error),v.remove.active(),v.remove.success(),v.remove.warning(),v.complete(),e&&v.set.label(e),d.onError.call(E,v.value,v.total)},total:function(e){v.total=e},progress:function(e){var t,n="string"==typeof e?""!==e.replace(/[^\d.]/g,"")?+e.replace(/[^\d.]/g,""):!1:e;n===!1&&v.error(h.nonNumeric,e),v.total?(v.value=n,t=n/v.total*100,v.debug("Calculating percent complete from total",t),v.set.percent(t)):(t=n,v.debug("Setting value to exact percentage value",t),v.set.percent(t))}},setting:function(t,n){if(v.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,d,t);else{if(n===r)return d[t];d[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,v,t);else{if(n===r)return v[t];v[t]=n}},debug:function(){d.debug&&(d.performance?v.performance.log(arguments):(v.debug=Function.prototype.bind.call(console.info,console,d.name+":"),v.debug.apply(console,arguments)))},verbose:function(){d.verbose&&d.debug&&(d.performance?v.performance.log(arguments):(v.verbose=Function.prototype.bind.call(console.info,console,d.name+":"),v.verbose.apply(console,arguments)))},error:function(){v.error=Function.prototype.bind.call(console.error,console,d.name+":"),v.error.apply(console,arguments)},performance:{log:function(e){var t,n,r;d.performance&&(t=(new Date).getTime(),r=s||t,n=t-r,s=t,c.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:E,"Execution Time":n})),clearTimeout(v.performance.timer),v.performance.timer=setTimeout(v.performance.display,100)},display:function(){var t=d.name+":",n=0;s=!1,clearTimeout(v.performance.timer),e.each(c,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",i&&(t+=" '"+i+"'"),(console.group!==r||console.table!==r)&&c.length>0&&(console.groupCollapsed(t),console.table?console.table(c):e.each(c,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),c=[]}},invoke:function(t,n,o){var i,s,c,l=S;return n=n||g,o=E||o,"string"==typeof t&&l!==r&&(t=t.split(/[\. ]/),i=t.length-1,e.each(t,function(n,a){var o=n!=i?a+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(l[o])&&n!=i)l=l[o];else{if(l[o]!==r)return s=l[o],!1;if(!e.isPlainObject(l[a])||n==i)return l[a]!==r?(s=l[a],!1):(v.error(h.method,t),!1);l=l[a]}})),e.isFunction(s)?c=s.apply(o,n):s!==r&&(c=s),e.isArray(a)?a.push(c):a!==r?a=[a,c]:c!==r&&(a=c),s}},u?(S===r&&v.initialize(),v.invoke(l)):(S!==r&&v.destroy(),v.initialize())}),a!==r?a:this},e.fn.progress.settings={name:"Progress",namespace:"progress",debug:!1,verbose:!0,performance:!0,random:{min:2,max:5},duration:300,autoSuccess:!0,showActivity:!0,limitValues:!0,label:"percent",precision:1,framerate:1e3/30,percent:!1,total:!1,value:!1,onChange:function(){},onSuccess:function(){},onActive:function(){},onError:function(){},onWarning:function(){},error:{method:"The method you called is not defined.",nonNumeric:"Progress value is non numeric",tooHigh:"Value specified is above 100%",tooLow:"Value specified is below 0%"},regExp:{variable:/\{\$*[A-z0-9]+\}/g},metadata:{percent:"percent",total:"total",value:"value"},selector:{bar:"> .bar",label:"> .label",progress:".bar > .progress"},text:{active:!1,error:!1,success:!1,warning:!1,percent:"{percent}%",ratio:"{value} of {total}"},className:{active:"active",error:"error",success:"success",warning:"warning"}}}(jQuery,window,document);