/*!
 * # Semantic UI 2.0.0 - Popup
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Copyright 2015 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(t,e,o,n){"use strict";t.fn.popup=function(i){var r,a=t(this),s=t(o),p=t(e),l=t("body"),u=a.selector||"",c="ontouchstart"in o.documentElement,d=(new Date).getTime(),f=[],g=arguments[0],h="string"==typeof g,m=[].slice.call(arguments,1);return a.each(function(){var o,a,v,b,y,w=t.isPlainObject(i)?t.extend(!0,{},t.fn.popup.settings,i):t.extend({},t.fn.popup.settings),T=w.selector,P=w.className,C=w.error,k=w.metadata,x=w.namespace,S="."+w.namespace,E="module-"+x,D=t(this),O=t(w.context),j=w.target?t(w.target):D,A=0,R=!1,F=!1,H=this,I=D.data(E);y={initialize:function(){y.debug("Initializing",D),y.createID(),y.bind.events(),!y.exists()&&w.preserve&&y.create(),y.instantiate()},instantiate:function(){y.verbose("Storing instance",y),I=y,D.data(E,I)},refresh:function(){w.popup?o=t(w.popup).eq(0):w.inline&&(o=j.next(T.popup).eq(0),w.popup=o),w.popup?(o.addClass(P.loading),a=y.get.offsetParent(),o.removeClass(P.loading),w.movePopup&&y.has.popup()&&y.get.offsetParent(o)[0]!==a[0]&&(y.debug("Moving popup to the same offset parent as activating element"),o.detach().appendTo(a))):a=w.inline?y.get.offsetParent(j):y.has.popup()?y.get.offsetParent(o):l,a.is("html")&&(y.debug("Setting page as offset parent"),a=l)},reposition:function(){y.refresh(),y.set.position()},destroy:function(){y.debug("Destroying previous module"),o&&!w.preserve&&y.removePopup(),clearTimeout(y.hideTimer),clearTimeout(y.showTimer),p.off(v),D.off(S).removeData(E)},event:{start:function(e){var o=t.isPlainObject(w.delay)?w.delay.show:w.delay;clearTimeout(y.hideTimer),y.showTimer=setTimeout(y.show,o)},end:function(){var e=t.isPlainObject(w.delay)?w.delay.hide:w.delay;clearTimeout(y.showTimer),y.hideTimer=setTimeout(y.hide,e)},touchstart:function(t){F=!0,y.event.start()},resize:function(){y.is.visible()&&y.set.position()},hideGracefully:function(e){e&&0===t(e.target).closest(T.popup).length?(y.debug("Click occurred outside popup hiding popup"),y.hide()):y.debug("Click was inside popup, keeping popup open")}},create:function(){var e=y.get.html(),n=y.get.variation(),i=y.get.title(),r=y.get.content();e||r||i?(y.debug("Creating pop-up html"),e||(e=w.templates.popup({title:i,content:r})),o=t("<div/>").addClass(P.popup).addClass(n).data(k.activator,D).html(e),n&&o.addClass(n),w.inline?(y.verbose("Inserting popup element inline",o),o.insertAfter(D)):(y.verbose("Appending popup element to body",o),o.appendTo(O)),y.refresh(),w.hoverable&&y.bind.popup(),w.onCreate.call(o,H)):0!==j.next(T.popup).length?(y.verbose("Pre-existing popup found"),w.inline=!0,w.popups=j.next(T.popup).data(k.activator,D),y.refresh(),w.hoverable&&y.bind.popup()):w.popup?(t(w.popup).data(k.activator,D),y.verbose("Used popup specified in settings"),y.refresh(),w.hoverable&&y.bind.popup()):y.debug("No content specified skipping display",H)},createID:function(){b=(Math.random().toString(16)+"000000000").substr(2,8),v="."+b,y.verbose("Creating unique id for element",b)},toggle:function(){y.debug("Toggling pop-up"),y.is.hidden()?(y.debug("Popup is hidden, showing pop-up"),y.unbind.close(),y.show()):(y.debug("Popup is visible, hiding pop-up"),y.hide())},show:function(t){if(t=t||function(){},y.debug("Showing pop-up",w.transition),y.is.hidden()&&(!y.is.active()||!y.is.dropdown())){if(y.exists()||y.create(),w.onShow.call(o,H)===!1)return void y.debug("onShow callback returned false, cancelling popup animation");w.preserve||w.popup||y.refresh(),o&&y.set.position()&&(y.save.conditions(),w.exclusive&&y.hideAll(),y.animate.show(t))}},hide:function(t){if(t=t||function(){},y.is.visible()||y.is.animating()){if(w.onHide.call(o,H)===!1)return void y.debug("onHide callback returned false, cancelling popup animation");y.remove.visible(),y.unbind.close(),y.restore.conditions(),y.animate.hide(t)}},hideAll:function(){t(T.popup).filter("."+P.visible).each(function(){t(this).data(k.activator).popup("hide")})},exists:function(){return o?w.inline||w.popup?y.has.popup():o.closest(O).length>=1?!0:!1:!1},removePopup:function(){y.debug("Removing popup",o),y.has.popup()&&!w.popup&&(o.remove(),o=n),w.onRemove.call(o,H)},save:{conditions:function(){y.cache={title:D.attr("title")},y.cache.title&&D.removeAttr("title"),y.verbose("Saving original attributes",y.cache.title)}},restore:{conditions:function(){return y.cache&&y.cache.title&&(D.attr("title",y.cache.title),y.verbose("Restoring original attributes",y.cache.title)),!0}},animate:{show:function(e){e=t.isFunction(e)?e:function(){},w.transition&&t.fn.transition!==n&&D.transition("is supported")?(y.set.visible(),o.transition({animation:w.transition+" in",queue:!1,debug:w.debug,verbose:w.verbose,duration:w.duration,onComplete:function(){y.bind.close(),e.call(o,H),w.onVisible.call(o,H)}})):y.error(C.noTransition)},hide:function(e){return e=t.isFunction(e)?e:function(){},y.debug("Hiding pop-up"),w.onShow.call(o,H)===!1?void y.debug("onShow callback returned false, cancelling popup animation"):void(w.transition&&t.fn.transition!==n&&D.transition("is supported")?o.transition({animation:w.transition+" out",queue:!1,duration:w.duration,debug:w.debug,verbose:w.verbose,onComplete:function(){y.reset(),e.call(o,H),w.onHidden.call(o,H)}}):y.error(C.noTransition))}},get:{html:function(){return D.removeData(k.html),D.data(k.html)||w.html},title:function(){return D.removeData(k.title),D.data(k.title)||w.title},content:function(){return D.removeData(k.content),D.data(k.content)||D.attr("title")||w.content},variation:function(){return D.removeData(k.variation),D.data(k.variation)||w.variation},calculations:function(){var t,n=j[0],i=w.inline||w.popup?j.position():j.offset(),r={};return r={target:{element:j[0],width:j.outerWidth(),height:j.outerHeight(),top:i.top,left:i.left,margin:{}},popup:{width:o.outerWidth(),height:o.outerHeight()},parent:{width:a.outerWidth(),height:a.outerHeight()},screen:{scroll:{top:p.scrollTop(),left:p.scrollLeft()},width:p.width(),height:p.height()}},r.target.margin.top=w.inline?parseInt(e.getComputedStyle(n).getPropertyValue("margin-top"),10):0,r.target.margin.left=w.inline?y.is.rtl()?parseInt(e.getComputedStyle(n).getPropertyValue("margin-right"),10):parseInt(e.getComputedStyle(n).getPropertyValue("margin-left"),10):0,t=r.screen,r.boundary={top:t.scroll.top,bottom:t.scroll.top+t.height,left:t.scroll.left,right:t.scroll.left+t.width},r},id:function(){return b},startEvent:function(){return"hover"==w.on?"mouseenter":"focus"==w.on?"focus":!1},scrollEvent:function(){return"scroll"},endEvent:function(){return"hover"==w.on?"mouseleave":"focus"==w.on?"blur":!1},offsetParent:function(e){var o=e!==n?e[0]:D[0],i=o.parentNode,r=t(i);if(i)for(var a="none"===r.css("transform"),s="static"===r.css("position"),p=r.is("html");i&&!p&&s&&a;)i=i.parentNode,r=t(i),a="none"===r.css("transform"),s="static"===r.css("position"),p=r.is("html");return r&&r.length>0?r:t()},offstagePosition:function(e,n){var i,r,a=o.offset(),s={},p=[];return e=e||!1,n=n||y.get.calculations(),i=n.popup,r=n.boundary,a&&e&&(s={top:a.top<r.top,bottom:a.top+i.height>r.bottom,right:a.left+i.width>r.right,left:a.left<r.left},y.verbose("Offstage positions determined",a,s)),t.each(s,function(t,e){e&&p.push(t)}),p.length>0?p.join(" "):!1},positions:function(){return{"top left":!1,"top center":!1,"top right":!1,"bottom left":!1,"bottom center":!1,"bottom right":!1,"left center":!1,"right center":!1}},nextPosition:function(t){var e=t.split(" "),o=e[0],n=e[1],i={top:"bottom",bottom:"top",left:"right",right:"left"},r={left:"center",center:"right",right:"left"},a={"top left":"top center","top center":"top right","top right":"right center","right center":"bottom right","bottom right":"bottom center","bottom center":"bottom left","bottom left":"left center","left center":"top left"},s="top"==o||"bottom"==o,p=!1,l=!1,u=!1;return R||(y.verbose("All available positions available"),R=y.get.positions()),y.debug("Recording last position tried",t),R[t]=!0,"opposite"===w.prefer&&(u=[i[o],n],u=u.join(" "),p=R[u]===!0,y.debug("Trying opposite strategy",u)),"adjacent"===w.prefer&&s&&(u=[o,r[n]],u=u.join(" "),l=R[u]===!0,y.debug("Trying adjacent strategy",u)),(l||p)&&(y.debug("Using backup position",u),u=a[t]),u}},set:{position:function(t,e){if(0===j.length||0===o.length)return void y.error(C.notFound);var i,r,a,s,p,l,u;if(e=e||y.get.calculations(),t=t||D.data(k.position)||w.position,i=D.data(k.offset)||w.offset,r=w.distanceAway,a=e.target,s=e.popup,p=e.parent,0===a.top&&0===a.left)return y.debug("Popup target is hidden, no action taken"),!1;switch(w.inline&&(y.debug("Adding margin to calculation",a.margin),"left center"==t||"right center"==t?(i+=a.margin.top,r+=-a.margin.left):"top left"==t||"top center"==t||"top right"==t?(i+=a.margin.left,r-=a.margin.top):(i+=a.margin.left,r+=a.margin.top)),y.debug("Determining popup position from calculations",t,e),y.is.rtl()&&(t=t.replace(/left|right/g,function(t){return"left"==t?"right":"left"}),y.debug("RTL: Popup position updated",t)),A==w.maxSearchDepth&&w.lastResort&&(y.debug('Using "last resort" position to display',w.lastResort),t=w.lastResort),t){case"top left":l={top:"auto",bottom:p.height-a.top+r,left:a.left+i,right:"auto"};break;case"top center":l={bottom:p.height-a.top+r,left:a.left+a.width/2-s.width/2+i,top:"auto",right:"auto"};break;case"top right":l={bottom:p.height-a.top+r,right:p.width-a.left-a.width-i,top:"auto",left:"auto"};break;case"left center":l={top:a.top+a.height/2-s.height/2+i,right:p.width-a.left+r,left:"auto",bottom:"auto"};break;case"right center":l={top:a.top+a.height/2-s.height/2+i,left:a.left+a.width+r,bottom:"auto",right:"auto"};break;case"bottom left":l={top:a.top+a.height+r,left:a.left+i,bottom:"auto",right:"auto"};break;case"bottom center":l={top:a.top+a.height+r,left:a.left+a.width/2-s.width/2+i,bottom:"auto",right:"auto"};break;case"bottom right":l={top:a.top+a.height+r,right:p.width-a.left-a.width-i,left:"auto",bottom:"auto"}}if(l===n&&y.error(C.invalidPosition,t),y.debug("Calculated popup positioning values",l),o.css(l).removeClass(P.position).addClass(t).addClass(P.loading),u=y.get.offstagePosition(t,e)){if(y.debug("Popup cant fit into viewport",t,u),A<w.maxSearchDepth)return A++,t=y.get.nextPosition(t),y.debug("Trying new position",t),o?y.set.position(t,e):!1;if(!w.lastResort)return y.debug("Popup could not find a position in view",o),y.remove.attempts(),y.remove.loading(),y.reset(),!1}return y.debug("Position is on stage",t),y.remove.attempts(),y.set.fluidWidth(e),y.remove.loading(),!0},fluidWidth:function(t){t=t||y.get.calculations(),w.setFluidWidth&&o.hasClass(P.fluid)&&o.css("width",t.parent.width)},visible:function(){D.addClass(P.visible)}},remove:{loading:function(){o.removeClass(P.loading)},visible:function(){D.removeClass(P.visible)},attempts:function(){y.verbose("Resetting all searched positions"),A=0,R=!1}},bind:{events:function(){y.debug("Binding popup events to module"),"click"==w.on&&D.on("click"+S,y.toggle),"hover"==w.on&&c?D.on("touchstart"+S,y.event.touchstart):y.get.startEvent()&&D.on(y.get.startEvent()+S,y.event.start).on(y.get.endEvent()+S,y.event.end),w.target&&y.debug("Target set to element",j),p.on("resize"+v,y.event.resize)},popup:function(){y.verbose("Allowing hover events on popup to prevent closing"),o&&y.has.popup()&&o.on("mouseenter"+S,y.event.start).on("mouseleave"+S,y.event.end)},close:function(){(w.hideOnScroll===!0||"auto"==w.hideOnScroll&&"click"!=w.on)&&(s.one(y.get.scrollEvent()+v,y.event.hideGracefully),O.one(y.get.scrollEvent()+v,y.event.hideGracefully)),"hover"==w.on&&F&&(y.verbose("Binding popup close event to document"),s.on("touchstart"+v,function(t){y.verbose("Touched away from popup"),y.event.hideGracefully.call(H,t)})),"click"==w.on&&w.closable&&(y.verbose("Binding popup close event to document"),s.on("click"+v,function(t){y.verbose("Clicked away from popup"),y.event.hideGracefully.call(H,t)}))}},unbind:{close:function(){(w.hideOnScroll===!0||"auto"==w.hideOnScroll&&"click"!=w.on)&&(s.off("scroll"+v,y.hide),O.off("scroll"+v,y.hide)),"hover"==w.on&&F&&(s.off("touchstart"+v),F=!1),"click"==w.on&&w.closable&&(y.verbose("Removing close event from document"),s.off("click"+v))}},has:{popup:function(){return o&&o.length>0}},is:{active:function(){return D.hasClass(P.active)},animating:function(){return o&&o.hasClass(P.animating)},visible:function(){return o&&o.hasClass(P.visible)},dropdown:function(){return D.hasClass(P.dropdown)},hidden:function(){return!y.is.visible()},rtl:function(){return"rtl"==D.css("direction")}},reset:function(){y.remove.visible(),w.preserve?t.fn.transition!==n&&o.transition("remove transition"):y.removePopup()},setting:function(e,o){if(t.isPlainObject(e))t.extend(!0,w,e);else{if(o===n)return w[e];w[e]=o}},internal:function(e,o){if(t.isPlainObject(e))t.extend(!0,y,e);else{if(o===n)return y[e];y[e]=o}},debug:function(){w.debug&&(w.performance?y.performance.log(arguments):(y.debug=Function.prototype.bind.call(console.info,console,w.name+":"),y.debug.apply(console,arguments)))},verbose:function(){w.verbose&&w.debug&&(w.performance?y.performance.log(arguments):(y.verbose=Function.prototype.bind.call(console.info,console,w.name+":"),y.verbose.apply(console,arguments)))},error:function(){y.error=Function.prototype.bind.call(console.error,console,w.name+":"),y.error.apply(console,arguments)},performance:{log:function(t){var e,o,n;w.performance&&(e=(new Date).getTime(),n=d||e,o=e-n,d=e,f.push({Name:t[0],Arguments:[].slice.call(t,1)||"",Element:H,"Execution Time":o})),clearTimeout(y.performance.timer),y.performance.timer=setTimeout(y.performance.display,500)},display:function(){var e=w.name+":",o=0;d=!1,clearTimeout(y.performance.timer),t.each(f,function(t,e){o+=e["Execution Time"]}),e+=" "+o+"ms",u&&(e+=" '"+u+"'"),(console.group!==n||console.table!==n)&&f.length>0&&(console.groupCollapsed(e),console.table?console.table(f):t.each(f,function(t,e){console.log(e.Name+": "+e["Execution Time"]+"ms")}),console.groupEnd()),f=[]}},invoke:function(e,o,i){var a,s,p,l=I;return o=o||m,i=H||i,"string"==typeof e&&l!==n&&(e=e.split(/[\. ]/),a=e.length-1,t.each(e,function(o,i){var r=o!=a?i+e[o+1].charAt(0).toUpperCase()+e[o+1].slice(1):e;if(t.isPlainObject(l[r])&&o!=a)l=l[r];else{if(l[r]!==n)return s=l[r],!1;if(!t.isPlainObject(l[i])||o==a)return l[i]!==n?(s=l[i],!1):!1;l=l[i]}})),t.isFunction(s)?p=s.apply(i,o):s!==n&&(p=s),t.isArray(r)?r.push(p):r!==n?r=[r,p]:p!==n&&(r=p),s}},h?(I===n&&y.initialize(),y.invoke(g)):(I!==n&&I.invoke("destroy"),y.initialize())}),r!==n?r:this},t.fn.popup.settings={name:"Popup",debug:!1,verbose:!1,performance:!0,namespace:"popup",onCreate:function(){},onRemove:function(){},onShow:function(){},onVisible:function(){},onHide:function(){},onHidden:function(){},on:"hover",addTouchEvents:!0,position:"top left",variation:"",movePopup:!0,target:!1,popup:!1,inline:!1,preserve:!0,hoverable:!1,content:!1,html:!1,title:!1,closable:!0,hideOnScroll:"auto",exclusive:!1,context:"body",prefer:"opposite",lastResort:!1,delay:{show:50,hide:70},setFluidWidth:!0,duration:200,transition:"scale",distanceAway:0,offset:0,maxSearchDepth:20,error:{invalidPosition:"The position you specified is not a valid position",cannotPlace:"No visible position could be found for the popup",method:"The method you called is not defined.",noTransition:"This module requires ui transitions <https://github.com/Semantic-Org/UI-Transition>",notFound:"The target or popup you specified does not exist on the page"},metadata:{activator:"activator",content:"content",html:"html",offset:"offset",position:"position",title:"title",variation:"variation"},className:{active:"active",animating:"animating",dropdown:"dropdown",fluid:"fluid",loading:"loading",popup:"ui popup",position:"top left center bottom right",visible:"visible"},selector:{popup:".ui.popup"},templates:{escape:function(t){var e=/[&<>"'`]/g,o=/[&<>"'`]/,n={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},i=function(t){return n[t]};return o.test(t)?t.replace(e,i):t},popup:function(e){var o="",i=t.fn.popup.settings.templates.escape;return typeof e!==n&&(typeof e.title!==n&&e.title&&(e.title=i(e.title),o+='<div class="header">'+e.title+"</div>"),typeof e.content!==n&&e.content&&(e.content=i(e.content),o+='<div class="content">'+e.content+"</div>")),o}}}}(jQuery,window,document);