/*!
 * # Semantic UI 2.0.6 - Form Validation
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Copyright 2015 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,t,n,i){"use strict";e.fn.form=function(t){var r,o=e(this),a=o.selector||"",s=(new Date).getTime(),l=[],c=arguments[0],u=arguments[1],f="string"==typeof c,d=[].slice.call(arguments,1);return o.each(function(){var p,g,m,v,h,b,y,x,k,w,E,C,R,S,F,T,O,z,D=e(this),j=this,A=[],$=!1;z={initialize:function(){z.get.settings(),f?(O===i&&z.instantiate(),z.invoke(c)):(z.verbose("Initializing form validation",D,x),z.bindEvents(),z.set.defaults(),z.instantiate())},instantiate:function(){z.verbose("Storing instance of module",z),O=z,D.data(F,z)},destroy:function(){z.verbose("Destroying previous module",O),z.removeEvents(),D.removeData(F)},refresh:function(){z.verbose("Refreshing selector cache"),p=D.find(E.field),g=D.find(E.group),m=D.find(E.message),v=D.find(E.prompt),h=D.find(E.submit),b=D.find(E.clear),y=D.find(E.reset)},submit:function(){z.verbose("Submitting form",D),D.submit()},attachEvents:function(t,n){n=n||"submit",e(t).on("click"+T,function(e){z[n](),e.preventDefault()})},bindEvents:function(){z.verbose("Attaching form events"),D.on("submit"+T,z.validate.form).on("blur"+T,E.field,z.event.field.blur).on("click"+T,E.submit,z.submit).on("click"+T,E.reset,z.reset).on("click"+T,E.clear,z.clear),x.keyboardShortcuts&&D.on("keydown"+T,E.field,z.event.field.keydown),p.each(function(){var t=e(this),n=t.prop("type"),i=z.get.changeEvent(n,t);e(this).on(i+T,z.event.field.change)})},clear:function(){p.each(function(){var t=e(this),n=t.parent(),i=t.closest(g),r=i.find(E.prompt),o=t.data(w.defaultValue)||"",a=n.is(E.uiCheckbox),s=n.is(E.uiDropdown),l=i.hasClass(C.error);l&&(z.verbose("Resetting error on field",i),i.removeClass(C.error),r.remove()),s?(z.verbose("Resetting dropdown value",n,o),n.dropdown("clear")):a?t.prop("checked",!1):(z.verbose("Resetting field value",t,o),t.val(""))})},reset:function(){p.each(function(){var t=e(this),n=t.parent(),r=t.closest(g),o=r.find(E.prompt),a=t.data(w.defaultValue),s=n.is(E.uiCheckbox),l=n.is(E.uiDropdown),c=r.hasClass(C.error);a!==i&&(c&&(z.verbose("Resetting error on field",r),r.removeClass(C.error),o.remove()),l?(z.verbose("Resetting dropdown value",n,a),n.dropdown("restore defaults")):s?(z.verbose("Resetting checkbox value",n,a),t.prop("checked",a)):(z.verbose("Resetting field value",t,a),t.val(a)))})},is:{valid:function(){var t=!0;return z.verbose("Checking if form is valid"),e.each(k,function(e,n){z.validate.field(n)||(t=!1)}),t}},removeEvents:function(){D.off(T),p.off(T),h.off(T),p.off(T)},event:{field:{keydown:function(t){var n=e(this),i=t.which,r={enter:13,escape:27};i==r.escape&&(z.verbose("Escape key pressed blurring field"),n.blur()),!t.ctrlKey&&i==r.enter&&n.is(E.input)&&n.not(E.checkbox).length>0&&($||(n.one("keyup"+T,z.event.field.keyup),z.submit(),z.debug("Enter pressed on input submitting form")),$=!0)},keyup:function(){$=!1},blur:function(){var t=e(this),n=t.closest(g),i=z.get.validation(t);n.hasClass(C.error)?(z.debug("Revalidating field",t,i),z.validate.field(i)):("blur"==x.on||"change"==x.on)&&z.validate.field(i)},change:function(){var t=e(this),n=t.closest(g);("change"==x.on||n.hasClass(C.error)&&x.revalidate)&&(clearTimeout(z.timer),z.timer=setTimeout(function(){z.debug("Revalidating field",t,z.get.validation(t)),z.validate.field(z.get.validation(t))},x.delay))}}},get:{changeEvent:function(e,t){return"checkbox"==e||"radio"==e||"hidden"==e||t.is("select")?"change":z.get.inputEvent()},inputEvent:function(){return n.createElement("input").oninput!==i?"input":n.createElement("input").onpropertychange!==i?"propertychange":"keyup"},settings:function(){if(e.isPlainObject(t)){var n=Object.keys(t),r=n.length>0?t[n[0]].identifier!==i&&t[n[0]].rules!==i:!1;r?(x=e.extend(!0,{},e.fn.form.settings,u),k=e.extend({},e.fn.form.settings.defaults,t),z.error(x.error.oldSyntax,j),z.verbose("Extending settings from legacy parameters",k,x)):(x=e.extend(!0,{},e.fn.form.settings,t),k=e.extend({},e.fn.form.settings.defaults,x.fields),z.verbose("Extending settings",k,x))}else x=e.fn.form.settings,k=e.fn.form.settings.defaults,z.verbose("Using default form validation",k,x);S=x.namespace,w=x.metadata,E=x.selector,C=x.className,R=x.error,F="module-"+S,T="."+S,O=D.data(F),z.refresh()},field:function(t){return z.verbose("Finding field with identifier",t),p.filter("#"+t).length>0?p.filter("#"+t):p.filter('[name="'+t+'"]').length>0?p.filter('[name="'+t+'"]'):p.filter('[name="'+t+'[]"]').length>0?p.filter('[name="'+t+'[]"]'):p.filter("[data-"+w.validate+'="'+t+'"]').length>0?p.filter("[data-"+w.validate+'="'+t+'"]'):e("<input/>")},fields:function(t){var n=e();return e.each(t,function(e,t){n=n.add(z.get.field(t))}),n},validation:function(t){var n;return k?(e.each(k,function(e,i){z.get.field(i.identifier)[0]==t[0]&&(n=i)}),n||!1):!1},value:function(e){var t,n=[];return n.push(e),t=z.get.values.call(j,n),t[e]},values:function(t){var n=e.isArray(t)?z.get.fields(t):p,i={};return n.each(function(t,n){var r=e(n),o=(r.prop("type"),r.prop("name")),a=r.val(),s=r.is(E.checkbox),l=r.is(E.radio),c=-1!==o.indexOf("[]"),u=s?r.is(":checked"):!1;if(o)if(c)if(o=o.replace("[]",""),i[o]||(i[o]=[]),s){if(!u)return z.debug("Omitted unchecked checkbox",r),!0;i[o].push(a)}else i[o].push(a);else if(l)u&&(i[o]=a);else if(s){if(!u)return z.debug("Omitted unchecked checkbox",r),!0;i[o]=!0}else i[o]=a}),i}},has:{field:function(e){return z.verbose("Checking for existence of a field with identifier",e),"string"!=typeof e&&z.error(R.identifier,e),p.filter("#"+e).length>0?!0:p.filter('[name="'+e+'"]').length>0?!0:p.filter("[data-"+w.validate+'="'+e+'"]').length>0?!0:!1}},add:{prompt:function(t,n){var r=z.get.field(t),o=r.closest(g),a=o.children(E.prompt),s=0!==a.length;n="string"==typeof n?[n]:n,z.verbose("Adding field error state",t),o.addClass(C.error),x.inline&&(s||(a=x.templates.prompt(n),a.appendTo(o)),a.html(n[0]),s?z.verbose("Inline errors are disabled, no inline error added",t):x.transition&&e.fn.transition!==i&&D.transition("is supported")?(z.verbose("Displaying error with css transition",x.transition),a.transition(x.transition+" in",x.duration)):(z.verbose("Displaying error with fallback javascript animation"),a.fadeIn(x.duration)))},errors:function(e){z.debug("Adding form error messages",e),m.html(x.templates.error(e))}},remove:{prompt:function(t){var n=z.get.field(t.identifier),r=n.closest(g),o=r.children(E.prompt);r.removeClass(C.error),x.inline&&o.is(":visible")&&(z.verbose("Removing prompt for field",t),x.transition&&e.fn.transition!==i&&D.transition("is supported")?o.transition(x.transition+" out",x.duration,function(){o.remove()}):o.fadeOut(x.duration,function(){o.remove()}))}},set:{success:function(){D.removeClass(C.error).addClass(C.success)},defaults:function(){p.each(function(){var t=e(this),n=t.filter(E.checkbox).length>0,i=n?t.is(":checked"):t.val();t.data(w.defaultValue,i)})},error:function(){D.removeClass(C.success).addClass(C.error)},value:function(e,t){var n={};return n[e]=t,z.set.values.call(j,n)},values:function(t){e.isEmptyObject(t)||e.each(t,function(t,n){var i,r=z.get.field(t),o=r.parent(),a=e.isArray(n),s=o.is(E.uiCheckbox),l=o.is(E.uiDropdown),c=r.is(E.radio)&&s,u=r.length>0;u&&(a&&s?(z.verbose("Selecting multiple",n,r),o.checkbox("uncheck"),e.each(n,function(e,t){i=r.filter('[value="'+t+'"]'),o=i.parent(),i.length>0&&o.checkbox("check")})):c?(z.verbose("Selecting radio value",n,r),r.filter('[value="'+n+'"]').parent(E.uiCheckbox).checkbox("check")):s?(z.verbose("Setting checkbox value",n,o),o.checkbox(n===!0?"check":"uncheck")):l?(z.verbose("Setting dropdown value",n,o),o.dropdown("set selected",n)):(z.verbose("Setting field value",n,r),r.val(n)))})}},validate:{form:function(e){return $?!1:(A=[],z.is.valid()?(z.debug("Form has no validation errors, submitting"),z.set.success(),x.onSuccess.call(j,e)):(z.debug("Form has errors"),z.set.error(),x.inline||z.add.errors(A),D.data("moduleApi")!==i&&e.stopImmediatePropagation(),x.onFailure.call(j,A)))},field:function(t){var n=z.get.field(t.identifier),r=!0,o=[];return n.prop("disabled")?(z.debug("Field is disabled. Skipping",t.identifier),r=!0):t.optional&&""===e.trim(n.val())?(z.debug("Field is optional and empty. Skipping",t.identifier),r=!0):t.rules!==i&&e.each(t.rules,function(e,n){z.has.field(t.identifier)&&!z.validate.rule(t,n)&&(z.debug("Field is invalid",t.identifier,n.type),o.push(n.prompt),r=!1)}),r?(z.remove.prompt(t,o),x.onValid.call(n),!0):(A=A.concat(o),z.add.prompt(t.identifier,o),x.onInvalid.call(n,o),!1)},rule:function(t,n){var r,o,a,s=z.get.field(t.identifier),l=n.type,c=s.val(),u=l.match(x.regExp.bracket),f=!0;if(c=c===i||""===c||null===c?"":e.trim(c+""),u){if(o=""+u[1],a=l.replace(u[0],""),r=x.rules[a],!e.isFunction(r))return void z.error(R.noRule,a);f=r.call(s,c,o)}else{if(r=x.rules[l],!e.isFunction(r))return void z.error(R.noRule,l);f=r.call(s,c)}return f}},setting:function(t,n){if(e.isPlainObject(t))e.extend(!0,x,t);else{if(n===i)return x[t];x[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,z,t);else{if(n===i)return z[t];z[t]=n}},debug:function(){x.debug&&(x.performance?z.performance.log(arguments):(z.debug=Function.prototype.bind.call(console.info,console,x.name+":"),z.debug.apply(console,arguments)))},verbose:function(){x.verbose&&x.debug&&(x.performance?z.performance.log(arguments):(z.verbose=Function.prototype.bind.call(console.info,console,x.name+":"),z.verbose.apply(console,arguments)))},error:function(){z.error=Function.prototype.bind.call(console.error,console,x.name+":"),z.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;x.performance&&(t=(new Date).getTime(),i=s||t,n=t-i,s=t,l.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:j,"Execution Time":n})),clearTimeout(z.performance.timer),z.performance.timer=setTimeout(z.performance.display,500)},display:function(){var t=x.name+":",n=0;s=!1,clearTimeout(z.performance.timer),e.each(l,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",a&&(t+=" '"+a+"'"),o.length>1&&(t+=" ("+o.length+")"),(console.group!==i||console.table!==i)&&l.length>0&&(console.groupCollapsed(t),console.table?console.table(l):e.each(l,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),l=[]}},invoke:function(t,n,o){var a,s,l,c=O;return n=n||d,o=j||o,"string"==typeof t&&c!==i&&(t=t.split(/[\. ]/),a=t.length-1,e.each(t,function(n,r){var o=n!=a?r+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(c[o])&&n!=a)c=c[o];else{if(c[o]!==i)return s=c[o],!1;if(!e.isPlainObject(c[r])||n==a)return c[r]!==i?(s=c[r],!1):!1;c=c[r]}})),e.isFunction(s)?l=s.apply(o,n):s!==i&&(l=s),e.isArray(r)?r.push(l):r!==i?r=[r,l]:l!==i&&(r=l),s}},z.initialize()}),r!==i?r:this},e.fn.form.settings={name:"Form",namespace:"form",debug:!1,verbose:!1,performance:!0,fields:!1,keyboardShortcuts:!0,on:"submit",inline:!1,delay:200,revalidate:!0,transition:"scale",duration:200,onValid:function(){},onInvalid:function(){},onSuccess:function(){return!0},onFailure:function(){return!1},metadata:{defaultValue:"default",validate:"validate"},regExp:{bracket:/\[(.*)\]/i,escape:/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,email:"[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?",integer:/^\-?\d+$/,flags:/^\/(.*)\/(.*)?/,url:/(https?:\/\/(?:www\.|(?!www))[^\s\.]+\.[^\s]{2,}|www\.[^\s]+\.[^\s]{2,})/i},selector:{checkbox:'input[type="checkbox"], input[type="radio"]',clear:".clear",field:"input, textarea, select",group:".field",input:"input",message:".error.message",prompt:".prompt.label",radio:'input[type="radio"]',reset:'.reset:not([type="reset"])',submit:'.submit:not([type="submit"])',uiCheckbox:".ui.checkbox",uiDropdown:".ui.dropdown"},className:{error:"error",label:"ui prompt label",pressed:"down",success:"success"},error:{oldSyntax:"Starting in 2.0 forms now only take a single settings object. Validation settings converted to new syntax automatically.",identifier:"You must specify a string identifier for each field",noRule:"There is no rule matching the one you specified",method:"The method you called is not defined."},templates:{error:function(t){var n='<ul class="list">';return e.each(t,function(e,t){n+="<li>"+t+"</li>"}),n+="</ul>",e(n)},prompt:function(t){return e("<div/>").addClass("ui red pointing prompt label").html(t[0])}},rules:{empty:function(t){return!(t===i||""===t||e.isArray(t)&&0===t.length)},checked:function(){return e(this).filter(":checked").length>0},email:function(t){var n=new RegExp(e.fn.form.settings.regExp.email,"i");return n.test(t)},url:function(t){return e.fn.form.settings.regExp.url.test(t)},regExp:function(t,n){var i,r=n.match(e.fn.form.settings.regExp.flags);return r&&(n=r.length>=2?r[1]:n,i=r.length>=3?r[2]:""),t.match(new RegExp(n,i))},integer:function(t,n){var r,o,a,s=e.fn.form.settings.regExp.integer;return n===i||""===n||".."===n||(-1==n.indexOf("..")?s.test(n)&&(r=o=n-0):(a=n.split("..",2),s.test(a[0])&&(r=a[0]-0),s.test(a[1])&&(o=a[1]-0))),s.test(t)&&(r===i||t>=r)&&(o===i||o>=t)},is:function(e,t){return t="string"==typeof t?t.toLowerCase():t,e="string"==typeof e?e.toLowerCase():e,e==t},isExactly:function(e,t){return e==t},not:function(e,t){return e="string"==typeof e?e.toLowerCase():e,t="string"==typeof t?t.toLowerCase():t,e!=t},notExactly:function(e,t){return e!=t},contains:function(t,n){return n=n.replace(e.fn.form.settings.regExp.escape,"\\$&"),-1!==t.search(new RegExp(n,"i"))},containsExactly:function(t,n){return n=n.replace(e.fn.form.settings.regExp.escape,"\\$&"),-1!==t.search(new RegExp(n))},doesntContain:function(t,n){return n=n.replace(e.fn.form.settings.regExp.escape,"\\$&"),-1===t.search(new RegExp(n,"i"))},doesntContainExactly:function(t,n){return n=n.replace(e.fn.form.settings.regExp.escape,"\\$&"),-1===t.search(new RegExp(n))},minLength:function(e,t){return e!==i?e.length>=t:!1},length:function(e,t){return e!==i?e.length>=t:!1},exactLength:function(e,t){return e!==i?e.length==t:!1},maxLength:function(e,t){return e!==i?e.length<=t:!1},match:function(t,n){{var r;e(this)}return e('[data-validate="'+n+'"]').length>0?r=e('[data-validate="'+n+'"]').val():e("#"+n).length>0?r=e("#"+n).val():e('[name="'+n+'"]').length>0?r=e('[name="'+n+'"]').val():e('[name="'+n+'[]"]').length>0&&(r=e('[name="'+n+'[]"]')),r!==i?t.toString()==r.toString():!1},different:function(t,n){{var r;e(this)}return e('[data-validate="'+n+'"]').length>0?r=e('[data-validate="'+n+'"]').val():e("#"+n).length>0?r=e("#"+n).val():e('[name="'+n+'"]').length>0?r=e('[name="'+n+'"]').val():e('[name="'+n+'[]"]').length>0&&(r=e('[name="'+n+'[]"]')),r!==i?t.toString()!==r.toString():!1},exactCount:function(e,t){return 0==t?""===e:1==t?""!==e&&-1===e.search(","):e.split(",").length==t},minCount:function(e,t){return 0==t?!0:1==t?""!==e:e.split(",").length>=t},maxCount:function(e,t){return 0==t?!1:1==t?-1===e.search(","):e.split(",").length<=t}}}}(jQuery,window,document);