/*!
 * # Semantic UI 2.0.6 - Dropdown
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Copyright 2015 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,t,n,i){"use strict";e.fn.dropdown=function(a){var o,s=e(this),r=e(n),l=s.selector||"",c="ontouchstart"in n.documentElement,u=(new Date).getTime(),d=[],v=arguments[0],m="string"==typeof v,f=[].slice.call(arguments,1);return s.each(function(h){var g,b,p,w,x,C,S,y=e.isPlainObject(a)?e.extend(!0,{},e.fn.dropdown.settings,a):e.extend({},e.fn.dropdown.settings),A=y.className,T=y.message,k=y.metadata,L=y.namespace,D=y.regExp,I=y.selector,R=y.error,q=y.templates,V="."+L,E="module-"+L,O=e(this),F=e(y.context),P=O.find(I.text),M=O.find(I.search),z=O.find(I.input),H=O.find(I.icon),j=O.prev().find(I.text).length>0?O.prev().find(I.text):O.prev(),U=O.children(I.menu),N=U.find(I.item),K=!1,W=!1,B=this,$=O.data(E);S={initialize:function(){S.debug("Initializing dropdown",y),S.is.alreadySetup()?S.setup.reference():(S.setup.layout(),S.refreshData(),S.save.defaults(),S.restore.selected(),S.create.id(),c&&S.bind.touchEvents(),S.bind.mouseEvents(),S.bind.keyboardEvents(),S.observeChanges(),S.instantiate())},instantiate:function(){S.verbose("Storing instance of dropdown",S),$=S,O.data(E,S)},destroy:function(){S.verbose("Destroying previous dropdown",O),S.remove.tabbable(),O.off(V).removeData(E),U.off(V),r.off(p),x&&x.disconnect(),C&&C.disconnect()},observeChanges:function(){"MutationObserver"in t&&(x=new MutationObserver(function(e){S.debug("<select> modified, recreating menu"),S.setup.select()}),C=new MutationObserver(function(e){S.debug("Menu modified, updating selector cache"),S.refresh()}),S.has.input()&&x.observe(z[0],{childList:!0,subtree:!0}),S.has.menu()&&C.observe(U[0],{childList:!0,subtree:!0}),S.debug("Setting up mutation observer",x,C))},create:{id:function(){w=(Math.random().toString(16)+"000000000").substr(2,8),p="."+w,S.verbose("Creating unique id for element",w)},userChoice:function(t){var n,a,o;return(t=t||S.get.userValues())?(t=e.isArray(t)?t:[t],e.each(t,function(t,s){S.get.item(s)===!1&&(o=y.templates.addition(s),a=e("<div />").html(o).data(k.value,s).addClass(A.addition).addClass(A.item),n=n===i?a:n.add(a),S.verbose("Creating user choices for value",s,a))}),n):!1},userLabels:function(t){var n=S.get.userValues();n&&(S.debug("Adding user labels",n),e.each(n,function(e,t){S.verbose("Adding custom user value"),S.add.label(t,t)}))}},search:function(e){e=e!==i?e:S.get.query(),S.verbose("Searching for query",e),S.filter(e)},select:{firstUnfiltered:function(){S.verbose("Selecting first non-filtered element"),S.remove.selectedItem(),N.not(I.unselectable).eq(0).addClass(A.selected)},nextAvailable:function(e){e=e.eq(0);var t=e.nextAll(I.item).not(I.unselectable).eq(0),n=e.prevAll(I.item).not(I.unselectable).eq(0),i=t.length>0;i?(S.verbose("Moving selection to",t),t.addClass(A.selected)):(S.verbose("Moving selection to",n),n.addClass(A.selected))}},setup:{api:function(){var e={debug:y.debug,on:!1};S.verbose("First request, initializing API"),O.api(e)},layout:function(){O.is("select")&&(S.setup.select(),S.setup.returnedObject()),S.is.search()&&!S.has.search()&&(S.verbose("Adding search input"),M=e("<input />").addClass(A.search).insertBefore(P)),y.allowTab&&S.set.tabbable(),0===U.length&&(U=e("<div />").addClass(A.menu).appendTo(O))},select:function(){var t=S.get.selectValues();S.debug("Dropdown initialized on a select",t),O.is("select")&&(z=O),z.parent(I.dropdown).length>0?(S.debug("UI dropdown already exists. Creating dropdown menu only"),O=z.closest(I.dropdown),U=O.children(I.menu),S.setup.menu(t)):(S.debug("Creating entire dropdown from select"),O=e("<div />").attr("class",z.attr("class")).addClass(A.selection).addClass(A.dropdown).html(q.dropdown(t)).insertBefore(z),z.hasClass(A.multiple)&&z.prop("multiple")===!1&&(S.error(R.missingMultiple),z.prop("multiple",!0)),z.is("[multiple]")&&S.set.multiple(),z.removeAttr("class").detach().prependTo(O)),S.refresh()},menu:function(e){U.html(q.menu(e)),N=U.find(I.item)},reference:function(){S.debug("Dropdown behavior was called on select, replacing with closest dropdown"),O=O.parent(I.dropdown),S.refresh(),S.setup.returnedObject(),m&&($=S,S.invoke(v))},returnedObject:function(){var e=s.slice(0,h),t=s.slice(h+1);s=e.add(O).add(t)}},refresh:function(){S.refreshSelectors(),S.refreshData()},refreshSelectors:function(){S.verbose("Refreshing selector cache"),P=O.find(I.text),M=O.find(I.search),z=O.find(I.input),H=O.find(I.icon),j=O.prev().find(I.text).length>0?O.prev().find(I.text):O.prev(),U=O.children(I.menu),N=U.find(I.item)},refreshData:function(){S.verbose("Refreshing cached metadata"),N.removeData(k.text).removeData(k.value),O.removeData(k.defaultText).removeData(k.defaultValue).removeData(k.placeholderText)},toggle:function(){S.verbose("Toggling menu visibility"),S.is.active()?S.hide():S.show()},show:function(t){if(t=e.isFunction(t)?t:function(){},S.can.show()&&!S.is.active()){if(S.debug("Showing dropdown"),S.is.multiple()&&!S.has.search()&&S.is.allFiltered())return!0;S.animate.show(function(){S.can.click()&&S.bind.intent(),S.set.visible(),t.call(B)}),y.onShow.call(B)}},hide:function(t){t=e.isFunction(t)?t:function(){},S.is.active()&&(S.debug("Hiding dropdown"),S.animate.hide(function(){S.remove.visible(),t.call(B)}),y.onHide.call(B))},hideOthers:function(){S.verbose("Finding other dropdowns to hide"),s.not(O).has(I.menu+"."+A.visible).dropdown("hide")},hideMenu:function(){S.verbose("Hiding menu  instantaneously"),S.remove.active(),S.remove.visible(),U.transition("hide")},hideSubMenus:function(){var e=U.children(I.item).find(I.menu);S.verbose("Hiding sub menus",e),e.transition("hide")},bind:{keyboardEvents:function(){S.debug("Binding keyboard events"),O.on("keydown"+V,S.event.keydown),S.has.search()&&O.on(S.get.inputEvent()+V,I.search,S.event.input),S.is.multiple()&&r.on("keydown"+p,S.event.document.keydown)},touchEvents:function(){S.debug("Touch device detected binding additional touch events"),S.is.searchSelection()||S.is.single()&&O.on("touchstart"+V,S.event.test.toggle),U.on("touchstart"+V,I.item,S.event.item.mouseenter)},mouseEvents:function(){S.debug("Mouse detected binding mouse events"),S.is.multiple()&&O.on("click"+V,I.label,S.event.label.click).on("click"+V,I.remove,S.event.remove.click),S.is.searchSelection()?(O.on("mousedown"+V,I.menu,S.event.menu.mousedown).on("mouseup"+V,I.menu,S.event.menu.mouseup).on("click"+V,I.icon,S.event.icon.click).on("click"+V,I.search,S.show).on("focus"+V,I.search,S.event.search.focus).on("blur"+V,I.search,S.event.search.blur).on("click"+V,I.text,S.event.text.focus),S.is.multiple()&&O.on("click"+V,S.event.click)):("click"==y.on?O.on("click"+V,I.icon,S.event.icon.click).on("click"+V,S.event.test.toggle):"hover"==y.on?O.on("mouseenter"+V,S.delay.show).on("mouseleave"+V,S.delay.hide):O.on(y.on+V,S.toggle),O.on("mousedown"+V,S.event.mousedown).on("mouseup"+V,S.event.mouseup).on("focus"+V,S.event.focus).on("blur"+V,S.event.blur)),U.on("mouseenter"+V,I.item,S.event.item.mouseenter).on("mouseleave"+V,I.item,S.event.item.mouseleave).on("click"+V,I.item,S.event.item.click)},intent:function(){S.verbose("Binding hide intent event to document"),c&&r.on("touchstart"+p,S.event.test.touch).on("touchmove"+p,S.event.test.touch),r.on("click"+p,S.event.test.hide)}},unbind:{intent:function(){S.verbose("Removing hide intent event from document"),c&&r.off("touchstart"+p).off("touchmove"+p),r.off("click"+p)}},filter:function(e){var t=e!==i?e:S.get.query(),n=function(){S.is.multiple()&&S.filterActive(),S.select.firstUnfiltered(),S.has.allResultsFiltered()?y.onNoResults.call(B,t)?y.allowAdditions||(S.verbose("All items filtered, showing message",t),S.add.message(T.noResults)):(S.verbose("All items filtered, hiding dropdown",t),S.hideMenu()):S.remove.message(),y.allowAdditions&&S.add.userSuggestion(e),S.is.searchSelection()&&S.can.show()&&S.is.focusedOnSearch()&&S.show()};y.useLabels&&S.has.maxSelections()||(y.apiSettings?S.can.useAPI()?S.queryRemote(t,function(){n()}):S.error(R.noAPI):(S.filterItems(t),n()))},queryRemote:function(t,n){var i={errorDuration:!1,throttle:y.throttle,cache:"local",urlData:{query:t},onError:function(){S.add.message(T.serverError),n()},onFailure:function(){S.add.message(T.serverError),n()},onSuccess:function(e){S.remove.message(),S.setup.menu({values:e.results}),n()}};O.api("get request")||S.setup.api(),i=e.extend(!0,{},i,y.apiSettings),O.api("setting",i).api("query")},filterItems:function(t){var n=t!==i?t:S.get.query(),a=e(),o=S.escape.regExp(n),s=new RegExp("^"+o,"igm");""===n?a=N:(S.verbose("Searching for matching values",n),N.each(function(){var t,i,o=e(this);if("both"==y.match||"text"==y.match){if(t=String(S.get.choiceText(o,!1)),-1!==t.search(s))return a=a.add(o),!0;if(y.fullTextSearch&&S.fuzzySearch(n,t))return a=a.add(o),!0}if("both"==y.match||"value"==y.match){if(i=String(S.get.choiceValue(o,t)),-1!==i.search(s))return a=a.add(o),!0;if(y.fullTextSearch&&S.fuzzySearch(n,i))return a=a.add(o),!0}})),S.debug("Showing only matched items",n),S.remove.filteredItem(),N.not(a).addClass(A.filtered)},fuzzySearch:function(e,t){var n=t.length,i=e.length;if(e=e.toLowerCase(),t=t.toLowerCase(),i>n)return!1;if(i===n)return e===t;e:for(var a=0,o=0;i>a;a++){for(var s=e.charCodeAt(a);n>o;)if(t.charCodeAt(o++)===s)continue e;return!1}return!0},filterActive:function(){y.useLabels&&N.filter("."+A.active).addClass(A.filtered)},focusSearch:function(){S.is.search()&&!S.is.focusedOnSearch()&&M[0].focus()},forceSelection:function(){var e=N.not(A.filtered).filter("."+A.selected).eq(0),t=N.not(A.filtered).filter("."+A.active).eq(0),n=e.length>0?e:t,i=n.size()>0;i?(S.debug("Forcing partial selection to selected item",n),S.event.item.click.call(n)):S.hide()},event:{focus:function(){y.showOnFocus&&!K&&S.is.hidden()&&!b&&S.show()},click:function(t){var n=e(t.target);n.is(O)&&!S.is.focusedOnSearch()&&S.focusSearch()},blur:function(e){b=n.activeElement===this,K||b||(S.remove.activeLabel(),S.hide())},mousedown:function(){K=!0},mouseup:function(){K=!1},search:{focus:function(){K=!0,S.is.multiple()&&S.remove.activeLabel(),y.showOnFocus&&S.show()},blur:function(e){b=n.activeElement===this,W||b||(S.is.multiple()?(S.remove.activeLabel(),S.hide()):y.forceSelection?S.forceSelection():S.hide())}},icon:{click:function(e){S.toggle(),e.stopPropagation()}},text:{focus:function(e){K=!0,S.focusSearch()}},input:function(e){(S.is.multiple()||S.is.searchSelection())&&S.set.filtered(),clearTimeout(S.timer),S.timer=setTimeout(S.search,y.delay.search)},label:{click:function(t){var n=e(this),i=O.find(I.label),a=i.filter("."+A.active),o=n.nextAll("."+A.active),s=n.prevAll("."+A.active),r=o.length>0?n.nextUntil(o).add(a).add(n):n.prevUntil(s).add(a).add(n);t.shiftKey?(a.removeClass(A.active),r.addClass(A.active)):t.ctrlKey?n.toggleClass(A.active):(a.removeClass(A.active),n.addClass(A.active)),y.onLabelSelect.apply(this,i.filter("."+A.active))}},remove:{click:function(){var t=e(this).parent();t.hasClass(A.active)?S.remove.activeLabels():S.remove.activeLabels(t)}},test:{toggle:function(e){var t=S.is.multiple()?S.show:S.toggle;S.determine.eventOnElement(e,t)&&e.preventDefault()},touch:function(e){S.determine.eventOnElement(e,function(){"touchstart"==e.type?S.timer=setTimeout(S.hide,y.delay.touch):"touchmove"==e.type&&clearTimeout(S.timer)}),e.stopPropagation()},hide:function(e){S.determine.eventInModule(e,S.hide)}},menu:{mousedown:function(){W=!0},mouseup:function(){W=!1}},item:{mouseenter:function(t){var n=e(this).children(I.menu),i=e(this).siblings(I.item).children(I.menu);n.length>0&&(clearTimeout(S.itemTimer),S.itemTimer=setTimeout(function(){S.verbose("Showing sub-menu",n),e.each(i,function(){S.animate.hide(!1,e(this))}),S.animate.show(!1,n)},y.delay.show),t.preventDefault())},mouseleave:function(t){var n=e(this).children(I.menu);n.length>0&&(clearTimeout(S.itemTimer),S.itemTimer=setTimeout(function(){S.verbose("Hiding sub-menu",n),S.animate.hide(!1,n)},y.delay.hide))},click:function(t){var n=e(this),i=e(t?t.target:""),a=n.find(I.menu),o=S.get.choiceText(n),s=S.get.choiceValue(n,o),r=a.length>0,l=a.find(i).length>0;l||r&&!y.allowCategorySelection||(y.useLabels||(S.remove.filteredItem(),S.remove.searchTerm(),S.set.scrollPosition(n)),S.determine.selectAction.call(this,o,s))}},document:{keydown:function(e){var t=e.which,n=S.get.shortcutKeys(),i=S.is.inObject(t,n);if(i){var a=O.find(I.label),o=a.filter("."+A.active),s=(o.data("value"),a.index(o)),r=a.length,l=o.length>0,c=o.length>1,u=0===s,d=s+1==r,v=S.is.searchSelection(),m=S.is.focusedOnSearch(),f=S.is.focused(),h=m&&0===S.get.caretPosition();if(v&&!l&&!m)return;t==n.leftArrow?!f&&!h||l?l&&(e.shiftKey?S.verbose("Adding previous label to selection"):(S.verbose("Selecting previous label"),a.removeClass(A.active)),u&&!c?o.addClass(A.active):o.prev(I.siblingLabel).addClass(A.active).end(),e.preventDefault()):(S.verbose("Selecting previous label"),a.last().addClass(A.active)):t==n.rightArrow?(f&&!l&&a.first().addClass(A.active),l&&(e.shiftKey?S.verbose("Adding next label to selection"):(S.verbose("Selecting next label"),a.removeClass(A.active)),d?v?m?a.removeClass(A.active):S.focusSearch():c?o.next(I.siblingLabel).addClass(A.active):o.addClass(A.active):o.next(I.siblingLabel).addClass(A.active),e.preventDefault())):t==n.deleteKey||t==n.backspace?l?(S.verbose("Removing active labels"),d&&v&&!m&&S.focusSearch(),o.last().next(I.siblingLabel).addClass(A.active),S.remove.activeLabels(o),e.preventDefault()):h&&!l&&t==n.backspace&&(S.verbose("Removing last label on input backspace"),o=a.last().addClass(A.active),S.remove.activeLabels(o)):o.removeClass(A.active)}}},keydown:function(e){var t=e.which,n=S.get.shortcutKeys(),i=S.is.inObject(t,n);if(i){var a,o,s=N.not(I.unselectable).filter("."+A.selected).eq(0),r=U.children("."+A.active).eq(0),l=s.length>0?s:r,c=l.length>0?l.siblings(":not(."+A.filtered+")").andSelf():U.children(":not(."+A.filtered+")"),u=l.children(I.menu),d=l.closest(I.menu),v=d.hasClass(A.visible)||d.hasClass(A.animating)||d.parent(I.menu).length>0,m=u.length>0,f=l.length>0,h=l.not(I.unselectable).length>0;if(S.is.visible()){if((t==n.enter||t==n.delimiter)&&(t==n.enter&&f&&m&&!y.allowCategorySelection?(S.verbose("Pressed enter on unselectable category, opening sub menu"),t=n.rightArrow):h&&(S.verbose("Selecting item from keyboard shortcut",l),S.event.item.click.call(l,e),S.is.searchSelection()&&S.remove.searchTerm()),e.preventDefault()),t==n.leftArrow&&(o=d[0]!==U[0],o&&(S.verbose("Left key pressed, closing sub-menu"),S.animate.hide(!1,d),l.removeClass(A.selected),d.closest(I.item).addClass(A.selected),e.preventDefault())),t==n.rightArrow&&m&&(S.verbose("Right key pressed, opening sub-menu"),S.animate.show(!1,u),l.removeClass(A.selected),u.find(I.item).eq(0).addClass(A.selected),e.preventDefault()),t==n.upArrow){if(a=f&&v?l.prevAll(I.item+":not("+I.unselectable+")").eq(0):N.eq(0),c.index(a)<0)return S.verbose("Up key pressed but reached top of current menu"),void e.preventDefault();S.verbose("Up key pressed, changing active item"),l.removeClass(A.selected),a.addClass(A.selected),S.set.scrollPosition(a),e.preventDefault()}if(t==n.downArrow){if(a=f&&v?a=l.nextAll(I.item+":not("+I.unselectable+")").eq(0):N.eq(0),0===a.length)return S.verbose("Down key pressed but reached bottom of current menu"),void e.preventDefault();S.verbose("Down key pressed, changing active item"),N.removeClass(A.selected),a.addClass(A.selected),S.set.scrollPosition(a),e.preventDefault()}t==n.pageUp&&(S.scrollPage("up"),e.preventDefault()),t==n.pageDown&&(S.scrollPage("down"),e.preventDefault()),t==n.escape&&(S.verbose("Escape key pressed, closing dropdown"),S.hide())}else t==n.delimiter&&e.preventDefault(),t==n.downArrow&&(S.verbose("Down key pressed, showing dropdown"),S.show(),e.preventDefault())}else S.is.selection()&&!S.is.search()&&S.set.selectedLetter(String.fromCharCode(t))}},determine:{selectAction:function(t,n){S.verbose("Determining action",y.action),e.isFunction(S.action[y.action])?(S.verbose("Triggering preset action",y.action,t,n),S.action[y.action].call(this,t,n)):e.isFunction(y.action)?(S.verbose("Triggering user action",y.action,t,n),y.action.call(this,t,n)):S.error(R.action,y.action)},eventInModule:function(t,i){var a=e(t.target),o=a.closest(n.documentElement).length>0,s=a.closest(O).length>0;return i=e.isFunction(i)?i:function(){},o&&!s?(S.verbose("Triggering event",i),i(),!0):(S.verbose("Event occurred in dropdown, canceling callback"),!1)},eventOnElement:function(t,n){var i=e(t.target),a=0===i.closest(I.siblingLabel).length,o=0===i.closest(U).length;return n=e.isFunction(n)?n:function(){},a&&o?(S.verbose("Triggering event",n),n(),!0):(S.verbose("Event occurred in dropdown menu, canceling callback"),!1)}},action:{nothing:function(){},activate:function(t,n){if(n=n!==i?n:t,S.can.activate(e(this))){if(S.set.selected(n,e(this)),S.is.multiple()&&!S.is.allFiltered())return;S.hideAndClear()}},select:function(e,t){S.action.activate.call(this)},combo:function(t,n){n=n!==i?n:t,S.set.selected(n,e(this)),S.hideAndClear()},hide:function(){S.hideAndClear()}},get:{id:function(){return w},text:function(){return P.text()},query:function(){return e.trim(M.val())},searchWidth:function(e){return e*y.glyphWidth+"em"},selectionCount:function(){var t,n=S.get.values();return t=S.is.multiple()?e.isArray(n)?n.length:0:""!==S.get.value()?1:0},transition:function(e){return"auto"==y.transition?S.is.upward(e)?"slide up":"slide down":y.transition},userValues:function(){var t=S.get.values();return t?(t=e.isArray(t)?t:[t],e.grep(t,function(e){return S.get.item(e)===!1})):!1},uniqueArray:function(t){return e.grep(t,function(n,i){return e.inArray(n,t)===i})},caretPosition:function(){var e,t,i=M.get(0);return"selectionStart"in i?i.selectionStart:n.selection?(i.focus(),e=n.selection.createRange(),t=e.text.length,e.moveStart("character",-i.value.length),e.text.length-t):void 0},shortcutKeys:function(){return{backspace:8,delimiter:188,deleteKey:46,enter:13,escape:27,pageUp:33,pageDown:34,leftArrow:37,upArrow:38,rightArrow:39,downArrow:40}},value:function(){var t=z.length>0?z.val():O.data(k.value);return e.isArray(t)&&1===t.length&&""===t[0]?"":t},values:function(){var e=S.get.value();return""===e?"":!S.has.selectInput()&&S.is.multiple()?"string"==typeof e?e.split(y.delimiter):"":e},remoteValues:function(){var t=S.get.values(),n=!1;return t&&("string"==typeof t&&(t=[t]),n={},e.each(t,function(e,t){var i=S.read.remoteData(t);S.verbose("Restoring value from session data",i,t),n[t]=i?i:t})),n},choiceText:function(e,t){return t=t!==i?t:y.preserveHTML,e?(e.find(I.menu).length>0&&(S.verbose("Retreiving text of element with sub-menu"),e=e.clone(),e.find(I.menu).remove(),e.find(I.menuIcon).remove()),e.data(k.text)!==i?e.data(k.text):t?e.html().trim():e.text().trim()):void 0},choiceValue:function(e,t){return t=t||S.get.choiceText(e),e?e.data(k.value)!==i?e.data(k.value):"string"==typeof t?t.toLowerCase().trim():t:!1},inputEvent:function(){var e=M[0];return e?e.oninput!==i?"input":e.onpropertychange!==i?"propertychange":"keyup":!1},selectValues:function(){var t={};return t.values=[],O.find("option").each(function(){var n=e(this),a=n.html(),o=n.attr("disabled"),s=n.attr("value")!==i?n.attr("value"):a;"auto"===y.placeholder&&""===s?t.placeholder=a:t.values.push({name:a,value:s,disabled:o})}),y.placeholder&&"auto"!==y.placeholder&&(S.debug("Setting placeholder value to",y.placeholder),t.placeholder=y.placeholder),y.sortSelect?(t.values.sort(function(e,t){return e.name>t.name?1:-1}),S.debug("Retrieved and sorted values from select",t)):S.debug("Retreived values from select",t),t},activeItem:function(){return N.filter("."+A.active)},selectedItem:function(){var e=N.not(I.unselectable).filter("."+A.selected);return e.length>0?e:N.eq(0)},itemWithAdditions:function(e){var t=S.get.item(e),n=S.create.userChoice(e),i=n&&n.length>0;return i&&(t=t.length>0?t.add(n):n),t},item:function(t,n){var a,o,s=!1;return t=t!==i?t:S.get.values()!==i?S.get.values():S.get.text(),a=o?t.length>0:t!==i&&""!==t&&null!==t,o=S.is.multiple()&&e.isArray(t),n=""===t||0===t?!0:n||!1,a&&N.each(function(){var a=e(this),r=S.get.choiceText(a),l=S.get.choiceValue(a,r);if(null!==l&&l!==i)if(o)(-1!==e.inArray(l.toString(),t)||-1!==e.inArray(r,t))&&(s=s?s.add(a):a);else if(n){if(S.verbose("Ambiguous dropdown value using strict type check",a,t),l===t||r===t)return s=a,!0}else if(l.toString()==t.toString()||r==t)return S.verbose("Found select item by value",l,t),s=a,!0}),s}},check:{maxSelections:function(e){return y.maxSelections?(e=e!==i?e:S.get.selectionCount(),e>=y.maxSelections?(S.debug("Maximum selection count reached"),y.useLabels&&(N.addClass(A.filtered),S.add.message(T.maxSelections)),!0):(S.verbose("No longer at maximum selection count"),S.remove.message(),S.remove.filteredItem(),S.is.searchSelection()&&S.filterItems(),!1)):!0}},restore:{defaults:function(){S.clear(),S.restore.defaultText(),S.restore.defaultValue()},defaultText:function(){var e=O.data(k.defaultText);S.debug("Restoring default text",e),S.set.text(e),P.addClass(A.placeholder)},defaultValue:function(){var e=O.data(k.defaultValue);e!==i&&(S.debug("Restoring default value",e),""!==e?(S.set.value(e),S.set.selected()):(S.remove.activeItem(),S.remove.selectedItem()))},labels:function(){y.allowAdditions&&(y.useLabels||(S.error(R.labels),y.useLabels=!0),S.debug("Restoring selected values"),S.create.userLabels()),S.check.maxSelections()},selected:function(){S.restore.values(),S.is.multiple()?(S.debug("Restoring previously selected values and labels"),S.restore.labels()):S.debug("Restoring previously selected values")},values:function(){S.set.initialLoad(),y.apiSettings?y.saveRemoteData?S.restore.remoteValues():S.clearValue():S.set.selected(),S.remove.initialLoad()},remoteValues:function(){var t=S.get.remoteValues();S.debug("Recreating selected from session data",t),t&&(S.is.single()?e.each(t,function(e,t){S.set.text(t)}):e.each(t,function(e,t){S.add.label(e,t)}))}},read:{remoteData:function(e){var n;return t.Storage===i?void S.error(R.noStorage):(n=sessionStorage.getItem(e),n!==i?n:!1)}},save:{defaults:function(){S.save.defaultText(),S.save.placeholderText(),S.save.defaultValue()},defaultValue:function(){var e=S.get.value();S.verbose("Saving default value as",e),O.data(k.defaultValue,e)},defaultText:function(){var e=S.get.text();S.verbose("Saving default text as",e),O.data(k.defaultText,e)},placeholderText:function(){var e;P.hasClass(A.placeholder)&&(e=S.get.text(),S.verbose("Saving placeholder text as",e),O.data(k.placeholderText,e))},remoteData:function(e,n){return t.Storage===i?void S.error(R.noStorage):(S.verbose("Saving remote data to session storage",n,e),void sessionStorage.setItem(n,e))}},clear:function(){S.is.multiple()?S.remove.labels():(S.remove.activeItem(),S.remove.selectedItem()),S.set.placeholderText(),S.clearValue()},clearValue:function(){S.set.value("")},scrollPage:function(e,t){var n,i,a,t=t||S.get.selectedItem(),o=t.closest(I.menu),s=o.outerHeight(),r=o.scrollTop(),l=N.eq(0).outerHeight(),c=Math.floor(s/l),u=(o.prop("scrollHeight"),"up"==e?r-l*c:r+l*c),d=N.not(I.unselectable);a="up"==e?d.index(t)-c:d.index(t)+c,n="up"==e?a>=0:a<d.length,i=n?d.eq(a):"up"==e?d.first():d.last(),i.length>0&&(S.debug("Scrolling page",e,i),t.removeClass(A.selected),i.addClass(A.selected),o.scrollTop(u))},set:{filtered:function(){var e=S.is.multiple(),t=S.is.searchSelection(),n=e&&t,i=t?S.get.query():"",a="string"==typeof i&&i.length>0,o=S.get.searchWidth(i.length),s=""!==i;e&&a&&(S.verbose("Adjusting input width",o,y.glyphWidth),M.css("width",o)),a||n&&s?(S.verbose("Hiding placeholder text"),P.addClass(A.filtered)):(!e||n&&!s)&&(S.verbose("Showing placeholder text"),P.removeClass(A.filtered))},loading:function(){O.addClass(A.loading)},placeholderText:function(e){e=e||O.data(k.placeholderText),e&&(S.debug("Restoring placeholder text"),S.set.text(e),P.addClass(A.placeholder))},tabbable:function(){S.has.search()?(S.debug("Added tabindex to searchable dropdown"),M.val("").attr("tabindex",0),U.attr("tabindex",-1)):(S.debug("Added tabindex to dropdown"),O.attr("tabindex")||(O.attr("tabindex",0),U.attr("tabindex",-1)))},initialLoad:function(){S.verbose("Setting initial load"),g=!0},scrollPosition:function(e,t){var n,a,o,s,r,l,c,u,d,v=5;e=e||S.get.selectedItem(),n=e.closest(I.menu),a=e&&e.length>0,t=t!==i?t:!1,e&&n.length>0&&a&&(s=e.position().top,n.addClass(A.loading),l=n.scrollTop(),r=n.offset().top,s=e.offset().top,o=l-r+s,t||(c=n.height(),d=o+v>l+c,u=l>o-v),S.debug("Scrolling to active item",o),(t||u||d)&&n.scrollTop(o),n.removeClass(A.loading))},text:function(e){"select"!==y.action&&("combo"==y.action?(S.debug("Changing combo button text",e,j),y.preserveHTML?j.html(e):j.text(e)):(S.debug("Changing text",e,P),P.removeClass(A.filtered).removeClass(A.placeholder),y.preserveHTML?P.html(e):P.text(e)))},selectedLetter:function(t){var n,i=N.filter("."+A.selected),a=i.length>0&&S.has.firstLetter(i,t),o=!1;a&&(n=i.nextAll(N).eq(0),S.has.firstLetter(n,t)&&(o=n)),o||N.each(function(){return S.has.firstLetter(e(this),t)?(o=e(this),!1):void 0}),o&&(S.verbose("Scrolling to next value with letter",t),S.set.scrollPosition(o),i.removeClass(A.selected),o.addClass(A.selected))},direction:function(e){"auto"==y.direction?S.is.onScreen(e)?S.remove.upward(e):S.set.upward(e):"upward"==y.direction&&S.set.upward(e)},upward:function(e){var t=e||O;t.addClass(A.upward)},value:function(e,t,n){var i=z.length>0,a=(!S.has.value(e),S.get.values()),o="number"==typeof e?e.toString():e;if(i){if(o==a&&(S.verbose("Skipping value update already same value",e,a),!S.is.initialLoad()))return;S.is.single()&&S.has.selectInput()&&S.can.extendSelect()&&(S.debug("Adding user option",e),S.add.optionValue(e)),S.debug("Updating input value",e,a),z.val(e).trigger("change")}else S.verbose("Storing value in metadata",e,z),e!==a&&O.data(k.value,e);y.fireOnInit===!1&&S.is.initialLoad()?S.verbose("No callback on initial load",y.onChange):y.onChange.call(B,e,t,n)},active:function(){O.addClass(A.active)},multiple:function(){O.addClass(A.multiple)},visible:function(){O.addClass(A.visible)},exactly:function(e,t){S.debug("Setting selected to exact values"),S.clear(),S.set.selected(e,t)},selected:function(t,n){var i=S.is.multiple();n=y.allowAdditions?n||S.get.itemWithAdditions(t):n||S.get.item(t),n&&(S.debug("Setting selected menu item to",n),S.is.single()?(S.remove.activeItem(),S.remove.selectedItem()):y.useLabels&&S.remove.selectedItem(),n.each(function(){var t=e(this),a=S.get.choiceText(t),o=S.get.choiceValue(t,a),s=t.hasClass(A.filtered),r=t.hasClass(A.active),l=t.hasClass(A.addition),c=i&&1==n.length;i?!r||l?(y.apiSettings&&y.saveRemoteData&&S.save.remoteData(a,o),y.useLabels?(S.add.value(o,a,t),S.add.label(o,a,c),t.addClass(A.active),S.filterActive(),S.select.nextAvailable(n)):(S.add.value(o,a,t),S.set.text(S.add.variables(T.count)),t.addClass(A.active))):s||(S.debug("Selected active value, removing label"),S.remove.selected(o)):(y.apiSettings&&y.saveRemoteData&&S.save.remoteData(a,o),S.set.text(a),S.set.value(o,a,t),t.addClass(A.active).addClass(A.selected))}))}},add:{label:function(t,n,i){var a,o=S.is.searchSelection()?M:P;return a=e("<a />").addClass(A.label).attr("data-value",t).html(q.label(t,n)),a=y.onLabelCreate.call(a,t,n),S.has.label(t)?void S.debug("Label already exists, skipping",t):(y.label.variation&&a.addClass(y.label.variation),void(i===!0?(S.debug("Animating in label",a),a.addClass(A.hidden).insertBefore(o).transition(y.label.transition,y.label.duration)):(S.debug("Adding selection label",a),a.insertBefore(o))))},message:function(t){var n=U.children(I.message),i=y.templates.message(S.add.variables(t));n.length>0?n.html(i):n=e("<div/>").html(i).addClass(A.message).appendTo(U)},optionValue:function(t){var n=z.find('option[value="'+t+'"]'),i=n.length>0;i||(x&&(x.disconnect(),S.verbose("Temporarily disconnecting mutation observer",t)),S.is.single()&&(S.verbose("Removing previous user addition"),z.find("option."+A.addition).remove()),e("<option/>").prop("value",t).addClass(A.addition).html(t).appendTo(z),S.verbose("Adding user addition as an <option>",t),x&&x.observe(z[0],{childList:!0,subtree:!0}))},userSuggestion:function(e){var t,n=U.children(I.addition),i=S.get.item(e),a=n.length>0;if(!y.useLabels||!S.has.maxSelections()){if(""===e||i)return void n.remove();N.removeClass(A.selected),a?(t=y.templates.addition(e),n.html(t).data(k.value,e).removeClass(A.filtered).addClass(A.selected),S.verbose("Replacing user suggestion with new value",n)):(n=S.create.userChoice(e),n.prependTo(U).addClass(A.selected),S.verbose("Adding item choice to menu corresponding with user choice addition",n))}},variables:function(e){var t,n,i=-1!==e.search("{count}"),a=-1!==e.search("{maxCount}"),o=-1!==e.search("{term}");return S.verbose("Adding templated variables to message",e),i&&(t=S.get.selectionCount(),e=e.replace("{count}",t)),a&&(t=S.get.selectionCount(),e=e.replace("{maxCount}",y.maxSelections)),o&&(n=S.get.query(),e=e.replace("{term}",n)),e},value:function(t,n,i){var a,o=S.get.values();return""===t?void S.debug("Cannot select blank values from multiselect"):(e.isArray(o)?(a=o.concat([t]),a=S.get.uniqueArray(a)):a=[t],S.has.selectInput()?S.can.extendSelect()&&(S.debug("Adding value to select",t,a,z),S.add.optionValue(t)):(a=a.join(y.delimiter),S.debug("Setting hidden input to delimited value",a,z)),y.fireOnInit===!1&&S.is.initialLoad()?S.verbose("No callback on initial load",y.onAdd):y.onAdd.call(B,t,n,i),S.set.value(a,t,n,i),void S.check.maxSelections())}},remove:{active:function(){O.removeClass(A.active)},activeLabel:function(){O.find(I.label).removeClass(A.active)},loading:function(){O.removeClass(A.loading)},initialLoad:function(){g=!1},upward:function(e){var t=e||O;t.removeClass(A.upward)},visible:function(){O.removeClass(A.visible)},activeItem:function(){N.removeClass(A.active)},filteredItem:function(){y.useLabels&&S.has.maxSelections()||(y.useLabels?N.not("."+A.active).removeClass(A.filtered):N.removeClass(A.filtered))},optionValue:function(e){var t=z.find('option[value="'+e+'"]'),n=t.length>0;n&&t.hasClass(A.addition)&&(x&&(x.disconnect(),S.verbose("Temporarily disconnecting mutation observer",e)),t.remove(),S.verbose("Removing user addition as an <option>",e),x&&x.observe(z[0],{childList:!0,subtree:!0}))},message:function(){U.children(I.message).remove()},searchTerm:function(){S.verbose("Cleared search term"),M.val(""),S.set.filtered()},selected:function(t,n){return(n=y.allowAdditions?n||S.get.itemWithAdditions(t):n||S.get.item(t))?void n.each(function(){var t=e(this),n=S.get.choiceText(t),i=S.get.choiceValue(t,n);S.is.multiple()?y.useLabels?(S.remove.value(i,n,t),S.remove.label(i)):(S.remove.value(i,n,t),S.set.text(S.add.variables(T.count))):S.remove.value(i,n,t),t.removeClass(A.filtered).removeClass(A.active),y.useLabels&&t.removeClass(A.selected)}):!1},selectedItem:function(){N.removeClass(A.selected)},value:function(e,t,n){var i,a=S.get.values();S.has.selectInput()?(S.verbose("Input is <select> removing selected option",e),i=S.remove.arrayValue(e,a),S.remove.optionValue(e)):(S.verbose("Removing from delimited values",e),i=S.remove.arrayValue(e,a),i=i.join(y.delimiter)),y.fireOnInit===!1&&S.is.initialLoad()?S.verbose("No callback on initial load",y.onRemove):y.onRemove.call(B,e,t,n),S.set.value(i,t,n),S.check.maxSelections()},arrayValue:function(t,n){return e.isArray(n)||(n=[n]),n=e.grep(n,function(e){return t!=e}),S.verbose("Removed value from delimited string",t,n),n},label:function(e,t){var n=O.find(I.label),i=n.filter('[data-value="'+e+'"]');S.verbose("Removing label",i),i.remove()},activeLabels:function(e){e=e||O.find(I.label).filter("."+A.active),S.verbose("Removing active label selections",e),S.remove.labels(e)},labels:function(t){t=t||O.find(I.label),S.verbose("Removing labels",t),t.each(function(){var t=e(this).data("value"),n=S.is.userValue(t);n?(S.remove.value(t),S.remove.label(t)):S.remove.selected(t)})},tabbable:function(){S.has.search()?(S.debug("Searchable dropdown initialized"),M.attr("tabindex","-1"),U.attr("tabindex","-1")):(S.debug("Simple selection dropdown initialized"),
O.attr("tabindex","-1"),U.attr("tabindex","-1"))}},has:{search:function(){return M.length>0},selectInput:function(){return z.is("select")},firstLetter:function(e,t){var n,i;return e&&0!==e.length&&"string"==typeof t?(n=S.get.choiceText(e,!1),t=t.toLowerCase(),i=String(n).charAt(0).toLowerCase(),t==i):!1},input:function(){return z.length>0},items:function(){return N.length>0},menu:function(){return U.length>0},message:function(){return 0!==U.children(I.message).length},label:function(e){var t=O.find(I.label);return t.filter('[data-value="'+e+'"]').length>0},maxSelections:function(){return y.maxSelections&&S.get.selectionCount()>=y.maxSelections},allResultsFiltered:function(){return N.filter(I.unselectable).length===N.length},value:function(t){var n=S.get.values(),i=e.isArray(n)?n&&-1!==e.inArray(t,n):n==t;return i?!0:!1}},is:{active:function(){return O.hasClass(A.active)},alreadySetup:function(){return O.is("select")&&O.parent(I.dropdown).length>0&&0===O.prev().length},animating:function(e){return e?e.transition&&e.transition("is animating"):U.transition&&U.transition("is animating")},disabled:function(){return O.hasClass(A.disabled)},focused:function(){return n.activeElement===O[0]},focusedOnSearch:function(){return n.activeElement===M[0]},allFiltered:function(){return(S.is.multiple()||S.has.search())&&!S.has.message()&&S.has.allResultsFiltered()},hidden:function(e){return!S.is.visible(e)},initialLoad:function(){return g},onScreen:function(e){var t,n=e||U,i=!0,a={};return n.addClass(A.loading),t={context:{scrollTop:F.scrollTop(),height:F.outerHeight()},menu:{offset:n.offset(),height:n.outerHeight()}},a={above:t.context.scrollTop<=t.menu.offset.top-t.menu.height,below:t.context.scrollTop+t.context.height>=t.menu.offset.top+t.menu.height},a.below?(S.verbose("Dropdown can fit in context downward",a),i=!0):a.below||a.above?(S.verbose("Dropdown cannot fit below, opening upward",a),i=!1):(S.verbose("Dropdown cannot fit in either direction, favoring downward",a),i=!0),n.removeClass(A.loading),i},inObject:function(t,n){var i=!1;return e.each(n,function(e,n){return n==t?(i=!0,!0):void 0}),i},multiple:function(){return O.hasClass(A.multiple)},single:function(){return!S.is.multiple()},selectMutation:function(t){var n=!1;return e.each(t,function(t,i){return i.target&&e(i.target).is("select")?(n=!0,!0):void 0}),n},search:function(){return O.hasClass(A.search)},searchSelection:function(){return S.has.search()&&1===M.parent(I.dropdown).length},selection:function(){return O.hasClass(A.selection)},userValue:function(t){return-1!==e.inArray(t,S.get.userValues())},upward:function(e){var t=e||O;return t.hasClass(A.upward)},visible:function(e){return e?e.hasClass(A.visible):U.hasClass(A.visible)}},can:{activate:function(e){return y.useLabels?!0:S.has.maxSelections()?S.has.maxSelections()&&e.hasClass(A.active)?!0:!1:!0},click:function(){return c||"click"==y.on},extendSelect:function(){return y.allowAdditions||y.apiSettings},show:function(){return!S.is.disabled()&&(S.has.items()||S.has.message())},useAPI:function(){return e.fn.api!==i}},animate:{show:function(t,n){var a,o=n||U,s=n?function(){}:function(){S.hideSubMenus(),S.hideOthers(),S.set.active()};t=e.isFunction(t)?t:function(){},S.verbose("Doing menu show animation",o),S.set.direction(n),a=S.get.transition(n),S.is.selection()&&S.set.scrollPosition(S.get.selectedItem(),!0),(S.is.hidden(o)||S.is.animating(o))&&("none"==a?(s(),o.transition("show"),t.call(B)):e.fn.transition!==i&&O.transition("is supported")?o.transition({animation:a+" in",debug:y.debug,verbose:y.verbose,duration:y.duration,queue:!0,onStart:s,onComplete:function(){t.call(B)}}):S.error(R.noTransition,a))},hide:function(t,n){var a=n||U,o=(n?.9*y.duration:y.duration,n?function(){}:function(){S.can.click()&&S.unbind.intent(),S.remove.active()}),s=S.get.transition(n);t=e.isFunction(t)?t:function(){},(S.is.visible(a)||S.is.animating(a))&&(S.verbose("Doing menu hide animation",a),"none"==s?(o(),a.transition("hide"),t.call(B)):e.fn.transition!==i&&O.transition("is supported")?a.transition({animation:s+" out",duration:y.duration,debug:y.debug,verbose:y.verbose,queue:!0,onStart:o,onComplete:function(){"auto"==y.direction&&S.remove.upward(n),t.call(B)}}):S.error(R.transition))}},hideAndClear:function(){S.remove.searchTerm(),S.has.maxSelections()||(S.has.search()?S.hide(function(){S.remove.filteredItem()}):S.hide())},delay:{show:function(){S.verbose("Delaying show event to ensure user intent"),clearTimeout(S.timer),S.timer=setTimeout(S.show,y.delay.show)},hide:function(){S.verbose("Delaying hide event to ensure user intent"),clearTimeout(S.timer),S.timer=setTimeout(S.hide,y.delay.hide)}},escape:{regExp:function(e){return e=String(e),e.replace(D.escape,"\\$&")}},setting:function(t,n){if(S.debug("Changing setting",t,n),e.isPlainObject(t))e.extend(!0,y,t);else{if(n===i)return y[t];y[t]=n}},internal:function(t,n){if(e.isPlainObject(t))e.extend(!0,S,t);else{if(n===i)return S[t];S[t]=n}},debug:function(){y.debug&&(y.performance?S.performance.log(arguments):(S.debug=Function.prototype.bind.call(console.info,console,y.name+":"),S.debug.apply(console,arguments)))},verbose:function(){y.verbose&&y.debug&&(y.performance?S.performance.log(arguments):(S.verbose=Function.prototype.bind.call(console.info,console,y.name+":"),S.verbose.apply(console,arguments)))},error:function(){S.error=Function.prototype.bind.call(console.error,console,y.name+":"),S.error.apply(console,arguments)},performance:{log:function(e){var t,n,i;y.performance&&(t=(new Date).getTime(),i=u||t,n=t-i,u=t,d.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:B,"Execution Time":n})),clearTimeout(S.performance.timer),S.performance.timer=setTimeout(S.performance.display,500)},display:function(){var t=y.name+":",n=0;u=!1,clearTimeout(S.performance.timer),e.each(d,function(e,t){n+=t["Execution Time"]}),t+=" "+n+"ms",l&&(t+=" '"+l+"'"),(console.group!==i||console.table!==i)&&d.length>0&&(console.groupCollapsed(t),console.table?console.table(d):e.each(d,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),d=[]}},invoke:function(t,n,a){var s,r,l,c=$;return n=n||f,a=B||a,"string"==typeof t&&c!==i&&(t=t.split(/[\. ]/),s=t.length-1,e.each(t,function(n,a){var o=n!=s?a+t[n+1].charAt(0).toUpperCase()+t[n+1].slice(1):t;if(e.isPlainObject(c[o])&&n!=s)c=c[o];else{if(c[o]!==i)return r=c[o],!1;if(!e.isPlainObject(c[a])||n==s)return c[a]!==i?(r=c[a],!1):(S.error(R.method,t),!1);c=c[a]}})),e.isFunction(r)?l=r.apply(a,n):r!==i&&(l=r),e.isArray(o)?o.push(l):o!==i?o=[o,l]:l!==i&&(o=l),r}},m?($===i&&S.initialize(),S.invoke(v)):($!==i&&$.invoke("destroy"),S.initialize())}),o!==i?o:s},e.fn.dropdown.settings={debug:!1,verbose:!1,performance:!0,on:"click",action:"activate",apiSettings:!1,saveRemoteData:!0,throttle:200,context:t,direction:"auto",keepOnScreen:!0,match:"both",fullTextSearch:!1,placeholder:"auto",preserveHTML:!0,sortSelect:!1,forceSelection:!0,allowAdditions:!1,maxSelections:!1,useLabels:!0,delimiter:",",showOnFocus:!0,allowTab:!0,allowCategorySelection:!1,fireOnInit:!1,transition:"auto",duration:200,glyphWidth:1.0714,label:{transition:"scale",duration:200,variation:!1},delay:{hide:300,show:200,search:20,touch:50},onChange:function(e,t,n){},onAdd:function(e,t,n){},onRemove:function(e,t,n){},onLabelSelect:function(e){},onLabelCreate:function(t,n){return e(this)},onNoResults:function(e){return!0},onShow:function(){},onHide:function(){},name:"Dropdown",namespace:"dropdown",message:{addResult:"Add <b>{term}</b>",count:"{count} selected",maxSelections:"Max {maxCount} selections",noResults:"No results found.",serverError:"There was an error contacting the server"},error:{action:"You called a dropdown action that was not defined",alreadySetup:"Once a select has been initialized behaviors must be called on the created ui dropdown",labels:"Allowing user additions currently requires the use of labels.",missingMultiple:"<select> requires multiple property to be set to correctly preserve multiple values",method:"The method you called is not defined.",noAPI:"The API module is required to load resources remotely",noStorage:"Saving remote data requires session storage",noTransition:"This module requires ui transitions <https://github.com/Semantic-Org/UI-Transition>"},regExp:{escape:/[-[\]{}()*+?.,\\^$|#\s]/g},metadata:{defaultText:"defaultText",defaultValue:"defaultValue",placeholderText:"placeholder",text:"text",value:"value"},selector:{addition:".addition",dropdown:".ui.dropdown",icon:"> .dropdown.icon",input:'> input[type="hidden"], > select',item:".item",label:"> .label",remove:"> .label > .delete.icon",siblingLabel:".label",menu:".menu",message:".message",menuIcon:".dropdown.icon",search:"input.search, .menu > .search > input",text:"> .text:not(.icon)",unselectable:".disabled, .filtered"},className:{active:"active",addition:"addition",animating:"animating",disabled:"disabled",dropdown:"ui dropdown",filtered:"filtered",hidden:"hidden transition",item:"item",label:"ui label",loading:"loading",menu:"menu",message:"message",multiple:"multiple",placeholder:"default",search:"search",selected:"selected",selection:"selection",upward:"upward",visible:"visible"}},e.fn.dropdown.settings.templates={dropdown:function(t){var n=t.placeholder||!1,i=(t.values||{},"");return i+='<i class="dropdown icon"></i>',i+=t.placeholder?'<div class="default text">'+n+"</div>":'<div class="text"></div>',i+='<div class="menu">',e.each(t.values,function(e,t){i+=t.disabled?'<div class="disabled item" data-value="'+t.value+'">'+t.name+"</div>":'<div class="item" data-value="'+t.value+'">'+t.name+"</div>"}),i+="</div>"},menu:function(t){var n=(t.values||{},"");return e.each(t.values,function(e,t){n+='<div class="item" data-value="'+t.value+'">'+t.name+"</div>"}),n},label:function(e,t){return t+'<i class="delete icon"></i>'},message:function(e){return e},addition:function(e){return e}}}(jQuery,window,document);