/*!
 * # Semantic UI 2.0.7 - Checkbox
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Copyright 2015 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,n,t,i){"use strict";e.fn.checkbox=function(t){var o,r=e(this),a=r.selector||"",c=(new Date).getTime(),d=[],s=arguments[0],l="string"==typeof s,u=[].slice.call(arguments,1);return r.each(function(){var r,b,g=e.extend(!0,{},e.fn.checkbox.settings,t),h=g.className,p=g.namespace,m=g.selector,f=g.error,k="."+p,v="module-"+p,y=e(this),x=e(this).children(m.label),C=e(this).children(m.input),I=!1,O=y.data(v),D=this;b={initialize:function(){b.verbose("Initializing checkbox",g),b.create.label(),b.bind.events(),b.set.tabbable(),b.hide.input(),b.observeChanges(),b.instantiate(),b.setup()},instantiate:function(){b.verbose("Storing instance of module",b),O=b,y.data(v,b)},destroy:function(){b.verbose("Destroying module"),b.unbind.events(),b.show.input(),y.removeData(v)},fix:{reference:function(){y.is(m.input)&&(b.debug("Behavior called on <input> adjusting invoked element"),y=y.closest(m.checkbox),b.refresh())}},setup:function(){b.is.indeterminate()?(b.debug("Initial value is indeterminate"),b.set.indeterminate(),g.fireOnInit&&(g.onIndeterminate.call(C[0]),g.onChange.call(C[0]))):b.is.checked()?(b.debug("Initial value is checked"),b.set.checked(),g.fireOnInit&&(g.onChecked.call(C[0]),g.onChange.call(C[0]))):(b.debug("Initial value is unchecked"),b.set.unchecked(),g.fireOnInit&&(g.onUnchecked.call(C[0]),g.onChange.call(C[0])))},refresh:function(){x=y.children(m.label),C=y.children(m.input)},hide:{input:function(){b.verbose("Modfying <input> z-index to be unselectable"),C.addClass(h.hidden)}},show:{input:function(){b.verbose("Modfying <input> z-index to be selectable"),C.removeClass(h.hidden)}},observeChanges:function(){"MutationObserver"in n&&(r=new MutationObserver(function(e){b.debug("DOM tree modified, updating selector cache"),b.refresh()}),r.observe(D,{childList:!0,subtree:!0}),b.debug("Setting up mutation observer",r))},attachEvents:function(n,t){var i=e(n);t=e.isFunction(b[t])?b[t]:b.toggle,i.length>0?(b.debug("Attaching checkbox events to element",n,t),i.on("click"+k,t)):b.error(f.notFound)},event:{click:function(n){return e(n.target).is(m.input)?void b.verbose("Using default check action on initialized checkbox"):(b.toggle(),C.focus(),void n.preventDefault())},keydown:function(e){var n=e.which,t={enter:13,space:32,escape:27};n==t.escape?(b.verbose("Escape key pressed blurring field"),C.blur(),I=!0):e.ctrlKey||n!=t.space&&n!=t.enter?I=!1:(b.verbose("Enter/space key pressed, toggling checkbox"),b.toggle(),I=!0)},keyup:function(e){I&&e.preventDefault()}},check:function(){return!b.is.indeterminate()&&b.is.checked()?void b.debug("Checkbox is already checked"):(b.debug("Checking checkbox",C),b.set.checked(),g.onChecked.call(C[0]),void g.onChange.call(C[0]))},uncheck:function(){return!b.is.indeterminate()&&b.is.unchecked()?void b.debug("Checkbox is already unchecked"):(b.debug("Unchecking checkbox"),b.set.unchecked(),g.onUnchecked.call(C[0]),void g.onChange.call(C[0]))},indeterminate:function(){return b.is.indeterminate()?void b.debug("Checkbox is already indeterminate"):(b.debug("Making checkbox indeterminate"),b.set.indeterminate(),g.onIndeterminate.call(C[0]),void g.onChange.call(C[0]))},determinate:function(){return b.is.determinate()?void b.debug("Checkbox is already determinate"):(b.debug("Making checkbox determinate"),b.set.determinate(),g.onDeterminate.call(C[0]),void g.onChange.call(C[0]))},enable:function(){return b.is.enabled()?void b.debug("Checkbox is already enabled"):(b.debug("Enabling checkbox"),b.set.enabled(),void g.onEnable.call(C[0]))},disable:function(){return b.is.disabled()?void b.debug("Checkbox is already disabled"):(b.debug("Disabling checkbox"),b.set.disabled(),void g.onDisable.call(C[0]))},get:{radios:function(){var n=b.get.name();return e('input[name="'+n+'"]').closest(m.checkbox)},otherRadios:function(){return b.get.radios().not(y)},name:function(){return C.attr("name")}},is:{radio:function(){return C.hasClass(h.radio)||"radio"==C.attr("type")},indeterminate:function(){return C.prop("indeterminate")!==i&&C.prop("indeterminate")},checked:function(){return C.prop("checked")!==i&&C.prop("checked")},disabled:function(){return C.prop("disabled")!==i&&C.prop("disabled")},enabled:function(){return!b.is.disabled()},determinate:function(){return!b.is.indeterminate()},unchecked:function(){return!b.is.checked()}},can:{change:function(){return!(y.hasClass(h.disabled)||y.hasClass(h.readOnly)||C.prop("disabled")||C.prop("readonly"))},uncheck:function(){return"boolean"==typeof g.uncheckable?g.uncheckable:!b.is.radio()}},set:{checked:function(){return b.verbose("Setting class to checked"),y.removeClass(h.indeterminate).addClass(h.checked),b.is.radio()&&b.uncheckOthers(),!b.is.indeterminate()&&b.is.checked()?void b.debug("Input is already checked, skipping input property change"):(b.verbose("Setting state to checked",C[0]),C.prop("indeterminate",!1).prop("checked",!0),void b.trigger.change())},unchecked:function(){return b.verbose("Removing checked class"),y.removeClass(h.indeterminate).removeClass(h.checked),!b.is.indeterminate()&&b.is.unchecked()?void b.debug("Input is already unchecked"):(b.debug("Setting state to unchecked"),C.prop("indeterminate",!1).prop("checked",!1),void b.trigger.change())},indeterminate:function(){return b.verbose("Setting class to indeterminate"),y.addClass(h.indeterminate),b.is.indeterminate()?void b.debug("Input is already indeterminate, skipping input property change"):(b.debug("Setting state to indeterminate"),C.prop("indeterminate",!0),void b.trigger.change())},determinate:function(){return b.verbose("Removing indeterminate class"),y.removeClass(h.indeterminate),b.is.determinate()?void b.debug("Input is already determinate, skipping input property change"):(b.debug("Setting state to determinate"),void C.prop("indeterminate",!1))},disabled:function(){return b.verbose("Setting class to disabled"),y.addClass(h.disabled),b.is.disabled()?void b.debug("Input is already disabled, skipping input property change"):(b.debug("Setting state to disabled"),C.prop("disabled","disabled"),void b.trigger.change())},enabled:function(){return b.verbose("Removing disabled class"),y.removeClass(h.disabled),b.is.enabled()?void b.debug("Input is already enabled, skipping input property change"):(b.debug("Setting state to enabled"),C.prop("disabled",!1),void b.trigger.change())},tabbable:function(){b.verbose("Adding tabindex to checkbox"),C.attr("tabindex")===i&&C.attr("tabindex",0)}},trigger:{change:function(){b.verbose("Triggering change event from programmatic change"),C.trigger("change")}},create:{label:function(){C.prevAll(m.label).length>0?(C.prev(m.label).detach().insertAfter(C),b.debug("Moving existing label",x)):b.has.label()||(x=e("<label>").insertAfter(C),b.debug("Creating label",x))}},has:{label:function(){return x.length>0}},bind:{events:function(){b.verbose("Attaching checkbox events"),y.on("click"+k,b.event.click).on("keydown"+k,m.input,b.event.keydown).on("keyup"+k,m.input,b.event.keyup)}},unbind:{events:function(){b.debug("Removing events"),y.off(k)}},uncheckOthers:function(){var e=b.get.otherRadios();b.debug("Unchecking other radios",e),e.removeClass(h.checked)},toggle:function(){return b.can.change()?void(b.is.indeterminate()||b.is.unchecked()?(b.debug("Currently unchecked"),b.check()):b.is.checked()&&b.can.uncheck()&&(b.debug("Currently checked"),b.uncheck())):void(b.is.radio()||b.debug("Checkbox is read-only or disabled, ignoring toggle"))},setting:function(n,t){if(b.debug("Changing setting",n,t),e.isPlainObject(n))e.extend(!0,g,n);else{if(t===i)return g[n];g[n]=t}},internal:function(n,t){if(e.isPlainObject(n))e.extend(!0,b,n);else{if(t===i)return b[n];b[n]=t}},debug:function(){g.debug&&(g.performance?b.performance.log(arguments):(b.debug=Function.prototype.bind.call(console.info,console,g.name+":"),b.debug.apply(console,arguments)))},verbose:function(){g.verbose&&g.debug&&(g.performance?b.performance.log(arguments):(b.verbose=Function.prototype.bind.call(console.info,console,g.name+":"),b.verbose.apply(console,arguments)))},error:function(){b.error=Function.prototype.bind.call(console.error,console,g.name+":"),b.error.apply(console,arguments)},performance:{log:function(e){var n,t,i;g.performance&&(n=(new Date).getTime(),i=c||n,t=n-i,c=n,d.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:D,"Execution Time":t})),clearTimeout(b.performance.timer),b.performance.timer=setTimeout(b.performance.display,500)},display:function(){var n=g.name+":",t=0;c=!1,clearTimeout(b.performance.timer),e.each(d,function(e,n){t+=n["Execution Time"]}),n+=" "+t+"ms",a&&(n+=" '"+a+"'"),(console.group!==i||console.table!==i)&&d.length>0&&(console.groupCollapsed(n),console.table?console.table(d):e.each(d,function(e,n){console.log(n.Name+": "+n["Execution Time"]+"ms")}),console.groupEnd()),d=[]}},invoke:function(n,t,r){var a,c,d,s=O;return t=t||u,r=D||r,"string"==typeof n&&s!==i&&(n=n.split(/[\. ]/),a=n.length-1,e.each(n,function(t,o){var r=t!=a?o+n[t+1].charAt(0).toUpperCase()+n[t+1].slice(1):n;if(e.isPlainObject(s[r])&&t!=a)s=s[r];else{if(s[r]!==i)return c=s[r],!1;if(!e.isPlainObject(s[o])||t==a)return s[o]!==i?(c=s[o],!1):(b.error(f.method,n),!1);s=s[o]}})),e.isFunction(c)?d=c.apply(r,t):c!==i&&(d=c),e.isArray(o)?o.push(d):o!==i?o=[o,d]:d!==i&&(o=d),c}},l?(O===i&&b.initialize(),b.invoke(s)):(O!==i&&O.invoke("destroy"),b.initialize())}),o!==i?o:this},e.fn.checkbox.settings={name:"Checkbox",namespace:"checkbox",debug:!1,verbose:!0,performance:!0,uncheckable:"auto",fireOnInit:!1,onChange:function(){},onChecked:function(){},onUnchecked:function(){},onDeterminate:function(){},onIndeterminate:function(){},onEnabled:function(){},onDisabled:function(){},className:{checked:"checked",indeterminate:"indeterminate",disabled:"disabled",hidden:"hidden",radio:"radio",readOnly:"read-only"},error:{method:"The method you called is not defined"},selector:{checkbox:".ui.checkbox",label:"label, .box",input:'input[type="checkbox"], input[type="radio"]'}}}(jQuery,window,document);