/*!
 * # Semantic UI 2.0.7 - Search
 * http://github.com/semantic-org/semantic-ui/
 *
 *
 * Copyright 2015 Contributors
 * Released under the MIT license
 * http://opensource.org/licenses/MIT
 *
 */
!function(e,t,s,r){"use strict";e.fn.search=function(n){var a,i=e(this),c=i.selector||"",o=(new Date).getTime(),u=[],l=arguments[0],d="string"==typeof l,g=[].slice.call(arguments,1);return e(this).each(function(){var f,p=e.isPlainObject(n)?e.extend(!0,{},e.fn.search.settings,n):e.extend({},e.fn.search.settings),v=p.className,h=p.metadata,m=p.regExp,b=p.selector,y=p.error,C=p.namespace,R="."+C,w=C+"-module",x=e(this),j=x.find(b.prompt),q=x.find(b.searchButton),k=x.find(b.results),A=(x.find(b.result),x.find(b.category),this),E=x.data(w);f={initialize:function(){f.verbose("Initializing module"),f.determine.searchFields(),f.bind.events(),f.set.type(),f.create.results(),f.instantiate()},instantiate:function(){f.verbose("Storing instance of module",f),E=f,x.data(w,f)},destroy:function(){f.verbose("Destroying instance"),x.off(R).removeData(w)},bind:{events:function(){f.verbose("Binding events to search"),p.automatic&&(x.on(f.get.inputEvent()+R,b.prompt,f.event.input),j.attr("autocomplete","off")),x.on("focus"+R,b.prompt,f.event.focus).on("blur"+R,b.prompt,f.event.blur).on("keydown"+R,b.prompt,f.handleKeyboard).on("click"+R,b.searchButton,f.query).on("mousedown"+R,b.results,f.event.result.mousedown).on("mouseup"+R,b.results,f.event.result.mouseup).on("click"+R,b.result,f.event.result.click)}},determine:{searchFields:function(){n&&n.searchFields!==r&&(p.searchFields=n.searchFields)}},event:{input:function(){clearTimeout(f.timer),f.timer=setTimeout(f.query,p.searchDelay)},focus:function(){f.set.focus(),f.has.minimumCharacters()&&(f.query(),f.showResults())},blur:function(e){var t=s.activeElement===this;t||f.resultsClicked||(f.cancel.query(),f.remove.focus(),f.timer=setTimeout(f.hideResults,p.hideDelay))},result:{mousedown:function(){f.resultsClicked=!0},mouseup:function(){f.resultsClicked=!1},click:function(s){f.debug("Search result selected");var r=e(this),n=r.find(b.title).eq(0),a=r.find("a[href]").eq(0),i=a.attr("href")||!1,c=a.attr("target")||!1,o=(n.html(),n.length>0?n.text():!1),u=f.get.results(),l=r.data(h.result)||f.get.result(o,u);return e.isFunction(p.onSelect)&&p.onSelect.call(A,l,u)===!1?void f.debug("Custom onSelect callback cancelled default select action"):(f.hideResults(),o&&f.set.value(o),void(i&&(f.verbose("Opening search link found in result",a),"_blank"==c||s.ctrlKey?t.open(i):t.location.href=i)))}}},handleKeyboard:function(e){var t,s=x.find(b.result),r=x.find(b.category),n=s.index(s.filter("."+v.active)),a=s.length,i=e.which,c={backspace:8,enter:13,escape:27,upArrow:38,downArrow:40};if(i==c.escape&&(f.verbose("Escape key pressed, blurring search field"),j.trigger("blur")),f.is.visible())if(i==c.enter){if(f.verbose("Enter key pressed, selecting active result"),s.filter("."+v.active).length>0)return f.event.result.click.call(s.filter("."+v.active),e),e.preventDefault(),!1}else i==c.upArrow?(f.verbose("Up key pressed, changing active result"),t=0>n-1?n:n-1,r.removeClass(v.active),s.removeClass(v.active).eq(t).addClass(v.active).closest(r).addClass(v.active),e.preventDefault()):i==c.downArrow&&(f.verbose("Down key pressed, changing active result"),t=n+1>=a?n:n+1,r.removeClass(v.active),s.removeClass(v.active).eq(t).addClass(v.active).closest(r).addClass(v.active),e.preventDefault());else i==c.enter&&(f.verbose("Enter key pressed, executing query"),f.query(),f.set.buttonPressed(),j.one("keyup",f.remove.buttonFocus))},setup:{api:function(){var e={debug:p.debug,on:!1,cache:"local",action:"search",onError:f.error};f.verbose("First request, initializing API"),x.api(e)}},can:{useAPI:function(){return e.fn.api!==r},transition:function(){return p.transition&&e.fn.transition!==r&&x.transition("is supported")}},is:{empty:function(){return""===k.html()},visible:function(){return k.filter(":visible").length>0},focused:function(){return j.filter(":focus").length>0}},get:{inputEvent:function(){var e=j[0],t=e!==r&&e.oninput!==r?"input":e!==r&&e.onpropertychange!==r?"propertychange":"keyup";return t},value:function(){return j.val()},results:function(){var e=x.data(h.results);return e},result:function(t,s){var n=["title","id"],a=!1;return t=t!==r?t:f.get.value(),s=s!==r?s:f.get.results(),"category"===p.type?(f.debug("Finding result that matches",t),e.each(s,function(s,r){return e.isArray(r.results)&&(a=f.search.object(t,r.results,n)[0])?!1:void 0})):(f.debug("Finding result in results object",t),a=f.search.object(t,s,n)[0]),a||!1}},set:{focus:function(){x.addClass(v.focus)},loading:function(){x.addClass(v.loading)},value:function(e){f.verbose("Setting search input value",e),j.val(e)},type:function(e){e=e||p.type,"category"==p.type&&x.addClass(p.type)},buttonPressed:function(){q.addClass(v.pressed)}},remove:{loading:function(){x.removeClass(v.loading)},focus:function(){x.removeClass(v.focus)},buttonPressed:function(){q.removeClass(v.pressed)}},query:function(){var t=f.get.value(),s=f.read.cache(t);f.has.minimumCharacters()?s?(f.debug("Reading result from cache",t),f.save.results(s.results),f.addResults(s.html),f.inject.id(s.results)):(f.debug("Querying for",t),e.isPlainObject(p.source)||e.isArray(p.source)?f.search.local(t):f.can.useAPI()?f.search.remote(t):f.error(y.source),p.onSearchQuery.call(A,t)):f.hideResults()},search:{local:function(e){var t,s=f.search.object(e,p.content);f.set.loading(),f.save.results(s),f.debug("Returned local search results",s),t=f.generateResults({results:s}),f.remove.loading(),f.addResults(t),f.inject.id(s),f.write.cache(e,{html:t,results:s})},remote:function(t){var s={onSuccess:function(e){f.parse.response.call(A,e,t)},onFailure:function(){f.displayMessage(y.serverError)},urlData:{query:t}};x.api("get request")||f.setup.api(),e.extend(!0,s,p.apiSettings),f.debug("Executing search",s),f.cancel.query(),x.api("setting",s).api("query")},object:function(t,s,n){var a=[],i=[],c=t.toString().replace(m.escape,"\\$&"),o=new RegExp(m.beginsWith+c,"i"),u=function(t,s){var r=-1==e.inArray(s,a),n=-1==e.inArray(s,i);r&&n&&t.push(s)};return s=s||p.source,n=n!==r?n:p.searchFields,e.isArray(n)||(n=[n]),s===r||s===!1?(f.error(y.source),[]):(e.each(n,function(r,n){e.each(s,function(e,s){var r="string"==typeof s[n];r&&(-1!==s[n].search(o)?u(a,s):p.searchFullText&&f.fuzzySearch(t,s[n])&&u(i,s))})}),e.merge(a,i))}},fuzzySearch:function(e,t){var s=t.length,r=e.length;if("string"!=typeof e)return!1;if(e=e.toLowerCase(),t=t.toLowerCase(),r>s)return!1;if(r===s)return e===t;e:for(var n=0,a=0;r>n;n++){for(var i=e.charCodeAt(n);s>a;)if(t.charCodeAt(a++)===i)continue e;return!1}return!0},parse:{response:function(e,t){var s=f.generateResults(e);f.verbose("Parsing server response",e),e!==r&&t!==r&&e.results!==r&&(f.addResults(s),f.inject.id(e.results),f.write.cache(t,{html:s,results:e.results}),f.save.results(e.results))}},cancel:{query:function(){f.can.useAPI()&&x.api("abort")}},has:{minimumCharacters:function(){var e=f.get.value(),t=e.length;return t>=p.minCharacters}},clear:{cache:function(e){var t=x.data(h.cache);e?e&&t&&t[e]&&(f.debug("Removing value from cache",e),delete t[e],x.data(h.cache,t)):(f.debug("Clearing cache",e),x.removeData(h.cache))}},read:{cache:function(e){var t=x.data(h.cache);return p.cache?(f.verbose("Checking cache for generated html for query",e),"object"==typeof t&&t[e]!==r?t[e]:!1):!1}},create:{id:function(e,t){var s,n,a=e+1;return t!==r?(s=String.fromCharCode(97+t),n=s+a,f.verbose("Creating category result id",n)):(n=a,f.verbose("Creating result id",n)),n},results:function(){0===k.length&&(k=e("<div />").addClass(v.results).appendTo(x))}},inject:{result:function(e,t,s){f.verbose("Injecting result into results");var n=s!==r?k.children().eq(s).children(b.result).eq(t):k.children(b.result).eq(t);f.verbose("Injecting results metadata",n),n.data(h.result,e)},id:function(t){f.debug("Injecting unique ids into results");var s=0,n=0;return"category"===p.type?e.each(t,function(t,a){n=0,e.each(a.results,function(e,t){var i=a.results[e];i.id===r&&(i.id=f.create.id(n,s)),f.inject.result(i,n,s),n++}),s++}):e.each(t,function(e,s){var a=t[e];a.id===r&&(a.id=f.create.id(n)),f.inject.result(a,n),n++}),t}},save:{results:function(e){f.verbose("Saving current search results to metadata",e),x.data(h.results,e)}},write:{cache:function(e,t){var s=x.data(h.cache)!==r?x.data(h.cache):{};p.cache&&(f.verbose("Writing generated html to cache",e,t),s[e]=t,x.data(h.cache,s))}},addResults:function(t){return e.isFunction(p.onResultsAdd)&&p.onResultsAdd.call(k,t)===!1?(f.debug("onResultsAdd callback cancelled default action"),!1):(k.html(t),void f.showResults())},showResults:function(){f.is.visible()||!f.is.focused()||f.is.empty()||(f.can.transition()?(f.debug("Showing results with css animations"),k.transition({animation:p.transition+" in",debug:p.debug,verbose:p.verbose,duration:p.duration,queue:!0})):(f.debug("Showing results with javascript"),k.stop().fadeIn(p.duration,p.easing)),p.onResultsOpen.call(k))},hideResults:function(){f.is.visible()&&(f.can.transition()?(f.debug("Hiding results with css animations"),k.transition({animation:p.transition+" out",debug:p.debug,verbose:p.verbose,duration:p.duration,queue:!0})):(f.debug("Hiding results with javascript"),k.stop().fadeOut(p.duration,p.easing)),p.onResultsClose.call(k))},generateResults:function(t){f.debug("Generating html from response",t);var s=p.templates[p.type],r=e.isPlainObject(t.results)&&!e.isEmptyObject(t.results),n=e.isArray(t.results)&&t.results.length>0,a="";return r||n?(p.maxResults>0&&(r?"standard"==p.type&&f.error(y.maxResults):t.results=t.results.slice(0,p.maxResults)),e.isFunction(s)?a=s(t):f.error(y.noTemplate,!1)):a=f.displayMessage(y.noResults,"empty"),p.onResults.call(A,t),a},displayMessage:function(e,t){return t=t||"standard",f.debug("Displaying message",e,t),f.addResults(p.templates.message(e,t)),p.templates.message(e,t)},setting:function(t,s){if(e.isPlainObject(t))e.extend(!0,p,t);else{if(s===r)return p[t];p[t]=s}},internal:function(t,s){if(e.isPlainObject(t))e.extend(!0,f,t);else{if(s===r)return f[t];f[t]=s}},debug:function(){p.debug&&(p.performance?f.performance.log(arguments):(f.debug=Function.prototype.bind.call(console.info,console,p.name+":"),f.debug.apply(console,arguments)))},verbose:function(){p.verbose&&p.debug&&(p.performance?f.performance.log(arguments):(f.verbose=Function.prototype.bind.call(console.info,console,p.name+":"),f.verbose.apply(console,arguments)))},error:function(){f.error=Function.prototype.bind.call(console.error,console,p.name+":"),f.error.apply(console,arguments)},performance:{log:function(e){var t,s,r;p.performance&&(t=(new Date).getTime(),r=o||t,s=t-r,o=t,u.push({Name:e[0],Arguments:[].slice.call(e,1)||"",Element:A,"Execution Time":s})),clearTimeout(f.performance.timer),f.performance.timer=setTimeout(f.performance.display,500)},display:function(){var t=p.name+":",s=0;o=!1,clearTimeout(f.performance.timer),e.each(u,function(e,t){s+=t["Execution Time"]}),t+=" "+s+"ms",c&&(t+=" '"+c+"'"),i.length>1&&(t+=" ("+i.length+")"),(console.group!==r||console.table!==r)&&u.length>0&&(console.groupCollapsed(t),console.table?console.table(u):e.each(u,function(e,t){console.log(t.Name+": "+t["Execution Time"]+"ms")}),console.groupEnd()),u=[]}},invoke:function(t,s,n){var i,c,o,u=E;return s=s||g,n=A||n,"string"==typeof t&&u!==r&&(t=t.split(/[\. ]/),i=t.length-1,e.each(t,function(s,n){var a=s!=i?n+t[s+1].charAt(0).toUpperCase()+t[s+1].slice(1):t;if(e.isPlainObject(u[a])&&s!=i)u=u[a];else{if(u[a]!==r)return c=u[a],!1;if(!e.isPlainObject(u[n])||s==i)return u[n]!==r?(c=u[n],!1):!1;u=u[n]}})),e.isFunction(c)?o=c.apply(n,s):c!==r&&(o=c),e.isArray(a)?a.push(o):a!==r?a=[a,o]:o!==r&&(a=o),c}},d?(E===r&&f.initialize(),f.invoke(l)):(E!==r&&E.invoke("destroy"),f.initialize())}),a!==r?a:this},e.fn.search.settings={name:"Search",namespace:"search",debug:!1,verbose:!1,performance:!0,type:"standard",minCharacters:1,apiSettings:!1,source:!1,searchFields:["title","description"],searchFullText:!0,automatic:!0,hideDelay:0,searchDelay:200,maxResults:7,cache:!0,transition:"scale",duration:200,easing:"easeOutExpo",onSelect:!1,onResultsAdd:!1,onSearchQuery:function(){},onResults:function(e){},onResultsOpen:function(){},onResultsClose:function(){},className:{active:"active",empty:"empty",focus:"focus",loading:"loading",results:"results",pressed:"down"},error:{source:"Cannot search. No source used, and Semantic API module was not included",noResults:"Your search returned no results",logging:"Error in debug logging, exiting.",noEndpoint:"No search endpoint was specified",noTemplate:"A valid template name was not specified.",serverError:"There was an issue querying the server.",maxResults:"Results must be an array to use maxResults setting",method:"The method you called is not defined."},metadata:{cache:"cache",results:"results",result:"result"},regExp:{escape:/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,beginsWith:"(?:s|^)"},selector:{prompt:".prompt",searchButton:".search.button",results:".results",category:".category",result:".result",title:".title, .name"},templates:{escape:function(e){var t=/[&<>"'`]/g,s=/[&<>"'`]/,r={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#x27;","`":"&#x60;"},n=function(e){return r[e]};return s.test(e)?e.replace(t,n):e},message:function(e,t){var s="";return e!==r&&t!==r&&(s+='<div class="message '+t+'">',s+="empty"==t?'<div class="header">No Results</div class="header"><div class="description">'+e+'</div class="description">':' <div class="description">'+e+"</div>",s+="</div>"),s},category:function(t){var s="",n=e.fn.search.settings.templates.escape;return t.results!==r?(e.each(t.results,function(t,a){a.results!==r&&a.results.length>0&&(s+='<div class="category"><div class="name">'+a.name+"</div>",e.each(a.results,function(e,t){s+='<div class="result">',t.url&&(s+='<a href="'+t.url+'"></a>'),t.image!==r&&(t.image=n(t.image),s+='<div class="image"> <img src="'+t.image+'" alt=""></div>'),s+='<div class="content">',t.price!==r&&(t.price=n(t.price),s+='<div class="price">'+t.price+"</div>"),t.title!==r&&(t.title=n(t.title),s+='<div class="title">'+t.title+"</div>"),t.description!==r&&(s+='<div class="description">'+t.description+"</div>"),s+="</div></div>"}),s+="</div>")}),t.action&&(s+='<a href="'+t.action.url+'" class="action">'+t.action.text+"</a>"),s):!1},standard:function(t){var s="";return t.results!==r?(e.each(t.results,function(e,t){s+=t.url?'<a class="result" href="'+t.url+'">':'<a class="result">',t.image!==r&&(s+='<div class="image"> <img src="'+t.image+'"></div>'),s+='<div class="content">',t.price!==r&&(s+='<div class="price">'+t.price+"</div>"),t.title!==r&&(s+='<div class="title">'+t.title+"</div>"),t.description!==r&&(s+='<div class="description">'+t.description+"</div>"),s+="</div>",s+="</a>"}),t.action&&(s+='<a href="'+t.action.url+'" class="action">'+t.action.text+"</a>"),s):!1}}}}(jQuery,window,document);